# Documentation Structure

This archive contains the complete Lucit Platform documentation in Markdown format.

## Directory Layout

```
lucit-docs-markdown/
├── README                  - Archive information and usage guide
├── manifest.json          - Metadata about this archive
├── STRUCTURE.md           - This file - explains the documentation structure
├── mkdocs.yml             - MkDocs configuration (for rebuilding the site)
├── .lucitdocs             - Marker file for automated tool detection
└── docs/                  - All documentation files

### Root Documentation Files

- .problem-solution-md-template.md
- about.md
- definitions.md
- faq.md
- index.md

### docs/compare/

- compare/index.md
- compare/lucit-vs-apparatix.md
- compare/lucit-vs-billboard-planet.md
- compare/lucit-vs-blip.md
- compare/lucit-vs-daktronics.md
- compare/lucit-vs-formetco.md
- compare/lucit-vs-place-exchange.md
- compare/lucit-vs-vistar-media.md
- compare/lucit-vs-watchfire-ignite.md

### docs/developer/

- developer/apps/app/3dcart-reference.md
- developer/apps/app/AdamsOutdoorScalaAdManagerIntegration-reference.md
- developer/apps/app/AirnowAirQualityIndex-reference.md
- developer/apps/app/AlterraMountainCoSkiResortsSnowReport-reference.md
- developer/apps/app/Apparatix1-reference.md
- developer/apps/app/Autorevo1-reference.md
- developer/apps/app/Ayuda-reference.md
- developer/apps/app/BibleVerses-reference.md
- developer/apps/app/Blip-reference.md
- developer/apps/app/BornOnThisDayByDigichief-reference.md
- developer/apps/app/BridgeInteractiveMls-reference.md
- developer/apps/app/Carsforsale1-reference.md
- developer/apps/app/CdkGlobal1-reference.md
- developer/apps/app/ChristmasCoundown-reference.md
- developer/apps/app/CoinPaprika-reference.md
- developer/apps/app/CoindeskLiveBitcoinPrice-reference.md
- developer/apps/app/CommodityPricesByDigichiefDemo-reference.md
- developer/apps/app/CtiMls1-reference.md
- developer/apps/app/DailyHoroscope-reference.md
- developer/apps/app/Daktronics1-reference.md
- developer/apps/app/DealerCarSearch1-reference.md
- developer/apps/app/DealerSpecialties1-reference.md
- developer/apps/app/Dealerslink1-reference.md
- developer/apps/app/Dealerspike1-reference.md
- developer/apps/app/DoohclickPlayer-reference.md
- developer/apps/app/DriveTimeDigitalBoardToLocation-reference.md
- developer/apps/app/Ecrs1-reference.md
- developer/apps/app/EcwidEcommerce1-reference.md
- developer/apps/app/EleadAutomotive-reference.md
- developer/apps/app/EpicSkiResortsSnowReport-reference.md
- developer/apps/app/ExperityUrgentCareWaitTimes-reference.md
- developer/apps/app/FacebookSocialFeedByTagbox-reference.md
- developer/apps/app/FamousQuotes-reference.md
- developer/apps/app/FamousQuotesByDigichief-reference.md
- developer/apps/app/Flexmls1-reference.md
- developer/apps/app/FloridaGulfCoastMls-reference.md
- developer/apps/app/FormetcoF360-reference.md
- developer/apps/app/FoxNews-reference.md
- developer/apps/app/FunRandomFactsByDigichief-reference.md
- developer/apps/app/GoogleBusinessReviews-reference.md
- developer/apps/app/GoogleSheets-reference.md
- developer/apps/app/GoogleSheetsAgInventory-reference.md
- developer/apps/app/GoogleSheetsArticleInventory-reference.md
- developer/apps/app/GoogleSheetsAvailableJobs-reference.md
- developer/apps/app/GoogleSheetsKeyValueData-reference.md
- developer/apps/app/GoogleSheetsProductInventory-reference.md
- developer/apps/app/GoogleSheetsRealEstateAgents-reference.md
- developer/apps/app/GoogleSheetsRecreationalInventory-reference.md
- developer/apps/app/GoogleSheetsReview-reference.md
- developer/apps/app/HealthWellnessTipsByDigichief-reference.md
- developer/apps/app/Homenet2-reference.md
- developer/apps/app/Instagram-reference.md
- developer/apps/app/LamarIspotPlayer-reference.md
- developer/apps/app/Ldsk1-reference.md
- developer/apps/app/LightningPlayer-reference.md
- developer/apps/app/LinkedinSocialFeedByTagbox-reference.md
- developer/apps/app/LiopsLucitWatchfireIgniteOpSupervisor-reference.md
- developer/apps/app/LotusCorpRadioNowPlaying-reference.md
- developer/apps/app/LovelandSkiAreaSnowPackDepth-reference.md
- developer/apps/app/LucitGoogleSheetsRealEstateProperties-reference.md
- developer/apps/app/LucitSampleDataSources-reference.md
- developer/apps/app/MachineFinder1-reference.md
- developer/apps/app/MatrixMlsByCorelogic-reference.md
- developer/apps/app/MegaMillions-reference.md
- developer/apps/app/MlbLiveGameScores-reference.md
- developer/apps/app/NavicaMls1-reference.md
- developer/apps/app/NbaLiveGameScores-reference.md
- developer/apps/app/NcaaBasketballLiveGameScores-reference.md
- developer/apps/app/NcaaCollegeFootballLiveGameScores-reference.md
- developer/apps/app/NcaaWomensVolleyballScores-reference.md
- developer/apps/app/NearestLocationDataViaGoogleSheets-reference.md
- developer/apps/app/NewYorkTimesWorldNews-reference.md
- developer/apps/app/NflLiveGameScores-reference.md
- developer/apps/app/NorthwoodsLeagueBaseball-reference.md
- developer/apps/app/NtreisMlsData-reference.md
- developer/apps/app/OilAndGasMarketPricesByDigichief-reference.md
- developer/apps/app/OutfrontMediaPlayer-reference.md
- developer/apps/app/ParagonMls-reference.md
- developer/apps/app/Paris2024Olympics-reference.md
- developer/apps/app/PgaGolfTourLeaderboards-reference.md
- developer/apps/app/PinterestSocialFeedByTagbox-reference.md
- developer/apps/app/PlaceExchange1-reference.md
- developer/apps/app/Powerball-reference.md
- developer/apps/app/PreciousMetalPricesByDigichiefDemo-reference.md
- developer/apps/app/PremierLeagueFootball-reference.md
- developer/apps/app/PriceadvantageFuelPrices-reference.md
- developer/apps/app/ProductLaunchCountdown-reference.md
- developer/apps/app/Redline2-reference.md
- developer/apps/app/RentalPropertiesUsingGoogleSheets-reference.md
- developer/apps/app/Rmls1-reference.md
- developer/apps/app/RssFeed-reference.md
- developer/apps/app/SantiamPassSkiPatrolSnowDepth-reference.md
- developer/apps/app/Shopify-reference.md
- developer/apps/app/Signbird2-reference.md
- developer/apps/app/SkiResortsConditions-reference.md
- developer/apps/app/SoutheastAlabamaAssociationOfRealtors-reference.md
- developer/apps/app/StockPricesByDigichief-reference.md
- developer/apps/app/TheFinancialTimes-reference.md
- developer/apps/app/TheWashingtonPost-reference.md
- developer/apps/app/ThisDayInHistoryByDigichief-reference.md
- developer/apps/app/TicketsRemainingEventbrite-reference.md
- developer/apps/app/TrestleCoreLogic1-reference.md
- developer/apps/app/UsGovernmentDebtCounter-reference.md
- developer/apps/app/UselessFacts-reference.md
- developer/apps/app/Vauto1-reference.md
- developer/apps/app/Vinsolutions1-reference.md
- developer/apps/app/VistarMediaPlayer-reference.md
- developer/apps/app/Watchfire1-reference.md
- developer/apps/app/Weather-reference.md
- developer/apps/app/Weather2-reference.md
- developer/apps/app/Wix-reference.md
- developer/apps/app/Woocommerce-reference.md
- developer/apps/app/Wordpress-reference.md
- developer/apps/app/XTwitterByTagbox-reference.md
- developer/apps/application-capabilities-reference.md
- developer/apps/application-permissions-reference.md
- developer/apps/index.md
- developer/fields/lucit-form-fields-specification.md
- developer/index.md
- developer/macros/field-map-macro-reference.md
- developer/macros/field-map-specification.md
- developer/templates/index.md
- developer/templates/lucit-render-app-guide.md
- developer/templates/lucit-template-animation-guide.md
- developer/templates/lucit-template-css-guide.md
- developer/templates/lucit-template-custom-fields.md
- developer/templates/lucit-template-html-guide.md
- developer/templates/lucit-text-formatting-function-reference.md
- developer/templates/lucit-text-formatting-functions-guide.md
- developer/templates/template-animation-keyframes.md
- developer/templates/template-css-styles.md

### docs/guides/

- guides/campaign-page-navigation-guide.md
- guides/general-navigation-guide.md
- guides/how-tos/create-a-campaign-with-poi-dynamic-creatives.md
- guides/how-tos/create-weather-triggered-creatives.md
- guides/how-tos/index.md
- guides/index.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-adams-scala.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-apparatix.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-ayuda.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-blip-player.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-clear-channel.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-daktronics.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-doohclick.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-formetco-f360.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-lamar-ispot.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-ldsk-player.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-place-exchange.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-vistar-media.md
- guides/integrations/how-to-schedule-lucit-campaigns-in-watchfire-ignite.md
- guides/integrations/index.md
- guides/post-ad-navigation-guide.md
- guides/screen-format-reference.md
- guides/template-designer-general-navigation-guide.md
- guides/user-roles-reference.md

### docs/solutions/

- solutions/city-specific-dynamic-creative-mockups.md
- solutions/clients-overwhelm-scheduling-teams.md
- solutions/complex-campaign-date-scheduling.md
- solutions/creative-mockups-for-every-placement.md
- solutions/creatives-break-across-screen-sizes.md
- solutions/designing-for-every-billboard-size.md
- solutions/dynamic-creative-api-costs-too-high.md
- solutions/dynamic-creatives-too-expensive.md
- solutions/dynamic-creatives-too-long-to-launch.md
- solutions/endless-email-loops-creative-updates.md
- solutions/generating-creatives-from-large-datasets.md
- solutions/index.md
- solutions/limited-font-support-dynamic-creatives.md
- solutions/live-sports-creatives-manual-control.md
- solutions/location-based-data-nearest-exits.md
- solutions/managing-campaigns-across-operators.md
- solutions/no-multi-layer-creative-support.md
- solutions/no-real-time-campaign-performance-data.md
- solutions/proof-of-play-every-screen.md
- solutions/real-time-creative-control.md
- solutions/secure-client-access-to-screens.md
- solutions/too-many-text-changes-per-creative.md
- solutions/too-much-time-spent-scheduling-creatives.md
- solutions/unified-analytics-across-billboard-networks.md

### docs/use-cases/

- use-cases/by-industry/animal-rescue.md
- use-cases/by-industry/automotive.md
- use-cases/by-industry/coffee-shops.md
- use-cases/by-industry/construction-equipment.md
- use-cases/by-industry/convenience-gas-stations.md
- use-cases/by-industry/entertainment-sports.md
- use-cases/by-industry/financial-services.md
- use-cases/by-industry/fitness-recreation.md
- use-cases/by-industry/furniture.md
- use-cases/by-industry/grocery.md
- use-cases/by-industry/healthcare.md
- use-cases/by-industry/higher-education.md
- use-cases/by-industry/hospitality-tourism.md
- use-cases/by-industry/index.md
- use-cases/by-industry/insurance.md
- use-cases/by-industry/jewelry.md
- use-cases/by-industry/lawn-garden.md
- use-cases/by-industry/legal-services.md
- use-cases/by-industry/news-media.md
- use-cases/by-industry/orthodontics.md
- use-cases/by-industry/qsr-restaurants.md
- use-cases/by-industry/real-estate.md
- use-cases/by-industry/recreational-marine.md
- use-cases/by-industry/retail.md
- use-cases/by-industry/spa-salon.md
- use-cases/by-industry/transportation-government.md
- use-cases/by-role/account-executive-at-ad-agency.md
- use-cases/by-role/account-executive-at-media-owner-operator.md
- use-cases/by-role/brand-manager-at-franchisor-or-parent-corporation.md
- use-cases/by-role/chief-marketing-officer-at-advertiser-or-brand.md
- use-cases/by-role/creative-director-at-ad-agency.md
- use-cases/by-role/data-analyst-at-advertiser.md
- use-cases/by-role/dynamic-creative-programmer-at-media-owner-operator.md
- use-cases/by-role/general-manager-at-owner-operator.md
- use-cases/by-role/graphic-designer-at-creative-team.md
- use-cases/by-role/index.md
- use-cases/by-role/local-franchise-owner-at-location-general-manager.md
- use-cases/by-role/marketing-assistant-at-advertiser.md
- use-cases/by-role/marketing-manager-at-advertiser.md
- use-cases/by-role/media-buyer-at-ad-agency.md
- use-cases/by-role/public-relations-manager-at-ad-agency.md
- use-cases/by-role/software-developer-in-marketing-technology-space.md
- use-cases/by-role/traffic-scheduler-at-media-owner-operator.md
- use-cases/by-role/website-developer-for-billboard-operator-websites.md
- use-cases/index.md

## Usage

### For LLMs and Automated Tools

All Markdown files maintain their original formatting and are suitable for:
- Direct ingestion into LLM context windows
- Search indexing and semantic analysis
- Documentation parsing and extraction
- Offline reading and reference

### For Static Site Generation

Use the included `mkdocs.yml` to rebuild the full documentation site:

```bash
pip install mkdocs mkdocs-material
mkdocs build
```

### File Format

All files use standard Markdown with:
- YAML frontmatter (optional) for metadata
- Standard Markdown syntax
- Relative links between documents
- Embedded images (if any) referenced relatively

## Metadata

See `manifest.json` for:
- Version information
- Generation timestamp
- Complete file listing
- Archive statistics
