---
title: "Lucit vs Formetco - Digital Billboard Manufacturing vs Creative Platform"
description: "Compare Lucit's creative management platform with Formetco's turnkey digital billboard manufacturing and integrated software solutions."
keywords: "Lucit vs Formetco, digital billboard manufacturing, turnkey LED solutions, billboard hardware software"
---

# Lucit vs Formetco

## Displaying Lucit Content on Formetco

The comparison information below is a comparison between the native / built-in features of Formetco, versus, WITHOUT a Lucit integration enabled, versus WITH Lucit enabled (the Lucit Column is the features you will get if you integrate Lucit into Formetco).

The Formetco column is the feature set if you DO NOT integrate Lucit.

This is designed to help you understand how Lucit can help you with your dynamic creative delivery.

If you wish to use Lucit and get all the features of the Lucit platform, while using Formetco as your primary CMS - You can integrate Lucit into Formetco by following the guide at [How to Schedule Lucit Campaigns in Formetco F360](../guides/integrations/how-to-schedule-lucit-campaigns-in-formetco-f360.md).

## Overview

Formetco is a manufacturer and fabricator of digital billboards, LED signs, sports displays, and outdoor advertising structures with turnkey solutions. Family-owned since 1968, they emphasize American manufacturing, custom solutions, and comprehensive service including design, manufacturing, and support. They provide hardware manufacturing with integrated software solutions, focusing on turnkey display solutions for OOH operators, sports venues, and businesses.

## Does Lucit work WITH Formetco?

Yes - You can create a Lucit powered creative campaign in Formetco Software and get all of the features of Lucit via the integration


Please see below for the the features that Lucit provides that Formetco does not unless you enable the Lucit Integration


## Key Comparison Points

### Technology & Platform

| Feature | Lucit | *Formetco* |
|---------|--------|--------------|
| API Access | Yes | No|
| Mobile app | Yes (Android and iOS) |No |
| Web Based | Yes |Yes |
| White Label Capability | Yes |No |
| User Security | Strong,  Requires 2fa |Weak - Password based |
| User roles / permissions | Strong and granular | No |
| Client Login | Yes | No |
| Agency / Multiple Account Access | Yes |No |
| Community Engagement Account Tools | Yes - Build publicly accessible campaigns for community members to post to |No |



### Creatives

| Feature | Lucit | *Formetco* |
|---------|--------|--------------|
| Works on Any type of Screen / Player Software | Yes | Limited - Primarily Formetco hardware |
| Sizing / Grouping | One creative, contains multiple sizes |1 ad per size |
| Responsive | Automatically resizes to screens without distortion | No|
| Dynamic Elements | Unlimited dynamic elements from unlimited data sources | No|
| On Screen Proofs | Real-world screen proofs / mockups with Lucit XR |No |
| Auto Generated from Data | Generate unlimited creatives from data |No |
| Data based triggers | Unlimited data triggers from any data source | No|
| Custom Data Sources | Build custom data sources using Lucit tools |No |
| Date / Time scheduling | Yes, date, day of week, time of day | Basic content scheduling |
| Screen Targeting | Yes - Select or via data / filters |Yes |
| Size / Format Support | Unlimited | Limited to Formetco displays |
| Layer based Templates | Yes |No |
| Template - Fonts | Unlimited | No|
| Template - Colors | Unlimited |No |
| Template - Shadows, Borders | Yes |No |
| Template - Object rotation / transform | Yes |No |
| Template - Transparency | Yes |No |
| Template - Single design multiple size | Yes | No|
| Template - Image position options | Yes (Fixed, fill, stretch, positioning) | No|
| Template - Font Stroke | Yes | No |
| Template - Opacity | Yes |No |
| Template - Object Borders | Yes |No |
| Template - CSS Support | Support ALL CSS Features |No |
| Template - HTML Based | Yes | No|
| Template - Renders to JPEG | Yes | Yes|
| Template - Can render to HTML | Yes |No |
| Template - Use rules to apply template to different data | Yes | No|
| Template - Custom Field / Function Support | Yes |No |
| Template - Javascript Support | Yes |No |
| Template - Library of pre-built content | Limited / small | Creative library services |
| Elements - Countdowns | Yes (Day, Hour, Minute) |Yes |
| Elements - Social | Yes - via Taggbox integration | No|
| Elements - Weather | Yes - screen or destination | Yes|
| Animation Support | Yes | No|
| Video Support | Yes |Yes |
| AI Assisted Moderation | Yes | No|



### Data Sources

| Feature | Lucit | *Formetco* |
|---------|--------|--------------|
| Supported Types | Unlimited | |
| Multiple data sources on a single creative | Yes | No|
| Bespoke Apps for specific data | Yes - See 100's at [Lucit Apps List](https://lucit.app/apps) |No |
| Authenticated data sources (oAuth, etc.) | Yes | No|
| First party / Private data sources | Yes |No |
| Create custom data sources | Yes |No |
| Data sources can generate ads | Yes | No|
| Data sources as triggers | Yes |No |
| Data source data filtering and rules | Yes, unlimited and easy to setup No| |
| Data source automated triggers | Yes - When generating a creative, specify the triggers that are attached |No |
| Data source limits | Yes |No |
| Data source update frequency control | Yes |No |
| Built in Sports Scores data for all major sports | Yes |No |
| Built in Weather data | Yes |No |
| Social Data Feeds | Yes |No |
| Automotive Data | Yes | No|
| Real Estate Data | Yes |No |
| Google Sheets / Docs | Yes | No|
| RSS | Yes | No|
| JSON | Yes | No|


### Campaign Operations

| Feature | Lucit | *Formetco* |
|---------|--------|--------------|
| Multi operator campaigns | Manage multiple campaigns across multiple billboard operators from a single interface | No - Limited to Formetco displays |
| Individual screen targeting within campaign per creative | Yes | Yes |
| Individual screen targeting based on screen data, location, weather, etc. | Yes |No |
| Auto-Post to campaigns from Data Sources | Yes, unlimited | No|
| Frequency control among creatives in a campaign | Yes - Via percentages |No |
| Bulk Edit / Update | Yes |No |
| Schedule / Timeline View | Yes |Yes |
| Share a campaign with multiple child accounts | Yes |No |
| Brokers share real-estate campaign with all agents | Yes |No |



### Analytics & Reporting

| Feature | Lucit | *Formetco* |
|---------|--------|--------------|
| Real time analytics | Yes - plays report in real-time | Basic display monitoring |
| Historical data | Yes - Up to 3 years |Yes |
| Charting | Yes | No|
| API Access | Yes |No |
| Plays and Impressions | Yes - Both | Plays only |
| Analytics for every dynamic creative change | Yes |No |
| Third Party Impression Trackers | Yes - DV360 and custom |No |




## Summary

Lucit and Formetco serve different needs in the digital signage ecosystem. Lucit provides platform-agnostic creative management with advanced dynamic capabilities and multi-operator support, while Formetco offers complete turnkey hardware-software solutions with custom manufacturing. Choose Lucit for flexible, multi-platform creative management with sophisticated content capabilities, or Formetco for complete custom hardware solutions with integrated content management.

---

*Want to learn more about how Lucit compares to Formetco? [Contact our team](https://lucit.app/contact) for a detailed comparison and demo.*