---
title: "Lucit Platform Definitions - DOOH & Digital Advertising Terms"
description: "Complete glossary of Lucit platform terms and digital out-of-home advertising definitions. Essential terminology for DOOH, PDOOH, and programmatic advertising."
keywords: "DOOH definitions, digital billboard terms, programmatic advertising glossary, Lucit terminology"
audience: [developer, marketer, operator, agency]
category: reference
difficulty: beginner
tags: [glossary, definitions, terminology, reference, DOOH, PDOOH, OOH, advertising]
related_topics:
  - developer/index.md
  - guides/index.md
  - about.md
  - guides/user-roles-reference.md
last_updated: "2026-01-09"
---

# Lucit Platform — Definitions

This page defines common terms used throughout the **Lucit Platform** and the broader **Out-Of-Home (OOH)**, **Digital Out-Of-Home (DOOH)**, and **Programmatic DOOH (PDOOH)** ecosystems.

Many terms are used interchangeably across the industry. Where applicable, those equivalencies are explicitly noted to reduce ambiguity for users, integrators, search engines, and AI systems.

---

## Summary

This glossary contains **40+ essential terms** for understanding digital out-of-home advertising with Lucit. Terms are organized by category for easy navigation, with aliases and cross-references to help you find what you need quickly.

**Key Takeaways:**
- 📌 Many industry terms are interchangeable (noted with "Aliases")
- 📌 Definitions include Lucit-specific implementation details
- 📌 Cross-references help you understand relationships between concepts
- 📌 Examples provide real-world context for each term

**Quick Navigation:** 
[Users & Organizations](#users--organizations) | [Screens & Inventory](#screens--inventory) | [Out-of-Home](#out-of-home-advertising) | [Campaigns & Creative](#campaigns--creative) | [Creative Production](#creative-production) | [Formats & Playback](#formats--playback) | [Data & Logic](#data--logic) | [Integration & Players](#integration--players) | [Automation](#automation--programmatic) | [Scheduling](#scheduling--delivery) | [Developer & Applications](#developer--applications) | [AdTech](#advertising-technology-adtech) | [Security](#security)

---

## Quick Reference Table

| Category | Key Terms | Count |
|----------|-----------|-------|
| [Users & Organizations](#users--organizations) | User, Account, Agency, Operator, Profile | 5 |
| [Screens & Inventory](#screens--inventory) | Screen, Billboard, Billboard Owner | 3 |
| [Out-Of-Home](#out-of-home-advertising) | OOH, DOOH, PDOOH, Programmatic | 4 |
| [Campaigns & Creative](#campaigns--creative) | Campaign, Creative, Dynamic Creative, DCO, Fallback, Post Ad, Approve, Publish | 9 |
| [Creative Production](#creative-production) | Template Designer, Canvas, Layer, Editor Mode, Dynamic Data Element, Cropping & Sizing, LucitXR, Proof Page | 8 |
| [Formats & Playback](#formats--playback) | Format, Play, Slot, Frequency, Aspect Ratio, Impression, POP, Play Report | 8 |
| [Data & Logic](#data--logic) | Data Source, Trigger, Macro, Field Map, Rule, Data Source Provider, Field Map, Inventory Type, Caching Layer, Refresh, Webhook | 11 |
| [Integration & Players](#integration--players) | Player, CMS, Live Link, XML Feed, HTML Package, DPF, VAST, Deal ID | 8 |
| [Automation](#automation--programmatic) | Automation, Deal | 2 |
| [Scheduling](#scheduling--delivery) | Scheduler, Trafficking | 2 |
| [Developer & Applications](#developer--applications) | Application Class, Application Capability, LCUID, Bot, Bot Token, Application Permission, API Token, Secret | 8 |
| [AdTech](#advertising-technology-adtech) | SSP, DSP, Ad Server | 3 |
| [Security](#security) | 2FA, MFA | 1 |

**Total Terms Defined:** 70+

---

## Alphabetical Index

**A-C:** [Account](#account) | [Ad Server](#ad-server) | [Agency](#agency) | [API Token](#api-token) | [App](#app-in-lucit) | [Application Capability](#application-capability) | [Application Class](#application-class) | [Application Permission](#application-permission) | [Approve](#approve--approval) | [Aspect Ratio](#aspect-ratio) | [Automation](#automation) | [Billboard](#billboard) | [Billboard Owner](#billboard-owner) | [Bot](#bot) | [Bot Token](#bot-token) | [Caching Layer](#caching-layer) | [Campaign](#campaign) | [Canvas](#canvas) | [CMS](#cms-content-management-system) | [Creative](#creative) | [Cropping & Sizing](#cropping--sizing)

**D-F:** [Data Source](#data-source) | [Data Source Provider](#data-source-provider) | [DCO](#dco-dynamic-creative-optimization) | [Deal](#deal) | [Deal ID](#deal-id--insertion-order) | [DOOH](#digital-out-of-home-dooh) | [DPF](#dpf-daktronics-package-file) | [DSP](#dsp-demand-side-platform) | [Dynamic Creative](#dynamic-creative) | [Dynamic Data Element](#dynamic-data-element) | [Editor Mode](#editor-mode) | [Fallback Creative](#fallback-creative) | [Field Map](#field-map) | [First Party Data Feed](#first-party-data-feed) | [Format](#format) | [Frequency](#frequency)

**H-L:** [HTML Package](#html-package) | [Impression](#impression) | [Insertion Order](#deal-id--insertion-order) | [Inventory Type](#inventory-type) | [Layer](#layer--element) | [LCUID](#lcuid-lucit-unique-id) | [Live Link](#live-link) | [LucitXR](#lucitxr)

**M-P:** [Macro](#macro) | [MFA](#2fa--mfa-two-factor--multi-factor-authentication) | [OOH](#out-of-home-ooh) | [Operator](#operator) | [OOH Scheduler](#ooh-scheduler) | [OOH Traffic](#ooh-traffic--trafficking) | [PDOOH](#programmatic-digital-out-of-home-pdooh) | [Play](#play) | [Play Report](#play-report) | [Player](#player) | [POP](#pop-proof-of-play) | [Post Ad](#post-ad) | [Profile](#profile) | [Programmatic](#programmatic-ooh-context) | [Proof Page](#proof-page) | [Publish](#publish)

**R-Z:** [Refresh](#refresh) | [Responsive Creative](#responsive-creative) | [Rule](#rule--condition) | [Screen](#screen) | [Secret](#secret) | [Slot](#slot) | [SSP](#ssp-supply-side-platform) | [Template Designer](#template-designer) | [Third Party Data Feed](#third-party-data-feed) | [Trigger](#trigger) | [User](#user) | [VAST](#vast) | [Webhook](#webhook) | [XML Feed](#xml-feed) | [2FA](#2fa--mfa-two-factor--multi-factor-authentication)

---

## Users & Organizations

### **User**

**Category:** Platform Entity | **Also Known As:** Platform User, Account Member

**Definition:** An individual person who can authenticate into the Lucit Platform.

**Detailed Explanation:**
Users are assigned roles and permissions that determine what actions they can perform within an Account. Users are not "created" by account owners, but are instead "invited". A user must sign-up/register on Lucit in order to have access.

**In Lucit:**
- Invites are extended to users via their email address or phone number
- When registering and/or signing in, users must authenticate via 2FA (typically via their mobile phone number)
- A user can have access to multiple accounts with different permission levels in each

**Example:**
Sarah is a marketing manager who has been invited to three different Lucit accounts: her company's account (as an admin), a client's account (as a creative designer), and a partner agency account (as a viewer).

**Related Terms:** [Account](#account) | [Agency](#agency) | [Operator](#operator)  
**See Also:** [User Roles Reference](guides/user-roles-reference.md) | [2FA](#2fa--mfa-two-factor--multi-factor-authentication)

---

### **Account**

**Category:** Platform Entity | **Also Known As:** Organization, Company Profile

**Definition:** A top-level organizational entity within Lucit that represents a business, brand, agency, or media owner.

**Detailed Explanation:**
An Account contains users, creatives, campaigns, screens, data sources, and platform configurations. It serves as the primary container for all resources and activities within Lucit.

**In Lucit:**
- Each account has its own set of users with specific permission levels
- Data sources and templates are scoped to the account level
- Billing and subscription settings are managed per account
- Accounts can collaborate with other accounts for campaign management

**Example:**
"Bob's Pizza" has a Lucit Account that contains 50 restaurant locations as screens, 3 team members as users, multiple dynamic templates for menu items, and data sources connected to their inventory system.

**Related Terms:** [User](#user) | [Campaign](#campaign) | [Data Source](#data-source)  
**See Also:** [Getting Started Guide](guides/index.md) | [About Lucit](about.md)

---

### **Agency**

**Aliases:** Ad Agency, Marketer, Advertiser | **Category:** Organization Type

**Definition:** An organization that plans, creates, and manages advertising campaigns on behalf of brands or clients.

**Detailed Explanation:**
Agencies typically create creatives, configure data sources, and deploy campaigns to media owners or programmatic platforms. In the DOOH ecosystem, agencies act as intermediaries between advertisers and media owners.

**In Lucit:**
- Agencies can manage multiple client accounts from a single interface
- Agency users can switch between different account profiles
- Agencies create campaigns that are then scheduled by operators on their screens

**Example:**
Creative Media Agency manages DOOH campaigns for 15 restaurant chains. They use Lucit to create dynamic menu boards that automatically update pricing and availability, then coordinate with 8 different billboard operators to display the content.

**Related Terms:** [Operator](#operator) | [Account](#account) | [Campaign](#campaign)  
**See Also:** [Agency Workflow Guide](guides/index.md) | [Managing Campaigns Across Operators](solutions/managing-campaigns-across-operators.md)

---

### **Operator**

**Aliases:** Media Owner, Sign Owner, Billboard Operator, Publisher | **Category:** Organization Type

**Definition:** An organization that owns, operates, or manages advertising inventory.

**Detailed Explanation:**
Operators control screens, scheduling, playback systems, and campaign fulfillment. They provide the physical infrastructure (digital billboards) and manage what content plays on their network.

**In Lucit:**
- Operators integrate their player systems (CMS) with Lucit
- They approve and schedule campaigns from agencies/advertisers
- Operators can provide screen access to multiple agencies and clients
- They manage screen inventory, formats, and availability

**Example:**
Midwest Digital Billboards operates 200 digital screens across 5 states. They use Lucit to give their agency partners the ability to create dynamic campaigns, while maintaining control over scheduling and playback through their Watchfire player system.

**Related Terms:** [Agency](#agency) | [Screen](#screen) | [CMS](#cms-content-management-system)  
**See Also:** [Operator Workflow Guide](guides/index.md) | [Screen Format Reference](guides/screen-format-reference.md)

---

### **Profile**

**Category:** User Interface | **Also Known As:** Context View, Account Profile, User Profile, Operator Profile

**Definition:** A specific context or organizational view within the Lucit platform that determines what resources and capabilities are accessible.

**Detailed Explanation:**
Profiles allow users to switch between different organizational contexts within Lucit. Each profile type provides access to different features, data, and management capabilities appropriate to that role.

**In Lucit:**
- **Account Profile** - View and manage a specific advertiser account's campaigns and creatives
- **User Profile** - Personal settings, applications, and cross-account access
- **Operator Profile** - Manage screens, approvals, and operator-level applications
- Users can switch between profiles using the profile switcher in the navigation

**Example:**
A user who works for both an advertising agency and operates their own screens would switch between their "Account Profile" (when creating campaigns) and "Operator Profile" (when managing screen inventory and approvals).

**Related Terms:** [User](#user) | [Account](#account) | [Operator](#operator)  
**See Also:** [General Navigation Guide](guides/general-navigation-guide.md) | [User Roles Reference](guides/user-roles-reference.md)

---

**Common Workflows Using These Terms:**
- [Setting up your first account](guides/general-navigation-guide.md)
- [Understanding user roles and permissions](guides/user-roles-reference.md)
- [Managing teams and inviting users](guides/general-navigation-guide.md)

---

## Screens & Inventory

### **Screen**

**Aliases:** Digital Screen, Board, Billboard, Digital Billboard, Panel, AdUnit, Sign | **Category:** Physical Asset

**Definition:** A physical digital display capable of showing advertising content.

**Detailed Explanation:**
In Lucit, these terms are treated as **interchangeable**, representing a single addressable playback surface with defined formats, dimensions, and scheduling constraints. Each screen is a unique display location that can show campaigns.

**In Lucit:**
- Screens are configured with specific formats (dimensions, aspect ratios)
- Each screen has a unique identifier and location
- Screens are linked to player systems (CMS) for content delivery
- Multiple campaigns can be scheduled to the same screen
- Screens can have associated data (location, demographics, traffic patterns)

**Example:**
A digital billboard on Highway 101 at Exit 45 is configured in Lucit as a screen with format 1920x1080 (16:9), connected to a Watchfire player system. This screen can display campaigns from multiple advertisers based on the operator's scheduling.

**Related Terms:** [Billboard](#billboard) | [Format](#format) | [CMS](#cms-content-management-system)  
**See Also:** [Screen Format Reference](guides/screen-format-reference.md) | [Campaign Scheduling Guide](guides/campaign-page-navigation-guide.md)

---

### **Billboard**

**Category:** Physical Asset | **Context:** Typically refers to digital billboards in Lucit

**Definition:** A large-format outdoor advertising display.

**Detailed Explanation:**
Billboards may be static (printed) or digital (LED/LCD displays). Within Lucit documentation, the term typically refers to **digital billboards** unless otherwise specified. Digital billboards can display multiple ads in rotation and support dynamic content.

**In Lucit:**
- "Billboard" and "Screen" are used interchangeably
- All billboard references assume digital capability unless noted as "static"
- Billboards are typically categorized by size, location type, and traffic patterns

**Example:**
A 14' x 48' digital billboard in downtown Chicago can rotate 8 different advertisements every 8 seconds, displaying campaigns from multiple brands throughout the day.

**Related Terms:** [Screen](#screen) | [DOOH](#digital-out-of-home-dooh) | [Operator](#operator)  
**See Also:** [Out-of-Home Advertising](#out-of-home-ooh)

---

### **Billboard Owner**

**Category:** Organization Type | **Also Known As:** Asset Owner, Infrastructure Owner

**Definition:** The entity that owns the physical structure or asset on which a billboard is installed.

**Detailed Explanation:**
Ownership may be separate from the operator that manages content and scheduling. For example, a real estate company might own the physical billboard structure, while a media company operates the digital display and manages advertising.

**Example:**
Smith Properties owns the land and physical billboard structure at Interstate 90, but leases it to Midwest Digital Billboards (the operator) who manages the content, scheduling, and advertiser relationships.

**Related Terms:** [Operator](#operator) | [Billboard](#billboard) | [Screen](#screen)

---

**Common Workflows Using These Terms:**
- [Understanding screen formats and specifications](guides/screen-format-reference.md)
- [Scheduling campaigns to screens](guides/campaign-page-navigation-guide.md)
- [Setting up screen inventory](guides/general-navigation-guide.md)

---

## Out-Of-Home Advertising

### **Out-Of-Home (OOH)**

**Aliases:** Out of Home | **Category:** Advertising Medium

**Definition:** Advertising that reaches consumers while they are outside their homes.

**Detailed Explanation:**
OOH includes billboards, transit displays (buses, trains, subways), street furniture (bus shelters, kiosks), and place-based media (airports, malls, gas stations). It's one of the oldest forms of advertising and has evolved to include digital formats.

**In Lucit:**
While Lucit primarily focuses on digital OOH (DOOH), the platform's principles apply to any screen-based out-of-home advertising.

**Example:**
A comprehensive OOH campaign might include static billboards on highways, digital screens in shopping malls, transit ads on city buses, and digital displays at gas stations.

**Related Terms:** [DOOH](#digital-out-of-home-dooh) | [PDOOH](#programmatic-digital-out-of-home-pdooh)  
**See Also:** [About Lucit](about.md) | [Solutions Overview](solutions/index.md)

---

### **Digital Out-Of-Home (DOOH)**

**Aliases:** Digital Billboards, Digital Out-Of-Home | **Category:** Advertising Medium

**Definition:** OOH advertising delivered on digital screens, enabling time-based scheduling, dynamic content, and data-driven creative.

**Detailed Explanation:**
DOOH represents the evolution of traditional OOH advertising, using LED or LCD displays that can change content throughout the day. This enables multiple advertisers to share the same screen, dynamic content that responds to data, and more flexible campaign management.

**In Lucit:**
Lucit specializes in DOOH, providing tools for creating dynamic campaigns, managing content across multiple operators, and automating creative updates based on real-time data.

**Example:**
A coffee shop chain uses DOOH to display morning specials during rush hour (6-9 AM), lunch combos during midday (11 AM-2 PM), and happy hour promotions in the evening (4-7 PM), all on the same digital billboard.

**Related Terms:** [OOH](#out-of-home-ooh) | [PDOOH](#programmatic-digital-out-of-home-pdooh) | [Dynamic Creative](#dynamic-creative)  
**See Also:** [What is Lucit?](about.md) | [Dynamic Creative Solutions](solutions/index.md)

---

### **Programmatic Digital Out-Of-Home (PDOOH)**

**Aliases:** Programmatic OOH, Programmatic DOOH, pDOOH | **Category:** Buying/Selling Method

**Definition:** The automated buying, selling, and delivery of DOOH inventory using software platforms, real-time decisioning, and defined rules.

**Detailed Explanation:**
PDOOH brings the automation and efficiency of programmatic digital advertising to the out-of-home space. Instead of manual negotiations and insertion orders, campaigns can be bought and sold through platforms, with automated decisioning based on audience data, time of day, weather, and other factors.

**In Lucit:**
Lucit integrates with programmatic platforms like Place Exchange and Vistar Media, allowing campaigns to be delivered programmatically while maintaining Lucit's dynamic creative capabilities.

**Example:**
A fast-food chain uses PDOOH to automatically purchase billboard space within 5 miles of their locations when temperature exceeds 85°F, showing ice cream promotions. The buying, creative delivery, and optimization happen automatically without manual intervention.

**Related Terms:** [DOOH](#digital-out-of-home-dooh) | [DSP](#dsp-demand-side-platform) | [SSP](#ssp-supply-side-platform) | [Deal](#deal)  
**See Also:** [Programmatic Integrations](guides/integrations/index.md) | [Vistar Media Comparison](compare/lucit-vs-vistar-media.md)

---

### **Programmatic (OOH Context)**

**Category:** Buying/Selling Method | **Context:** Automated trading

**Definition:** The use of automated systems to transact OOH inventory via DSPs and SSPs rather than manual scheduling and trafficking.

**Detailed Explanation:**
In the programmatic model, inventory (screen time) is made available through supply-side platforms, and advertisers bid on that inventory through demand-side platforms. Deals are executed automatically based on rules, budgets, and targeting parameters.

**In Lucit:**
Lucit serves as the creative layer in programmatic transactions, delivering the right creative to the right screen at the right time based on programmatic decisions.

**Example:**
Instead of calling 10 different billboard operators to book space, an advertiser uses a DSP to set a budget, target parameters (location, demographics, time), and let the system automatically purchase inventory across multiple operators.

**Related Terms:** [PDOOH](#programmatic-digital-out-of-home-pdooh) | [DSP](#dsp-demand-side-platform) | [SSP](#ssp-supply-side-platform)  
**See Also:** [Place Exchange Integration](guides/integrations/index.md)

---

**Common Workflows Using These Terms:**
- [Understanding DOOH advertising](about.md)
- [Comparing Lucit to other platforms](compare/index.md)
- [Setting up programmatic campaigns](guides/integrations/index.md)

---

## Campaigns & Creative

### **Campaign**

**Category:** Content Container | **Also Known As:** Campaign Folder, Ad Group

**Definition:** A logical container for one or more creatives within Lucit.

**Detailed Explanation:**
A Lucit Campaign functions similarly to a folder or grouping and is later scheduled by the media owner within their CMS or player system.

Once an operator schedules a Lucit Campaign in their CMS, all creative control is then handled via the Lucit platform (adding/removing ads, settings dates/times/screens, configuring triggers, etc.)

**In Lucit:**
- Campaigns contain multiple creatives that can be scheduled together
- Each campaign has settings for screens, dates, and delivery options
- Campaigns can be shared with operators for scheduling approval
- Frequency controls determine how creatives rotate within a campaign

**Example:**
"Summer Menu 2026" is a campaign for Bob's Pizza containing 5 different creatives: breakfast special, lunch combo, dinner deal, late-night offer, and weekend family pack. The operator schedules this campaign to run on 10 screens for 8 weeks, and the creatives rotate based on time-of-day triggers.

**Related Terms:** [Creative](#creative) | [Screen](#screen) | [Operator](#operator)  
**See Also:** [Campaign Navigation Guide](guides/campaign-page-navigation-guide.md) | [Creating Your First Campaign](guides/general-navigation-guide.md)

---

### **Creative**

**Aliases:** Ad, Spot, Asset, Advertisement | **Category:** Content Unit

**Definition:** The visual or multimedia content displayed on a screen.

**Detailed Explanation:**
Creatives may be images, videos, animations, or rendered templates. In Lucit, creatives are the actual content that appears on digital billboards. They are contained within campaigns and scheduled by operators.

**In Lucit:**
Creatives can be:
- **Static uploads**: Directly uploaded images or videos
- **Template-generated**: Created from responsive Lucit Templates via Lucit's HTML → JPEG rendering system
- **Dynamic**: Automatically updated based on data sources

**Example:**
A car dealership has three types of creatives: (1) a static image showing their logo and address, (2) a template-generated creative showing this week's featured vehicles from their inventory system, and (3) a dynamic creative showing the current interest rate that updates daily.

**Related Terms:** [Campaign](#campaign) | [Dynamic Creative](#dynamic-creative) | [Template](#responsive-creative)  
**See Also:** [Template Designer Guide](guides/template-designer-general-navigation-guide.md) | [Creative Management Solutions](solutions/index.md)

---

### **Responsive Creative**

**Aliases:** Adaptive Creative, Multi-Format Creative | **Category:** Creative Type

**Definition:** A creative that automatically adapts its layout, typography, or composition to different screen sizes, orientations, or formats.

**Detailed Explanation:**
Rather than creating separate creatives for every screen size (1920x1080, 1080x1920, 1400x400, etc.), responsive creatives automatically adjust to fit any format while maintaining design integrity.

**In Lucit:**
- Templates in Lucit are inherently responsive
- Design once, deploy to any screen format automatically
- Elements reposition and resize based on screen dimensions
- Eliminates the need to recreate creatives for different screen sizes

**Example:**
A restaurant creates one responsive template for their daily special. This single template automatically adapts to display correctly on horizontal billboards (16:9), vertical displays (9:16), and ultrawide formats (3.5:1) without any manual adjustments.

**Related Terms:** [Creative](#creative) | [Format](#format) | [Aspect Ratio](#aspect-ratio)  
**See Also:** [Designing for Every Billboard Size](solutions/designing-for-every-billboard-size.md) | [Screen Format Reference](guides/screen-format-reference.md)

---

### **Dynamic Creative**

**Aliases:** DCO, Data-Driven Creative, Live Creative | **Category:** Creative Type

**Definition:** A creative that changes content based on live or scheduled data inputs such as time, location, weather, pricing, inventory, or external APIs.

**Detailed Explanation:**
Dynamic creatives pull data from connected sources and update automatically without manual intervention. This enables personalized, contextual advertising at scale.

**In Lucit:**
- Connect data sources to templates using macros
- Creatives update automatically when data changes
- Support for real-time APIs, databases, spreadsheets, and third-party services
- Triggers can control when specific versions display

**Example:**
A gas station chain displays current fuel prices on their billboards. Prices are pulled from their point-of-sale system every 15 minutes. When prices change, all billboards across their network update automatically within minutes — no manual creative updates needed.

**Related Terms:** [Data Source](#data-source) | [Macro](#macro) | [Trigger](#trigger) | [DCO](#dco-dynamic-creative-optimization)  
**See Also:** [Dynamic Creative Solutions](solutions/dynamic-creatives-too-expensive.md) | [Creating Dynamic Campaigns](guides/how-tos/index.md)

---

### **DCO (Dynamic Creative Optimization)**

**Category:** Process/Technology | **Full Term:** Dynamic Creative Optimization

**Definition:** The process of dynamically assembling or modifying creative output using data rules rather than pre-rendered variations.

**Detailed Explanation:**
DCO systems generate the right creative for the right audience at the right time by combining template structures with live data. In traditional digital advertising, this might mean showing different product recommendations to different users. In DOOH, it means showing contextually relevant content based on location, time, weather, or other factors.

**In Lucit:**
Lucit's entire platform is built around DCO principles, making dynamic creative optimization accessible and affordable for all advertisers, not just enterprise brands.

**Example:**
Instead of creating 100 separate creatives for 100 products, a retailer creates one template and connects it to their inventory database. The DCO system automatically generates the appropriate creative showing in-stock items, current prices, and relevant promotions for each location.

**Related Terms:** [Dynamic Creative](#dynamic-creative) | [Data Source](#data-source) | [Template](#responsive-creative)  
**See Also:** [Dynamic Creative Cost Comparison](solutions/dynamic-creatives-too-expensive.md)

---

### **Fallback Creative**

**Aliases:** Default Creative, Backup Creative, Fail-Safe Creative | **Category:** Creative Type

**Definition:** A default creative that is displayed when required data is unavailable, invalid, delayed, or fails validation.

**Detailed Explanation:**
Fallback creatives ensure uninterrupted playback and compliance with scheduling rules. They prevent blank screens or errors when dynamic data sources experience issues.

**In Lucit:**
- Every dynamic campaign should have a fallback creative
- Fallbacks display when APIs are down, data is missing, or triggers aren't met
- Can be a static image or a simplified version of the dynamic creative
- Automatically switches to fallback and back to dynamic without manual intervention

**Example:**
A sports bar displays live game scores on their billboards. When no games are in progress or the scores API is unavailable, the fallback creative displays their restaurant logo, hours, and "Game Day Headquarters" message.

**Related Terms:** [Dynamic Creative](#dynamic-creative) | [Data Source](#data-source)  
**See Also:** [Best Practices for Dynamic Creatives](solutions/index.md)

---

### **Post Ad**

**Category:** Workflow Action | **Also Known As:** Create Ad, Upload Ad, Publish Ad

**Definition:** The workflow process in Lucit for creating and publishing an advertisement to a campaign.

**Detailed Explanation:**
Post Ad is the primary action users take to add new content to their campaigns. The workflow guides users through either uploading complete creative files or filling in dynamic template fields to generate ads across multiple screen formats.

**In Lucit:**
- Accessible from multiple locations: Account Home, Campaign pages, Template pages
- Two main paths: Complete Creative (upload images) or Dynamic Template (fill data fields)
- Includes cropping/sizing options for multi-format support
- Ends with a Proof Page for review before publishing

**Example:**
A restaurant chain needs to post a lunch special ad. They click "POST AD" from their campaign page, select their menu template, fill in today's special items and prices, preview the proof, and publish—the ad appears on all their screens within minutes.

**Related Terms:** [Campaign](#campaign) | [Creative](#creative) | [Template Designer](#template-designer) | [Proof Page](#proof-page)  
**See Also:** [Post Ad Navigation Guide](guides/post-ad-navigation-guide.md)

---

### **Approve / Approval**

**Category:** Workflow Action | **Also Known As:** Ad Approval, Content Approval

**Definition:** The operator or media owner review process that must occur before ads go live on screens.

**Detailed Explanation:**
Approval workflows allow operators to review advertiser content for brand safety, compliance, and technical quality before it displays on their screen inventory. This protects the operator's brand and ensures content meets their standards.

**In Lucit:**
- Operators can require approval for specific accounts or campaigns
- Approvers receive notifications when new ads are posted
- Ads remain in "Pending Approval" status until reviewed
- Operators can approve or reject with feedback
- Controlled by user roles and permissions

**Example:**
A billboard operator requires approval for all alcohol advertising. When an advertiser posts a new beer ad, it enters "Pending Approval" status. The operator's traffic manager reviews the creative, confirms it meets local regulations and their brand standards, then approves it. Only then does the ad become available for scheduling on screens.

**Related Terms:** [Operator](#operator) | [Post Ad](#post-ad) | [Trafficking](#ooh-traffic--trafficking)  
**See Also:** [User Roles Reference](guides/user-roles-reference.md) | [Operator Workflows](guides/index.md)

---

**Common Workflows Using These Terms:**
- [Creating your first campaign](guides/campaign-page-navigation-guide.md)
- [Designing dynamic templates](guides/template-designer-general-navigation-guide.md)
- [Managing multiple creatives](solutions/too-many-text-changes-per-creative.md)

---

## Creative Production

### **Template Designer**

**Category:** Platform Tool | **Also Known As:** Creative Designer, Template Builder

**Definition:** Lucit's browser-based interface for creating multi-layer, responsive creative templates with dynamic data integration.

**Detailed Explanation:**
The Template Designer is where users build reusable creative templates that automatically adapt to different screen sizes and incorporate live data. It provides layer-based composition, responsive design controls, data source integration, and real-time preview capabilities.

**In Lucit:**
- Drag-and-drop interface for adding layers (backgrounds, logos, text, data fields)
- Responsive sizing controls for multi-format support
- Dynamic Data Elements pull from connected apps
- Canvas shows live preview of design
- LucitXR integration for on-screen proofing
- Accessible from Templates section: `Templates → Create`

**Example:**
A real estate agency uses Template Designer to build a property listing template. They add layers for background image, property photo, price text, address text, and agent info. They connect it to their MLS data feed, making price and details dynamic. The template automatically generates listings for all properties across all screen formats.

**Related Terms:** [Canvas](#canvas) | [Layer](#layer--element) | [Dynamic Data Element](#dynamic-data-element) | [LucitXR](#lucitxr)  
**See Also:** [Template Designer General Navigation Guide](guides/template-designer-general-navigation-guide.md)

---

### **Canvas**

**Category:** UI Component | **Also Known As:** Design Workspace, Artboard

**Definition:** The visual design workspace within Template Designer where creative elements are positioned, sized, and styled.

**Detailed Explanation:**
The Canvas provides a what-you-see-is-what-you-get (WYSIWYG) editing experience. Users can directly manipulate layers, see real-time changes, and preview how designs will appear across different screen formats.

**In Lucit:**
- Shows live preview of current design
- Displays selected format dimensions
- Supports direct manipulation of layers (drag, resize, rotate)
- Switches between formats for responsive design testing
- Displays safe zones and guides

**Example:**
While designing a restaurant menu board template, the designer sees the Canvas displaying the widescreen format. They drag the logo layer to the top-right corner, resize the text layer, and immediately see how it looks. Switching to the vertical format on the Canvas shows how the same design adapts to vertical screens.

**Related Terms:** [Template Designer](#template-designer) | [Layer](#layer--element) | [Editor Mode](#editor-mode)  
**See Also:** [Template Designer General Navigation Guide](guides/template-designer-general-navigation-guide.md)

---

### **Layer / Element**

**Category:** Design Component | **Also Known As:** Creative Element, Design Layer

**Definition:** An individual visual component (image, text, graphic, data field) within a template that can be independently controlled and positioned.

**Detailed Explanation:**
Layers stack to create complete compositions. Each layer has its own properties (position, size, z-order, transparency, styling) and can be static or dynamic. Layer-based design enables complex creative compositions and independent updates of individual elements.

**In Lucit:**
- Types: Background images, logos, text fields, data fields, graphics
- Properties: Position, size, rotation, opacity, z-order (front/back)
- Can be locked or hidden during editing
- Dynamic layers pull data from connected sources
- Each layer adapts independently to different formats

**Example:**
A weather-themed billboard has these layers: (1) animated sky background, (2) city name text, (3) temperature data field, (4) weather icon graphic, (5) sponsor logo. When temperature changes, only layer 3 updates. When switching from landscape to portrait format, each layer repositions appropriately.

**Related Terms:** [Template Designer](#template-designer) | [Canvas](#canvas) | [Dynamic Data Element](#dynamic-data-element)  
**See Also:** [Multi-Layer Creative Support](solutions/no-multi-layer-creative-support.md)

---

### **Editor Mode**

**Category:** Template Setting | **Options:** All Sizes Together, Each Size Independently

**Definition:** A Template Designer setting that controls whether design changes apply simultaneously to all format sizes or only to the currently selected format.

**Detailed Explanation:**
Editor Mode determines the scope of editing actions. "All Sizes Together" is ideal for initial design when you want consistency. "Each Size Independently" allows format-specific adjustments for optimal display on different screen shapes.

**In Lucit:**
- Located in Canvas toolbar: `Canvas → Editor Mode`
- **All Sizes Together**: Changes apply to every format (default for new templates)
- **Each Size Independently**: Adjust positioning, sizing, and visibility per format
- Typical workflow: Design in "All Sizes Together", then refine in "Each Size Independently"

**Example:**
A designer creates a billboard template in "All Sizes Together" mode, adding logo, headline, and image that apply to all formats. Switching to "Each Size Independently", they notice the headline overlaps the image on vertical screens, so they adjust only the 9:16 format's text position without affecting other formats.

**Related Terms:** [Template Designer](#template-designer) | [Canvas](#canvas) | [Responsive Creative](#responsive-creative)  
**See Also:** [Responsive Design Guide](solutions/designing-for-every-billboard-size.md)

---

### **Dynamic Data Element**

**Category:** Template Component | **Also Known As:** Data Field, Dynamic Field, Data Layer

**Definition:** A template field that automatically pulls and displays real-time data from connected data sources.

**Detailed Explanation:**
Dynamic Data Elements are the link between templates and live data. Instead of static text or images, these elements reference data source fields using macros, automatically updating when source data changes.

**In Lucit:**
- Added under `Dynamic Data Elements` section in Template Designer
- Available elements depend on connected data sources (apps)
- Display live data preview in template
- Support formatting, default values, and fallbacks
- Can trigger conditional display rules

**Example:**
A stock ticker template includes a Dynamic Data Element for "Current Price" that references `{account.store.StockApp1_price}`. When the connected stock price app updates (every 15 minutes), the price displayed on all billboards updates automatically without any manual creative changes.

**Related Terms:** [Template Designer](#template-designer) | [Data Source](#data-source) | [Macro](#macro) | [Dynamic Creative](#dynamic-creative)  
**See Also:** [Dynamic Creative Solutions](solutions/dynamic-creatives-too-expensive.md) | [Apps & Data Guide](guides/index.md)

---

### **Cropping & Sizing**

**Category:** Image Handling | **Options:** No Cropping, Zoom to Fit, Stretch to Fill

**Definition:** Options for controlling how images scale and fit within template boundaries across different aspect ratios.

**Detailed Explanation:**
Cropping & Sizing ensures images display properly across multiple screen formats without distortion. Each option handles the tradeoff between maintaining aspect ratio and filling the available space differently.

**In Lucit:**
- **No Cropping**: Maintains exact image aspect ratio, may show letterboxing/pillarboxing
- **Zoom to Fit**: Scales image until it fills the space, may crop edges
- **Stretch to Fill**: Forces image to fill space exactly, may distort aspect ratio
- Applied per-layer in Template Designer
- Critical for responsive designs spanning multiple formats

**Example:**
A horizontal logo (1000×200px) needs to display on both landscape (16:9) and square (1:1) screens. Set to "No Cropping", it maintains its proportions but leaves empty space on square screens. Set to "Zoom to Fit", it fills the square screen but crops the edges. Set to "Stretch to Fill", it fills the space but looks squashed on square screens.

**Related Terms:** [Layer](#layer--element) | [Aspect Ratio](#aspect-ratio) | [Responsive Creative](#responsive-creative)  
**See Also:** [Responsive Design Best Practices](solutions/creatives-break-across-screen-sizes.md)

---

### **LucitXR**

**Category:** Platform Feature | **Full Term:** Lucit Extended Reality

**Definition:** Lucit's augmented reality preview tool that shows exactly how creatives will appear on actual physical screens in real-world environments.

**Detailed Explanation:**
LucitXR uses geolocation and AR technology to overlay creative mockups onto physical billboard locations visible through a mobile device camera. This provides realistic proofs for clients and eliminates guesswork about how designs will look in context.

**In Lucit:**
- Accessible from campaign creative proofs
- Uses device camera + GPS to locate nearby screens
- Overlays actual creative render onto screen location
- Works for any screen in the platform with location data
- Provides shareable proof images and videos

**Example:**
An advertiser in Chicago wants to show their client how the new creative will look before it goes live. They open LucitXR, point their phone at the billboard at Michigan Avenue and Roosevelt, and see their creative displayed on that exact screen in real-time through their camera. They capture a photo to send to the client for approval.

**Related Terms:** [Proof Page](#proof-page) | [Screen](#screen) | [Creative](#creative)  
**See Also:** [Creative Mockup Solutions](solutions/creative-mockups-for-every-placement.md)

---

### **Proof Page**

**Category:** UI Component | **Also Known As:** Preview Page, Creative Proof, Mockup Page

**Definition:** The interface displaying how a creative will render across different formats before publishing.

**Detailed Explanation:**
Proof Pages show final rendered output for all screen formats in a campaign, allowing users to verify designs, test dynamic data, and catch issues before content goes live. It's the last review step before publishing.

**In Lucit:**
- Displays after completing Post Ad workflow
- Shows renders for every format in campaign
- Includes dynamic data preview with live values
- Provides LucitXR access for on-screen proofing
- Allows editing or publishing from same page

**Example:**
After filling in template fields for a new promotional ad, the user sees the Proof Page displaying renders for Poster (9:16), Bulletin (14:48), and Widescreen (32:9) formats. They notice the headline is too large on Poster format, click "Edit", adjust the font size, and regenerate the proof to verify the fix before publishing.

**Related Terms:** [Post Ad](#post-ad) | [Template Designer](#template-designer) | [LucitXR](#lucitxr) | [Publish](#publish)  
**See Also:** [Post Ad Navigation Guide](guides/post-ad-navigation-guide.md)

---

**Common Workflows Using These Terms:**
- [Creating your first campaign](guides/campaign-page-navigation-guide.md)
- [Designing dynamic templates](guides/template-designer-general-navigation-guide.md)
- [Managing multiple creatives](solutions/too-many-text-changes-per-creative.md)

---

## Formats & Playback

### **Format**

A predefined creative layout specification, typically defined by pixel dimensions, orientation, and aspect ratio.
Formats ensure creatives render correctly across different screen types.

---

### **Aspect Ratio**

The proportional relationship between width and height of a creative or screen (e.g., 16:9, 9:16, 1400×400).
Aspect ratio is critical for responsive and scalable DOOH creatives.

---

### **Play**

A single, one-time display of a creative on a screen.
Each Play has:

* A play datetime
* A defined duration (in seconds)

Plays are the fundamental unit of DOOH delivery.

---

### **Slot**

A fractional share of a screen’s total available playback time.
Slots are commonly used in contract DOOH campaigns to divide screen time among advertisers.

**Example:**
If a billboard is divided into 8 slots and each slot is 8 seconds:

* One slot equals **1,350 plays per day** (24 × 60 × 60 ÷ 8 × 1⁄8)

In Programmatic DOOH, campaigns deliver based on impression / play targets, and not specific slot allocations.

---

### **Frequency**

The number of times a creative or campaign is played within a defined time period (e.g., per hour, per day).

Frequency is often used to control pacing, exposure, and delivery fairness.

In Lucit, frequency is controlled as a share of the overall campaign using the Frequency Control Sliders in the campaign.

---

### **Impression**

**Category:** Measurement Unit | **Also Known As:** Ad Impression, Display

**Definition:** A single instance of an advertisement displaying on a screen, synonymous with a Play in DOOH context.

**Detailed Explanation:**
Impressions are the standard unit of measurement for advertising delivery. In DOOH, one impression equals one play (one time a creative displays on a screen for its defined duration). Unlike digital advertising where impressions represent individual user views, DOOH impressions represent screen displays that may be seen by many viewers.

**In Lucit:**
- Tracked automatically when integrated with analytics-capable players
- Reported in campaign analytics dashboards
- Used for programmatic campaign billing and delivery tracking
- Can be estimated or verified depending on player integration

**Example:**
A campaign runs on 10 screens, with each screen displaying the ad 100 times per day. Daily impressions = 1,000. If verified by the player system, these become reportable proof-of-play impressions for billing and performance analysis.

**Related Terms:** [Play](#play) | [POP](#pop-proof-of-play) | [Play Report](#play-report)  
**See Also:** [Analytics Features](guides/index.md)

---

### **POP (Proof of Play)**

**Category:** Analytics | **Full Term:** Proof of Play

**Definition:** Verified playback logs from player systems confirming when and where ads actually displayed.

**Detailed Explanation:**
POP provides accountability in DOOH advertising by documenting actual ad delivery. Player systems record each time a creative plays, capturing timestamp, location, duration, and creative identifier. This data verifies campaign delivery for billing, auditing, and performance analysis.

**In Lucit:**
- Available for campaigns using analytics-capable player integrations
- Displayed in campaign analytics section
- Includes play timestamp, screen location, creative ID, duration
- Enables accurate impression counting and verification
- Note: Legacy player integrations may not support POP reporting

**Example:**
An advertiser contracted for 50,000 impressions across 20 screens. At campaign end, they download the POP report showing 52,340 verified plays with exact timestamps and locations. This documentation proves delivery exceeded contract requirements and provides data for ROI analysis.

**Related Terms:** [Impression](#impression) | [Play](#play) | [Play Report](#play-report) | [Player](#player)  
**See Also:** [Analytics Reporter Capability](developer/apps/application-capabilities-reference.md)

---

### **Play Report**

**Category:** Analytics Document | **Also Known As:** Impression Report, Delivery Report, POP Report

**Definition:** Analytics documentation showing verified playback history, impression counts, and delivery performance for campaigns.

**Detailed Explanation:**
Play Reports compile POP data into actionable formats for stakeholders. Reports typically include impression totals, play frequency by screen/time period, creative performance comparisons, and delivery verification against contracts.

**In Lucit:**
- Generated from campaign analytics section
- Customizable date ranges and screen selections
- Exportable formats (CSV, PDF) for sharing with clients
- Includes impression totals, play counts per screen, hourly/daily breakdowns
- Only available for campaigns with analytics-capable player integrations

**Example:**
A media buyer needs monthly performance data for their client. They generate a Play Report for June showing: 125,000 total impressions across 15 screens, average 278 plays per screen per day, peak performance hours 7-9am and 5-7pm, with individual screen breakdowns and creative rotation data.

**Related Terms:** [POP](#pop-proof-of-play) | [Impression](#impression) | [Analytics Reporter](#application-capability)  
**See Also:** [Campaign Analytics Guide](guides/index.md)

---

## Data & Logic

### **Data Source**

**Aliases:** Data Feed, First Party Data Feed, Third Party Data Feed, App

Any system that provides structured data to Lucit for use in creatives, triggers, or automations.

---

### **First Party Data Feed**

A data source owned or controlled by the advertiser, agency, or operator (e.g., internal APIs, databases, spreadsheets).

---

### **Third Party Data Feed**

A data source provided by an external vendor (e.g., weather, sports, finance, traffic, transit).

---

### **App (in Lucit)**

A packaged integration that connects Lucit to a specific data source or external system and exposes standardized fields for use in creatives and logic.

---

### **Rule / Condition**

A logical expression that evaluates data values.

Rules are typically used within Triggers, Automations, and data processing pipelines and may consist of simple or complex boolean logic.

In Lucit, rules are available on the creative triggers (for screen or data source) and are also available in Data Sources (Rules to use when injesting data) and in Automations (Rules used to apply automations)

Rules can also be used in Lucit to automate creative attachment to campaigns in large campaign / creative environment where lots of creatives are being generated automatically.

---

### **Trigger**

A data-driven boolean (or compound boolean) expression that determines whether a creative **should play or not** at a given moment.

Triggers are evaluated in real time or on a schedule and are commonly used with dynamic creatives.


As an example, in Lucit, you could build a trigger like this : 
*Run Creative X when the temperature is over 90 degrees, the Chicago White Sox won or are winning, and the price of bitcoin is above 100,000*


### **Macro**

A macro is a dynamic field that can be added to a dynamic create template to generate dynamic data driven creatives 

Macros contain data from a user, account, screen (digital board) and come from either user input, or, data sources the generate data.

A reference to all available macros is provided by a **Field Map**

### **Field Map**

A Field Map contains a set of macros that are available for a specific object.   In addition to the macro itself, a field map describes various settings, types and options for every dynamic field macro

---

### **Data Source Provider**

**Category:** Application Capability | **Also Known As:** Data Provider

**Definition:** An application capability that supplies external data to Lucit templates, triggers, and automations.

**Detailed Explanation:**
Data Source Providers are apps that fetch, process, and expose structured data from external systems. They handle authentication, API requests, data transformation, and caching, presenting clean field maps for use in templates.

**In Lucit:**
- Configured in `Apps & Data` section of Account or Operator Profile
- Each provider exposes a field map of available macros
- Types include KeyValue, Inventory, and ListGenerator
- Examples: Weather data, sports scores, stock prices, social feeds, spreadsheets
- Apps may provide multiple data source providers

**Example:**
The Weather app is a Data Source Provider that fetches forecast data from weather APIs. After installation, it exposes macros like `{account.store.Weather1_temperature}` and `{digital_board.store.Weather1_conditions}` that templates can use to display location-specific weather information.

**Related Terms:** [App](#app-in-lucit) | [Field Map](#field-map) | [Macro](#macro) | [Application Capability](#application-capability)  
**See Also:** [Application Capabilities Reference](developer/apps/application-capabilities-reference.md)

---

### **Inventory Type**

**Category:** Data Classification | **Options:** KeyValue, Inventory, ListGenerator

**Definition:** Classification of data source providers based on how they structure and deliver data.

**Detailed Explanation:**
Inventory Types determine how data from providers is organized and accessed in templates. The type affects whether data is account-wide, screen-specific, or generates lists of items.

**In Lucit:**
- **KeyValue**: Simple account-level or screen-level data (weather, stock prices, single values)
- **Inventory**: Items that exist per-screen or per-account, generating individual creative instances
- **ListGenerator**: Creates lists of items that can be iterated in templates
- Determines which macros are available and how data flows to creatives
- Configured when creating Data Source Provider apps

**Example:**
A weather app uses KeyValue type—temperature is account-wide or screen-specific. An event calendar uses Inventory type—each event becomes a separate creative instance. A product feed uses ListGenerator—all products available as a list for rotation.

**Related Terms:** [Data Source Provider](#data-source-provider) | [Field Map](#field-map) | [App](#app-in-lucit)  
**See Also:** [Application Development Guide](developer/index.md)

---

### **Caching Layer**

**Category:** Platform Feature | **Also Known As:** Data Cache, Intelligent Caching

**Definition:** Lucit's middleware system that stores and serves data to reduce external API calls, bandwidth costs, and latency.

**Detailed Explanation:**
The Caching Layer sits between player systems and external data sources, intelligently storing frequently accessed data. It dramatically reduces API costs, improves performance, and provides reliability when external services experience issues.

**In Lucit:**
- Automatically caches data from connected apps/data sources
- Configurable refresh intervals per data source
- Reduces third-party API costs by up to 99%
- Players pull from Lucit's cache, not directly from external APIs
- Provides failover when external sources are unavailable
- Transparent to end users—just works

**Example:**
A campaign showing cryptocurrency prices updates every 15 minutes across 100 screens. Without caching, this would make 400 API calls per hour to the crypto provider. Lucit's Caching Layer makes 4 calls per hour (one per 15 minutes), storing results that all 100 screens pull from—saving 99% of API costs.

**Related Terms:** [Data Source](#data-source) | [Refresh](#refresh) | [App](#app-in-lucit)  
**See Also:** [Dynamic Creative API Cost Solutions](solutions/dynamic-creative-api-costs-too-high.md)

---

### **Refresh**

**Category:** Action | **Also Known As:** Data Refresh, Update Data, Pull Data

**Definition:** The action of fetching updated data from a connected data source, either automatically on schedule or manually triggered.

**Detailed Explanation:**
Refresh updates the cached data that templates use. Automatic refresh runs on configured intervals. Manual refresh allows users to immediately update data when needed, useful for testing or time-sensitive updates.

**In Lucit:**
- Automatic refresh: Configured per data source (every X minutes/hours/days)
- Manual refresh: Available in `Apps & Data → {App} → DATA → REFRESH`
- Manual schedule mode: Requires manual refresh, automatic scheduling disabled
- Refresh updates all creatives using that data source
- Respects API rate limits and caching layers

**Example:**
A real estate agency has their MLS property feed set to auto-refresh every 2 hours. When they get a new listing they want to feature immediately, they go to `Apps & Data → MLS Feed → DATA → REFRESH` to manually trigger an update rather than waiting for the next automatic refresh.

**Related Terms:** [Data Source](#data-source) | [Caching Layer](#caching-layer) | [App](#app-in-lucit)  
**See Also:** [Apps & Data Management Guide](guides/index.md)

---

### **Webhook**

**Category:** Integration Method | **Also Known As:** HTTP Callback, Event Notification

**Definition:** A real-time HTTP notification sent from Lucit to external systems when specific events occur, enabling automated workflows and integrations.

**Detailed Explanation:**
Webhooks enable event-driven integrations where Lucit pushes notifications to external systems when things happen (campaign published, creative approved, play logged). This allows external systems to react immediately without polling for changes.

**In Lucit:**
- Used in apps with the Automation capability added to them
- Available for accounts, creatives, campaigns and related events.
- Payload includes event type, timestamp, relevant entity data
- Mentioned in integration guides for advanced configurations

**Example:**
A media agency integrates their CRM with Lucit using webhooks. When a campaign is published in Lucit, a webhook fires to their CRM, automatically updating the campaign status and notifying the account manager that the campaign is live—no manual status updates needed.

**Related Terms:** [API Token](#api-token) | [Integration](#integration--players)  
**See Also:** [API Documentation](developer/api/index.html) | [Integration Guides](guides/integrations/index.md)

---

## Integration & Players

### **Player**

**Category:** System Component | **Also Known As:** Digital Signage Player, Media Player, CMS

**Definition:** The software/hardware system that manages content playback on digital screens.

**Detailed Explanation:**
Players control what displays on screens and when. They communicate with Lucit to pull dynamic creatives, handle scheduling, manage playlists, and report playback data. Players are typically provided by screen operators or media owners.

**In Lucit:**
- Lucit integrates with 13+ major player systems
- Players pull content via Live Links, XML Feeds, HTML Packages, or API endpoints
- Integration complexity varies by player capabilities
- Analytics-capable players report POP data back to Lucit
- Examples: Watchfire, Apparatix, Daktronics, Blip, Vistar Media, Formetco

**Example:**
A billboard operator uses Watchfire player software to manage their 50 screens. They integrate Watchfire with Lucit using XML feeds. Watchfire pulls updated creative URLs from Lucit every 5 minutes, automatically displaying new content when campaigns are published.

**Related Terms:** [CMS](#cms-content-management-system) | [Screen](#screen) | [Operator](#operator)  
**See Also:** [Player Integration Guides](guides/integrations/index.md) | [Lucit vs Player Comparisons](compare/index.md)

---

### **CMS (Content Management System)**

**Aliases:** Player System, Digital Signage Player, Player Software | **Category:** System Type

**Definition:** A system used to manage, schedule, and distribute creative content to digital screens.

**Detailed Explanation:**
In the context of Lucit and DOOH, **CMS** and **Player System** are used interchangeably to refer to the software that controls what content displays on screens and when. Examples include Watchfire, Apparatix, Daktronics, Blip, Vistar Media, and others.

**In Lucit:**
CMS functionality is closely integrated with templates, data sources, and automation through platform integrations.

**Related Terms:** [Player](#player) | [Operator](#operator) | [Ad Server](#ad-server)  
**See Also:** [Integration Hub](guides/integrations/index.md)

---

### **Live Link**

**Category:** Integration Method | **Also Known As:** Direct URL, Real-Time Link

**Definition:** A real-time URL connection allowing player systems to pull dynamic content directly from Lucit without file uploads.

**Detailed Explanation:**
Live Links provide the simplest integration method. Players are configured with a Lucit URL that always returns the current creative. When content updates in Lucit, players automatically receive the new creative on their next fetch—no manual uploads or scheduling changes needed.

**In Lucit:**
- Available in campaign's Link Player section
- Format: `https://lucit.cc/[campaign-hash]/[format-type]`
- Updates automatically when creatives change
- Requires player support for external URL content
- Used by Apparatix, Formetco F360, and other modern players

**Example:**
An operator configures their Apparatix player with Live Link URL: `https://lucit.cc/abc123/poster`. Whenever the advertiser updates their campaign creative in Lucit, the next time the player fetches (typically every 5-15 minutes), it automatically displays the new version—zero manual intervention.

**Related Terms:** [Player](#player) | [XML Feed](#xml-feed) | [Integration](#integration--players)  
**See Also:** [Apparatix Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-apparatix.md)

---

### **XML Feed**

**Category:** Integration Format | **Also Known As:** RSS Feed, Data Feed

**Definition:** Structured XML format for delivering campaign information and creative URLs to player systems.

**Detailed Explanation:**
XML Feeds provide more flexibility than Live Links by including metadata like creative titles, descriptions, start/end dates, and format-specific URLs. Players parse the XML and use the information for scheduling and content management.

**In Lucit:**
- Generated dynamically per campaign and screen location
- Include parameters: `campaign_id`, `location_id`, `format_type`
- Update automatically when campaign changes
- Support location-specific dynamic content
- Used by Watchfire, Blip, Clear Channel, and others

**Example:**
A Watchfire integration uses XML Feed: `https://lucit.cc/feed/xml?campaign=abc123&location=screen_456`. The XML returns creative URLs, titles, and durations that Watchfire imports into its scheduling system. When Lucit campaign updates, the XML feed reflects changes on next fetch.

**Related Terms:** [Player](#player) | [Live Link](#live-link) | [Integration](#integration--players)  
**See Also:** [Watchfire Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-watchfire-ignite.md) | [Blip Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-blip-player.md)

---

### **HTML Package**

**Category:** Integration Format | **Also Known As:** Creative Package, Offline Package

**Definition:** A self-contained bundle of HTML, CSS, JavaScript, and configuration files for deploying dynamic creatives to player systems.

**Detailed Explanation:**
HTML Packages enable dynamic creative functionality on players that don't support live API connections. The package contains all code needed to fetch data and render creatives locally, with configuration files specifying API endpoints and parameters.

**In Lucit:**
- Generated for specific player systems (Ayuda, Vistar, Place Exchange)
- Includes: HTML template, JavaScript logic, CSS styling, settings.js configuration
- Configured with campaign ID, API tokens, location parameters
- Players execute package locally, fetching data from Lucit APIs
- Submitted to player system (uploaded or sent to support team)

**Example:**
For Vistar Media integration, Lucit generates an HTML Package ZIP file containing the creative template, Vistar-specific JavaScript, and configuration for venue-based targeting. The package is submitted to Vistar support who deploys it to their rendering service.

**Related Terms:** [Player](#player) | [Integration](#integration--players) | [API Token](#api-token)  
**See Also:** [Ayuda Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-ayuda.md) | [Vistar Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-vistar-media.md)

---

### **DPF (Daktronics Package File)**

**Category:** File Format | **Full Term:** Daktronics Package File

**Definition:** Proprietary file format used by Daktronics Venus Control Suite for scheduling content on Daktronics displays.

**Detailed Explanation:**
DPF files are Daktronics' native format for billboard content. Lucit generates DPF files containing dynamic creative logic that operators download and upload to their Venus Control Suite media library for scheduling like standard image files.

**In Lucit:**
- Generated for campaigns using Daktronics app integration
- Downloaded from campaign Link Player section
- Must be uploaded to Venus Control Suite Media Library
- Requires Venus sign GUID for targeting specific screens
- Updates by replacing DPF file in Venus

**Example:**
A Daktronics operator downloads `Campaign_ABC_Bulletin.dpf` from Lucit, uploads it to their Venus Control Suite Media Library, then schedules it in a playlist targeting specific sign GUIDs. The DPF dynamically pulls current creative from Lucit each time it plays.

**Related Terms:** [Player](#player) | [Integration](#integration--players)  
**See Also:** [Daktronics Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-daktronics.md)

---

### **VAST**

**Category:** Format Standard | **Full Term:** Video Ad Serving Template

**Definition:** IAB standard XML format for video ad delivery, supported by some DOOH player systems.

**Detailed Explanation:**
VAST is an industry-standard format originally designed for digital video advertising that some DOOH platforms have adapted. It provides a standardized way to deliver video creative metadata and URLs to players.

**In Lucit:**
- Available through DoohClick and other API-format integrations
- One of multiple format options (JSON, XML, IMAGE, HTML, VAST)
- Used when player systems are VAST-compatible
- Generated dynamically per request with campaign data

**Example:**
A DoohClick integration can use VAST format endpoint to receive video ad specifications in standardized XML format that their player understands natively, enabling video creative playback alongside Lucit's dynamic capabilities.

**Related Terms:** [Player](#player) | [XML Feed](#xml-feed) | [Integration](#integration--players)  
**See Also:** [DoohClick Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-doohclick.md)

---

### **Deal ID / Insertion Order**

**Category:** Programmatic Identifier | **Also Known As:** IO, Deal, Line Item

**Definition:** Unique identifier linking Lucit campaigns to programmatic advertising campaigns in SSP platforms.

**Detailed Explanation:**
Deal IDs create the connection between programmatic ad buying (through SSPs like Vistar or Place Exchange) and Lucit's dynamic creative delivery. The SSP uses the Deal ID to request the appropriate creative from Lucit for each impression.

**In Lucit:**
- Configured in campaign settings when using programmatic integrations
- Links Lucit Campaign to SSP Deal/Insertion Order
- SSP passes Deal ID with each ad request
- Lucit returns appropriate creative based on Deal ID + location
- Used with Vistar Media, Place Exchange integrations

**Example:**
An advertiser books a programmatic campaign through Place Exchange (Deal ID: PX-12345). They enter this Deal ID in their Lucit campaign settings. When Place Exchange wins an impression and requests creative from Lucit, it passes "PX-12345" and the screen location. Lucit returns the corresponding dynamic creative for that deal and location.

**Related Terms:** [Programmatic](#programmatic-ooh-context) | [SSP](#ssp-supply-side-platform) | [Player](#player)  
**See Also:** [Place Exchange Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-place-exchange.md) | [Vistar Integration Guide](guides/integrations/how-to-schedule-lucit-campaigns-in-vistar-media.md)

---

## Automation & Programmatic

### **Automation**

An event-driven workflow composed of one or more actions executed within Lucit.
Automations are typically defined by developers by creating adding the Automatio capability to a new Lucit app, and may create, update, or execute tasks in response to events such as data changes, entity creation, or system activity.

---

### **Deal**

A predefined agreement that governs how inventory is bought or sold programmatically.
Deals may define pricing, targeting constraints, access rules, or priority between buyers and sellers.

With Place Exchange and Vistar Media, Deal ID's are used to link the Lucit Campaign to the Programmatic Campaign within the SSP Platform.   In other words, the SSP makes requests TO LUCIT for a creative by providing a screen id and a deal id

---

## Scheduling & Delivery

### **OOH Scheduler**

**Aliases:** Scheduling, Traffic, Trafficking

The system or process that determines **what content plays, where, and when** across screens.

Scheduling accounts for contracts, priorities, slots, availability, and constraints.

A person who handles scheduling for an operator / media owner is typically called a scheduler

---

### **OOH Traffic / Trafficking**

The operational workflow of managing and scheduling campaigns from booking through fulfillment, including approvals, scheduling, conflict resolution, playback verification, and reporting.

---

## Developer & Applications

### **Application Class**

**Category:** Application Configuration | **Options:** Private, Third Party, Core, Generic

**Definition:** The visibility and access model that determines who can install and use a Lucit application.

**Detailed Explanation:**
Application Classes control application distribution and access permissions. Private apps are for personal/organizational use, Third Party apps are available to all users, while Core and Generic are Lucit internal classifications.

**In Lucit:**
- **Private**: Only the creator and designated members can install
- **Third Party**: Publicly available for any user to install
- **Core**: Lucit internal applications (not available for third-party developers)
- **Generic**: Lucit internal classification (not available for third-party developers)
- Set when creating new application under User Profile

**Example:**
A developer builds a custom inventory management integration for their agency—they set it as "Private" so only their team can use it. Later, they decide to make it publicly available and change the class to "Third Party", allowing any Lucit user to install and benefit from their integration.

**Related Terms:** [Application Capability](#application-capability) | [App](#app-in-lucit)  
**See Also:** [Application Classes & Capabilities Reference](developer/apps/application-capabilities-reference.md)

---

### **Application Capability**

**Category:** Application Configuration | **Examples:** Player, Data Source Provider, Analytics Reporter, White Label

**Definition:** A functional role or set of features that an application provides within the Lucit platform.

**Detailed Explanation:**
Capabilities define what an application does—whether it provides data, connects to player systems, reports analytics, or enables white-label functionality. Apps can have multiple capabilities. This classification helps users understand application purposes and determines what features are available.

**In Lucit:**
- **Player**: Integrates with player/CMS systems for content delivery
- **Data Source Provider**: Supplies external data for templates
- **Analytics Reporter**: Fetches and reports playback/impression data
- **White Label**: Enables branded/customized experiences
- **Automation**: Provides event-driven workflow capabilities
- Configured when building applications

**Example:**
The Watchfire application has three capabilities: "Player" (integrates with Watchfire CMS), "Analytics Reporter" (reports playback data back to Lucit), and "White Label" (supports operator-branded experiences). This tells users it handles both content delivery and performance tracking.

**Related Terms:** [Application Class](#application-class) | [Data Source Provider](#data-source-provider) | [App](#app-in-lucit)  
**See Also:** [Application Classes & Capabilities Reference](developer/apps/application-capabilities-reference.md)

---

### **LCUID (Lucit Unique ID)**

**Category:** Identifier | **Format:** `LCUID-[TYPE]-[UUID]`

**Definition:** System-wide unique identifier for applications, campaigns, screens, and other resources within the Lucit platform.

**Detailed Explanation:**
LCUIDs provide globally unique, type-prefixed identifiers that remain constant across the platform. They enable reliable referencing of entities in APIs, integrations, and documentation regardless of name changes or other modifications.

**In Lucit:**
- Format: `LCUID-LAP-xxxx` (apps), `LCUID-CAM-xxxx` (campaigns), etc.
- Visible in entity details and API responses
- Used for deep linking to specific resources
- Permanent—doesn't change even if entity is renamed
- Required for some API operations and integrations

**Example:**
The Weather app has LCUID `LCUID-LAP-c25386d4-55a5-48a6-b9c8-a189051555bd`. This identifier appears in API responses, documentation links, and developer references. Even if the app is renamed, the LCUID remains constant, preventing broken integrations.

**Related Terms:** [App](#app-in-lucit) | [API Token](#api-token)  
**See Also:** [Application Reference Guide](developer/apps/index.md) | [API Documentation](developer/api/index.html)

---

### **Bot**

**Category:** User Type | **Also Known As:** Service Account, Automated User, Bot User

**Definition:** An automated user account that performs actions programmatically via API rather than through the web interface.

**Detailed Explanation:**
Bots are non-human users designed for integrations, automation, and API access. Unlike regular users, bots can't log into the web interface but can perform actions via API calls using bot tokens with configured permissions.

**In Lucit:**
- Created under applications in User Profile → Apps → {Application} → TOKENS
- Can't log into web interface (programmatic access only)
- Permissions inherited from parent application's configuration
- Used for integrations, data synchronization, automated workflows
- Subject to application permission scope

**Example:**
A marketing agency builds a tool that automatically creates Lucit campaigns from their internal CRM. They create a bot user with campaign creation permissions, generate a bot token, and use it to authenticate API requests. The bot creates campaigns automatically whenever new contracts are signed in their CRM.

**Related Terms:** [Bot Token](#bot-token) | [Application Permission](#application-permission) | [API Token](#api-token)  
**See Also:** [Application Permissions Reference](developer/apps/application-permissions-reference.md)

---

### **Bot Token**

**Category:** Authentication Credential | **Also Known As:** Bot API Token, Service Token

**Definition:** An authentication token that enables a bot to make API requests with specific permissions.

**Detailed Explanation:**
Bot Tokens are long-lived credentials that authenticate bot users for programmatic API access. They carry the permissions configured on their parent application and are scoped to specific accounts or agencies where the application is installed.

**In Lucit:**
- Generated in User Profile → Apps → {Application} → TOKENS → CREATE TOKEN
- Token type: "Authentication Token"
- Inherits permissions from application configuration
- Never expires (unless manually revoked)
- Should be stored securely (environment variables, secrets management)
- Never expose in client-side code or public repositories

**Example:**
An analytics dashboard app needs to read campaign data. Developer generates a bot token with `account.viewAnalytics` and `account.viewCampaigns` permissions. The token is stored in their server environment variables and used to authenticate API requests that fetch campaign performance data for display in their dashboard.

**Related Terms:** [Bot](#bot) | [Application Permission](#application-permission) | [API Token](#api-token) | [Secret](#secret)  
**See Also:** [Application Permissions Reference](developer/apps/application-permissions-reference.md) | [API Documentation](developer/api/index.html)

---

### **Application Permission**

**Category:** Access Control | **Examples:** `account.viewAnalytics`, `agency.createAccounts`, `account.editCampaigns`

**Definition:** Granular access controls defining what actions application bots can perform within accounts or agencies.

**Detailed Explanation:**
Application Permissions determine bot capabilities when users install apps. Permissions are configured on the application and automatically granted to bot tokens when the app is installed in accounts or agencies. This creates a permission elevation model where bots gain specific capabilities in organizational contexts.

**In Lucit:**
- Configured in application settings (Account Permissions & Agency Permissions tabs)
- Two permission scopes: Account (advertiser level) and Agency (operator/agency level)
- Granted when users install app and click "ALLOW"
- Bot tokens automatically gain these permissions for installations
- Principle of least privilege: Request only necessary permissions

**Example:**
A creative management app requests permissions: `account.createCampaigns`, `account.editCampaigns`, `account.uploadCreatives`. When an advertiser installs the app, they review these permissions and click "ALLOW". Now the app's bots can create campaigns and upload creatives to that advertiser's account—but only that account, not others.

**Related Terms:** [Bot](#bot) | [Bot Token](#bot-token) | [Application Class](#application-class)  
**See Also:** [Application Permissions Reference](developer/apps/application-permissions-reference.md) | [User Roles Reference](guides/user-roles-reference.md)

---

### **API Token**

**Category:** Authentication Credential | **Also Known As:** Access Token, Auth Token

**Definition:** A credential for authenticating API requests, can be either a user token or bot token.

**Detailed Explanation:**
API Tokens enable programmatic access to Lucit's API. User tokens provide access based on the user's permissions and roles. Bot tokens provide access based on application permissions. Both authenticate requests and determine what actions can be performed.

**In Lucit:**
- User Tokens: Generated in User Settings → API Tokens
- Bot Tokens: Generated under application TOKENS section
- Passed in API request headers: `Authorization: Bearer {token}`
- Required for all API operations
- Can be revoked at any time
- Should never be committed to code repositories

**Example:**
A developer building a custom integration generates a user API token from their Lucit settings. They use this token to authenticate requests while developing. For production, they create a bot token under their application with appropriate permissions, ensuring the integration works independently of their personal user account.

**Related Terms:** [Bot Token](#bot-token) | [Secret](#secret) | [Application Permission](#application-permission)  
**See Also:** [API Documentation](developer/api/index.html)

---

### **Secret**

**Category:** Authentication Component | **Also Known As:** API Secret, Client Secret

**Definition:** A secure credential component used in API authentication, typically paired with App ID and Token for request signing.

**Detailed Explanation:**
Secrets are cryptographic keys used to sign and verify API requests. Together with App ID and Token, they form the complete authentication credential set for secure API access. Secrets must be protected and never exposed in client-side code.

**In Lucit:**
- Required for API V3 authentication alongside AppIdV3 and Token
- Stored in environment variables: `.env` file
- Used to sign API requests for verification
- Never transmitted in plain text (used for HMAC signing)
- Compromised secrets should be regenerated immediately

**Example:**
A developer sets up API access with three credentials: `AppIdV3=abc123`, `Token=xyz789`, `Secret=secret456`. These are stored in environment variables. Their application uses all three to generate authenticated API requests. The Secret never appears in logs or client code—only used server-side for request signing.

**Related Terms:** [API Token](#api-token) | [Bot Token](#bot-token) | [Application Permission](#application-permission)  
**See Also:** [API Documentation](developer/api/index.html) | [Security Best Practices](developer/index.md)

---

## Advertising Technology (AdTech)

### **SSP (Supply-Side Platform)**

A platform used by media owners to offer inventory programmatically to buyers.

---

### **DSP (Demand-Side Platform)**

A platform used by advertisers or agencies to purchase inventory programmatically.

---

### **Ad Server**

A system responsible for delivering creatives to screens and logging playback events.

---

### **CMS (Content Management System)**

**Aliases:** Player System, Digital Signage Player, Player Software

A system used to manage, schedule, and distribute creative content to digital screens.

In the context of Lucit and DOOH, **CMS** and **Player System** are used interchangeably to refer to the software that controls what content displays on screens and when. Examples include Watchfire, Apparatix, Daktronics, Blip, Vistar Media, and others.

In Lucit, CMS functionality is closely integrated with templates, data sources, and automation through platform integrations.

---

## Security

### **2FA / MFA (Two-Factor / Multi-Factor Authentication)**

Authentication methods requiring two or more verification factors to improve account security.

---

## Notes on Terminology Equivalency

The following terms are considered equivalent or near-equivalent within Lucit documentation:

* **Agency ≈ Advertiser ≈ Marketer**
* **Operator ≈ Media Owner ≈ Billboard Operator ≈ Publisher**
* **Screen ≈ Sign ≈ Board ≈ Billboard ≈ Digital Billboard ≈ AdUnit**
* **Creative ≈ Ad ≈ Inventory Item**
* **Dynamic Creative ≈ DCO**
* **Programmatic ≈ PDOOH**
* **OOH ≈ Digital Out-Of-Home**
* **Player ≈ CMS ≈ Digital Signage Player ≈ Player System**
* **Layer ≈ Element ≈ Creative Element**
* **Impression ≈ Play** (in DOOH context)
* **POP ≈ Proof of Play ≈ Play Report** (analytics context)
* **Data Source ≈ Data Feed ≈ App** (data provider context)
* **Bot Token ≈ Service Token ≈ Bot API Token**
* **Deal ID ≈ Insertion Order ≈ Line Item** (programmatic context)

---
