---
title: "Alterra Mountain Co Ski Resorts - Snow Report - Lucit Application Reference"
description: "Get the current snow report data from various Alterra Mountain Co Ski Resorts including : - Stratton - Snowshoe Mountain - Blue Mountain - Tremblant - Winter Park - Steamboat"
keywords: "lucit application, Alterra Mountain Co Ski Resorts - Snow Report, app reference, integration"
---

# Alterra Mountain Co Ski Resorts - Snow Report

Get the current snow report data from various Alterra Mountain Co Ski Resorts including : - Stratton - Snowshoe Mountain - Blue Mountain - Tremblant - Winter Park - Steamboat

**Application Details:**

- **Name:** Alterra Mountain Co Ski Resorts - Snow Report
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-e4eeaa49-da55-4452-8ea8-61debd8d487e`

---

## View in Lucit

**[🔗 View Alterra Mountain Co Ski Resorts - Snow Report in Lucit](https://lucit.app/AlterraMountainCoSkiResortsSnowReport){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Alterra Mountain Co Ski Resorts - Snow Report to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Alterra Mountain Co Ski Resorts - Snow Report"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Alterra Mountain Co Ski Resorts - Snow Report application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Alterra Mountain Co Ski Resorts - Snow Report Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Alterra Mountain Co Ski Resorts - Snow Report

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Alterra Mountain Co Ski Resorts - Snow Report dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Alterra Mountain Co Ski Resorts - Snow Report**

To add values from Alterra Mountain Co Ski Resorts - Snow Report to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Alterra Mountain Co Ski Resorts - Snow Report `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Alterra Mountain Co Ski Resorts - Snow Report or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Alterra Mountain Co Ski Resorts - Snow Report data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Alterra Mountain Co Ski Resorts - Snow Report:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Ski Resort** | `json` [(enum)](#ski-resort-options) | Choose a Resort | Required |

**Enum Options:**

<a id="ski-resort-options"></a>

*Ski Resort:*

| Label | Value |
|-------|------|
| Stratton | 1 |
| Snowshoe Mountain | 2 |
| Blue Mountain | 3 |
| Tremblant | 4 |
| Winter Park | 5 |
| Steamboat | 6 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Alterra Mountain Co Ski Resorts Snow Report1 Additional Text | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_additional_text}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Alert | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_alert}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last24 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last24_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last24 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last24_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last48 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last48_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last48 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last48_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last7 Days Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last7_days_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last7 Days In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last7_days_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last72 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last72_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Last72 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__last72_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Since Lifts Closed Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__since_lifts_closed_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 All Mountain  Since Lifts Closed In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_all_mountain__since_lifts_closed_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Annual Average Snowfall Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_annual_average_snowfall_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Annual Average Snowfall In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_annual_average_snowfall_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Imperial | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__imperial}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Label | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__label}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Label French | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__label_french}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Last Update | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__last_update}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Location | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__location}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Metric | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__metric}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Name | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__name}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 0  Type | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_0__type}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Imperial | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__imperial}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Label | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__label}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Label French | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__label_french}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Last Update | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__last_update}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Location | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__location}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Metric | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__metric}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Name | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__name}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Api Metrics 1  Type | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_api_metrics_1__type}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Base Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__base_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Base In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__base_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last24 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last24_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last24 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last24_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last48 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last48_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last48 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last48_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last7 Days Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last7_days_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last7 Days In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last7_days_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last72 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last72_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Last72 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__last72_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Since Lifts Closed Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__since_lifts_closed_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Area  Since Lifts Closed In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_area__since_lifts_closed_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Base Conditions | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_base_conditions}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Feed Last Run Had Errors | text | boolean | `{account.store.AlterraMountainCoSkiResortsSnowReport1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Alterra Mountain Co Ski Resorts Snow Report1 Feed Last Run Was Success | text | boolean | `{account.store.AlterraMountainCoSkiResortsSnowReport1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Alterra Mountain Co Ski Resorts Snow Report1 Feed Last Succesful Run At | text | datetime | `{account.store.AlterraMountainCoSkiResortsSnowReport1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Alterra Mountain Co Ski Resorts Snow Report1 Groomed Trails | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_groomed_trails}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Grooming Active | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_grooming_active}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Last Update | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_last_update}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Last Updated Lift  Wild Spur Express Mid  Way Station | text | datetime | `{account.store.AlterraMountainCoSkiResortsSnowReport1_last_updated_lift__wild_spur_express_mid__way_station}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Lift Notification | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_lift_notification}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Base Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__base_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Base In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__base_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last24 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last24_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last24 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last24_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last48 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last48_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last48 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last48_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last7 Days Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last7_days_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last7 Days In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last7_days_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last72 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last72_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Last72 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__last72_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Since Lifts Closed Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__since_lifts_closed_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Mid Mountain Area  Since Lifts Closed In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_mid_mountain_area__since_lifts_closed_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 News | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_news}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Open Halfpipes | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_open_halfpipes}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Open Night Parks | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_open_night_parks}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Open Night Trails | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_open_night_trails}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Open Terrain Acres | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_open_terrain_acres}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Open Terrain Hectares | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_open_terrain_hectares}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Preferred Base Reporting | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_preferred_base_reporting}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Safety Report | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_safety_report}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Season Total Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_season_total_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Season Total In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_season_total_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Secondary Season Total Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_secondary_season_total_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Secondary Season Total In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_secondary_season_total_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Snow Base Range C M | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_snow_base_range_c_m}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Snow Base Range In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_snow_base_range_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Snow Making Active | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_snow_making_active}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Storm Radar | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_storm_radar}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Storm Radar Button Text | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_storm_radar_button_text}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Storm Total C M | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_storm_total_c_m}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Storm Total In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_storm_total_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Base Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__base_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Base In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__base_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last24 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last24_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last24 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last24_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last48 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last48_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last48 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last48_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last7 Days Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last7_days_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last7 Days In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last7_days_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last72 Hours Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last72_hours_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Last72 Hours In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__last72_hours_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Since Lifts Closed Cm | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__since_lifts_closed_cm}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Summit Area  Since Lifts Closed In | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_summit_area__since_lifts_closed_in}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Activities | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_activities}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Halfpipes | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_halfpipes}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Lifts | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_lifts}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Night Parks | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_night_parks}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Night Trails | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_night_trails}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Open Activities | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_open_activities}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Open Lifts | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_open_lifts}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Open Parks | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_open_parks}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Open Trails | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_open_trails}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Park Features | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_park_features}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Parks | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_parks}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Terrain Acres | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_terrain_acres}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Terrain Hectares | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_terrain_hectares}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Trails | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_trails}` | — |
| Alterra Mountain Co Ski Resorts Snow Report1 Total Trails Making Snow | text | scalar | `{account.store.AlterraMountainCoSkiResortsSnowReport1_total_trails_making_snow}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:25 UTC*
