---
title: "CDK Global - Lucit Application Reference"
description: "CDK Global connects you to dealership software solutions that work together to help you reach your potential. Lucit connects to your automotive data feed through CDK Global to..."
keywords: "lucit application, CDK Global, app reference, integration"
---

# CDK Global

CDK Global connects you to dealership software solutions that work together to help you reach your potential. Lucit connects to your automotive data feed through CDK Global to...

**Application Details:**

- **Name:** CDK Global
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-f84d7fb3-78c3-4725-af15-a9a726c92ffd`

---

## View in Lucit

**[🔗 View CDK Global in Lucit](https://lucit.app/CdkGlobal1){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add CDK Global to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "CDK Global"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The CDK Global application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using CDK Global Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### CDK Global

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with CDK Global dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for CDK Global**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on CDK Global to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on CDK Global to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **CDK Global Dealer Id** | `text` | Your Dealership ID | Required |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Cdk Global2 Feed Last Run Had Errors | text | boolean | `{account.store.CdkGlobal2_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Cdk Global2 Feed Last Run Was Success | text | boolean | `{account.store.CdkGlobal2_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Cdk Global2 Feed Last Succesful Run At | text | datetime | `{account.store.CdkGlobal2_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Amenities | text | scalar | `{item.inventory_attributes.amenities}` | — |
| Body Style | text | scalar | `{item.inventory_attributes.body_style}` | — |
| Body Type | text | scalar | `{item.inventory_attributes.body_type}` | — |
| Cdk Style Id | text | scalar | `{item.inventory_attributes.cdk_style_id}` | — |
| Cylinders | text | scalar | `{item.inventory_attributes.cylinders}` | — |
| Date Created | text | scalar | `{item.inventory_attributes.date_created}` | — |
| Displacement | text | scalar | `{item.inventory_attributes.displacement}` | — |
| Doors | text | scalar | `{item.inventory_attributes.doors}` | — |
| Drivetrain | text | scalar | `{item.inventory_attributes.drivetrain}` | — |
| Eng Config | text | scalar | `{item.inventory_attributes.eng_config}` | — |
| Eng Power | text | scalar | `{item.inventory_attributes.eng_power}` | — |
| Engine | text | scalar | `{item.inventory_attributes.engine}` | — |
| Exterior | text | scalar | `{item.inventory_attributes.exterior}` | — |
| Fuel Type | text | scalar | `{item.inventory_attributes.fuel_type}` | — |
| Induction | text | scalar | `{item.inventory_attributes.induction}` | — |
| Interior | text | scalar | `{item.inventory_attributes.interior}` | — |
| Last Modified | text | scalar | `{item.inventory_attributes.last_modified}` | — |
| Lot Date | text | scalar | `{item.inventory_attributes.lot_date}` | — |
| Msrp | text | scalar | `{item.inventory_attributes.msrp}` | — |
| Oem Ext Color Code | text | scalar | `{item.inventory_attributes.oem_ext_color_code}` | — |
| Oem Int Color Code | text | scalar | `{item.inventory_attributes.oem_int_color_code}` | — |
| Oem Model Code | text | scalar | `{item.inventory_attributes.oem_model_code}` | — |
| Option Codes | text | scalar | `{item.inventory_attributes.option_codes}` | — |
| Retail Price | text | scalar | `{item.inventory_attributes.retail_price}` | — |
| Sale Price | text | scalar | `{item.inventory_attributes.sale_price}` | — |
| Speeds | text | scalar | `{item.inventory_attributes.speeds}` | — |
| Trans Text | text | scalar | `{item.inventory_attributes.trans_text}` | — |
| Transmission | text | scalar | `{item.inventory_attributes.transmission}` | — |
| Vehicle Label | text | scalar | `{item.inventory_attributes.vehicle_label}` | — |
| Vehicle Type | text | scalar | `{item.inventory_attributes.vehicle_type}` | — |
| Warranty | text | scalar | `{item.inventory_attributes.warranty}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:24:55 UTC*
