---
title: "Daily Horoscope - Lucit Application Reference"
description: "Daily Horoscope transforms your daily horoscope experience with dynamically generated content for digital billboard campaigns. Deliver the latest astrological insights,..."
keywords: "lucit application, Daily Horoscope, app reference, integration"
---

# Daily Horoscope

Daily Horoscope transforms your daily horoscope experience with dynamically generated content for digital billboard campaigns. Deliver the latest astrological insights,...

**Application Details:**

- **Name:** Daily Horoscope
- **Class:** ThirdParty
- **Capabilities:** Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-8d252558-06b6-4344-8c37-b419deeef206`

---

## View in Lucit

**[🔗 View Daily Horoscope in Lucit](https://lucit.app/DailyHoroscope){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Daily Horoscope to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Daily Horoscope"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Daily Horoscope application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **12 data source provider(s)**.

### Prerequisites to Using Daily Horoscope Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Aquarius Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Aquarius Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Aquarius Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Aquarius Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Aquarius Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Aquarius Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.AquariusHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Aquarius Horoscope Feed Last Run Was Success | text | boolean | `{account.store.AquariusHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Aquarius Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.AquariusHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Aries Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Aries Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Aries Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Aries Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Aries Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Aries Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.AriesHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Aries Horoscope Feed Last Run Was Success | text | boolean | `{account.store.AriesHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Aries Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.AriesHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Cancer Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Cancer Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Cancer Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Cancer Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Cancer Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Cancer Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.CancerHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Cancer Horoscope Feed Last Run Was Success | text | boolean | `{account.store.CancerHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Cancer Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.CancerHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Capricorn Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Capricorn Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Capricorn Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Capricorn Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Capricorn Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Capricorn Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.CapricornHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Capricorn Horoscope Feed Last Run Was Success | text | boolean | `{account.store.CapricornHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Capricorn Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.CapricornHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Gemini Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Gemini Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Gemini Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Gemini Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Gemini Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Gemini Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.GeminiHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Gemini Horoscope Feed Last Run Was Success | text | boolean | `{account.store.GeminiHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Gemini Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.GeminiHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Leo Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Leo Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Leo Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Leo Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Leo Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Leo Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.LeoHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Leo Horoscope Feed Last Run Was Success | text | boolean | `{account.store.LeoHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Leo Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.LeoHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Libra Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Libra Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Libra Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Libra Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Libra Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Libra Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.LibraHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Libra Horoscope Feed Last Run Was Success | text | boolean | `{account.store.LibraHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Libra Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.LibraHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Pisces Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Pisces Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Pisces Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Pisces Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Pisces Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Pisces Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.PiscesHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Pisces Horoscope Feed Last Run Was Success | text | boolean | `{account.store.PiscesHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Pisces Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.PiscesHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Sagittarius Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Sagittarius Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Sagittarius Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Sagittarius Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Sagittarius Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Sagittarius Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.SagittariusHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Sagittarius Horoscope Feed Last Run Was Success | text | boolean | `{account.store.SagittariusHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Sagittarius Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.SagittariusHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Scorpio Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Scorpio Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Scorpio Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Scorpio Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Scorpio Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Scorpio Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.ScorpioHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Scorpio Horoscope Feed Last Run Was Success | text | boolean | `{account.store.ScorpioHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Scorpio Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.ScorpioHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Taurus Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Taurus Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Taurus Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Taurus Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Taurus Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Taurus Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.TaurusHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Taurus Horoscope Feed Last Run Was Success | text | boolean | `{account.store.TaurusHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Taurus Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.TaurusHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Virgo Horoscope

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Virgo Horoscope dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Virgo Horoscope**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Virgo Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Virgo Horoscope to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Virgo Horoscope Feed Last Run Had Errors | text | boolean | `{account.store.VirgoHoroscope_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Virgo Horoscope Feed Last Run Was Success | text | boolean | `{account.store.VirgoHoroscope_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Virgo Horoscope Feed Last Succesful Run At | text | datetime | `{account.store.VirgoHoroscope_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:50 UTC*
