---
title: "Drive Time - Digital Screen to Location - Lucit Application Reference"
description: "Use this app to display the estimated drive time in minutes from your digital board(s) to specific locations of interest Create a list of locations, businesses or intersections to..."
keywords: "lucit application, Drive Time - Digital Screen to Location, app reference, integration"
---

# Drive Time - Digital Screen to Location

Use this app to display the estimated drive time in minutes from your digital board(s) to specific locations of interest Create a list of locations, businesses or intersections to...

**Application Details:**

- **Name:** Drive Time - Digital Screen to Location
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-2d0cb615-4290-488e-bfc6-8a6c8961f245`

---

## View in Lucit

**[🔗 View Drive Time - Digital Screen to Location in Lucit](https://lucit.app/DriveTimeDigitalBoardToLocation){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Drive Time - Digital Screen to Location to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Drive Time - Digital Screen to Location"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Drive Time - Digital Screen to Location application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Drive Time - Digital Screen to Location Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Drive Time - Digital Board to Location

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Drive Time - Digital Board to Location dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Drive Time - Digital Board to Location**

To add values from Drive Time - Digital Board to Location to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Drive Time - Digital Board to Location `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Drive Time - Digital Board to Location or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Drive Time - Digital Board to Location data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Drive Time - Digital Board to Location:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Google Sheet Url** | `text` | Copy and paste the url to your google spreadheet | Required |
| **Google Routes API Key** | `secret` | To use this app, you must register an API key in Google Cloud that has permissions to access the Google Routes API | Required |
| **Routing Preference** | `text` [(enum)](#routing-preference-options) | — | Required |
| **Travel Mode** | `text` [(enum)](#travel-mode-options) | — | Required |
| **Scope keys to this feed** | `int` [(enum)](#scope-keys-to-this-feed-options) | Enable this feature if you have more than one copy of this POI data source on this account | Required |
| **Combine nearby screens when calculating** | `int` [(enum)](#combine-nearby-screens-when-calculating-options) | Enable this to cluster the screens together into a single point when making requests for data.  This can improve the performance of this feed, and reduce api call costs. | — |
| **Distance From Screen Resolution** | `int` [(enum)](#distance-from-screen-resolution-options) | The radius around a screen to pull a data point for.  Useful for adjusting performance of this feed for 100's or 1000's of screens | — |
| **Use specific departure time** | `text` | To only get the travel time for a specific departure time, enter it in here in HH:MM TZ format (e.g. 3:00pm EST) | — |

**Enum Options:**

<a id="routing-preference-options"></a>

*Routing Preference:*

| Label | Value |
|-------|------|
| Traffic Un-Aware | TRAFFIC_UNAWARE |
| Traffic Aware (Current Traffic Conditions) | TRAFFIC_AWARE |

<a id="travel-mode-options"></a>

*Travel Mode:*

| Label | Value |
|-------|------|
| Driving | DRIVE |
| Public Transit | TRANSIT |
| Walking | WALK |

<a id="scope-keys-to-this-feed-options"></a>

*Scope keys to this feed:*

| Label | Value |
|-------|------|
| No | 0 |
| Yes | 1 |

<a id="combine-nearby-screens-when-calculating-options"></a>

*Combine nearby screens when calculating:*

| Label | Value |
|-------|------|
| No | 0 |
| Yes | 1 |

<a id="distance-from-screen-resolution-options"></a>

*Distance From Screen Resolution:*

| Label | Value |
|-------|------|
| 400 Feet | 10 |
| 1000 Feet | 9 |
| 0.5 Miles | 8 |
| 1.5 Miles | 7 |
| 4 Miles | 6 |
| 10 Miles | 5 |
| 25 Miles | 4 |
| 75 Miles | 3 |
| 200 Miles | 2 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Drive Time Digital Board To Location1 Feed Last Run Had Errors | text | boolean | `{account.store.DriveTimeDigitalBoardToLocation1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Drive Time Digital Board To Location1 Feed Last Run Was Success | text | boolean | `{account.store.DriveTimeDigitalBoardToLocation1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Drive Time Digital Board To Location1 Feed Last Succesful Run At | text | datetime | `{account.store.DriveTimeDigitalBoardToLocation1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| L F1150 Nearest Poi Address | text | scalar | `{account.store.LF1150_nearest_poi_address}` | — |
| L F1150 Nearest Poi Bearing | text | float | `{account.store.LF1150_nearest_poi_bearing}` | — |
| L F1150 Nearest Poi Bearing Cardinal | text | scalar | `{account.store.LF1150_nearest_poi_bearing_cardinal}` | — |
| L F1150 Nearest Poi Board Id | text | scalar | `{account.store.LF1150_nearest_poi_board_id}` | — |
| L F1150 Nearest Poi City | text | scalar | `{account.store.LF1150_nearest_poi_city}` | — |
| L F1150 Nearest Poi Country | text | scalar | `{account.store.LF1150_nearest_poi_country}` | — |
| L F1150 Nearest Poi Distance Feet | text | float | `{account.store.LF1150_nearest_poi_distance_feet}` | — |
| L F1150 Nearest Poi Distance Kilometers | text | float | `{account.store.LF1150_nearest_poi_distance_kilometers}` | — |
| L F1150 Nearest Poi Distance Meters | text | float | `{account.store.LF1150_nearest_poi_distance_meters}` | — |
| L F1150 Nearest Poi Distance Miles | text | float | `{account.store.LF1150_nearest_poi_distance_miles}` | — |
| L F1150 Nearest Poi Drive Time Duration Hours | text | float | `{account.store.LF1150_nearest_poi_drive_time_duration_hours}` | — |
| L F1150 Nearest Poi Drive Time Duration Localized | text | scalar | `{account.store.LF1150_nearest_poi_drive_time_duration_localized}` | — |
| L F1150 Nearest Poi Drive Time Duration Minutes | text | float | `{account.store.LF1150_nearest_poi_drive_time_duration_minutes}` | — |
| L F1150 Nearest Poi Drive Time Duration Seconds | text | float | `{account.store.LF1150_nearest_poi_drive_time_duration_seconds}` | — |
| L F1150 Nearest Poi Drive Time Duration Success | text | boolean | `{account.store.LF1150_nearest_poi_drive_time_duration_success}` | — |
| L F1150 Nearest Poi Human Readable Distance | text | scalar | `{account.store.LF1150_nearest_poi_human_readable_distance}` | — |
| L F1150 Nearest Poi Human Readable Distance Metric | text | scalar | `{account.store.LF1150_nearest_poi_human_readable_distance_metric}` | — |
| L F1150 Nearest Poi Human Readable Distance Metric Short | text | scalar | `{account.store.LF1150_nearest_poi_human_readable_distance_metric_short}` | — |
| L F1150 Nearest Poi Human Readable Distance Metric Shorter | text | scalar | `{account.store.LF1150_nearest_poi_human_readable_distance_metric_shorter}` | — |
| L F1150 Nearest Poi Human Readable Distance Short | text | scalar | `{account.store.LF1150_nearest_poi_human_readable_distance_short}` | — |
| L F1150 Nearest Poi Human Readable Distance Shorter | text | scalar | `{account.store.LF1150_nearest_poi_human_readable_distance_shorter}` | — |
| L F1150 Nearest Poi Latitude | text | float | `{account.store.LF1150_nearest_poi_latitude}` | — |
| L F1150 Nearest Poi Longitude | text | float | `{account.store.LF1150_nearest_poi_longitude}` | — |
| L F1150 Nearest Poi Name | text | scalar | `{account.store.LF1150_nearest_poi_name}` | — |
| L F1150 Nearest Poi Non Branded Location Name | text | scalar | `{account.store.LF1150_nearest_poi_non_branded_location_name}` | — |
| L F1150 Nearest Poi Phone | text | scalar | `{account.store.LF1150_nearest_poi_phone}` | — |
| L F1150 Nearest Poi State | text | scalar | `{account.store.LF1150_nearest_poi_state}` | — |
| L F1150 Nearest Poi Unique Id | text | scalar | `{account.store.LF1150_nearest_poi_unique_id}` | — |
| L F1150 Nearest Poi Viewer Bearing | text | float | `{account.store.LF1150_nearest_poi_viewer_bearing}` | — |
| L F1150 Nearest Poi Viewer Bearing Cardinal | text | float | `{account.store.LF1150_nearest_poi_viewer_bearing_cardinal}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:14 UTC*
