---
title: "Famous Quotes (By DIGICHIEF) - Lucit Application Reference"
description: "Add random famous, inspiring and funny quotes to your digital out-of-home signage and billboard creatives #infotainment"
keywords: "lucit application, Famous Quotes (By DIGICHIEF), app reference, integration"
---

# Famous Quotes (By DIGICHIEF)

Add random famous, inspiring and funny quotes to your digital out-of-home signage and billboard creatives #infotainment

**Application Details:**

- **Name:** Famous Quotes (By DIGICHIEF)
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-2c2b9add-3d17-4575-a45e-99b569e87229`

---

## View in Lucit

**[🔗 View Famous Quotes (By DIGICHIEF) in Lucit](https://lucit.app/FamousQuotesByDigichief){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Famous Quotes (By DIGICHIEF) to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Famous Quotes (By DIGICHIEF)"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Famous Quotes (By DIGICHIEF) application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Famous Quotes (By DIGICHIEF) Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Famous Quotes (By DIGICHIEF)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Famous Quotes (By DIGICHIEF) dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Famous Quotes (By DIGICHIEF)**

To add values from Famous Quotes (By DIGICHIEF) to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Famous Quotes (By DIGICHIEF) `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Famous Quotes (By DIGICHIEF) or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Famous Quotes (By DIGICHIEF) data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Famous Quotes (By DIGICHIEF):

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **DIGICHIEF Customer Name** | `secret` | Enter the customer name provided to you along with your API key | Required |
| **DIGICHIEF API Key** | `secret` | Enter the API key provided to you by DIGICHIEF | Required |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Famous Quotes By Digichief1 Author | text | scalar | `{account.store.FamousQuotesByDigichief1_author}` | — |
| Famous Quotes By Digichief1 Category | text | scalar | `{account.store.FamousQuotesByDigichief1_category}` | — |
| Famous Quotes By Digichief1 Feed Last Run Had Errors | text | boolean | `{account.store.FamousQuotesByDigichief1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Famous Quotes By Digichief1 Feed Last Run Was Success | text | boolean | `{account.store.FamousQuotesByDigichief1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Famous Quotes By Digichief1 Feed Last Succesful Run At | text | datetime | `{account.store.FamousQuotesByDigichief1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Famous Quotes By Digichief1 Graphic | img | string | `{account.store.FamousQuotesByDigichief1_graphic}` | — |
| Famous Quotes By Digichief1 Quote | text | scalar | `{account.store.FamousQuotesByDigichief1_quote}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:12 UTC*
