---
title: "Product Inventory using Google Sheets - Lucit Application Reference"
description: "Get Product Inventory from a Google Drive Spreadsheet. Use an online spreadsheet to automate your product inventory onto your Lucit campaign. - title - description - price -..."
keywords: "lucit application, Product Inventory using Google Sheets, app reference, integration"
---

# Product Inventory using Google Sheets

Get Product Inventory from a Google Drive Spreadsheet. Use an online spreadsheet to automate your product inventory onto your Lucit campaign. - title - description - price -...

**Application Details:**

- **Name:** Product Inventory using Google Sheets
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-44b690c2-ff49-4e37-87ea-cd920495e8ca`

---

## View in Lucit

**[🔗 View Product Inventory using Google Sheets in Lucit](https://lucit.app/GoogleSheetsProductInventory){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Product Inventory using Google Sheets to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Product Inventory using Google Sheets"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Product Inventory using Google Sheets application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Product Inventory using Google Sheets Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Google Sheets Product Inventory

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Google Sheets Product Inventory dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Google Sheets Product Inventory**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Google Sheets Product Inventory to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Google Sheets Product Inventory to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Google Sheet Url** | `text` | Copy and paste the url to your google spreadheet | Required |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Google Sheets Product Inventory1 Feed Last Run Had Errors | text | boolean | `{account.store.GoogleSheetsProductInventory1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Google Sheets Product Inventory1 Feed Last Run Was Success | text | boolean | `{account.store.GoogleSheetsProductInventory1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Google Sheets Product Inventory1 Feed Last Succesful Run At | text | datetime | `{account.store.GoogleSheetsProductInventory1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:30 UTC*
