---
title: "HomeNet Automotive - Lucit Application Reference"
description: "HomeNet’s digital merchandising platforms are designed to help providers support their clients and help dealers build an online presence that attracts and engages shoppers..."
keywords: "lucit application, HomeNet Automotive, app reference, integration"
---

# HomeNet Automotive

HomeNet’s digital merchandising platforms are designed to help providers support their clients and help dealers build an online presence that attracts and engages shoppers...

**Application Details:**

- **Name:** HomeNet Automotive
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-6d9ec462-a688-4507-b267-ff0f0659cea8`

---

## View in Lucit

**[🔗 View HomeNet Automotive in Lucit](https://lucit.app/Homenet2){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add HomeNet Automotive to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "HomeNet Automotive"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The HomeNet Automotive application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using HomeNet Automotive Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### HomeNet

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with HomeNet dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for HomeNet**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on HomeNet to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on HomeNet to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Dealer Export File Name** | `text` | The name of the file supplied to you by HomeNet.  Exclude the extension | Required |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Homenet3 Feed Last Run Had Errors | text | boolean | `{account.store.Homenet3_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Homenet3 Feed Last Run Was Success | text | boolean | `{account.store.Homenet3_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Homenet3 Feed Last Succesful Run At | text | datetime | `{account.store.Homenet3_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Body | text | scalar | `{item.inventory_attributes.body}` | — |
| Book Value | text | scalar | `{item.inventory_attributes.book_value}` | — |
| Categorized Options | text | scalar | `{item.inventory_attributes.categorized_options}` | — |
| Certified | text | scalar | `{item.inventory_attributes.certified}` | — |
| City M P G | text | scalar | `{item.inventory_attributes.city_m_p_g}` | — |
| Comment1 | text | scalar | `{item.inventory_attributes.comment1}` | — |
| Comment2 | text | scalar | `{item.inventory_attributes.comment2}` | — |
| Comment3 | text | scalar | `{item.inventory_attributes.comment3}` | — |
| Comment4 | text | scalar | `{item.inventory_attributes.comment4}` | — |
| Comment5 | text | scalar | `{item.inventory_attributes.comment5}` | — |
| Date In Stock | text | scalar | `{item.inventory_attributes.date_in_stock}` | — |
| Dealer Address | text | scalar | `{item.inventory_attributes.dealer_address}` | — |
| Dealer City | text | scalar | `{item.inventory_attributes.dealer_city}` | — |
| Dealer Email | text | scalar | `{item.inventory_attributes.dealer_email}` | — |
| Dealer Fax | text | scalar | `{item.inventory_attributes.dealer_fax}` | — |
| Dealer Name | text | scalar | `{item.inventory_attributes.dealer_name}` | — |
| Dealer Phone | text | scalar | `{item.inventory_attributes.dealer_phone}` | — |
| Dealer State | text | scalar | `{item.inventory_attributes.dealer_state}` | — |
| Dealer Zip | text | scalar | `{item.inventory_attributes.dealer_zip}` | — |
| Description | text | scalar | `{item.inventory_attributes.description}` | — |
| Doors | text | scalar | `{item.inventory_attributes.doors}` | — |
| Drivetrain | text | scalar | `{item.inventory_attributes.drivetrain}` | — |
| E P A Classification | text | scalar | `{item.inventory_attributes.e_p_a_classification}` | — |
| Engine Aspiration Type | text | scalar | `{item.inventory_attributes.engine_aspiration_type}` | — |
| Engine Block Type | text | scalar | `{item.inventory_attributes.engine_block_type}` | — |
| Engine Cylinders | text | scalar | `{item.inventory_attributes.engine_cylinders}` | — |
| Engine Description | text | scalar | `{item.inventory_attributes.engine_description}` | — |
| Engine Displacement | text | scalar | `{item.inventory_attributes.engine_displacement}` | — |
| Engine Displacement Cubic Inches | text | scalar | `{item.inventory_attributes.engine_displacement_cubic_inches}` | — |
| Ext Color Code | text | scalar | `{item.inventory_attributes.ext_color_code}` | — |
| Ext Color Generic | text | scalar | `{item.inventory_attributes.ext_color_generic}` | — |
| Ext Color Hex Code | text | scalar | `{item.inventory_attributes.ext_color_hex_code}` | — |
| Exterior Color | text | scalar | `{item.inventory_attributes.exterior_color}` | — |
| Factory Codes | text | scalar | `{item.inventory_attributes.factory_codes}` | — |
| Fuel Type | text | scalar | `{item.inventory_attributes.fuel_type}` | — |
| Highway M P G | text | scalar | `{item.inventory_attributes.highway_m_p_g}` | — |
| Image List | img | scalar | `{item.inventory_attributes.image_list}` | — |
| Int Color Code | text | scalar | `{item.inventory_attributes.int_color_code}` | — |
| Int Color Generic | text | scalar | `{item.inventory_attributes.int_color_generic}` | — |
| Int Color Hex Code | text | scalar | `{item.inventory_attributes.int_color_hex_code}` | — |
| Int Upholstery | text | scalar | `{item.inventory_attributes.int_upholstery}` | — |
| Interior Color | text | scalar | `{item.inventory_attributes.interior_color}` | — |
| Internet Price | text | scalar | `{item.inventory_attributes.internet_price}` | — |
| Invoice | text | scalar | `{item.inventory_attributes.invoice}` | — |
| Market Class | text | scalar | `{item.inventory_attributes.market_class}` | — |
| Miles | text | scalar | `{item.inventory_attributes.miles}` | — |
| Misc Price1 | text | scalar | `{item.inventory_attributes.misc_price1}` | — |
| Misc Price2 | text | scalar | `{item.inventory_attributes.misc_price2}` | — |
| Misc Price3 | text | scalar | `{item.inventory_attributes.misc_price3}` | — |
| Model Number | text | scalar | `{item.inventory_attributes.model_number}` | — |
| Msrp | text | scalar | `{item.inventory_attributes.msrp}` | — |
| Options | text | scalar | `{item.inventory_attributes.options}` | — |
| Passenger Capacity | text | scalar | `{item.inventory_attributes.passenger_capacity}` | — |
| Selling Price | text | scalar | `{item.inventory_attributes.selling_price}` | — |
| Stock | text | scalar | `{item.inventory_attributes.stock}` | — |
| Style Description | text | scalar | `{item.inventory_attributes.style_description}` | — |
| Transmission | text | scalar | `{item.inventory_attributes.transmission}` | — |
| Transmission Description | text | scalar | `{item.inventory_attributes.transmission_description}` | — |
| Transmission Speed | text | scalar | `{item.inventory_attributes.transmission_speed}` | — |
| Trim | text | scalar | `{item.inventory_attributes.trim}` | — |
| Type | text | scalar | `{item.inventory_attributes.type}` | — |
| Wheelbase Code | text | scalar | `{item.inventory_attributes.wheelbase_code}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:24:54 UTC*
