---
title: "LDSK - Lucit Application Reference"
description: "LDSK (Formerly Signkick and LiveDOOH) is a digital signage player platform for Digital Out of Home. This application for LDSK Dynamic Creatives allows you to build dynamic data..."
keywords: "lucit application, LDSK, app reference, integration"
---

# LDSK

LDSK (Formerly Signkick and LiveDOOH) is a digital signage player platform for Digital Out of Home. This application for LDSK Dynamic Creatives allows you to build dynamic data...

**Application Details:**

- **Name:** LDSK
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Player, Analytics Reporter

- **LCUID:** `LCUID-LAP-92d46d4c-2e92-44aa-8dbb-af34098af069`

---

## View in Lucit

**[🔗 View LDSK in Lucit](https://lucit.app/Ldsk1){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add LDSK to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "LDSK"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes


### Add LDSK to Your Agency or Operator Profile

1. **Navigate to Apps**
   - Log in to Lucit
   - Switch to your Agency/Operator profile
   - Go to `SETTINGS`
   - Scroll down to view the `Apps & Data Sources` section in `SETTINGS`

2. **Find the Application**
   - Click the `ADD NEW` button and Search for "LDSK"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Agency / Operator**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Configure agency-level settings as needed
   - Save your changes




---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:33 UTC*
