---
title: "Lotus Corp Radio - Now Playing - Lucit Application Reference"
description: "Provides connectivity to the now playing API for Lotus Corporation Radio Stations Add live now-playing to digital out of home billboard creatives featuring the song title, artist..."
keywords: "lucit application, Lotus Corp Radio - Now Playing, app reference, integration"
---

# Lotus Corp Radio - Now Playing

Provides connectivity to the now playing API for Lotus Corporation Radio Stations Add live now-playing to digital out of home billboard creatives featuring the song title, artist...

**Application Details:**

- **Name:** Lotus Corp Radio - Now Playing
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-3622e3e3-472f-422f-ba09-668c74af6880`

---

## View in Lucit

**[🔗 View Lotus Corp Radio - Now Playing in Lucit](https://lucit.app/LotusCorpRadioNowPlaying){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Lotus Corp Radio - Now Playing to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Lotus Corp Radio - Now Playing"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Lotus Corp Radio - Now Playing application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Lotus Corp Radio - Now Playing Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Lotus Corp Radio - Now Playing

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Lotus Corp Radio - Now Playing dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Lotus Corp Radio - Now Playing**

To add values from Lotus Corp Radio - Now Playing to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Lotus Corp Radio - Now Playing `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Lotus Corp Radio - Now Playing or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Lotus Corp Radio - Now Playing data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Lotus Corp Radio - Now Playing:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Station** | `json` [(enum)](#station-options) | Select a Station | Required |

**Enum Options:**

<a id="station-options"></a>

*Station:*

| Label | Value | Description |
|-------|------|-------------|
| KCHJ AM/FM | 2143/KCHJAM_FM | Bakersfield |
| KIWI FM | 2178/KIWIFM | Bakersfield |
| KPSL FM | 2142/KPSLFM | Bakersfield |
| KQKZ FM | 2151/KQKZFM | Bakersfield |
| KJOT FM | 2154/KJOTFM | Boise |
| KQXR FM | 2146/KQXRFM | Boise |
| KRVB FM | 2153/KRVBFM | Boise |
| KTHI FM | 2152/KTHIFM | Boise |
| KKBZ FM | 2182/KKBZFM | Fresno |
| KHIT FM | 2148/KHITFM | Fresno |
| KLBN FM | 2158/KLBNFM | Fresno |
| KOKO FM | 2434/KOKOFM | Fresno |
| KSEQ FM | 2155/KSEQFM | Fresno |
| KKGK AM/FM | 2104/KKGKAM_FM | Las Vegas |
| KLAV AM | 2104/KLAVAM | Las Vegas |
| KOMP FM | 2130/KOMPFM | Las Vegas |
| KENO AM | 2227/KENOAM | Las Vegas |
| KRLV AM | 2104/KRLVAM | Las Vegas |
| KWID FM | 2156/KWIDFM | Las Vegas |
| KWWN AM/FM | 2104/KWWNAM_FM | Las Vegas |
| KXPT FM | 2157/KXPTFM | Las Vegas |
| KDOT FM | 2161/KDOTFM | Reno |
| KFOY AM | 2175/KFOYAM | Reno |
| KHIT AM/FM | 2201/KHITAM_FM | Reno |
| KPLY AM | 2201/KPLYAM | Reno |
| KXZZ FM | 2176/KXZZFM | Reno |
| KNWN AM/FM | 2186/KNWNAM_FM | Seattle |
| KVI AM | 2184/KVIAM | Seattle |
| KFFN AM/FM | 2190/KFFNAM_FM | Tucson |
| KFMA FM | 2163/KFMAFM | Tucson |
| KLPX FM | 2165/KLPXFM | Tucson |
| KMXZ FM | 2189/KMXZFM | Tucson |
| HANK Tucson | 2657/HANKTucson | Tucson |
| KCMT FM | 2170/KCMTFM | Tucson |
| KTKT AM/FM | 2171/KTKTAM_FM | Tucson |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Lotus Corp Radio Now Playing1 Album Url | text | scalar | `{account.store.LotusCorpRadioNowPlaying1_album_url}` | — |
| Lotus Corp Radio Now Playing1 Artist | text | scalar | `{account.store.LotusCorpRadioNowPlaying1_artist}` | — |
| Lotus Corp Radio Now Playing1 Artist Url | text | scalar | `{account.store.LotusCorpRadioNowPlaying1_artist_url}` | — |
| Lotus Corp Radio Now Playing1 Feed Last Run Had Errors | text | boolean | `{account.store.LotusCorpRadioNowPlaying1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Lotus Corp Radio Now Playing1 Feed Last Run Was Success | text | boolean | `{account.store.LotusCorpRadioNowPlaying1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Lotus Corp Radio Now Playing1 Feed Last Succesful Run At | text | datetime | `{account.store.LotusCorpRadioNowPlaying1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Lotus Corp Radio Now Playing1 Image Url | img | scalar | `{account.store.LotusCorpRadioNowPlaying1_image_url}` | — |
| Lotus Corp Radio Now Playing1 Name | text | scalar | `{account.store.LotusCorpRadioNowPlaying1_name}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:37 UTC*
