---
title: "MLB Live Game Scores - Lucit Application Reference"
description: "Add LIVE MLB baseball scores on game-day to your digital billboard and digital signage creatives with the Major League Baseball Sports Game Scores app This app provides key game..."
keywords: "lucit application, MLB Live Game Scores, app reference, integration"
---

# MLB Live Game Scores

Add LIVE MLB baseball scores on game-day to your digital billboard and digital signage creatives with the Major League Baseball Sports Game Scores app This app provides key game...

**Application Details:**

- **Name:** MLB Live Game Scores
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-5e113d6a-b9d6-46ed-857e-713ce1ce5f93`

---

## View in Lucit

**[🔗 View MLB Live Game Scores in Lucit](https://lucit.app/MlbLiveGameScores){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add MLB Live Game Scores to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "MLB Live Game Scores"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The MLB Live Game Scores application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **2 data source provider(s)**.

### Prerequisites to Using MLB Live Game Scores Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### MLB Live Game Scores (All Games)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with MLB Live Game Scores (All Games) dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for MLB Live Game Scores (All Games)**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on MLB Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on MLB Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Season** | `text` | Enter a season | Required |
| **Game Date** | `text` | Enter a game date in YYYY-MM-DD format, or leave blank to get todays games | — |
| **Include games in pre-game status** | `bool` | Enable this option to include games before they have started.  Useful to show game-time creatives | — |
| **Choose Teams** | `int` [(multiple select)](#choose-teams-options) | Please select one or more teams | — |

**Enum Options:**

<a id="choose-teams-options"></a>

*Choose Teams:*

| Label | Value |
|-------|------|
| Arizona Diamondbacks | 2 |
| Atlanta Braves | 3 |
| Baltimore Orioles | 4 |
| Boston Red Sox | 5 |
| Canada | 39 |
| Chicago Cubs | 6 |
| Chicago White Sox | 7 |
| Cincinnati Reds | 8 |
| Cleveland Indians | 9 |
| Colorado Rockies | 10 |
| Detroit Tigers | 12 |
| Houston Astros | 15 |
| Kansas City Royals | 16 |
| Los Angeles Angels | 17 |
| Los Angeles Dodgers | 18 |
| Miami Marlins | 19 |
| Milwaukee Brewers | 20 |
| Minnesota G. | 21 |
| Minnesota Twins | 22 |
| New York Mets | 24 |
| New York Yankees | 25 |
| Northeastern | 43 |
| Oakland Athletics | 26 |
| Philadelphia Phillies | 27 |
| Pittsburgh Pirates | 28 |
| San Diego Padres | 30 |
| San Francisco Giants | 31 |
| Seattle Mariners | 32 |
| Southeastern | 46 |
| St.Louis Cardinals | 33 |
| Tampa Bay Rays | 34 |
| Texas Rangers | 35 |
| Toronto Blue Jays | 36 |
| Washington Nationals | 37 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Mlb Live Game Scores All Games Feed Last Run Had Errors | text | boolean | `{account.store.MlbLiveGameScoresAllGames_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Mlb Live Game Scores All Games Feed Last Run Was Success | text | boolean | `{account.store.MlbLiveGameScoresAllGames_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Mlb Live Game Scores All Games Feed Last Succesful Run At | text | datetime | `{account.store.MlbLiveGameScoresAllGames_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Away Team Abbreviation | text | scalar | `{item.inventory_attributes.away_team_abbreviation}` | — |
| Away Team Place | text | scalar | `{item.inventory_attributes.away_team_place}` | — |
| Away Team Short Name | text | scalar | `{item.inventory_attributes.away_team_short_name}` | — |
| Date | text | scalar | `{item.inventory_attributes.date}` | — |
| Home Team Abbreviation | text | scalar | `{item.inventory_attributes.home_team_abbreviation}` | — |
| Home Team Place | text | scalar | `{item.inventory_attributes.home_team_place}` | — |
| Home Team Short Name | text | scalar | `{item.inventory_attributes.home_team_short_name}` | — |
| Ingame | text | scalar | `{item.inventory_attributes.ingame}` | — |
| Inning Status Format Full | text | scalar | `{item.inventory_attributes.inning_status_format_full}` | — |
| Inning Status Format Number | text | scalar | `{item.inventory_attributes.inning_status_format_number}` | — |
| Inning Status Inning | text | scalar | `{item.inventory_attributes.inning_status_inning}` | — |
| Inning Status Top Or Bottom | text | scalar | `{item.inventory_attributes.inning_status_top_or_bottom}` | — |
| Postgame | text | scalar | `{item.inventory_attributes.postgame}` | — |
| Pregame | text | scalar | `{item.inventory_attributes.pregame}` | — |
| Scores Away Errors | text | scalar | `{item.inventory_attributes.scores_away_errors}` | — |
| Scores Away Hits | text | scalar | `{item.inventory_attributes.scores_away_hits}` | — |
| Scores Away Innings 1 | text | scalar | `{item.inventory_attributes.scores_away_innings_1}` | — |
| Scores Away Innings 2 | text | scalar | `{item.inventory_attributes.scores_away_innings_2}` | — |
| Scores Away Innings 3 | text | scalar | `{item.inventory_attributes.scores_away_innings_3}` | — |
| Scores Away Innings 4 | text | scalar | `{item.inventory_attributes.scores_away_innings_4}` | — |
| Scores Away Innings 5 | text | scalar | `{item.inventory_attributes.scores_away_innings_5}` | — |
| Scores Away Innings 6 | text | scalar | `{item.inventory_attributes.scores_away_innings_6}` | — |
| Scores Away Innings 7 | text | scalar | `{item.inventory_attributes.scores_away_innings_7}` | — |
| Scores Away Innings 8 | text | scalar | `{item.inventory_attributes.scores_away_innings_8}` | — |
| Scores Away Innings 9 | text | scalar | `{item.inventory_attributes.scores_away_innings_9}` | — |
| Scores Away Innings Extra | text | scalar | `{item.inventory_attributes.scores_away_innings_extra}` | — |
| Scores Away Total | text | scalar | `{item.inventory_attributes.scores_away_total}` | — |
| Scores Home Errors | text | scalar | `{item.inventory_attributes.scores_home_errors}` | — |
| Scores Home Hits | text | scalar | `{item.inventory_attributes.scores_home_hits}` | — |
| Scores Home Innings 1 | text | scalar | `{item.inventory_attributes.scores_home_innings_1}` | — |
| Scores Home Innings 2 | text | scalar | `{item.inventory_attributes.scores_home_innings_2}` | — |
| Scores Home Innings 3 | text | scalar | `{item.inventory_attributes.scores_home_innings_3}` | — |
| Scores Home Innings 4 | text | scalar | `{item.inventory_attributes.scores_home_innings_4}` | — |
| Scores Home Innings 5 | text | scalar | `{item.inventory_attributes.scores_home_innings_5}` | — |
| Scores Home Innings 6 | text | scalar | `{item.inventory_attributes.scores_home_innings_6}` | — |
| Scores Home Innings 7 | text | scalar | `{item.inventory_attributes.scores_home_innings_7}` | — |
| Scores Home Innings 8 | text | scalar | `{item.inventory_attributes.scores_home_innings_8}` | — |
| Scores Home Innings 9 | text | scalar | `{item.inventory_attributes.scores_home_innings_9}` | — |
| Scores Home Innings Extra | text | scalar | `{item.inventory_attributes.scores_home_innings_extra}` | — |
| Scores Home Total | text | scalar | `{item.inventory_attributes.scores_home_total}` | — |
| Status Long | text | scalar | `{item.inventory_attributes.status_long}` | — |
| Status Short | text | scalar | `{item.inventory_attributes.status_short}` | — |
| Teams Away Id | text | scalar | `{item.inventory_attributes.teams_away_id}` | — |
| Teams Away Name | text | scalar | `{item.inventory_attributes.teams_away_name}` | — |
| Teams Home Id | text | scalar | `{item.inventory_attributes.teams_home_id}` | — |
| Teams Home Name | text | scalar | `{item.inventory_attributes.teams_home_name}` | — |
| Time | text | scalar | `{item.inventory_attributes.time}` | — |
| Timestamp | text | scalar | `{item.inventory_attributes.timestamp}` | — |



---

### MLB Live Game Scores (Single Team)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with MLB Live Game Scores (Single Team) dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with MLB Live Game Scores (Single Team)**

To add values from MLB Live Game Scores (Single Team) to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from MLB Live Game Scores (Single Team) `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled MLB Live Game Scores (Single Team) or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using MLB Live Game Scores (Single Team) data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from MLB Live Game Scores (Single Team):

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Choose Team** | `int` [(enum)](#choose-team-options) | Please select a team | Required |

**Enum Options:**

<a id="choose-team-options"></a>

*Choose Team:*

| Label | Value |
|-------|------|
| Arizona Diamondbacks | 2 |
| Atlanta Braves | 3 |
| Baltimore Orioles | 4 |
| Boston Red Sox | 5 |
| Canada | 39 |
| Chicago Cubs | 6 |
| Chicago White Sox | 7 |
| Cincinnati Reds | 8 |
| Cleveland Indians | 9 |
| Colorado Rockies | 10 |
| Detroit Tigers | 12 |
| Houston Astros | 15 |
| Kansas City Royals | 16 |
| Los Angeles Angels | 17 |
| Los Angeles Dodgers | 18 |
| Miami Marlins | 19 |
| Milwaukee Brewers | 20 |
| Minnesota G. | 21 |
| Minnesota Twins | 22 |
| New York Mets | 24 |
| New York Yankees | 25 |
| Northeastern | 43 |
| Oakland Athletics | 26 |
| Philadelphia Phillies | 27 |
| Pittsburgh Pirates | 28 |
| San Diego Padres | 30 |
| San Francisco Giants | 31 |
| Seattle Mariners | 32 |
| Southeastern | 46 |
| St.Louis Cardinals | 33 |
| Tampa Bay Rays | 34 |
| Texas Rangers | 35 |
| Toronto Blue Jays | 36 |
| Washington Nationals | 37 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Mlb Live Game Scores1 Country Flag | img | scalar | `{account.store.MlbLiveGameScores1_country_flag}` | — |
| Mlb Live Game Scores1 Feed Last Run Had Errors | text | boolean | `{account.store.MlbLiveGameScores1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Mlb Live Game Scores1 Feed Last Run Was Success | text | boolean | `{account.store.MlbLiveGameScores1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Mlb Live Game Scores1 Feed Last Succesful Run At | text | datetime | `{account.store.MlbLiveGameScores1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Mlb Live Game Scores1 League Logo | img | scalar | `{account.store.MlbLiveGameScores1_league_logo}` | — |
| Mlb Live Game Scores1 Teams Away Logo | img | scalar | `{account.store.MlbLiveGameScores1_teams_away_logo}` | — |
| Mlb Live Game Scores1 Teams Home Logo | img | scalar | `{account.store.MlbLiveGameScores1_teams_home_logo}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:54 UTC*
