---
title: "NCAA Basketball - Live Game Scores - Lucit Application Reference"
description: "Add LIVE NCAA Mens basketball scores on game-day to your digital billboard and digital signage creatives with the NCAA Basetball Sports Game Scores app This app provides key game..."
keywords: "lucit application, NCAA Basketball - Live Game Scores, app reference, integration"
---

# NCAA Basketball - Live Game Scores

Add LIVE NCAA Mens basketball scores on game-day to your digital billboard and digital signage creatives with the NCAA Basetball Sports Game Scores app This app provides key game...

**Application Details:**

- **Name:** NCAA Basketball - Live Game Scores
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-434cf43a-a221-4aeb-90da-522d5a1ba373`

---

## View in Lucit

**[🔗 View NCAA Basketball - Live Game Scores in Lucit](https://lucit.app/NcaaBasketballLiveGameScores){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add NCAA Basketball - Live Game Scores to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "NCAA Basketball - Live Game Scores"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The NCAA Basketball - Live Game Scores application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using NCAA Basketball - Live Game Scores Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### NCAA Basketball Live Game Scores (All Games)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with NCAA Basketball Live Game Scores (All Games) dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for NCAA Basketball Live Game Scores (All Games)**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on NCAA Basketball Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on NCAA Basketball Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Season** | `text` | Enter a season in form YEAR-YEAR2 | Required |
| **Game Date** | `text` | Enter a game date in YYYY-MM-DD format, or leave blank to get todays games | — |
| **Include games in pre-game status** | `bool` | Enable this option to include games before they have started.  Useful to show game-time creatives | — |
| **Choose Teams** | `int` [(multiple select)](#choose-teams-options) | Please select one or more team | — |
| **Create tags from team names** | `text` [(enum)](#create-tags-from-team-names-options) | Would you like to create item tags in your account for each team | — |

**Enum Options:**

<a id="choose-teams-options"></a>

*Choose Teams:*

| Label | Value |
|-------|------|
| Abilene Christian | 1803 |
| Air Force | 1804 |
| Akron | 1805 |
| Alabama | 176 |
| Alabama A&M | 1806 |
| Alabama State | 1807 |
| Albany Great Danes | 6632 |
| Alcorn State | 1809 |
| Alice Loyd | 1810 |
| American University | 1811 |
| Anderson (Ind.) | 5705 |
| Appalachian State | 1813 |
| Aquinas | 1814 |
| Arizona | 1815 |
| Arizona State | 1816 |
| Arkansas | 177 |
| Arkansas Baptist | 3347 |
| Arkansas State | 1817 |
| Arkansas-Pine Bluff | 1818 |
| Arlington Baptist Patriots | 1819 |
| Army | 1820 |
| Asbury | 3220 |
| Aub.-Montgomery | 1821 |
| Auburn | 1822 |
| Augusta Jaguars | 6633 |
| Aurora | 5708 |
| Austin Peay | 1823 |
| Averett | 3221 |
| Avila | 1700 |
| Baldwin-Wallace | 5710 |
| Ball State | 1824 |
| Baylor | 1825 |
| Bellarmine | 2358 |
| Belmont | 1826 |
| Benedictine (AZ) | 5712 |
| Bethany | 1827 |
| Bethel (TN) | 5713 |
| Bethesda | 5714 |
| Bethune-Cookman | 1829 |
| Binghamton | 1830 |
| Blackburn | 5715 |
| Bluefield State | 1833 |
| Bluffton | 5716 |
| Bob Jones | 5717 |
| Boise State | 1835 |
| Boston College | 1836 |
| Boston University | 1837 |
| Bowdoin | 6634 |
| Bowie | 2373 |
| Bowling Green | 1838 |
| Boyce | 2413 |
| Bradley | 1839 |
| Brescia | 717 |
| Brevard College | 1840 |
| Brewton Parker | 2374 |
| Brigham Young | 1841 |
| Bronxville | 6200 |
| Brown | 208 |
| Bryan | 1842 |
| Bryant University | 1843 |
| Bryn Athyn | 3225 |
| Bucknell | 1844 |
| Buffalo | 1845 |
| Butler | 178 |
| Cairn | 5723 |
| Cal Poly | 1847 |
| California | 1850 |
| California Baptist | 210 |
| California Maritime | 5725 |
| California State-Stanislaus Warriors | 3229 |
| Calumet College | 5726 |
| Calvary | 3230 |
| Campbell | 179 |
| Campbellsville | 1852 |
| Campbellsville-Harrodsburg | 2415 |
| Canisius | 1489 |
| Capital Crusaders | 6635 |
| Carolina Christian | 6203 |
| Carolina University | 2375 |
| CBS Ambassadors | 6201 |
| Central Arkansas | 1490 |
| Central Connecticut State | 1856 |
| Central Michigan | 211 |
| Central Penn | 1858 |
| Central State (OH) | 6636 |
| Chadron S. | 2417 |
| Champion Christian Tigers | 5732 |
| Chapman Panthers | 5733 |
| Charleston | 1861 |
| Charleston Southern | 226 |
| Charlotte | 3429 |
| Chatham | 6637 |
| Chattanooga Mocs | 5734 |
| Chestnut Hill | 1862 |
| Cheyney Wolves | 6204 |
| Chicago State | 1863 |
| Christendom | 1864 |
| Cincinnati | 1865 |
| Citadel | 1866 |
| Cleary University | 6207 |
| Clemson | 180 |
| Cleveland State | 1867 |
| Coastal Carolina | 212 |
| Coastal Georgia | 5739 |
| Colby-Sawyer | 5740 |
| Colgate | 1491 |
| Colorado | 181 |
| Colorado Christian | 1869 |
| Colorado College | 3232 |
| Colorado Springs | 6638 |
| Colorado State | 1870 |
| Columbia | 1871 |
| Columbia International | 1872 |
| Concordia | 371 |
| Concordia St Paul | 6208 |
| Coppin State | 1878 |
| Corban | 2377 |
| Cornell | 227 |
| Creighton | 182 |
| Crowley's Ridge | 1879 |
| Crown College | 3234 |
| CS Fullerton | 5720 |
| CS Northridge | 5721 |
| CSU Bakersfield | 5722 |
| Dakota Wesleyan | 6210 |
| Dallas Christian | 1882 |
| Dallas Univ. | 3380 |
| Dalton | 2478 |
| Dartmouth | 1883 |
| Davenport Univ. | 6211 |
| Davidson | 183 |
| Davis & Elkins | 5743 |
| Dayton | 184 |
| Dean | 5744 |
| Defiance College | 5745 |
| Delaware | 1884 |
| Delaware State | 1885 |
| Denver | 1886 |
| DePaul | 213 |
| Detroit | 1887 |
| Dickinson Red Devils | 6639 |
| Dickinson State | 2479 |
| Dillard | 3236 |
| Dist. of Columbia | 5746 |
| Drake | 228 |
| Drexel | 1889 |
| Dubuque | 3238 |
| Duke | 1890 |
| Duquesne | 1891 |
| Earlham | 3240 |
| East Carolina | 1892 |
| East Tennessee St | 5747 |
| East. Washington | 5748 |
| Eastern Illinois | 1894 |
| Eastern Kentucky | 1895 |
| Eastern Michigan | 1896 |
| Eastern Oregon | 1897 |
| Ecclesia | 1898 |
| Edward Waters | 2421 |
| Elizabeth City | 6290 |
| Elms College | 6215 |
| Elon | 1901 |
| Embry-Riddle (AZ) | 5750 |
| Emerson | 3245 |
| Endicott Gulls | 6640 |
| Erskine | 3246 |
| Eureka | 1903 |
| Evansville | 1904 |
| Evergreen State | 1905 |
| EWU Phantoms | 3239 |
| Fairfield | 1906 |
| Fairleigh Dickinson | 1907 |
| Ferrum | 1908 |
| Fisher | 5753 |
| Fisk | 3249 |
| Florida | 1909 |
| Florida A&M | 1910 |
| Florida Atlantic | 230 |
| Florida Gulf Coast | 1912 |
| Florida International | 5628 |
| Florida National | 2383 |
| Florida State | 1914 |
| Florida Tech | 1915 |
| Fordham | 1916 |
| Fort Lauderdale | 2423 |
| Fort Valley State Wildcats | 3250 |
| Fort Wayne Mad Ants | 257 |
| Framingham State | 5754 |
| Franciscan University | 1917 |
| Franklin | 3357 |
| Franklin Pierce | 6641 |
| Fredonia State | 3251 |
| Fresno State | 1919 |
| Friends University | 6217 |
| Frostburg | 6642 |
| Furman | 185 |
| Gallaudet Univ. | 2248 |
| Gardner Webb | 5755 |
| George Mason | 1499 |
| George Washington | 1500 |
| Georgetown | 186 |
| Georgia | 6585 |
| Georgia | 1924 |
| Georgia Southern | 1501 |
| Georgia State | 1925 |
| Georgia Tech | 1926 |
| Georgian Court Univ. | 5757 |
| Gilbert Buccaneers | 6218 |
| Gonzaga | 1927 |
| Goshen | 5759 |
| Grambling St. | 232 |
| Grand Canyon | 214 |
| Gwynedd-Mercy | 3255 |
| Hampton | 233 |
| Hannibal-LaGrange | 5762 |
| Hardin Simmons | 2385 |
| Harris-Stowe | 5763 |
| Harvard | 187 |
| Haskell | 1932 |
| Hawaii | 1933 |
| Hawaii at Hilo | 6643 |
| Hawaii Pacific | 6298 |
| Heidelberg | 552 |
| High Point | 1934 |
| Hofstra | 188 |
| Holy | 1935 |
| Holy Cross | 1936 |
| Holy Cross Saints | 6644 |
| Houghton | 5764 |
| Houston | 1938 |
| Houston Christian | 5765 |
| Howard | 215 |
| Howard Payne | 1940 |
| Idaho | 1942 |
| Idaho State | 1943 |
| Illinois | 1944 |
| Illinois (Chi.) | 5767 |
| Illinois State | 1945 |
| Immaculata | 3265 |
| Incarnate Word | 1946 |
| Indiana | 189 |
| Indiana State | 1948 |
| Iona | 1949 |
| Iowa | 1950 |
| Iowa State | 1951 |
| IU Indy | 6712 |
| IUPUC | 6645 |
| IUPUI | 234 |
| Jackson State | 1952 |
| Jacksonville Dolphins | 6646 |
| Jacksonville State | 1493 |
| James Madison | 1954 |
| Jamestown Jimmies | 6647 |
| John Jay | 3392 |
| John Melvin | 6219 |
| Johnson and Wales (NC) | 5772 |
| Johnson Royals | 5771 |
| Judson | 1958 |
| Justice College | 6648 |
| Kansas | 1959 |
| Kansas Christian | 2486 |
| Kansas State | 1960 |
| Kean | 1961 |
| Kennesaw State | 1963 |
| Kent State | 235 |
| Kentucky | 1964 |
| Kentucky Christian | 1965 |
| Kentucky State | 5773 |
| Kentucky Wesleyan Panthers | 2387 |
| La Grange | 5775 |
| La Salle | 1968 |
| La Sierra | 5776 |
| La Verne | 3271 |
| Lafayette | 1969 |
| Lakeland | 6649 |
| Lamar | 1970 |
| Lancaster | 2389 |
| Lane College | 5948 |
| Le Moyne | 3274 |
| Le Tourneau | 5777 |
| Lehigh | 1971 |
| Lehman College | 6650 |
| Lesley | 2222 |
| Lewis &. Clark State | 5779 |
| Liberty | 1972 |
| Life Pacific | 2447 |
| Lincoln Mo. | 5780 |
| Lincoln University (CA) | 6651 |
| Lindenwood | 1973 |
| Lipscomb | 190 |
| LIU Sharks | 5774 |
| Livingstone | 6652 |
| Long Beach State | 1974 |
| Longwood | 216 |
| Louisiana Christian | 5782 |
| Louisiana Lafayette | 5783 |
| Louisiana Monroe | 5784 |
| Louisiana Tech | 1976 |
| Louisville | 1977 |
| Loyola Chicago | 191 |
| Loyola Maryland | 1503 |
| Loyola Marymount | 3382 |
| Loyola NO | 5786 |
| LSU | 1967 |
| LSU-Alexandria | 2425 |
| Lynchburg | 5787 |
| Lyndon State Hornets | 6653 |
| Maine Black Bears | 5790 |
| Maine-Augusta | 5791 |
| Maine-Fort Kent | 3281 |
| Manhattan | 1981 |
| Manhattanville | 3282 |
| Manor College | 6655 |
| Mansfield | 6656 |
| Marian Sabres | 6657 |
| Marist | 1982 |
| Marquette | 1983 |
| Marshall | 237 |
| Mary Baldwin | 3283 |
| Maryland | 1985 |
| Maryville | 1986 |
| Marywood Pacers | 6224 |
| Massachusetts-Boston | 1987 |
| Mayaguez Bulldogs | 6658 |
| McMurry | 2395 |
| Mcneese State | 1990 |
| Md.-East. Shore | 5795 |
| Medgar Evers | 2223 |
| Memphis | 192 |
| Menlo | 2224 |
| Mercer | 1494 |
| Mercy | 5796 |
| Mercyhurst Lakers | 2472 |
| Merrimack Warriors | 5797 |
| Miami (FL) | 1993 |
| Miami (Ohio) | 6292 |
| Miami-Hamilton | 3351 |
| Michigan | 1994 |
| Michigan State | 1995 |
| Michigan Tech | 6659 |
| Mid-America Christian | 1996 |
| Mid-Atlantic | 1997 |
| Middle Georgia State | 1998 |
| Middle Tenn. St. | 5799 |
| Midway | 2225 |
| Milligan | 2001 |
| Minnesota | 2003 |
| Misericordia | 5801 |
| Miss. Valley St. | 5802 |
| Mississippi Coll. | 5803 |
| Mississippi St. | 5804 |
| Missouri | 2006 |
| Missouri S&T | 5805 |
| Missouri Southern State | 6660 |
| Missouri State | 2008 |
| Mitchell | 6661 |
| MN-Crookston | 6654 |
| Mobile | 2010 |
| Monmouth | 2011 |
| Montana | 2012 |
| Montana State | 2013 |
| Montana Tech | 2014 |
| Montreat College | 3393 |
| Morehead State | 2016 |
| Morehouse | 5807 |
| Morgan State | 2018 |
| Morris College | 3291 |
| Mount Aloysius | 2513 |
| Mount Marty | 2019 |
| Mount Olive Trojans | 3292 |
| Mount St. Mary's | 2020 |
| Murray State | 2024 |
| Muskingum | 5809 |
| MUW Owls | 5789 |
| N. Carolina A&T | 5810 |
| N. Carolina Central | 5811 |
| N.C. Wesleyan | 2027 |
| Navy | 2029 |
| Nazareth | 6662 |
| NC Greensboro | 5812 |
| NC State | 5813 |
| NC Wilmington | 5814 |
| Nebraska | 195 |
| Nebraska O. | 5817 |
| Nelson | 6713 |
| Neumann | 3293 |
| Nevada | 2032 |
| New College (FL) | 6227 |
| New Hampshire Wildcats | 6663 |
| New Mexico | 2034 |
| New Mexico Cowboys | 5819 |
| New Mexico State | 2035 |
| New Orleans | 239 |
| Newberry | 2448 |
| Newport Apprentice | 3296 |
| Niagara | 2036 |
| Nicholls State | 2037 |
| NJIT | 5815 |
| Nobel Knights | 6664 |
| Norfolk State | 196 |
| North Alabama | 2038 |
| North Carolina | 2039 |
| North Central Cardinals | 2040 |
| North Central Rams | 3297 |
| North Dakota | 2041 |
| North Dakota St | 2042 |
| North Florida | 2043 |
| North Greenville | 2044 |
| North Texas | 1496 |
| North Texas-Dallas | 5821 |
| Northeastern | 2045 |
| Northeastern State | 2361 |
| Northern Arizona | 2046 |
| Northern Colorado | 2047 |
| Northern Illinois | 2048 |
| Northern Iowa | 2049 |
| Northern Kentucky | 2050 |
| Northern New Mexico | 2051 |
| Northwest | 2397 |
| Northwest Indian | 5823 |
| Northwestern | 2053 |
| Northwestern St. | 5824 |
| Notre Dame | 2055 |
| Notre Dame MD | 6228 |
| Oakland | 2056 |
| Oakwood Ambassadors | 5826 |
| Occidental | 5827 |
| Oglethorpe | 5828 |
| Ohio | 2057 |
| Ohio Christian | 3410 |
| Ohio State | 2058 |
| Ohio Wesleyan | 3352 |
| Oklahoma | 2059 |
| Oklahoma State | 2060 |
| Old Dominion | 2061 |
| Old Westbury | 5831 |
| Ole Miss | 2062 |
| Oral Roberts | 2064 |
| Oregon | 2065 |
| Oregon State | 2066 |
| Ouachita Baptist | 5832 |
| Our Lady Of The Lake | 2068 |
| Ozark Christian | 6230 |
| Pacific | 2069 |
| Pacific Boxers | 6665 |
| Paul Quinn | 2071 |
| Penn | 5834 |
| Penn St Altoona | 6666 |
| Penn State | 2073 |
| Penn State Wilkes-Barre | 3306 |
| Penn State-Fayette | 6667 |
| Penn State-Schuylkill | 6232 |
| Penn State-Scranton | 6668 |
| Penn State-Shenango | 6669 |
| Penn State-York | 3371 |
| Pepperdine | 2074 |
| Pfeiffer Falcons | 5836 |
| Piedmont | 2076 |
| Pittsburgh | 2079 |
| Pittsburgh Bradford | 6670 |
| Plattsburgh | 6233 |
| Point Chargers | 6234 |
| Polytechnic | 3309 |
| Portland | 2080 |
| Portland State | 2082 |
| Prairie View A&M | 2083 |
| Pratt Cannoneers | 6671 |
| Presbyterian | 240 |
| Princeton | 2084 |
| Providence | 197 |
| Purdue | 2085 |
| Purdue Northwest | 2450 |
| Queens Royals | 5839 |
| Quinnipiac | 241 |
| Radford | 2087 |
| Randall University | 2088 |
| Randolph | 3311 |
| Randolph-Macon | 6672 |
| Regent University | 2089 |
| Regis College | 3312 |
| Rhode Island | 2091 |
| Rhodes Lynx | 3313 |
| Rice | 1504 |
| Richmond Spiders | 6489 |
| Rider | 2093 |
| Rivier | 3314 |
| Robert Morris | 242 |
| Rockford University | 3315 |
| Rogers State Hillcats | 2401 |
| Rosemont | 2231 |
| Rust College | 2095 |
| Rutgers | 2096 |
| S'western (Texas) | 5841 |
| Sacramento State | 2101 |
| Sacred Heart | 2102 |
| Saint Josephs Hawks | 6490 |
| Sam Houston St. | 5847 |
| Samford | 2106 |
| San Diego | 5528 |
| San Diego State | 2108 |
| San Francisco | 1497 |
| San Francisco State | 2109 |
| San Jose State | 2110 |
| Santa Clara | 2111 |
| Schreiner Mountaineers | 3321 |
| SE Louisiana | 5842 |
| Seattle | 243 |
| Seton Hall | 2112 |
| Shawnee State | 6238 |
| Siena | 1570 |
| Siena Heights | 5849 |
| Siu Edwardsville | 5850 |
| SMU Mustangs | 5843 |
| SMWC Pomeroys | 5844 |
| South Alabama | 2115 |
| South Carolina | 2116 |
| South Carolina St | 5852 |
| South Dakota Coyotes | 5853 |
| South Dakota Mines | 6239 |
| South Dakota St. | 5854 |
| South Florida | 218 |
| Southeast Missouri State | 2118 |
| Southern Illinois | 2120 |
| Southern Indiana | 5566 |
| Southern Miss | 219 |
| Southern Oregon | 6675 |
| Southern Univ. | 5856 |
| Southern Utah | 244 |
| Southern Virginia | 2504 |
| Southern W. | 2403 |
| Southern-New O. | 2122 |
| Southwest Adventist | 3003 |
| Southwest Mustangs | 6293 |
| Southwestern Christian | 2233 |
| Spartanburg | 6676 |
| Spring Hill | 2505 |
| Springfield Pride | 2123 |
| St. Ambrose | 2432 |
| St. Andrews | 2124 |
| St. Bonaventure | 2125 |
| St. Elizabeth | 2126 |
| St. Francis (PA) | 5858 |
| St. Francis (PA) | 201 |
| St. John's (N.Y.) | 5859 |
| St. Joseph's (NY-LI) | 5860 |
| St. Louis | 2128 |
| St. Louis College of Pharmacy | 2433 |
| St. Mary's (MD) | 5862 |
| St. Marys (CA) | 5863 |
| St. Norbert | 6677 |
| St. Peters | 5864 |
| St. Thomas | 2132 |
| St. Thomas (Minn.) | 3325 |
| Stanford | 2133 |
| Stephen F. Austin | 2134 |
| Stetson | 2135 |
| Stonehill | 5866 |
| Stony Brook | 220 |
| Sul Ross State | 2434 |
| Suny Maritime | 5867 |
| Suny Oneonta | 6678 |
| SUNY-Brockport | 6673 |
| SUNY-Canton | 5845 |
| SUNY-Delhi | 5846 |
| SUNY-Purchase | 2100 |
| Syracuse | 2137 |
| Tabor | 6244 |
| Tarleton | 2362 |
| Taylor | 6679 |
| TCU | 202 |
| Temple | 2140 |
| Tennessee | 2141 |
| Tennessee State | 2142 |
| Tennessee Tech | 2143 |
| Texas | 203 |
| Texas A&M | 2144 |
| Texas A&M SA Jaguars | 6714 |
| Texas A&M-CC | 2145 |
| Texas A&M-Kingsville | 6680 |
| Texas College | 6681 |
| Texas Dallas | 6682 |
| Texas Lutheran | 5869 |
| Texas Southern | 246 |
| Texas State | 247 |
| Texas Tech | 2146 |
| Texas Texarkana Eagles | 2404 |
| Texas Wesleyan | 2147 |
| Texas-Permian Basin | 2148 |
| Thomas College | 2405 |
| Toccoa Falls | 2150 |
| Toledo | 204 |
| Towson | 2152 |
| Trinity (IL) | 5870 |
| Trinity Baptist | 2155 |
| Trinity of Texas | 5871 |
| Troy | 2157 |
| Truett-McConnell | 3329 |
| Tulane | 2158 |
| Tulsa | 2159 |
| Tusculum | 2438 |
| TX A&M Commerce | 3383 |
| UAB | 221 |
| UALR | 5873 |
| UC Davis | 2161 |
| UC Irvine | 2162 |
| UC Riverside | 2163 |
| UC San Diego | 2363 |
| UC Santa Barbara | 2164 |
| UCF Knights | 5874 |
| UCLA | 2166 |
| UConn | 5875 |
| UMass | 2168 |
| UMass Lowell | 2169 |
| UMBC Retrievers | 5876 |
| UMKC | 1505 |
| UNC Asheville | 5877 |
| Union Bulldogs | 6683 |
| University of the Cumberlands (KY) | 6326 |
| UNLV | 2171 |
| USC | 2172 |
| USC Upstate | 2173 |
| USMMA | 2439 |
| UT Arlington | 5878 |
| UT Martin | 5879 |
| Utah State | 2180 |
| Utah Tech | 5885 |
| Utah Utes | 5886 |
| Utah Valley State | 5887 |
| UTEP | 2177 |
| UTRGV | 5880 |
| UTSA Roadrunners | 5881 |
| UW-Stout | 5882 |
| VA Wesleyan | 2406 |
| Valley Forge | 5890 |
| Valparaiso | 2184 |
| Vanderbilt | 2185 |
| VCU Rams | 5888 |
| Vermont | 2187 |
| Vermont State - Johnson | 6684 |
| Vermont State - RK | 6685 |
| Villanova | 2188 |
| Virginia | 2189 |
| Virginia Tech | 2190 |
| Virginia-Lynchburg | 5892 |
| Virginia-Wise | 2440 |
| VMI | 5889 |
| Voorhees | 3333 |
| Wagner | 2191 |
| Wake Forest | 2192 |
| Waldorf College | 3334 |
| Walla Walla | 2237 |
| Warner University | 3335 |
| Warren Wilson | 3336 |
| Washington | 2193 |
| Washington Adventist | 2194 |
| Washington Coll | 3338 |
| Washington State | 2195 |
| Wayland Baptist | 6715 |
| Webber Int'l | 2407 |
| Weber State | 2196 |
| Wesleyan Univ. | 2253 |
| West Georgia | 6686 |
| West Virginia | 223 |
| West Virginia Wesleyan | 5896 |
| Westcliff | 2198 |
| Western Carolina | 2199 |
| Western Colorado | 3340 |
| Western Illinois | 2200 |
| Western Kentucky | 2201 |
| Western Michigan | 2202 |
| Western N. M. | 2508 |
| Western Oregon | 5897 |
| Westminster Blue Jays | 6687 |
| Westminster Titans | 5898 |
| Westminster UT | 2408 |
| Whittier | 2205 |
| Wichita State | 205 |
| Willamette | 3343 |
| William & Mary | 2209 |
| William Carey | 2238 |
| William Jessup | 2409 |
| William Peace | 2210 |
| William Woods | 3344 |
| Wilson College | 3345 |
| Winthrop | 2212 |
| Wisc. Green Bay | 5902 |
| Wisc. Milwaukee | 5903 |
| Wisconsin | 2214 |
| Wofford | 2215 |
| Worcester Tech | 3355 |
| Wright State | 206 |
| Wyoming | 1506 |
| Xavier | 207 |
| Yale | 2217 |
| York | 408 |
| York College | 6688 |
| Youngstown State | 2218 |

<a id="create-tags-from-team-names-options"></a>

*Create tags from team names:*

| Label | Value |
|-------|------|
| No | _tags |
| Yes - Create Tags | tags |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Ncaa Basketball Live Game Scores All Games Feed Last Run Had Errors | text | boolean | `{account.store.NcaaBasketballLiveGameScoresAllGames_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Ncaa Basketball Live Game Scores All Games Feed Last Run Was Success | text | boolean | `{account.store.NcaaBasketballLiveGameScoresAllGames_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Ncaa Basketball Live Game Scores All Games Feed Last Succesful Run At | text | datetime | `{account.store.NcaaBasketballLiveGameScoresAllGames_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Date | text | scalar | `{item.inventory_attributes.date}` | — |
| Id | text | scalar | `{item.inventory_attributes.id}` | — |
| Ingame | text | scalar | `{item.inventory_attributes.ingame}` | — |
| Postgame | text | scalar | `{item.inventory_attributes.postgame}` | — |
| Pregame | text | scalar | `{item.inventory_attributes.pregame}` | — |
| Scores Away Over Time | text | scalar | `{item.inventory_attributes.scores_away_over_time}` | — |
| Scores Away Quarter 1 | text | scalar | `{item.inventory_attributes.scores_away_quarter_1}` | — |
| Scores Away Quarter 2 | text | scalar | `{item.inventory_attributes.scores_away_quarter_2}` | — |
| Scores Away Quarter 3 | text | scalar | `{item.inventory_attributes.scores_away_quarter_3}` | — |
| Scores Away Quarter 4 | text | scalar | `{item.inventory_attributes.scores_away_quarter_4}` | — |
| Scores Away Total | text | scalar | `{item.inventory_attributes.scores_away_total}` | — |
| Scores Home Over Time | text | scalar | `{item.inventory_attributes.scores_home_over_time}` | — |
| Scores Home Quarter 1 | text | scalar | `{item.inventory_attributes.scores_home_quarter_1}` | — |
| Scores Home Quarter 2 | text | scalar | `{item.inventory_attributes.scores_home_quarter_2}` | — |
| Scores Home Quarter 3 | text | scalar | `{item.inventory_attributes.scores_home_quarter_3}` | — |
| Scores Home Quarter 4 | text | scalar | `{item.inventory_attributes.scores_home_quarter_4}` | — |
| Scores Home Total | text | scalar | `{item.inventory_attributes.scores_home_total}` | — |
| Stage | text | scalar | `{item.inventory_attributes.stage}` | — |
| Status Long | text | scalar | `{item.inventory_attributes.status_long}` | — |
| Status Short | text | scalar | `{item.inventory_attributes.status_short}` | — |
| Status Timer | text | scalar | `{item.inventory_attributes.status_timer}` | — |
| Teams Away Id | text | scalar | `{item.inventory_attributes.teams_away_id}` | — |
| Teams Away Name | text | scalar | `{item.inventory_attributes.teams_away_name}` | — |
| Teams Home Id | text | scalar | `{item.inventory_attributes.teams_home_id}` | — |
| Teams Home Name | text | scalar | `{item.inventory_attributes.teams_home_name}` | — |
| Time | text | scalar | `{item.inventory_attributes.time}` | — |
| Timestamp | text | scalar | `{item.inventory_attributes.timestamp}` | — |
| Venue | text | scalar | `{item.inventory_attributes.venue}` | — |
| Week | text | scalar | `{item.inventory_attributes.week}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:30 UTC*
