---
title: "NCAA College Football Live Game Scores - Lucit Application Reference"
description: "Add LIVE NCAA Football scores on game-day to your digital billboard and digital signage creatives with the NCAA Football Sports Game Scores app Add scores for both NCAA Division I..."
keywords: "lucit application, NCAA College Football Live Game Scores, app reference, integration"
---

# NCAA College Football Live Game Scores

Add LIVE NCAA Football scores on game-day to your digital billboard and digital signage creatives with the NCAA Football Sports Game Scores app Add scores for both NCAA Division I...

**Application Details:**

- **Name:** NCAA College Football Live Game Scores
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-9fb4e0d6-bda0-4042-a7d4-aea4cf8398e9`

---

## View in Lucit

**[🔗 View NCAA College Football Live Game Scores in Lucit](https://lucit.app/NcaaCollegeFootballLiveGameScores){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add NCAA College Football Live Game Scores to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "NCAA College Football Live Game Scores"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The NCAA College Football Live Game Scores application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **2 data source provider(s)**.

### Prerequisites to Using NCAA College Football Live Game Scores Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### NCAA College Football Live Game Scores (All Games)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with NCAA College Football Live Game Scores (All Games) dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for NCAA College Football Live Game Scores (All Games)**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on NCAA College Football Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on NCAA College Football Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Season** | `text` | Enter a season | Required |
| **Game Date** | `text` | Enter a game date in YYYY-MM-DD format, or leave blank to get todays games | — |
| **Include games in pre-game status** | `bool` | Enable this option to include games before they have started.  Useful to show game-time creatives | — |
| **Choose Teams** | `int` [(multiple select)](#choose-teams-options) | Please select one or more team | — |

**Enum Options:**

<a id="choose-teams-options"></a>

*Choose Teams:*

| Label | Value |
|-------|------|
| Abilene Christian | 241 |
| Adams State | 597 |
| Adrian | 626 |
| Air Force | 149 |
| Akron | 67 |
| Alabama | 106 |
| Alabama A&M | 82 |
| Alabama State | 221 |
| Albany State | 313 |
| Albion | 363 |
| Albright | 404 |
| Alcorn State | 228 |
| Alderson Broaddus | 441 |
| Alfred | 426 |
| Alfred State College | 359 |
| Allegheny | 675 |
| Allen | 539 |
| Alma College | 628 |
| Alvernia | 745 |
| American International | 483 |
| Amherst College | 580 |
| Anderson (IN) | 627 |
| Angelo State | 687 |
| Anna Maria College | 430 |
| Appalachian State | 144 |
| Apprentice School | 723 |
| Arizona | 156 |
| Arizona Christian | 803 |
| Arizona State | 86 |
| Arkansas | 127 |
| Arkansas Baptist | 727 |
| Arkansas State | 184 |
| Arkansas Tech | 640 |
| Arkansas-Monticello | 643 |
| Arkansas-Pine Bluff | 237 |
| Army | 177 |
| Ashland | 709 |
| Assumption | 304 |
| Auburn | 171 |
| Augsburg | 531 |
| Augustana College (IL) | 529 |
| Augustana University (SD) | 446 |
| Aurora | 533 |
| Austin College | 525 |
| Austin Peay | 40 |
| Ave Maria | 413 |
| Averett | 636 |
| BYU | 136 |
| Baldwin Wallace | 519 |
| Ball State | 70 |
| Barton College | 317 |
| Bates College | 495 |
| Baylor | 118 |
| Belhaven University | 702 |
| Beloit College | 432 |
| Bemidji State | 593 |
| Benedict College | 347 |
| Benedictine University (IL) | 546 |
| Bentley | 349 |
| Berry College | 467 |
| Bethany (WV) | 719 |
| Bethel (MN) | 706 |
| Bethune-Cookman | 124 |
| Birmingham-Southern | 721 |
| Black Hills State | 690 |
| Bloomsburg | 286 |
| Bluefield State University | 775 |
| Bluffton | 625 |
| Boise State | 204 |
| Boston College | 142 |
| Bowdoin | 410 |
| Bowie State | 605 |
| Bowling Green | 154 |
| Brevard College | 637 |
| Bridgewater College (VA) | 377 |
| Bridgewater State (MA) | 409 |
| Brockport | 392 |
| Bryant | 74 |
| Bucknell | 245 |
| Buena Vista | 623 |
| Buffalo State | 141 |
| Butler | 281 |
| Cal Poly | 89 |
| California | 161 |
| California (PA) | 380 |
| California Lutheran | 576 |
| Campbell | 249 |
| Capital University | 681 |
| Carleton College | 601 |
| Carnegie Mellon | 463 |
| Carroll (WI) | 648 |
| Carson-Newman | 471 |
| Carthage | 767 |
| Case Western Reserve | 676 |
| Castleton | 573 |
| Catawba | 502 |
| Catholic University | 474 |
| Central Arkansas | 214 |
| Central College | 542 |
| Central Connecticut | 137 |
| Central Michigan | 62 |
| Central Missouri | 587 |
| Central Oklahoma | 633 |
| Central State (OH) | 390 |
| Central Washington | 609 |
| Centre College | 714 |
| Chadron State | 319 |
| Chapman University | 694 |
| Charleston (WV) | 370 |
| Charleston Southern | 213 |
| Charlotte | 52 |
| Chattanooga | 255 |
| Chicago | 431 |
| Chowan | 417 |
| Christopher Newport | 710 |
| Cincinnati | 128 |
| Claremont Mudd Scripps College | 615 |
| Clarion | 561 |
| Clark Atlanta | 603 |
| Clemson | 209 |
| Coast Guard | 394 |
| Coastal Carolina | 176 |
| Coe College | 624 |
| Colby College | 506 |
| Colgate | 192 |
| College of Idaho | 733 |
| Colorado | 104 |
| Colorado Mesa | 599 |
| Colorado School of Mines | 598 |
| Colorado State | 116 |
| Colorado State-Pueblo | 616 |
| Columbia | 330 |
| Columbus State | 801 |
| Concord | 537 |
| Concordia (WI) | 547 |
| Concordia College (MI) | 291 |
| Concordia-Chicago | 532 |
| Concordia-Moorhead | 704 |
| Concordia-St. Paul | 682 |
| Cornell | 326 |
| Cornell College (IA) | 435 |
| Crown College | 770 |
| Curry College | 357 |
| Dakota State | 741 |
| Dartmouth | 327 |
| Davenport University-Grand Rapids | 753 |
| Davidson | 283 |
| Dayton | 277 |
| DePauw | 375 |
| Dean College | 356 |
| Defiance | 516 |
| Delaware | 146 |
| Delaware State | 284 |
| Delaware Valley | 504 |
| Delta State | 334 |
| Denison | 451 |
| Dickinson (PA) | 760 |
| Dickinson State | 798 |
| Drake | 289 |
| Dubuque | 420 |
| Duke | 99 |
| Duquesne | 50 |
| East Carolina | 120 |
| East Central | 591 |
| East Stroudsburg | 386 |
| East Tennessee State | 262 |
| East Texas Baptist | 563 |
| Eastern Illinois | 80 |
| Eastern Kentucky | 95 |
| Eastern Michigan | 94 |
| Eastern New Mexico | 332 |
| Eastern Oregon | 800 |
| Eastern University | 756 |
| Eastern Washington | 236 |
| Edinboro | 378 |
| Edward Waters | 340 |
| Elizabeth City State | 355 |
| Elmhurst | 528 |
| Elon | 173 |
| Emory & Henry College | 759 |
| Emporia State | 540 |
| Endicott College | 414 |
| Erskine | 610 |
| Eureka College | 568 |
| FDU-Florham | 395 |
| Fairmont State | 487 |
| Fayetteville State | 416 |
| Ferris State | 717 |
| Ferrum | 456 |
| Findlay | 366 |
| Fitchburg State | 397 |
| Florida | 113 |
| Florida A&M | 54 |
| Florida Atlantic | 51 |
| Florida International | 73 |
| Florida Memorial University | 296 |
| Florida State | 49 |
| Fordham | 257 |
| Fort Hays State | 662 |
| Fort Lewis | 565 |
| Fort Valley State | 538 |
| Framingham State | 515 |
| Franklin | 510 |
| Franklin & Marshall | 481 |
| Franklin Pierce | 634 |
| Fresno State | 88 |
| Frostburg State | 371 |
| Furman | 211 |
| Gallaudet | 361 |
| Gannon | 387 |
| Gardner-Webb | 225 |
| Geneva College | 466 |
| George Fox | 780 |
| Georgetown | 279 |
| Georgia | 109 |
| Georgia Southern | 166 |
| Georgia State | 189 |
| Georgia Tech | 208 |
| Gettysburg | 508 |
| Glenville State | 443 |
| Grambling | 185 |
| Grand Valley State | 660 |
| Greensboro College | 458 |
| Greenville | 574 |
| Grinnell | 434 |
| Grove City College | 464 |
| Guilford | 478 |
| Gustavus Adolphus | 556 |
| Hamilton | 411 |
| Hamline | 705 |
| Hampden Sydney | 457 |
| Hampton | 293 |
| Hanover | 427 |
| Hardin-Simmons | 545 |
| Harding University | 652 |
| Hartwick | 715 |
| Harvard | 321 |
| Hawai'i | 59 |
| Heidelberg | 672 |
| Henderson State | 642 |
| Hendrix College | 606 |
| Hilbert College | 399 |
| Hillsdale | 437 |
| Hiram College | 374 |
| Hobart | 484 |
| Holy Cross | 223 |
| Hope | 513 |
| Houston | 134 |
| Houston Christian | 259 |
| Howard | 230 |
| Howard Payne | 607 |
| Huntingdon College (AL) | 776 |
| Husson | 358 |
| Idaho | 202 |
| Idaho State | 44 |
| Illinois | 47 |
| Illinois College | 571 |
| Illinois State | 126 |
| Illinois Wesleyan | 651 |
| Incarnate Word | 222 |
| Indiana | 103 |
| Indiana State | 218 |
| Indiana Wesleyan | 299 |
| Indiana-Pennsylvania | 737 |
| Indianapolis | 659 |
| Iowa | 138 |
| Iowa State | 151 |
| Iowa Wesleyan | 582 |
| Ithaca | 425 |
| Jackson State | 303 |
| Jacksonville State | 250 |
| James Madison | 169 |
| Jerry Rice Team | 36 |
| John Carroll | 518 |
| Johns Hopkins | 423 |
| Johnson C Smith | 418 |
| Juniata | 424 |
| Kalamazoo | 517 |
| Kansas | 101 |
| Kansas State | 174 |
| Kean University | 475 |
| Keiser University | 335 |
| Kennesaw State | 217 |
| Kent State | 206 |
| Kentucky | 129 |
| Kentucky State | 325 |
| Kentucky Wesleyan | 684 |
| Kenyon | 449 |
| Keystone | 497 |
| Kings College (PA) | 755 |
| Knox College | 589 |
| Kutztown | 382 |
| LSU | 207 |
| La Verne | 301 |
| LaGrange College | 455 |
| Lafayette | 216 |
| Lake Erie | 749 |
| Lake Forest | 588 |
| Lakeland University | 671 |
| Lamar | 229 |
| Lane | 297 |
| Lawrence University | 797 |
| Lebanon Valley | 396 |
| Lehigh | 275 |
| Lenoir-Rhyne | 611 |
| Lewis & Clark | 579 |
| Liberty | 179 |
| Limestone | 268 |
| Lincoln (CA) | 732 |
| Lincoln (MO) | 661 |
| Lincoln (PA) | 285 |
| Lindenwood | 316 |
| Linfield | 612 |
| Livingstone | 622 |
| Lock Haven | 560 |
| Long Island University | 76 |
| Loras College | 543 |
| Louisiana | 182 |
| Louisiana Christian University | 312 |
| Louisiana Tech | 84 |
| Louisville | 198 |
| Luther | 422 |
| Lycoming | 698 |
| Lyon College | 747 |
| MIT | 699 |
| Macalester | 712 |
| Madonna University (Mich.) | 795 |
| Maine | 200 |
| Manchester | 575 |
| Marietta | 521 |
| Marist | 278 |
| Mars Hill | 269 |
| Marshall | 158 |
| Martin Luther | 768 |
| Mary Hardin-Baylor | 644 |
| Maryland | 140 |
| Maryville College (TN) | 763 |
| Mass Maritime | 429 |
| Mayville State | 786 |
| McDaniel College | 480 |
| McKendree | 344 |
| McMurry | 562 |
| McNeese | 234 |
| Memphis | 187 |
| Mercer | 172 |
| Merchant Marine | 476 |
| Mercyhurst | 381 |
| Merrimack | 276 |
| Methodist | 461 |
| Miami | 123 |
| Miami (OH) | 130 |
| Michigan | 115 |
| Michigan State | 92 |
| Michigan Tech | 309 |
| Middle Tennessee | 170 |
| Middlebury | 581 |
| Midwestern State | 685 |
| Miles College | 292 |
| Millersville | 738 |
| Millikin | 567 |
| Millsaps | 584 |
| Minnesota | 85 |
| Minnesota Duluth | 664 |
| Minnesota Morris | 782 |
| Minnesota State | 667 |
| Minnesota State Moorhead | 739 |
| Minot State | 558 |
| Misericordia | 405 |
| Mississippi College | 338 |
| Mississippi State | 186 |
| Mississippi Valley State | 271 |
| Missouri | 83 |
| Missouri S&T | 308 |
| Missouri Southern State | 632 |
| Missouri State | 239 |
| Missouri Western | 541 |
| Monmouth | 267 |
| Monmouth (IL) | 570 |
| Montana | 288 |
| Montana State | 253 |
| Montana Tech | 814 |
| Montana-Western | 807 |
| Montclair State | 489 |
| Moravian | 448 |
| Morehead State | 265 |
| Morehouse College | 329 |
| Morgan State | 167 |
| Mount St. Joseph | 512 |
| Mount Union | 520 |
| Muhlenberg | 499 |
| Murray State | 194 |
| Muskingum | 680 |
| NC State | 121 |
| NC Wesleyan | 376 |
| Navy | 145 |
| Nebraska | 42 |
| Nebraska Wesleyan | 766 |
| Nebraska-Kearney | 535 |
| Nevada | 56 |
| New Hampshire | 261 |
| New Haven | 482 |
| New Mexico | 199 |
| New Mexico Highlands | 564 |
| New Mexico State | 55 |
| Newberry | 454 |
| Nicholls | 164 |
| Nichols | 393 |
| Norfolk State | 159 |
| North Alabama | 263 |
| North American University | 318 |
| North Carolina | 53 |
| North Carolina A&T | 248 |
| North Carolina Central | 302 |
| North Central | 527 |
| North Dakota | 157 |
| North Dakota State | 254 |
| North Greenville | 266 |
| North Park | 649 |
| North Texas | 58 |
| Northeastern State | 689 |
| Northern Arizona | 87 |
| Northern Colorado | 220 |
| Northern Illinois | 79 |
| Northern Iowa | 150 |
| Northern Michigan | 368 |
| Northern State | 666 |
| Northwest Missouri State | 586 |
| Northwestern | 41 |
| Northwestern (IA) | 728 |
| Northwestern (MN) | 769 |
| Northwestern Oklahoma State | 654 |
| Northwestern State | 251 |
| Northwood (MI) | 734 |
| Norwich | 572 |
| Notre Dame | 108 |
| Notre Dame College (OH) | 748 |
| Oberlin | 452 |
| Ohio | 168 |
| Ohio Dominican | 505 |
| Ohio Northern | 673 |
| Ohio State | 107 |
| Ohio Wesleyan | 700 |
| Oklahoma | 117 |
| Oklahoma Baptist | 655 |
| Oklahoma Panhandle State | 783 |
| Oklahoma State | 61 |
| Old Dominion | 96 |
| Ole Miss | 131 |
| Olivet College | 428 |
| Oregon | 110 |
| Oregon State | 203 |
| Otterbein | 551 |
| Ouachita Baptist | 641 |
| Pace University | 352 |
| Pacific (OR) | 695 |
| Pacific Lutheran | 697 |
| Penn State | 78 |
| Pennsylvania | 324 |
| Pittsburg State | 688 |
| Pittsburgh | 63 |
| Plymouth State | 762 |
| Point University | 722 |
| Pomona Pitzer | 793 |
| Portland State | 91 |
| Post University | 307 |
| Prairie View A&M | 295 |
| Presbyterian | 294 |
| Princeton | 323 |
| Puget Sound | 577 |
| Purdue | 77 |
| Quincy | 365 |
| Randolph-Macon | 751 |
| Redlands | 613 |
| Rensselaer | 618 |
| Rhode Island | 256 |
| Rhodes College | 711 |
| Richmond | 148 |
| Ripon | 436 |
| Robert Morris | 224 |
| Rockford | 740 |
| Roosevelt | 774 |
| Rose-Hulman | 362 |
| Rowan | 701 |
| Rutgers | 143 |
| SE Louisiana | 183 |
| SMU | 190 |
| SUNY Cortland | 403 |
| SUNY Maritime | 477 |
| SUNY Morrisville | 354 |
| Sacramento State | 258 |
| Sacred Heart | 280 |
| Saginaw Valley State | 735 |
| Saint Augustine's | 777 |
| Saint John's (MN) | 796 |
| Saint Vincent | 787 |
| Salisbury University | 412 |
| Salve Regina | 742 |
| Sam Houston | 813 |
| Samford | 210 |
| San Diego | 300 |
| San Diego State | 155 |
| San José State | 90 |
| Savannah State | 348 |
| Seton Hill | 385 |
| Sewanee Univ. of the South | 552 |
| Shaw | 604 |
| Shenandoah | 761 |
| Shepherd | 379 |
| Shippensburg | 469 |
| Shorter | 369 |
| Simpson College (IA) | 778 |
| Sioux Falls | 683 |
| Slippery Rock | 384 |
| South Alabama | 163 |
| South Carolina | 188 |
| South Carolina State | 72 |
| South Dakota | 175 |
| South Dakota Mines | 600 |
| South Dakota State | 139 |
| South Florida | 135 |
| Southeast Missouri State | 152 |
| Southeastern Oklahoma | 657 |
| Southeastern University | 779 |
| Southern | 232 |
| Southern Arkansas | 653 |
| Southern Connecticut State | 339 |
| Southern Illinois | 243 |
| Southern Miss | 178 |
| Southern Nazarene | 590 |
| Southern Oregon | 808 |
| Southern Utah | 212 |
| Southern Virginia | 491 |
| Southwest Baptist | 342 |
| Southwest Minnesota State | 596 |
| Southwestern Assemblies of God | 802 |
| Southwestern Oklahoma | 656 |
| Southwestern University | 645 |
| Springfield | 757 |
| St. Ambrose | 772 |
| St. Andrews | 333 |
| St. Anselm | 635 |
| St. Francis (PA) | 68 |
| St. John Fisher University | 758 |
| St. Lawrence | 353 |
| St. Norbert | 771 |
| St. Olaf | 799 |
| St. Scholastica | 555 |
| St. Thomas University (Fl) | 282 |
| St. Thomas-Minnesota | 815 |
| St. Xavier (IL) | 812 |
| Stanford | 191 |
| Stephen F. Austin | 231 |
| Stetson | 290 |
| Stevenson | 790 |
| Stonehill | 287 |
| Stony Brook | 246 |
| Sul Ross State | 789 |
| Susquehanna University | 447 |
| Syracuse | 197 |
| TCU | 105 |
| Tarleton State | 731 |
| Taylor | 311 |
| Temple | 100 |
| Tennessee | 69 |
| Tennessee State | 252 |
| Tennessee Tech | 102 |
| Texas | 195 |
| Texas A&M | 111 |
| Texas A&M-Commerce | 272 |
| Texas A&M-Kingsville | 692 |
| Texas Lutheran | 647 |
| Texas Southern | 233 |
| Texas State | 165 |
| Texas Tech | 193 |
| The Citadel | 260 |
| The College of New Jersey | 415 |
| Thiel | 788 |
| Thomas More College | 305 |
| Tiffin | 750 |
| Toledo | 75 |
| Towson | 244 |
| Trine University | 511 |
| Trinity (CT) | 806 |
| Trinity University (TX) | 646 |
| Troy | 132 |
| Truman State | 438 |
| Tufts University | 522 |
| Tulane | 180 |
| Tulsa | 160 |
| Tusculum | 638 |
| Tuskegee | 320 |
| UAB | 81 |
| UAlbany | 730 |
| UC Davis | 162 |
| UCF | 71 |
| UCLA | 153 |
| UConn | 46 |
| UFTL | 724 |
| UL Monroe | 196 |
| UMASS Dartmouth | 514 |
| UMass | 181 |
| UNC Pembroke | 736 |
| UNLV | 43 |
| USC | 122 |
| UT Martin | 247 |
| UT Permian Basin | 784 |
| UTEP | 57 |
| UTSA | 133 |
| UVA Wise | 314 |
| Union (NY) | 754 |
| Union College | 781 |
| University of Mary | 595 |
| University of New England | 360 |
| University of Rochester (NY) | 752 |
| Upper Iowa | 665 |
| Ursinus | 744 |
| Utah | 114 |
| Utah State | 45 |
| Utah Tech | 264 |
| Utica College | 473 |
| VMI | 66 |
| Valdosta State | 663 |
| Valley City State | 746 |
| Valparaiso | 298 |
| Vanderbilt | 60 |
| Villanova | 242 |
| Virginia | 147 |
| Virginia Lynchburg | 306 |
| Virginia State | 620 |
| Virginia Tech | 97 |
| Virginia Union | 346 |
| WPI | 743 |
| Wabash College | 549 |
| Wagner | 219 |
| Wake Forest | 65 |
| Walsh | 364 |
| Warner | 336 |
| Wartburg College | 421 |
| Washburn | 534 |
| Washington | 205 |
| Washington & Jefferson | 677 |
| Washington State | 201 |
| Washington University (St. Louis) | 810 |
| Washington and Lee | 811 |
| Wayland Baptist | 804 |
| Wayne State (MI) | 630 |
| Wayne State (NE) | 559 |
| Waynesburg | 791 |
| Webber International | 729 |
| Weber State | 227 |
| Wesleyan University (CT) | 805 |
| West Alabama | 592 |
| West Chester | 388 |
| West Florida | 720 |
| West Georgia | 716 |
| West Liberty | 373 |
| West Texas A&M | 691 |
| West Virginia | 64 |
| West Virginia State | 486 |
| West Virginia Wesleyan | 536 |
| Western Carolina | 226 |
| Western Colorado | 617 |
| Western Connecticut State | 351 |
| Western Illinois | 215 |
| Western Kentucky | 39 |
| Western Michigan | 93 |
| Western New England | 472 |
| Western New Mexico | 337 |
| Western Oregon | 274 |
| Westfield State | 350 |
| Westminster (MO) | 773 |
| Westminster (PA) | 764 |
| Wheaton | 794 |
| Wheeling | 785 |
| Whitworth | 614 |
| Widener University | 407 |
| Wilkes University | 406 |
| Willamette | 400 |
| William & Mary | 98 |
| William Jewell College | 343 |
| William Paterson | 496 |
| Williams | 809 |
| Wilmington (OH) | 792 |
| Wingate | 639 |
| Winona State | 594 |
| Winston-Salem | 310 |
| Wisconsin | 125 |
| Wisconsin Lutheran | 670 |
| Wisconsin-Eau Claire | 703 |
| Wisconsin-La Crosse | 631 |
| Wisconsin-Oshkosh | 585 |
| Wisconsin-Platteville | 544 |
| Wisconsin-River Falls | 678 |
| Wisconsin-Stevens Point | 668 |
| Wisconsin-Stout | 557 |
| Wisconsin-Whitewater | 468 |
| Wittenberg | 765 |
| Wofford | 240 |
| Wooster | 548 |
| Worcester State College | 398 |
| Wyoming | 48 |
| Yale | 328 |
| Youngstown State | 238 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Ncaa College Football Live Game Scores All Games Feed Last Run Had Errors | text | boolean | `{account.store.NcaaCollegeFootballLiveGameScoresAllGames_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Ncaa College Football Live Game Scores All Games Feed Last Run Was Success | text | boolean | `{account.store.NcaaCollegeFootballLiveGameScoresAllGames_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Ncaa College Football Live Game Scores All Games Feed Last Succesful Run At | text | datetime | `{account.store.NcaaCollegeFootballLiveGameScoresAllGames_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Game Date Date | text | scalar | `{item.inventory_attributes.game_date_date}` | — |
| Game Date Time | text | scalar | `{item.inventory_attributes.game_date_time}` | — |
| Game Date Timestamp | text | scalar | `{item.inventory_attributes.game_date_timestamp}` | — |
| Game Stage | text | scalar | `{item.inventory_attributes.game_stage}` | — |
| Game Status Long | text | scalar<br/>[(enum)](#item-inventory_attributes-game-status-long-options) | `{item.inventory_attributes.game_status_long}` | — |
| Game Status Short | text | scalar<br/>[(enum)](#item-inventory_attributes-game-status-short-options) | `{item.inventory_attributes.game_status_short}` | — |
| Game Status Timer | text | scalar | `{item.inventory_attributes.game_status_timer}` | — |
| Game Venue City | text | scalar | `{item.inventory_attributes.game_venue_city}` | — |
| Game Venue Name | text | scalar | `{item.inventory_attributes.game_venue_name}` | — |
| Game Week | text | scalar | `{item.inventory_attributes.game_week}` | — |
| Ingame | text | scalar | `{item.inventory_attributes.ingame}` | — |
| Ncaa Contest Clock | text | scalar | `{item.inventory_attributes.ncaa_contestClock}` | — |
| Ncaa Current Period | text | scalar | `{item.inventory_attributes.ncaa_currentPeriod}` | — |
| Ncaa Final Message | text | scalar | `{item.inventory_attributes.ncaa_finalMessage}` | — |
| Ncaa Game State | text | scalar | `{item.inventory_attributes.ncaa_gameState}` | — |
| Ncaa Status Code Display | text | scalar | `{item.inventory_attributes.ncaa_statusCodeDisplay}` | — |
| Postgame | text | scalar | `{item.inventory_attributes.postgame}` | — |
| Pregame | text | scalar | `{item.inventory_attributes.pregame}` | — |
| Scores Away Overtime | text | scalar | `{item.inventory_attributes.scores_away_overtime}` | — |
| Scores Away Quarter 1 | text | scalar | `{item.inventory_attributes.scores_away_quarter_1}` | — |
| Scores Away Quarter 2 | text | scalar | `{item.inventory_attributes.scores_away_quarter_2}` | — |
| Scores Away Quarter 3 | text | scalar | `{item.inventory_attributes.scores_away_quarter_3}` | — |
| Scores Away Quarter 4 | text | scalar | `{item.inventory_attributes.scores_away_quarter_4}` | — |
| Scores Away Total | text | scalar | `{item.inventory_attributes.scores_away_total}` | — |
| Scores Home Overtime | text | scalar | `{item.inventory_attributes.scores_home_overtime}` | — |
| Scores Home Quarter 1 | text | scalar | `{item.inventory_attributes.scores_home_quarter_1}` | — |
| Scores Home Quarter 2 | text | scalar | `{item.inventory_attributes.scores_home_quarter_2}` | — |
| Scores Home Quarter 3 | text | scalar | `{item.inventory_attributes.scores_home_quarter_3}` | — |
| Scores Home Quarter 4 | text | scalar | `{item.inventory_attributes.scores_home_quarter_4}` | — |
| Scores Home Total | text | scalar | `{item.inventory_attributes.scores_home_total}` | — |
| Teams Away Id | text | scalar | `{item.inventory_attributes.teams_away_id}` | — |
| Teams Away Name | text | scalar | `{item.inventory_attributes.teams_away_name}` | — |
| Teams Away Ncaa Is Winner | text | scalar | `{item.inventory_attributes.teams_away_ncaa_isWinner}` | — |
| Teams Away Ncaa Name6 Char | text | scalar | `{item.inventory_attributes.teams_away_ncaa_name6Char}` | — |
| Teams Home Id | text | scalar | `{item.inventory_attributes.teams_home_id}` | — |
| Teams Home Name | text | scalar | `{item.inventory_attributes.teams_home_name}` | — |
| Teams Home Ncaa Is Winner | text | scalar | `{item.inventory_attributes.teams_home_ncaa_isWinner}` | — |
| Teams Home Ncaa Name6 Char | text | scalar | `{item.inventory_attributes.teams_home_ncaa_name6Char}` | — |

**Enum Options:**

<a id="item-inventory_attributes-game-status-long-options"></a>

*Game Status Long:*

| Label | Value | Description |
|-------|------|-------------|
| Not Started | Not Started | Code : NS |
| 1st Quarter | 1st Quarter | Code : Q1 |
| 2nd Quarter | 2nd Quarter | Code : Q2 |
| 3rd Quarter | 3rd Quarter | Code : Q3 |
| 4th Quarter | 4th Quarter | Code : Q4 |
| Halftime | Halftime | Code : HT |
| Overtime | Overtime | Code : OT |
| Final | Final | Code : FT |
| After Overtime | After Overtime | Code : AOT |
| Postponed | Postponed | Code : PST |
| Cancelled | Cancelled | Code : CANC |

<a id="item-inventory_attributes-game-status-short-options"></a>

*Game Status Short:*

| Label | Value |
|-------|------|
| Not Started | NS |
| 1st Quarter | Q1 |
| 2nd Quarter | Q2 |
| 3rd Quarter | Q3 |
| 4th Quarter | Q4 |
| Halftime | HT |
| Overtime | OT |
| Final | FT |
| After Overtime | AOT |
| Postponed | PST |
| Cancelled | CANC |




---

### NCAA College Football Live Game Scores (Single Team)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with NCAA College Football Live Game Scores (Single Team) dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with NCAA College Football Live Game Scores (Single Team)**

To add values from NCAA College Football Live Game Scores (Single Team) to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from NCAA College Football Live Game Scores (Single Team) `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled NCAA College Football Live Game Scores (Single Team) or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using NCAA College Football Live Game Scores (Single Team) data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from NCAA College Football Live Game Scores (Single Team):

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Choose Team** | `int` [(enum)](#choose-team-options) | Please select a team | Required |

**Enum Options:**

<a id="choose-team-options"></a>

*Choose Team:*

| Label | Value |
|-------|------|
| Abilene Christian | 241 |
| Adams State | 597 |
| Adrian | 626 |
| Air Force | 149 |
| Akron | 67 |
| Alabama | 106 |
| Alabama A&M | 82 |
| Alabama State | 221 |
| Albany State | 313 |
| Albion | 363 |
| Albright | 404 |
| Alcorn State | 228 |
| Alderson Broaddus | 441 |
| Alfred | 426 |
| Alfred State College | 359 |
| Allegheny | 675 |
| Allen | 539 |
| Alma College | 628 |
| Alvernia | 745 |
| American International | 483 |
| Amherst College | 580 |
| Anderson (IN) | 627 |
| Angelo State | 687 |
| Anna Maria College | 430 |
| Appalachian State | 144 |
| Apprentice School | 723 |
| Arizona | 156 |
| Arizona Christian | 803 |
| Arizona State | 86 |
| Arkansas | 127 |
| Arkansas Baptist | 727 |
| Arkansas State | 184 |
| Arkansas Tech | 640 |
| Arkansas-Monticello | 643 |
| Arkansas-Pine Bluff | 237 |
| Army | 177 |
| Ashland | 709 |
| Assumption | 304 |
| Auburn | 171 |
| Augsburg | 531 |
| Augustana College (IL) | 529 |
| Augustana University (SD) | 446 |
| Aurora | 533 |
| Austin College | 525 |
| Austin Peay | 40 |
| Ave Maria | 413 |
| Averett | 636 |
| BYU | 136 |
| Baldwin Wallace | 519 |
| Ball State | 70 |
| Barton College | 317 |
| Bates College | 495 |
| Baylor | 118 |
| Belhaven University | 702 |
| Beloit College | 432 |
| Bemidji State | 593 |
| Benedict College | 347 |
| Benedictine University (IL) | 546 |
| Bentley | 349 |
| Berry College | 467 |
| Bethany (WV) | 719 |
| Bethel (MN) | 706 |
| Bethune-Cookman | 124 |
| Birmingham-Southern | 721 |
| Black Hills State | 690 |
| Bloomsburg | 286 |
| Bluefield State University | 775 |
| Bluffton | 625 |
| Boise State | 204 |
| Boston College | 142 |
| Bowdoin | 410 |
| Bowie State | 605 |
| Bowling Green | 154 |
| Brevard College | 637 |
| Bridgewater College (VA) | 377 |
| Bridgewater State (MA) | 409 |
| Brockport | 392 |
| Bryant | 74 |
| Bucknell | 245 |
| Buena Vista | 623 |
| Buffalo State | 141 |
| Butler | 281 |
| Cal Poly | 89 |
| California | 161 |
| California (PA) | 380 |
| California Lutheran | 576 |
| Campbell | 249 |
| Capital University | 681 |
| Carleton College | 601 |
| Carnegie Mellon | 463 |
| Carroll (WI) | 648 |
| Carson-Newman | 471 |
| Carthage | 767 |
| Case Western Reserve | 676 |
| Castleton | 573 |
| Catawba | 502 |
| Catholic University | 474 |
| Central Arkansas | 214 |
| Central College | 542 |
| Central Connecticut | 137 |
| Central Michigan | 62 |
| Central Missouri | 587 |
| Central Oklahoma | 633 |
| Central State (OH) | 390 |
| Central Washington | 609 |
| Centre College | 714 |
| Chadron State | 319 |
| Chapman University | 694 |
| Charleston (WV) | 370 |
| Charleston Southern | 213 |
| Charlotte | 52 |
| Chattanooga | 255 |
| Chicago | 431 |
| Chowan | 417 |
| Christopher Newport | 710 |
| Cincinnati | 128 |
| Claremont Mudd Scripps College | 615 |
| Clarion | 561 |
| Clark Atlanta | 603 |
| Clemson | 209 |
| Coast Guard | 394 |
| Coastal Carolina | 176 |
| Coe College | 624 |
| Colby College | 506 |
| Colgate | 192 |
| College of Idaho | 733 |
| Colorado | 104 |
| Colorado Mesa | 599 |
| Colorado School of Mines | 598 |
| Colorado State | 116 |
| Colorado State-Pueblo | 616 |
| Columbia | 330 |
| Columbus State | 801 |
| Concord | 537 |
| Concordia (WI) | 547 |
| Concordia College (MI) | 291 |
| Concordia-Chicago | 532 |
| Concordia-Moorhead | 704 |
| Concordia-St. Paul | 682 |
| Cornell | 326 |
| Cornell College (IA) | 435 |
| Crown College | 770 |
| Curry College | 357 |
| Dakota State | 741 |
| Dartmouth | 327 |
| Davenport University-Grand Rapids | 753 |
| Davidson | 283 |
| Dayton | 277 |
| DePauw | 375 |
| Dean College | 356 |
| Defiance | 516 |
| Delaware | 146 |
| Delaware State | 284 |
| Delaware Valley | 504 |
| Delta State | 334 |
| Denison | 451 |
| Dickinson (PA) | 760 |
| Dickinson State | 798 |
| Drake | 289 |
| Dubuque | 420 |
| Duke | 99 |
| Duquesne | 50 |
| East Carolina | 120 |
| East Central | 591 |
| East Stroudsburg | 386 |
| East Tennessee State | 262 |
| East Texas Baptist | 563 |
| Eastern Illinois | 80 |
| Eastern Kentucky | 95 |
| Eastern Michigan | 94 |
| Eastern New Mexico | 332 |
| Eastern Oregon | 800 |
| Eastern University | 756 |
| Eastern Washington | 236 |
| Edinboro | 378 |
| Edward Waters | 340 |
| Elizabeth City State | 355 |
| Elmhurst | 528 |
| Elon | 173 |
| Emory & Henry College | 759 |
| Emporia State | 540 |
| Endicott College | 414 |
| Erskine | 610 |
| Eureka College | 568 |
| FDU-Florham | 395 |
| Fairmont State | 487 |
| Fayetteville State | 416 |
| Ferris State | 717 |
| Ferrum | 456 |
| Findlay | 366 |
| Fitchburg State | 397 |
| Florida | 113 |
| Florida A&M | 54 |
| Florida Atlantic | 51 |
| Florida International | 73 |
| Florida Memorial University | 296 |
| Florida State | 49 |
| Fordham | 257 |
| Fort Hays State | 662 |
| Fort Lewis | 565 |
| Fort Valley State | 538 |
| Framingham State | 515 |
| Franklin | 510 |
| Franklin & Marshall | 481 |
| Franklin Pierce | 634 |
| Fresno State | 88 |
| Frostburg State | 371 |
| Furman | 211 |
| Gallaudet | 361 |
| Gannon | 387 |
| Gardner-Webb | 225 |
| Geneva College | 466 |
| George Fox | 780 |
| Georgetown | 279 |
| Georgia | 109 |
| Georgia Southern | 166 |
| Georgia State | 189 |
| Georgia Tech | 208 |
| Gettysburg | 508 |
| Glenville State | 443 |
| Grambling | 185 |
| Grand Valley State | 660 |
| Greensboro College | 458 |
| Greenville | 574 |
| Grinnell | 434 |
| Grove City College | 464 |
| Guilford | 478 |
| Gustavus Adolphus | 556 |
| Hamilton | 411 |
| Hamline | 705 |
| Hampden Sydney | 457 |
| Hampton | 293 |
| Hanover | 427 |
| Hardin-Simmons | 545 |
| Harding University | 652 |
| Hartwick | 715 |
| Harvard | 321 |
| Hawai'i | 59 |
| Heidelberg | 672 |
| Henderson State | 642 |
| Hendrix College | 606 |
| Hilbert College | 399 |
| Hillsdale | 437 |
| Hiram College | 374 |
| Hobart | 484 |
| Holy Cross | 223 |
| Hope | 513 |
| Houston | 134 |
| Houston Christian | 259 |
| Howard | 230 |
| Howard Payne | 607 |
| Huntingdon College (AL) | 776 |
| Husson | 358 |
| Idaho | 202 |
| Idaho State | 44 |
| Illinois | 47 |
| Illinois College | 571 |
| Illinois State | 126 |
| Illinois Wesleyan | 651 |
| Incarnate Word | 222 |
| Indiana | 103 |
| Indiana State | 218 |
| Indiana Wesleyan | 299 |
| Indiana-Pennsylvania | 737 |
| Indianapolis | 659 |
| Iowa | 138 |
| Iowa State | 151 |
| Iowa Wesleyan | 582 |
| Ithaca | 425 |
| Jackson State | 303 |
| Jacksonville State | 250 |
| James Madison | 169 |
| Jerry Rice Team | 36 |
| John Carroll | 518 |
| Johns Hopkins | 423 |
| Johnson C Smith | 418 |
| Juniata | 424 |
| Kalamazoo | 517 |
| Kansas | 101 |
| Kansas State | 174 |
| Kean University | 475 |
| Keiser University | 335 |
| Kennesaw State | 217 |
| Kent State | 206 |
| Kentucky | 129 |
| Kentucky State | 325 |
| Kentucky Wesleyan | 684 |
| Kenyon | 449 |
| Keystone | 497 |
| Kings College (PA) | 755 |
| Knox College | 589 |
| Kutztown | 382 |
| LSU | 207 |
| La Verne | 301 |
| LaGrange College | 455 |
| Lafayette | 216 |
| Lake Erie | 749 |
| Lake Forest | 588 |
| Lakeland University | 671 |
| Lamar | 229 |
| Lane | 297 |
| Lawrence University | 797 |
| Lebanon Valley | 396 |
| Lehigh | 275 |
| Lenoir-Rhyne | 611 |
| Lewis & Clark | 579 |
| Liberty | 179 |
| Limestone | 268 |
| Lincoln (CA) | 732 |
| Lincoln (MO) | 661 |
| Lincoln (PA) | 285 |
| Lindenwood | 316 |
| Linfield | 612 |
| Livingstone | 622 |
| Lock Haven | 560 |
| Long Island University | 76 |
| Loras College | 543 |
| Louisiana | 182 |
| Louisiana Christian University | 312 |
| Louisiana Tech | 84 |
| Louisville | 198 |
| Luther | 422 |
| Lycoming | 698 |
| Lyon College | 747 |
| MIT | 699 |
| Macalester | 712 |
| Madonna University (Mich.) | 795 |
| Maine | 200 |
| Manchester | 575 |
| Marietta | 521 |
| Marist | 278 |
| Mars Hill | 269 |
| Marshall | 158 |
| Martin Luther | 768 |
| Mary Hardin-Baylor | 644 |
| Maryland | 140 |
| Maryville College (TN) | 763 |
| Mass Maritime | 429 |
| Mayville State | 786 |
| McDaniel College | 480 |
| McKendree | 344 |
| McMurry | 562 |
| McNeese | 234 |
| Memphis | 187 |
| Mercer | 172 |
| Merchant Marine | 476 |
| Mercyhurst | 381 |
| Merrimack | 276 |
| Methodist | 461 |
| Miami | 123 |
| Miami (OH) | 130 |
| Michigan | 115 |
| Michigan State | 92 |
| Michigan Tech | 309 |
| Middle Tennessee | 170 |
| Middlebury | 581 |
| Midwestern State | 685 |
| Miles College | 292 |
| Millersville | 738 |
| Millikin | 567 |
| Millsaps | 584 |
| Minnesota | 85 |
| Minnesota Duluth | 664 |
| Minnesota Morris | 782 |
| Minnesota State | 667 |
| Minnesota State Moorhead | 739 |
| Minot State | 558 |
| Misericordia | 405 |
| Mississippi College | 338 |
| Mississippi State | 186 |
| Mississippi Valley State | 271 |
| Missouri | 83 |
| Missouri S&T | 308 |
| Missouri Southern State | 632 |
| Missouri State | 239 |
| Missouri Western | 541 |
| Monmouth | 267 |
| Monmouth (IL) | 570 |
| Montana | 288 |
| Montana State | 253 |
| Montana Tech | 814 |
| Montana-Western | 807 |
| Montclair State | 489 |
| Moravian | 448 |
| Morehead State | 265 |
| Morehouse College | 329 |
| Morgan State | 167 |
| Mount St. Joseph | 512 |
| Mount Union | 520 |
| Muhlenberg | 499 |
| Murray State | 194 |
| Muskingum | 680 |
| NC State | 121 |
| NC Wesleyan | 376 |
| Navy | 145 |
| Nebraska | 42 |
| Nebraska Wesleyan | 766 |
| Nebraska-Kearney | 535 |
| Nevada | 56 |
| New Hampshire | 261 |
| New Haven | 482 |
| New Mexico | 199 |
| New Mexico Highlands | 564 |
| New Mexico State | 55 |
| Newberry | 454 |
| Nicholls | 164 |
| Nichols | 393 |
| Norfolk State | 159 |
| North Alabama | 263 |
| North American University | 318 |
| North Carolina | 53 |
| North Carolina A&T | 248 |
| North Carolina Central | 302 |
| North Central | 527 |
| North Dakota | 157 |
| North Dakota State | 254 |
| North Greenville | 266 |
| North Park | 649 |
| North Texas | 58 |
| Northeastern State | 689 |
| Northern Arizona | 87 |
| Northern Colorado | 220 |
| Northern Illinois | 79 |
| Northern Iowa | 150 |
| Northern Michigan | 368 |
| Northern State | 666 |
| Northwest Missouri State | 586 |
| Northwestern | 41 |
| Northwestern (IA) | 728 |
| Northwestern (MN) | 769 |
| Northwestern Oklahoma State | 654 |
| Northwestern State | 251 |
| Northwood (MI) | 734 |
| Norwich | 572 |
| Notre Dame | 108 |
| Notre Dame College (OH) | 748 |
| Oberlin | 452 |
| Ohio | 168 |
| Ohio Dominican | 505 |
| Ohio Northern | 673 |
| Ohio State | 107 |
| Ohio Wesleyan | 700 |
| Oklahoma | 117 |
| Oklahoma Baptist | 655 |
| Oklahoma Panhandle State | 783 |
| Oklahoma State | 61 |
| Old Dominion | 96 |
| Ole Miss | 131 |
| Olivet College | 428 |
| Oregon | 110 |
| Oregon State | 203 |
| Otterbein | 551 |
| Ouachita Baptist | 641 |
| Pace University | 352 |
| Pacific (OR) | 695 |
| Pacific Lutheran | 697 |
| Penn State | 78 |
| Pennsylvania | 324 |
| Pittsburg State | 688 |
| Pittsburgh | 63 |
| Plymouth State | 762 |
| Point University | 722 |
| Pomona Pitzer | 793 |
| Portland State | 91 |
| Post University | 307 |
| Prairie View A&M | 295 |
| Presbyterian | 294 |
| Princeton | 323 |
| Puget Sound | 577 |
| Purdue | 77 |
| Quincy | 365 |
| Randolph-Macon | 751 |
| Redlands | 613 |
| Rensselaer | 618 |
| Rhode Island | 256 |
| Rhodes College | 711 |
| Richmond | 148 |
| Ripon | 436 |
| Robert Morris | 224 |
| Rockford | 740 |
| Roosevelt | 774 |
| Rose-Hulman | 362 |
| Rowan | 701 |
| Rutgers | 143 |
| SE Louisiana | 183 |
| SMU | 190 |
| SUNY Cortland | 403 |
| SUNY Maritime | 477 |
| SUNY Morrisville | 354 |
| Sacramento State | 258 |
| Sacred Heart | 280 |
| Saginaw Valley State | 735 |
| Saint Augustine's | 777 |
| Saint John's (MN) | 796 |
| Saint Vincent | 787 |
| Salisbury University | 412 |
| Salve Regina | 742 |
| Sam Houston | 813 |
| Samford | 210 |
| San Diego | 300 |
| San Diego State | 155 |
| San José State | 90 |
| Savannah State | 348 |
| Seton Hill | 385 |
| Sewanee Univ. of the South | 552 |
| Shaw | 604 |
| Shenandoah | 761 |
| Shepherd | 379 |
| Shippensburg | 469 |
| Shorter | 369 |
| Simpson College (IA) | 778 |
| Sioux Falls | 683 |
| Slippery Rock | 384 |
| South Alabama | 163 |
| South Carolina | 188 |
| South Carolina State | 72 |
| South Dakota | 175 |
| South Dakota Mines | 600 |
| South Dakota State | 139 |
| South Florida | 135 |
| Southeast Missouri State | 152 |
| Southeastern Oklahoma | 657 |
| Southeastern University | 779 |
| Southern | 232 |
| Southern Arkansas | 653 |
| Southern Connecticut State | 339 |
| Southern Illinois | 243 |
| Southern Miss | 178 |
| Southern Nazarene | 590 |
| Southern Oregon | 808 |
| Southern Utah | 212 |
| Southern Virginia | 491 |
| Southwest Baptist | 342 |
| Southwest Minnesota State | 596 |
| Southwestern Assemblies of God | 802 |
| Southwestern Oklahoma | 656 |
| Southwestern University | 645 |
| Springfield | 757 |
| St. Ambrose | 772 |
| St. Andrews | 333 |
| St. Anselm | 635 |
| St. Francis (PA) | 68 |
| St. John Fisher University | 758 |
| St. Lawrence | 353 |
| St. Norbert | 771 |
| St. Olaf | 799 |
| St. Scholastica | 555 |
| St. Thomas University (Fl) | 282 |
| St. Thomas-Minnesota | 815 |
| St. Xavier (IL) | 812 |
| Stanford | 191 |
| Stephen F. Austin | 231 |
| Stetson | 290 |
| Stevenson | 790 |
| Stonehill | 287 |
| Stony Brook | 246 |
| Sul Ross State | 789 |
| Susquehanna University | 447 |
| Syracuse | 197 |
| TCU | 105 |
| Tarleton State | 731 |
| Taylor | 311 |
| Temple | 100 |
| Tennessee | 69 |
| Tennessee State | 252 |
| Tennessee Tech | 102 |
| Texas | 195 |
| Texas A&M | 111 |
| Texas A&M-Commerce | 272 |
| Texas A&M-Kingsville | 692 |
| Texas Lutheran | 647 |
| Texas Southern | 233 |
| Texas State | 165 |
| Texas Tech | 193 |
| The Citadel | 260 |
| The College of New Jersey | 415 |
| Thiel | 788 |
| Thomas More College | 305 |
| Tiffin | 750 |
| Toledo | 75 |
| Towson | 244 |
| Trine University | 511 |
| Trinity (CT) | 806 |
| Trinity University (TX) | 646 |
| Troy | 132 |
| Truman State | 438 |
| Tufts University | 522 |
| Tulane | 180 |
| Tulsa | 160 |
| Tusculum | 638 |
| Tuskegee | 320 |
| UAB | 81 |
| UAlbany | 730 |
| UC Davis | 162 |
| UCF | 71 |
| UCLA | 153 |
| UConn | 46 |
| UFTL | 724 |
| UL Monroe | 196 |
| UMASS Dartmouth | 514 |
| UMass | 181 |
| UNC Pembroke | 736 |
| UNLV | 43 |
| USC | 122 |
| UT Martin | 247 |
| UT Permian Basin | 784 |
| UTEP | 57 |
| UTSA | 133 |
| UVA Wise | 314 |
| Union (NY) | 754 |
| Union College | 781 |
| University of Mary | 595 |
| University of New England | 360 |
| University of Rochester (NY) | 752 |
| Upper Iowa | 665 |
| Ursinus | 744 |
| Utah | 114 |
| Utah State | 45 |
| Utah Tech | 264 |
| Utica College | 473 |
| VMI | 66 |
| Valdosta State | 663 |
| Valley City State | 746 |
| Valparaiso | 298 |
| Vanderbilt | 60 |
| Villanova | 242 |
| Virginia | 147 |
| Virginia Lynchburg | 306 |
| Virginia State | 620 |
| Virginia Tech | 97 |
| Virginia Union | 346 |
| WPI | 743 |
| Wabash College | 549 |
| Wagner | 219 |
| Wake Forest | 65 |
| Walsh | 364 |
| Warner | 336 |
| Wartburg College | 421 |
| Washburn | 534 |
| Washington | 205 |
| Washington & Jefferson | 677 |
| Washington State | 201 |
| Washington University (St. Louis) | 810 |
| Washington and Lee | 811 |
| Wayland Baptist | 804 |
| Wayne State (MI) | 630 |
| Wayne State (NE) | 559 |
| Waynesburg | 791 |
| Webber International | 729 |
| Weber State | 227 |
| Wesleyan University (CT) | 805 |
| West Alabama | 592 |
| West Chester | 388 |
| West Florida | 720 |
| West Georgia | 716 |
| West Liberty | 373 |
| West Texas A&M | 691 |
| West Virginia | 64 |
| West Virginia State | 486 |
| West Virginia Wesleyan | 536 |
| Western Carolina | 226 |
| Western Colorado | 617 |
| Western Connecticut State | 351 |
| Western Illinois | 215 |
| Western Kentucky | 39 |
| Western Michigan | 93 |
| Western New England | 472 |
| Western New Mexico | 337 |
| Western Oregon | 274 |
| Westfield State | 350 |
| Westminster (MO) | 773 |
| Westminster (PA) | 764 |
| Wheaton | 794 |
| Wheeling | 785 |
| Whitworth | 614 |
| Widener University | 407 |
| Wilkes University | 406 |
| Willamette | 400 |
| William & Mary | 98 |
| William Jewell College | 343 |
| William Paterson | 496 |
| Williams | 809 |
| Wilmington (OH) | 792 |
| Wingate | 639 |
| Winona State | 594 |
| Winston-Salem | 310 |
| Wisconsin | 125 |
| Wisconsin Lutheran | 670 |
| Wisconsin-Eau Claire | 703 |
| Wisconsin-La Crosse | 631 |
| Wisconsin-Oshkosh | 585 |
| Wisconsin-Platteville | 544 |
| Wisconsin-River Falls | 678 |
| Wisconsin-Stevens Point | 668 |
| Wisconsin-Stout | 557 |
| Wisconsin-Whitewater | 468 |
| Wittenberg | 765 |
| Wofford | 240 |
| Wooster | 548 |
| Worcester State College | 398 |
| Wyoming | 48 |
| Yale | 328 |
| Youngstown State | 238 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Ncaa College Football Live Game Scores1 Country Flag | img | scalar | `{account.store.NcaaCollegeFootballLiveGameScores1_country_flag}` | — |
| Ncaa College Football Live Game Scores1 Feed Last Run Had Errors | text | boolean | `{account.store.NcaaCollegeFootballLiveGameScores1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Ncaa College Football Live Game Scores1 Feed Last Run Was Success | text | boolean | `{account.store.NcaaCollegeFootballLiveGameScores1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Ncaa College Football Live Game Scores1 Feed Last Succesful Run At | text | datetime | `{account.store.NcaaCollegeFootballLiveGameScores1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Ncaa College Football Live Game Scores1 League Logo | img | scalar | `{account.store.NcaaCollegeFootballLiveGameScores1_league_logo}` | — |
| Ncaa College Football Live Game Scores1 Teams Away Logo | img | scalar | `{account.store.NcaaCollegeFootballLiveGameScores1_teams_away_logo}` | — |
| Ncaa College Football Live Game Scores1 Teams Home Logo | img | scalar | `{account.store.NcaaCollegeFootballLiveGameScores1_teams_home_logo}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:00 UTC*
