---
title: "NCAA Womens Volleyball Scores - Lucit Application Reference"
description: "Add NCAA Women's volleyball game scores to your digital out-of-home creatives This app will pull in todays games for all teams or, for teams that you specify"
keywords: "lucit application, NCAA Womens Volleyball Scores, app reference, integration"
---

# NCAA Womens Volleyball Scores

Add NCAA Women's volleyball game scores to your digital out-of-home creatives This app will pull in todays games for all teams or, for teams that you specify

**Application Details:**

- **Name:** NCAA Womens Volleyball Scores
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-51b60831-862c-4251-8297-b700ad3862f8`

---

## View in Lucit

**[🔗 View NCAA Womens Volleyball Scores in Lucit](https://lucit.app/NcaaWomensVolleyballScores){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add NCAA Womens Volleyball Scores to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "NCAA Womens Volleyball Scores"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The NCAA Womens Volleyball Scores application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using NCAA Womens Volleyball Scores Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### NCAA Womens Volleyball Scores

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with NCAA Womens Volleyball Scores dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for NCAA Womens Volleyball Scores**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on NCAA Womens Volleyball Scores to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on NCAA Womens Volleyball Scores to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Game Date** | `text` | Enter a game date in YYYY/MM/DD format, or leave blank to get todays games | — |
| **Choose Teams** | `int` [(multiple select)](#choose-teams-options) | Please select one or more team | Required |

**Enum Options:**

<a id="choose-teams-options"></a>

*Choose Teams:*

| Label | Value |
|-------|------|
| A&M-Corpus Christi | am-corpus-chris |
| Abilene Christian | abilene-christian |
| Air Force | air-force |
| Akron | akron |
| Alabama A&M | alabama-am |
| Alabama St. | alabama-st |
| Alcorn | alcorn |
| American | american |
| Arizona | arizona |
| Arizona St. | arizona-st |
| Ark.-Pine Bluff | ark-pine-bluff |
| Arkansas St. | arkansas-st |
| Army West Point | army |
| Auburn | auburn |
| Austin Peay | austin-peay |
| BYU | byu |
| Ball St. | ball-st |
| Baylor | baylor |
| Bellarmine | bellarmine |
| Belmont | belmont |
| Bethune-Cookman | bethune-cookman |
| Binghamton | binghamton |
| Boise St. | boise-st |
| Boston College | boston-college |
| Bowling Green | bowling-green |
| Bradley | bradley |
| Brown | brown |
| Bucknell | bucknell |
| Buffalo | buffalo |
| Butler | butler |
| CSU Bakersfield | bakersfield |
| CSUN | cal-st-northridge |
| Cal Poly | cal-poly |
| Cal St. Fullerton | cal-st-fullerton |
| California | california |
| California Baptist | california-baptist |
| Campbell | campbell |
| Canisius | canisius |
| Central Ark. | central-ark |
| Central Conn. St. | central-conn-st |
| Central Mich. | central-mich |
| Charleston So. | charleston-so |
| Charlotte | charlotte |
| Chattanooga | chattanooga |
| Chicago St. | chicago-st |
| Cincinnati | cincinnati |
| Clemson | clemson |
| Cleveland St. | cleveland-st |
| Coastal Carolina | coastal-caro |
| Col. of Charleston | col-of-charleston |
| Colgate | colgate |
| Colorado | colorado |
| Colorado St. | colorado-st |
| Columbia | columbia |
| Coppin St. | coppin-st |
| Cornell | cornell |
| Creighton | creighton |
| Dartmouth | dartmouth |
| Davidson | davidson |
| Dayton | dayton |
| DePaul | depaul |
| Delaware | delaware |
| Delaware St. | delaware-st |
| Denver | denver |
| Drake | drake |
| Duke | duke |
| Duquesne | duquesne |
| ETSU | east-tenn-st |
| East Carolina | east-carolina |
| Eastern Ill. | eastern-ill |
| Eastern Ky. | eastern-ky |
| Eastern Mich. | eastern-mich |
| Eastern Wash. | eastern-wash |
| Elon | elon |
| Evansville | evansville |
| FDU | fairleigh-dickinson |
| FGCU | fgcu |
| FIU | fiu |
| Fairfield | fairfield |
| Fla. Atlantic | fla-atlantic |
| Florida A&M | florida-am |
| Florida St. | florida-st |
| Fordham | fordham |
| Fresno St. | fresno-st |
| Furman | furman |
| Ga. Southern | ga-southern |
| Gardner-Webb | gardner-webb |
| George Mason | george-mason |
| George Washington | george-washington |
| Georgetown | georgetown |
| Georgia | georgia |
| Georgia St. | georgia-st |
| Georgia Tech | georgia-tech |
| Gonzaga | gonzaga |
| Grambling | grambling |
| Grand Canyon | grand-canyon |
| Green Bay | green-bay |
| Hampton | hampton |
| Harvard | harvard |
| Hawaii | hawaii |
| High Point | high-point |
| Hofstra | hofstra |
| Holy Cross | holy-cross |
| Houston | houston |
| Houston Christian | houston-baptist |
| Howard | howard |
| IU Indy | iu-indy |
| Idaho | idaho |
| Idaho St. | idaho-st |
| Illinois | illinois |
| Illinois St. | illinois-st |
| Indiana | indiana |
| Indiana St. | indiana-st |
| Iona | iona |
| Iowa | iowa |
| Iowa St. | iowa-st |
| Jacksonville | jacksonville |
| Jacksonville St. | jacksonville-st |
| James Madison | james-madison |
| Kansas | kansas |
| Kansas City | umkc |
| Kansas St. | kansas-st |
| Kennesaw St. | kennesaw-st |
| Kent St. | kent-st |
| Kentucky | kentucky |
| LIU | long-island |
| LMU (CA) | loyola-marymount |
| LSU | lsu |
| Lafayette | lafayette |
| Lamar University | lamar |
| Le Moyne | le-moyne |
| Lehigh | lehigh |
| Liberty | liberty |
| Lindenwood | lindenwood-mo |
| Lipscomb | lipscomb |
| Little Rock | ualr |
| Long Beach St. | long-beach-st |
| Louisiana Tech | louisiana-tech |
| Louisville | louisville |
| Loyola Chicago | loyola-chicago |
| Loyola Maryland | loyola-maryland |
| Manhattan | manhattan |
| Marist | marist |
| Marquette | marquette |
| Marshall | marshall |
| Maryland | maryland |
| McNeese | mcneese |
| Memphis | memphis |
| Mercer | mercer |
| Mercyhurst | mercyhurst |
| Merrimack | merrimack |
| Miami (FL) | miami-fl |
| Miami (OH) | miami-oh |
| Michigan | michigan |
| Michigan St. | michigan-st |
| Middle Tenn. | middle-tenn |
| Milwaukee | milwaukee |
| Minnesota | minnesota |
| Mississippi St. | mississippi-st |
| Missouri St. | missouri-st |
| Montana | montana |
| Montana St. | montana-st |
| Morehead St. | morehead-st |
| Morgan St. | morgan-st |
| Murray St. | murray-st |
| N.C. A&T | nc-at |
| N.C. Central | nc-central |
| NC State | north-carolina-st |
| NIU | northern-ill |
| NJIT | njit |
| Navy | navy |
| Nebraska | nebraska |
| Nevada | nevada |
| New Mexico | new-mexico |
| New Mexico St. | new-mexico-st |
| New Orleans | new-orleans |
| Niagara | niagara |
| Nicholls | nicholls-st |
| Norfolk St. | norfolk-st |
| North Ala. | north-ala |
| North Carolina | north-carolina |
| North Dakota | north-dakota |
| North Dakota St. | north-dakota-st |
| North Florida | north-florida |
| North Texas | north-texas |
| Northeastern | northeastern |
| Northern Ariz. | northern-ariz |
| Northern Colo. | northern-colo |
| Northern Ky. | northern-ky |
| Northwestern | northwestern |
| Northwestern St. | northwestern-st |
| Notre Dame | notre-dame |
| Oakland | oakland |
| Ohio | ohio |
| Ohio St. | ohio-st |
| Oklahoma | oklahoma |
| Old Dominion | old-dominion |
| Ole Miss | ole-miss |
| Omaha | neb-omaha |
| Oral Roberts | oral-roberts |
| Oregon | oregon |
| Oregon St. | oregon-st |
| Pacific | pacific |
| Penn | penn |
| Penn St. | penn-st |
| Pepperdine | pepperdine |
| Pittsburgh | pittsburgh |
| Portland | portland |
| Portland St. | portland-st |
| Prairie View | prairie-view |
| Presbyterian | presbyterian |
| Princeton | princeton |
| Providence | providence |
| Purdue | purdue |
| Purdue Fort Wayne | ipfw |
| Queens (NC) | queens-nc |
| Quinnipiac | quinnipiac |
| Radford | radford |
| Rhode Island | rhode-island |
| Rice | rice |
| Rider | rider |
| Robert Morris | robert-morris |
| Rutgers | rutgers |
| SFA | stephen-f-austin |
| SIUE | siu-edwardsville |
| SMU | smu |
| Sacramento St. | sacramento-st |
| Sacred Heart | sacred-heart |
| Saint Francis  | st-francis-pa |
| Saint Louis | saint-louis |
| Saint Mary's (CA) | st-marys-ca |
| Saint Peter's | st-peters |
| Sam Houston | sam-houston-st |
| Samford | samford |
| San Diego | san-diego |
| San Diego St. | san-diego-st |
| San Francisco | san-francisco |
| San Jose St. | san-jose-st |
| Santa Clara | santa-clara |
| Seattle U | seattle |
| Seton Hall | seton-hall |
| Siena | siena |
| South Alabama | south-ala |
| South Carolina | south-carolina |
| South Carolina St. | south-carolina-st |
| South Dakota | south-dakota |
| South Dakota St. | south-dakota-st |
| South Fla. | south-fla |
| Southeast Mo. St. | southeast-mo-st |
| Southeastern La. | southeastern-la |
| Southern California | southern-california |
| Southern Ill. | southern-ill |
| Southern Ind. | southern-ind |
| Southern Miss. | southern-miss |
| Southern Utah | southern-utah |
| St. John's (NY) | st-johns-ny |
| St. Thomas (MN) | st-thomas-mn |
| Stanford | stanford |
| Stetson | stetson |
| Stonehill | stonehill |
| Stony Brook | stony-brook |
| Syracuse | syracuse |
| TCU | tcu |
| Tarleton St. | tarleton-st |
| Temple | temple |
| Tennessee | tennessee |
| Tennessee St. | tennessee-st |
| Tennessee Tech | tennessee-tech |
| Tex. A&M-Commerce | tex-am-commerce |
| Texas | texas |
| Texas St. | texas-st |
| Texas Tech | texas-tech |
| The Citadel | citadel |
| Toledo | toledo |
| Towson | towson |
| Troy | troy |
| Tulane | tulane |
| Tulsa | tulsa |
| UAB | uab |
| UAlbany | albany-ny |
| UC Davis | uc-davis |
| UC Irvine | uc-irvine |
| UC Riverside | uc-riverside |
| UC San Diego | uc-san-diego |
| UC Santa Barbara | uc-santa-barbara |
| UCF | ucf |
| UCLA | ucla |
| UConn | uconn |
| UIC | ill-chicago |
| UIW | uiw |
| ULM | la-monroe |
| UMBC | umbc |
| UMES | md-east-shore |
| UNC Asheville | unc-asheville |
| UNC Greensboro | unc-greensboro |
| UNCW | unc-wilmington |
| UNI | uni |
| UNLV | unlv |
| USC Upstate | usc-upstate |
| UT Arlington | texas-arlington |
| UT Martin | ut-martin |
| UTEP | utep |
| UTRGV | utrgv |
| UTSA | utsa |
| Utah | utah |
| Utah St. | utah-st |
| Utah Tech | utah-tech |
| Utah Valley | utah-valley |
| VCU | vcu |
| Valparaiso | valparaiso |
| Villanova | villanova |
| Virginia | virginia |
| Virginia Tech | virginia-tech |
| Wake Forest | wake-forest |
| Washington | washington |
| Washington St. | washington-st |
| Weber St. | weber-st |
| West Ga. | west-ga |
| West Virginia | west-virginia |
| Western Caro. | western-caro |
| Western Ill. | western-ill |
| Western Ky. | western-ky |
| Western Mich. | western-mich |
| Wichita St. | wichita-st |
| William & Mary | william-mary |
| Winthrop | winthrop |
| Wisconsin | wisconsin |
| Wofford | wofford |
| Wright St. | wright-st |
| Wyoming | wyoming |
| Xavier | xavier |
| Yale | yale |
| Youngstown St. | youngstown-st |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Ncaa Womens Volleyball Scores1 Feed Last Run Had Errors | text | boolean | `{account.store.NcaaWomensVolleyballScores1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Ncaa Womens Volleyball Scores1 Feed Last Run Was Success | text | boolean | `{account.store.NcaaWomensVolleyballScores1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Ncaa Womens Volleyball Scores1 Feed Last Succesful Run At | text | datetime | `{account.store.NcaaWomensVolleyballScores1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Game Away Conferences Conference Name | text | scalar | `{item.inventory_attributes.game_away_conferences_conferenceName}` | — |
| Game Away Conferences Conference Seo | text | scalar | `{item.inventory_attributes.game_away_conferences_conferenceSeo}` | — |
| Game Away Description | text | scalar | `{item.inventory_attributes.game_away_description}` | — |
| Game Away Names Char6 | text | scalar | `{item.inventory_attributes.game_away_names_char6}` | — |
| Game Away Names Full | text | scalar | `{item.inventory_attributes.game_away_names_full}` | — |
| Game Away Names Seo | text | scalar | `{item.inventory_attributes.game_away_names_seo}` | — |
| Game Away Names Short | text | scalar | `{item.inventory_attributes.game_away_names_short}` | — |
| Game Away Rank | text | scalar | `{item.inventory_attributes.game_away_rank}` | — |
| Game Away Score | text | scalar | `{item.inventory_attributes.game_away_score}` | — |
| Game Away Seed | text | scalar | `{item.inventory_attributes.game_away_seed}` | — |
| Game Away Winner | text | scalar | `{item.inventory_attributes.game_away_winner}` | — |
| Game Bracket Id | text | scalar | `{item.inventory_attributes.game_bracketId}` | — |
| Game Bracket Region | text | scalar | `{item.inventory_attributes.game_bracketRegion}` | — |
| Game Bracket Round | text | scalar | `{item.inventory_attributes.game_bracketRound}` | — |
| Game Contest Clock | text | scalar | `{item.inventory_attributes.game_contestClock}` | — |
| Game Contest Name | text | scalar | `{item.inventory_attributes.game_contestName}` | — |
| Game Current Period | text | scalar | `{item.inventory_attributes.game_currentPeriod}` | — |
| Game Final Message | text | scalar | `{item.inventory_attributes.game_finalMessage}` | — |
| Game Game I D | text | scalar | `{item.inventory_attributes.game_gameID}` | — |
| Game Game State | text | scalar | `{item.inventory_attributes.game_gameState}` | — |
| Game Home Description | text | scalar | `{item.inventory_attributes.game_home_description}` | — |
| Game Home Names Char6 | text | scalar | `{item.inventory_attributes.game_home_names_char6}` | — |
| Game Home Names Full | text | scalar | `{item.inventory_attributes.game_home_names_full}` | — |
| Game Home Names Seo | text | scalar | `{item.inventory_attributes.game_home_names_seo}` | — |
| Game Home Names Short | text | scalar | `{item.inventory_attributes.game_home_names_short}` | — |
| Game Home Rank | text | scalar | `{item.inventory_attributes.game_home_rank}` | — |
| Game Home Score | text | scalar | `{item.inventory_attributes.game_home_score}` | — |
| Game Home Seed | text | scalar | `{item.inventory_attributes.game_home_seed}` | — |
| Game Home Winner | text | scalar | `{item.inventory_attributes.game_home_winner}` | — |
| Game Live Video Enabled | text | scalar | `{item.inventory_attributes.game_liveVideoEnabled}` | — |
| Game Network | text | scalar | `{item.inventory_attributes.game_network}` | — |
| Game Start Date | text | scalar | `{item.inventory_attributes.game_startDate}` | — |
| Game Start Time | text | scalar | `{item.inventory_attributes.game_startTime}` | — |
| Game Start Time Epoch | text | scalar | `{item.inventory_attributes.game_startTimeEpoch}` | — |
| Game Start Time Local | text | scalar | `{item.inventory_attributes.game_start_time_local}` | — |
| Game Title | text | scalar | `{item.inventory_attributes.game_title}` | — |
| Game Url | text | scalar | `{item.inventory_attributes.game_url}` | — |
| Game Video State | text | scalar | `{item.inventory_attributes.game_videoState}` | — |
| Ingame | text | scalar | `{item.inventory_attributes.ingame}` | — |
| Postgame | text | scalar | `{item.inventory_attributes.postgame}` | — |
| Pregame | text | scalar | `{item.inventory_attributes.pregame}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:13 UTC*
