---
title: "Nearest Location using Google Sheets - Lucit Application Reference"
description: "Use a list of POI (Point Of Interest) locations stored in a Google Sheets Spreadsheet and automatically show information about the nearest location to any screen in your campaign...."
keywords: "lucit application, Nearest Location using Google Sheets, app reference, integration"
---

# Nearest Location using Google Sheets

Use a list of POI (Point Of Interest) locations stored in a Google Sheets Spreadsheet and automatically show information about the nearest location to any screen in your campaign....

**Application Details:**

- **Name:** Nearest Location using Google Sheets
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-c0e673e2-5e97-41a8-a44d-39aa3854a628`

---

## View in Lucit

**[🔗 View Nearest Location using Google Sheets in Lucit](https://lucit.app/NearestLocationDataViaGoogleSheets){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Nearest Location using Google Sheets to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Nearest Location using Google Sheets"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Nearest Location using Google Sheets application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Nearest Location using Google Sheets Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Nearest Location - Google Sheets

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Nearest Location - Google Sheets dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Nearest Location - Google Sheets**

To add values from Nearest Location - Google Sheets to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Nearest Location - Google Sheets `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Nearest Location - Google Sheets or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Nearest Location - Google Sheets data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Nearest Location - Google Sheets:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Google Sheet Url** | `text` | Copy and paste the url to your google spreadheet | Required |
| **Add Driving Direction Next Step** | `int` [(enum)](#add-driving-direction-next-step-options) | Enable if you wish to add the next exit or turn from the sign to the POI | — |
| **Map Box API Key for Directions Data** | `text` | Required if getting directions data | — |

**Enum Options:**

<a id="add-driving-direction-next-step-options"></a>

*Add Driving Direction Next Step:*

| Label | Value |
|-------|------|
| No | 0 |
| Yes | 1 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Nearest Location Google Sheets Feed Last Run Had Errors | text | boolean | `{account.store.NearestLocationGoogleSheets_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Nearest Location Google Sheets Feed Last Run Was Success | text | boolean | `{account.store.NearestLocationGoogleSheets_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Nearest Location Google Sheets Feed Last Succesful Run At | text | datetime | `{account.store.NearestLocationGoogleSheets_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Nearest Location Google Sheets Nearest Poi Address | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_address}` | — |
| Nearest Location Google Sheets Nearest Poi Bearing | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_bearing}` | — |
| Nearest Location Google Sheets Nearest Poi Bearing Cardinal | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_bearing_cardinal}` | — |
| Nearest Location Google Sheets Nearest Poi Board Id | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_board_id}` | — |
| Nearest Location Google Sheets Nearest Poi City | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_city}` | — |
| Nearest Location Google Sheets Nearest Poi Country | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_country}` | — |
| Nearest Location Google Sheets Nearest Poi Distance Feet | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_distance_feet}` | — |
| Nearest Location Google Sheets Nearest Poi Distance Kilometers | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_distance_kilometers}` | — |
| Nearest Location Google Sheets Nearest Poi Distance Meters | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_distance_meters}` | — |
| Nearest Location Google Sheets Nearest Poi Distance Miles | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_distance_miles}` | — |
| Nearest Location Google Sheets Nearest Poi Human Readable Distance | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_human_readable_distance}` | — |
| Nearest Location Google Sheets Nearest Poi Human Readable Distance Metric | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_human_readable_distance_metric}` | — |
| Nearest Location Google Sheets Nearest Poi Human Readable Distance Metric Short | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_human_readable_distance_metric_short}` | — |
| Nearest Location Google Sheets Nearest Poi Human Readable Distance Metric Shorter | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_human_readable_distance_metric_shorter}` | — |
| Nearest Location Google Sheets Nearest Poi Human Readable Distance Short | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_human_readable_distance_short}` | — |
| Nearest Location Google Sheets Nearest Poi Human Readable Distance Shorter | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_human_readable_distance_shorter}` | — |
| Nearest Location Google Sheets Nearest Poi Latitude | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_latitude}` | — |
| Nearest Location Google Sheets Nearest Poi Longitude | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_longitude}` | — |
| Nearest Location Google Sheets Nearest Poi Name | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_name}` | — |
| Nearest Location Google Sheets Nearest Poi Non Branded Location Name | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_non_branded_location_name}` | — |
| Nearest Location Google Sheets Nearest Poi Phone | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_phone}` | — |
| Nearest Location Google Sheets Nearest Poi State | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_state}` | — |
| Nearest Location Google Sheets Nearest Poi Unique Id | text | scalar | `{account.store.NearestLocationGoogleSheets_nearest_poi_unique_id}` | — |
| Nearest Location Google Sheets Nearest Poi Viewer Bearing | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_viewer_bearing}` | — |
| Nearest Location Google Sheets Nearest Poi Viewer Bearing Cardinal | text | float | `{account.store.NearestLocationGoogleSheets_nearest_poi_viewer_bearing_cardinal}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:23 UTC*
