---
title: "NFL Live Game Scores - Lucit Application Reference"
description: "Add LIVE NFL Football scores on game-day to your digital billboard and digital signage creatives with the National Football League Sports Game Scores app This app provides key..."
keywords: "lucit application, NFL Live Game Scores, app reference, integration"
---

# NFL Live Game Scores

Add LIVE NFL Football scores on game-day to your digital billboard and digital signage creatives with the National Football League Sports Game Scores app This app provides key...

**Application Details:**

- **Name:** NFL Live Game Scores
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-4c1375ca-dcfb-4ce9-9cc0-cf8abcbff8f4`

---

## View in Lucit

**[🔗 View NFL Live Game Scores in Lucit](https://lucit.app/NflLiveGameScores){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add NFL Live Game Scores to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "NFL Live Game Scores"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The NFL Live Game Scores application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **2 data source provider(s)**.

### Prerequisites to Using NFL Live Game Scores Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### NFL Live Game Scores (All Games)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with NFL Live Game Scores (All Games) dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for NFL Live Game Scores (All Games)**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on NFL Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on NFL Live Game Scores (All Games) to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Season** | `text` | Enter a season, or leave empty to use current season | — |
| **Game Date** | `text` | Enter a game date in YYY-MM-DD format, or leave blank to get todays games | — |
| **Include games in pre-game status** | `bool` | Enable this option to include games before they have started.  Useful to show game-time creatives | — |
| **Choose Team(s)** | `int` [(multiple select)](#choose-team(s)-options) | Please select one or more teams or leave blank to get all teams | — |
| **Seconds after game start to ignore games with no data** | `int` | If it is this many seconds past the scheduled game start time, and we have no changes in status or score, then, ignore this game | — |
| **Ignore games with no changes for this many seconds** | `int` | If this many seconds have elapsed, and NO game state or score changes have occurred, then ignore this game | — |
| **Keep using yesterdays games, this many seconds after midnight** | `int` | You can consider this many seconds after midnight as the previous day in order to make games keep appearing after midnight | — |

**Enum Options:**

<a id="choose-team(s)-options"></a>

*Choose Team(s):*

| Label | Value |
|-------|------|
| Arizona Cardinals | 11 |
| Atlanta Falcons | 8 |
| Baltimore Ravens | 5 |
| Buffalo Bills | 20 |
| Carolina Panthers | 19 |
| Chicago Bears | 16 |
| Cincinnati Bengals | 10 |
| Cleveland Browns | 9 |
| Dallas Cowboys | 29 |
| Denver Broncos | 28 |
| Detroit Lions | 7 |
| Green Bay Packers | 15 |
| Houston Texans | 26 |
| Indianapolis Colts | 21 |
| Jacksonville Jaguars | 2 |
| Kansas City Chiefs | 17 |
| Las Vegas Raiders | 1 |
| Los Angeles Chargers | 30 |
| Los Angeles Rams | 31 |
| Miami Dolphins | 25 |
| Minnesota Vikings | 32 |
| New England Patriots | 3 |
| New Orleans Saints | 27 |
| New York Giants | 4 |
| New York Jets | 13 |
| Philadelphia Eagles | 12 |
| Pittsburgh Steelers | 22 |
| San Francisco 49ers | 14 |
| Seattle Seahawks | 23 |
| Tampa Bay Buccaneers | 24 |
| Tennessee Titans | 6 |
| Washington Commanders | 18 |
| AFC (Pro Bowl) | 34 |
| NFC (Pro Bowl) | 33 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Nfl Live Game Scores All Games Feed Last Run Had Errors | text | boolean | `{account.store.NflLiveGameScoresAllGames_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Nfl Live Game Scores All Games Feed Last Run Was Success | text | boolean | `{account.store.NflLiveGameScoresAllGames_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Nfl Live Game Scores All Games Feed Last Succesful Run At | text | datetime | `{account.store.NflLiveGameScoresAllGames_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Game Date Date | text | scalar | `{item.inventory_attributes.game_date_date}` | — |
| Game Date Time | text | scalar | `{item.inventory_attributes.game_date_time}` | — |
| Game Date Timestamp | text | scalar | `{item.inventory_attributes.game_date_timestamp}` | — |
| Game Stage | text | scalar | `{item.inventory_attributes.game_stage}` | — |
| Game Status Long | text | scalar | `{item.inventory_attributes.game_status_long}` | — |
| Game Status Short | text | scalar | `{item.inventory_attributes.game_status_short}` | — |
| Game Status Timer | text | scalar | `{item.inventory_attributes.game_status_timer}` | — |
| Game Venue City | text | scalar | `{item.inventory_attributes.game_venue_city}` | — |
| Game Venue Name | text | scalar | `{item.inventory_attributes.game_venue_name}` | — |
| Game Week | text | scalar | `{item.inventory_attributes.game_week}` | — |
| Ingame | text | scalar | `{item.inventory_attributes.ingame}` | — |
| Postgame | text | scalar | `{item.inventory_attributes.postgame}` | — |
| Pregame | text | scalar | `{item.inventory_attributes.pregame}` | — |
| Scores Away Overtime | text | scalar | `{item.inventory_attributes.scores_away_overtime}` | — |
| Scores Away Quarter 1 | text | scalar | `{item.inventory_attributes.scores_away_quarter_1}` | — |
| Scores Away Quarter 2 | text | scalar | `{item.inventory_attributes.scores_away_quarter_2}` | — |
| Scores Away Quarter 3 | text | scalar | `{item.inventory_attributes.scores_away_quarter_3}` | — |
| Scores Away Quarter 4 | text | scalar | `{item.inventory_attributes.scores_away_quarter_4}` | — |
| Scores Away Total | text | scalar | `{item.inventory_attributes.scores_away_total}` | — |
| Scores Home Overtime | text | scalar | `{item.inventory_attributes.scores_home_overtime}` | — |
| Scores Home Quarter 1 | text | scalar | `{item.inventory_attributes.scores_home_quarter_1}` | — |
| Scores Home Quarter 2 | text | scalar | `{item.inventory_attributes.scores_home_quarter_2}` | — |
| Scores Home Quarter 3 | text | scalar | `{item.inventory_attributes.scores_home_quarter_3}` | — |
| Scores Home Quarter 4 | text | scalar | `{item.inventory_attributes.scores_home_quarter_4}` | — |
| Scores Home Total | text | scalar | `{item.inventory_attributes.scores_home_total}` | — |
| Teams Away Id | text | scalar | `{item.inventory_attributes.teams_away_id}` | — |
| Teams Away Name | text | scalar | `{item.inventory_attributes.teams_away_name}` | — |
| Teams Home Id | text | scalar | `{item.inventory_attributes.teams_home_id}` | — |
| Teams Home Name | text | scalar | `{item.inventory_attributes.teams_home_name}` | — |



---

### NFL Live Game Scores (Single Team)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with NFL Live Game Scores (Single Team) dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with NFL Live Game Scores (Single Team)**

To add values from NFL Live Game Scores (Single Team) to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from NFL Live Game Scores (Single Team) `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled NFL Live Game Scores (Single Team) or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using NFL Live Game Scores (Single Team) data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from NFL Live Game Scores (Single Team):

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Choose Team** | `int` [(enum)](#choose-team-options) | Please select a team | Required |

**Enum Options:**

<a id="choose-team-options"></a>

*Choose Team:*

| Label | Value |
|-------|------|
| Arizona Cardinals | 11 |
| Atlanta Falcons | 8 |
| Baltimore Ravens | 5 |
| Buffalo Bills | 20 |
| Carolina Panthers | 19 |
| Chicago Bears | 16 |
| Cincinnati Bengals | 10 |
| Cleveland Browns | 9 |
| Dallas Cowboys | 29 |
| Denver Broncos | 28 |
| Detroit Lions | 7 |
| Green Bay Packers | 15 |
| Houston Texans | 26 |
| Indianapolis Colts | 21 |
| Jacksonville Jaguars | 2 |
| Kansas City Chiefs | 17 |
| Las Vegas Raiders | 1 |
| Los Angeles Chargers | 30 |
| Los Angeles Rams | 31 |
| Miami Dolphins | 25 |
| Minnesota Vikings | 32 |
| New England Patriots | 3 |
| New Orleans Saints | 27 |
| New York Giants | 4 |
| New York Jets | 13 |
| Philadelphia Eagles | 12 |
| Pittsburgh Steelers | 22 |
| San Francisco 49ers | 14 |
| Seattle Seahawks | 23 |
| Tampa Bay Buccaneers | 24 |
| Tennessee Titans | 6 |
| Washington Commanders | 18 |
| AFC (Pro Bowl) | 34 |
| NFC (Pro Bowl) | 33 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Nfl Live Game Scores1 Country Flag | img | scalar | `{account.store.NflLiveGameScores1_country_flag}` | — |
| Nfl Live Game Scores1 Feed Last Run Had Errors | text | boolean | `{account.store.NflLiveGameScores1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Nfl Live Game Scores1 Feed Last Run Was Success | text | boolean | `{account.store.NflLiveGameScores1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Nfl Live Game Scores1 Feed Last Succesful Run At | text | datetime | `{account.store.NflLiveGameScores1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Nfl Live Game Scores1 League Logo | img | scalar | `{account.store.NflLiveGameScores1_league_logo}` | — |
| Nfl Live Game Scores1 Teams Away Logo | img | scalar | `{account.store.NflLiveGameScores1_teams_away_logo}` | — |
| Nfl Live Game Scores1 Teams Home Logo | img | scalar | `{account.store.NflLiveGameScores1_teams_home_logo}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:58 UTC*
