---
title: "Northwoods League Baseball - Lucit Application Reference"
description: "Live NWL Scores on your digital billboards! This application will fetch live game scores from the Northwoods League summer college baseball league. This feed includes live in-game..."
keywords: "lucit application, Northwoods League Baseball, app reference, integration"
---

# Northwoods League Baseball

Live NWL Scores on your digital billboards! This application will fetch live game scores from the Northwoods League summer college baseball league. This feed includes live in-game...

**Application Details:**

- **Name:** Northwoods League Baseball
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-5dcd4542-6a18-407f-9e9f-5b439d85cb14`

---

## View in Lucit

**[🔗 View Northwoods League Baseball in Lucit](https://lucit.app/NorthwoodsLeagueBaseball){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Northwoods League Baseball to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Northwoods League Baseball"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Northwoods League Baseball application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Northwoods League Baseball Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Northwoods League Baseball

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Northwoods League Baseball dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Northwoods League Baseball**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Northwoods League Baseball to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Northwoods League Baseball to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Game Date** | `text` | Enter a game date in YYYY-MM-DD format, or leave blank to get todays games | — |
| **Include games in pre-game status** | `bool` | Enable this option to include games before they have started.  Useful to show game-time creatives | — |
| **Choose Teams** | `int` [(multiple select)](#choose-teams-options) | Please select one or more teams | — |

**Enum Options:**

<a id="choose-teams-options"></a>

*Choose Teams:*

| Label | Value |
|-------|------|
| Badlands Big Sticks | 99 |
| Battle Creek Battle Jacks | 60 |
| Bismarck Larks | 50 |
| Duluth Huskies | 51 |
| Eau Claire Express | 52 |
| Fond du Lac Dock Spiders | 70 |
| Green Bay Rockers | 61 |
| Kalamazoo Growlers | 62 |
| Kenosha Kingfish | 63 |
| La Crosse Loggers | 53 |
| Lakeshore Chinooks | 64 |
| Madison Mallards | 65 |
| Mankato MoonDogs | 54 |
| Minot Hot Tots | 90 |
| Rockford Rivets | 66 |
| Rochester Honkers | 55 |
| Royal Oak Leprechauns | 100 |
| St. Cloud Rox | 56 |
| Thunder Bay Border Cats | 57 |
| Traverse City Pit Spitters | 74 |
| Waterloo Bucks | 58 |
| Wausau Woodchucks | 68 |
| Willmar Stingers | 59 |
| Wisconsin Rapids Rafters | 67 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Northwoods League Baseball1 Feed Last Run Had Errors | text | boolean | `{account.store.NorthwoodsLeagueBaseball1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Northwoods League Baseball1 Feed Last Run Was Success | text | boolean | `{account.store.NorthwoodsLeagueBaseball1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Northwoods League Baseball1 Feed Last Succesful Run At | text | datetime | `{account.store.NorthwoodsLeagueBaseball1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Address | text | scalar | `{item.inventory_attributes.address}` | — |
| Attendance | text | scalar | `{item.inventory_attributes.attendance}` | — |
| Box Score Home Totals  E | text | scalar | `{item.inventory_attributes.box_score_home_totals_E}` | — |
| Box Score Home Totals  H | text | scalar | `{item.inventory_attributes.box_score_home_totals_H}` | — |
| Box Score Home Totals  R | text | scalar | `{item.inventory_attributes.box_score_home_totals_R}` | — |
| Box Score Visitor Totals  E | text | scalar | `{item.inventory_attributes.box_score_visitor_totals_E}` | — |
| Box Score Visitor Totals  H | text | scalar | `{item.inventory_attributes.box_score_visitor_totals_H}` | — |
| Box Score Visitor Totals  R | text | scalar | `{item.inventory_attributes.box_score_visitor_totals_R}` | — |
| Broadcast | text | scalar | `{item.inventory_attributes.broadcast}` | — |
| Broadcast Label | text | scalar | `{item.inventory_attributes.broadcast_label}` | — |
| Date | text | scalar | `{item.inventory_attributes.date}` | — |
| Duration | text | scalar | `{item.inventory_attributes.duration}` | — |
| Full Date | text | scalar | `{item.inventory_attributes.full_date}` | — |
| Full Date Utc | text | scalar | `{item.inventory_attributes.full_date_utc}` | — |
| Home Score | text | scalar | `{item.inventory_attributes.home_score}` | — |
| Home Team | text | scalar | `{item.inventory_attributes.home_team}` | — |
| Home Team Abv | text | scalar | `{item.inventory_attributes.home_team_abv}` | — |
| Home Team Color | text | scalar | `{item.inventory_attributes.home_team_color}` | — |
| Home Team Logo | img | scalar | `{item.inventory_attributes.home_team_logo}` | — |
| Home Team Name | text | scalar | `{item.inventory_attributes.home_team_name}` | — |
| Home Team Record Text | text | scalar | `{item.inventory_attributes.home_team_record_text}` | — |
| Home Team Shortname | text | scalar | `{item.inventory_attributes.home_team_shortname}` | — |
| Id | text | scalar | `{item.inventory_attributes.id}` | — |
| Ingame | text | scalar | `{item.inventory_attributes.ingame}` | — |
| League | text | scalar | `{item.inventory_attributes.league}` | — |
| Location | text | scalar | `{item.inventory_attributes.location}` | — |
| Original Full Date | text | scalar | `{item.inventory_attributes.original_full_date}` | — |
| Postgame | text | scalar | `{item.inventory_attributes.postgame}` | — |
| Pregame | text | scalar | `{item.inventory_attributes.pregame}` | — |
| Season | text | scalar | `{item.inventory_attributes.season}` | — |
| Season Name | text | scalar | `{item.inventory_attributes.season_name}` | — |
| Status | text | scalar | `{item.inventory_attributes.status}` | — |
| Status Code | text | scalar | `{item.inventory_attributes.status_code}` | — |
| Team Records Home  L | text | scalar | `{item.inventory_attributes.team_records_home_L}` | — |
| Team Records Home  W | text | scalar | `{item.inventory_attributes.team_records_home_W}` | — |
| Team Records Visitor  L | text | scalar | `{item.inventory_attributes.team_records_visitor_L}` | — |
| Team Records Visitor  W | text | scalar | `{item.inventory_attributes.team_records_visitor_W}` | — |
| Time | text | scalar | `{item.inventory_attributes.time}` | — |
| Timezone | text | scalar | `{item.inventory_attributes.timezone}` | — |
| Visitor Score | text | scalar | `{item.inventory_attributes.visitor_score}` | — |
| Visitor Team | text | scalar | `{item.inventory_attributes.visitor_team}` | — |
| Visitor Team Abv | text | scalar | `{item.inventory_attributes.visitor_team_abv}` | — |
| Visitor Team Color | text | scalar | `{item.inventory_attributes.visitor_team_color}` | — |
| Visitor Team Logo | img | scalar | `{item.inventory_attributes.visitor_team_logo}` | — |
| Visitor Team Name | text | scalar | `{item.inventory_attributes.visitor_team_name}` | — |
| Visitor Team Record Text | text | scalar | `{item.inventory_attributes.visitor_team_record_text}` | — |
| Visitor Team Shortname | text | scalar | `{item.inventory_attributes.visitor_team_shortname}` | — |
| Winning Team | text | scalar | `{item.inventory_attributes.winning_team}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:33 UTC*
