---
title: "Paris 2024 Summer Olympics - Lucit Application Reference"
description: "Create live Olympic medal count digital billboard creatives for the Summer Olympics in 2024 This app will allow you to either build a table of the top medal winning countries, or,..."
keywords: "lucit application, Paris 2024 Summer Olympics, app reference, integration"
---

# Paris 2024 Summer Olympics

Create live Olympic medal count digital billboard creatives for the Summer Olympics in 2024 This app will allow you to either build a table of the top medal winning countries, or,...

**Application Details:**

- **Name:** Paris 2024 Summer Olympics
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-5e8c428f-7e01-4786-8456-270b047745ae`

---

## View in Lucit

**[🔗 View Paris 2024 Summer Olympics in Lucit](https://lucit.app/Paris2024Olympics){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Paris 2024 Summer Olympics to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Paris 2024 Summer Olympics"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Paris 2024 Summer Olympics application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **2 data source provider(s)**.

### Prerequisites to Using Paris 2024 Summer Olympics Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Paris 2024 Summer Olympics - Medal Count for Country

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Paris 2024 Summer Olympics - Medal Count for Country dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Paris 2024 Summer Olympics - Medal Count for Country**

To add values from Paris 2024 Summer Olympics - Medal Count for Country to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Paris 2024 Summer Olympics - Medal Count for Country `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Paris 2024 Summer Olympics - Medal Count for Country or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Paris 2024 Summer Olympics - Medal Count for Country data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Paris 2024 Summer Olympics - Medal Count for Country:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Country** | `text` [(enum)](#country-options) | — | Required |

**Enum Options:**

<a id="country-options"></a>

*Country:*

| Label | Value |
|-------|------|
| Armenia | Armenia |
| Argentina | Argentina |
| Australia | Australia |
| Austria | Austria |
| Azerbaijan | Azerbaijan |
| Bahamas | Bahamas |
| Bahrain | Bahrain |
| Belarus | Belarus |
| Belgium | Belgium |
| Bermuda | Bermuda |
| Botswana | Botswana |
| Brazil | Brazil |
| Bulgaria | Bulgaria |
| Burkina Faso | Burkina Faso |
| Canada | Canada |
| China | China |
| Chinese Taipei | Chinese Taipei |
| Colombia | Colombia |
| Croatia | Croatia |
| Cuba | Cuba |
| Czech Republic | Czech Republic |
| Denmark | Denmark |
| Dominican Republic | Dominican Republic |
| Ecuador | Ecuador |
| Egypt | Egypt |
| Estonia | Estonia |
| Ethiopia | Ethiopia |
| Fiji | Fiji |
| Finland | Finland |
| France | France |
| Georgia | Georgia |
| Germany | Germany |
| Ghana | Ghana |
| Great Britain | Great Britain |
| Greece | Greece |
| Grenada | Grenada |
| Hong Kong | Hong Kong |
| Hungary | Hungary |
| India | India |
| Indonesia | Indonesia |
| Iran | Iran |
| Ireland | Ireland |
| Israel | Israel |
| Italy | Italy |
| Ivory Coast | Ivory Coast |
| Jamaica | Jamaica |
| Japan | Japan |
| Jordan | Jordan |
| Kazakhstan | Kazakhstan |
| Kenya | Kenya |
| Kosovo | Kosovo |
| Kuwait | Kuwait |
| Kyrgyzstan | Kyrgyzstan |
| Latvia | Latvia |
| Lithuania | Lithuania |
| Malaysia | Malaysia |
| Mexico | Mexico |
| Moldova | Moldova |
| Mongolia | Mongolia |
| Morocco | Morocco |
| Namibia | Namibia |
| Netherlands | Netherlands |
| New Zealand | New Zealand |
| Nigeria | Nigeria |
| North Macedonia | North Macedonia |
| Norway | Norway |
| Philippines | Philippines |
| Poland | Poland |
| Portugal | Portugal |
| Puerto Rico | Puerto Rico |
| Qatar | Qatar |
| ROC | ROC |
| Romania | Romania |
| San Marino | San Marino |
| Saudi Arabia | Saudi Arabia |
| Serbia | Serbia |
| Slovakia | Slovakia |
| Slovenia | Slovenia |
| South Africa | South Africa |
| South Korea | South Korea |
| Spain | Spain |
| Sweden | Sweden |
| Switzerland | Switzerland |
| Syria | Syria |
| Thailand | Thailand |
| Tunisia | Tunisia |
| Turkey | Turkey |
| Turkmenistan | Turkmenistan |
| Uganda | Uganda |
| Ukraine | Ukraine |
| United States | United States |
| Uzbekistan | Uzbekistan |
| Venezuela | Venezuela |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Paris2024 Summer Olympics Medal Count For Country Feed Last Run Had Errors | text | boolean | `{account.store.Paris2024SummerOlympicsMedalCountForCountry_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Paris2024 Summer Olympics Medal Count For Country Feed Last Run Was Success | text | boolean | `{account.store.Paris2024SummerOlympicsMedalCountForCountry_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Paris2024 Summer Olympics Medal Count For Country Feed Last Succesful Run At | text | datetime | `{account.store.Paris2024SummerOlympicsMedalCountForCountry_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---

### Paris 2024 Summer Olympics - Top 5 Medal Countries

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Paris 2024 Summer Olympics - Top 5 Medal Countries dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Paris 2024 Summer Olympics - Top 5 Medal Countries**

To add values from Paris 2024 Summer Olympics - Top 5 Medal Countries to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Paris 2024 Summer Olympics - Top 5 Medal Countries `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Paris 2024 Summer Olympics - Top 5 Medal Countries or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Paris 2024 Summer Olympics - Top 5 Medal Countries data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Paris 2024 Summer Olympics - Top 5 Medal Countries:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

*No configurable settings for this data source.*


#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Paris2024 Summer Olympics Top5 Medal Countries Feed Last Run Had Errors | text | boolean | `{account.store.Paris2024SummerOlympicsTop5MedalCountries_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Paris2024 Summer Olympics Top5 Medal Countries Feed Last Run Was Success | text | boolean | `{account.store.Paris2024SummerOlympicsTop5MedalCountries_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Paris2024 Summer Olympics Top5 Medal Countries Feed Last Succesful Run At | text | datetime | `{account.store.Paris2024SummerOlympicsTop5MedalCountries_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:56 UTC*
