---
title: "PGA Golf Tour Leaderboards - Lucit Application Reference"
description: "Create digital billboard creatives with the top players on the leaderboard from your selected tournament on the PGA Schedule This application will allow you to design ads for..."
keywords: "lucit application, PGA Golf Tour Leaderboards, app reference, integration"
---

# PGA Golf Tour Leaderboards

Create digital billboard creatives with the top players on the leaderboard from your selected tournament on the PGA Schedule This application will allow you to design ads for...

**Application Details:**

- **Name:** PGA Golf Tour Leaderboards
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-05c7b98c-8765-4670-93c0-3fa51fad239e`

---

## View in Lucit

**[🔗 View PGA Golf Tour Leaderboards in Lucit](https://lucit.app/PgaGolfTourLeaderboards){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add PGA Golf Tour Leaderboards to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "PGA Golf Tour Leaderboards"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The PGA Golf Tour Leaderboards application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using PGA Golf Tour Leaderboards Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### PGA Golf Tour Leaderboards

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with PGA Golf Tour Leaderboards dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with PGA Golf Tour Leaderboards**

To add values from PGA Golf Tour Leaderboards to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from PGA Golf Tour Leaderboards `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled PGA Golf Tour Leaderboards or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using PGA Golf Tour Leaderboards data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from PGA Golf Tour Leaderboards:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Year** | `int` | — | Required |
| **Tournament ID** | `array` [(enum)](#tournament-id-options) | — | Required |
| **Max players** | `int` | Max number of players to show from the leaderboard (Positions 1 - Max) | Required |

**Enum Options:**

<a id="tournament-id-options"></a>

*Tournament ID:*

| Label | Value | Description |
|-------|------|-------------|
| The Sentry | 016 | Week 1 : Jan 2 - 5 |
| Sony Open in Hawaii | 006 | Week 2 : Jan 9 - 12 |
| The American Express | 002 | Week 3 : Jan 16 - 19 |
| Farmers Insurance Open | 004 | Week 4 : Jan 22 - 25 |
| AT&T Pebble Beach Pro-Am | 005 | Week 5 : Jan 30 - 2 |
| WM Phoenix Open | 003 | Week 6 : Feb 6 - 9 |
| The Genesis Invitational | 007 | Week 7 : Feb 13 - 16 |
| Mexico Open at VidantaWorld | 540 | Week 8 : Feb 20 - 23 |
| Cognizant Classic in The Palm Beaches | 010 | Week 9 : Feb 27 - 2 |
| Arnold Palmer Invitational presented by Mastercard | 009 | Week 10 : Mar 6 - 9 |
| Puerto Rico Open | 483 | Week 10 : Mar 6 - 9 |
| THE PLAYERS Championship | 011 | Week 11 : Mar 13 - 16 |
| Valspar Championship | 475 | Week 12 : Mar 20 - 23 |
| Texas Children's Houston Open | 020 | Week 13 : Mar 27 - 30 |
| Valero Texas Open | 041 | Week 14 : Apr 3 - 6 |
| Masters Tournament | 014 | Week 15 : Apr 10 - 13 |
| RBC Heritage | 012 | Week 16 : Apr 17 - 20 |
| Corales Puntacana Championship | 522 | Week 16 : Apr 17 - 20 |
| Zurich Classic of New Orleans | 018 | Week 17 : Apr 24 - 27 |
| THE CJ CUP Byron Nelson | 019 | Week 18 : May 1 - 4 |
| Truist Championship | 480 | Week 19 : May 8 - 11 |
| Myrtle Beach Classic | 553 | Week 19 : May 8 - 11 |
| PGA Championship | 033 | Week 20 : May 15 - 18 |
| Charles Schwab Challenge | 021 | Week 21 : May 22 - 25 |
| the Memorial Tournament presented by Workday | 023 | Week 22 : May 29 - 1 |
| RBC Canadian Open | 032 | Week 23 : Jun 5 - 8 |
| U.S. Open | 026 | Week 24 : Jun 12 - 15 |
| Travelers Championship | 034 | Week 25 : Jun 19 - 22 |
| Rocket Mortgage Classic | 524 | Week 26 : Jun 26 - 29 |
| John Deere Classic | 030 | Week 27 : Jul 3 - 6 |
| Genesis Scottish Open | 541 | Week 28 : Jul 10 - 13 |
| ISCO Championship | 518 | Week 28 : Jul 10 - 13 |
| The Open Championship | 100 | Week 29 : Jul 17 - 20 |
| Barracuda Championship | 472 | Week 29 : Jul 17 - 20 |
| 3M Open | 525 | Week 30 : Jul 24 - 27 |
| Wyndham Championship | 013 | Week 31 : Jul 31 - 3 |
| FedEx St. Jude Championship | 027 | Week 32 : Aug 7 - 10 |
| BMW Championship | 028 | Week 33 : Aug 14 - 17 |
| TOUR Championship | 060 | Week 34 : Aug 21 - 24 |
| Procore Championship | 464 | Week 37 : Sep 11 - 14 |
| Ryder Cup | 468 | Week 39 : Sep 26 - 29 |
| Sanderson Farms Championship | 054 | Week 40 : Oct 2 - 5 |
| Baycurrent Classic | 527 | Week 41 : Oct 9 - 12 |
| Black Desert Championship | 554 | Week 43 : Oct 23 - 26 |
| World Wide Technology Championship | 457 | Week 45 : Nov 6 - 9 |
| Butterfield Bermuda Championship | 528 | Week 46 : Nov 13 - 16 |
| The RSM Classic | 493 | Week 47 : Nov 20 - 23 |
| Hero World Challenge | 478 | Week 49 : Dec 4 - 7 |
| Grant Thornton Invitational | 551 | Week 50 : Dec 12 - 15 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Pga Golf Tour Leaderboards1  Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1__id}` | — |
| Pga Golf Tour Leaderboards1 Cut Lines 0 Cut Count | text | scalar | `{account.store.PgaGolfTourLeaderboards1_cut_lines_0_cut_count}` | — |
| Pga Golf Tour Leaderboards1 Cut Lines 0 Cut Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_cut_lines_0_cut_score}` | — |
| Pga Golf Tour Leaderboards1 Feed Last Run Had Errors | text | boolean | `{account.store.PgaGolfTourLeaderboards1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Pga Golf Tour Leaderboards1 Feed Last Run Was Success | text | boolean | `{account.store.PgaGolfTourLeaderboards1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Pga Golf Tour Leaderboards1 Feed Last Succesful Run At | text | datetime | `{account.store.PgaGolfTourLeaderboards1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Pga Golf Tour Leaderboards1 Is Within Tournament Dates | text | datetime | `{account.store.PgaGolfTourLeaderboards1_is_within_tournament_dates}` | — |
| Pga Golf Tour Leaderboards1 Last Updated | text | datetime | `{account.store.PgaGolfTourLeaderboards1_last_updated}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 0 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_0_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 1 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_1_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 2 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_2_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 3 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_3_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 4 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_4_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 5 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_5_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 6 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_6_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 7 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_7_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 8 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_8_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Current Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_current_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_current_round}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Current Round Score | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_current_round_score}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 First Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_first_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Is Amateur | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_is_amateur}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Last Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_last_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Player Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_player_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Position | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_position}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Round Complete | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_round_complete}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 0 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_0_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 0 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_0_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 0 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_0_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 1 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_1_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 1 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_1_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 1 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_1_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 1 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_1_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 2 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_2_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 2 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_2_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 2 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_2_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 2 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_2_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 2 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_2_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 3 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_3_course_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 3 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_3_course_name}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 3 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_3_round_id}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 3 Score To Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_3_score_to_par}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Rounds 3 Strokes | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_rounds_3_strokes}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Starting Hole | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_starting_hole}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_status}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Tee Time | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_tee_time}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Tee Time Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_tee_time_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Thru | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_thru}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_total}` | — |
| Pga Golf Tour Leaderboards1 Leaderboard Rows 9 Total Strokes From Completed Rounds | text | scalar | `{account.store.PgaGolfTourLeaderboards1_leaderboard_rows_9_total_strokes_from_completed_rounds}` | — |
| Pga Golf Tour Leaderboards1 Org Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_org_id}` | — |
| Pga Golf Tour Leaderboards1 Round Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_round_id}` | — |
| Pga Golf Tour Leaderboards1 Round Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_round_status}` | — |
| Pga Golf Tour Leaderboards1 Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_status}` | — |
| Pga Golf Tour Leaderboards1 Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Tourn Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tourn_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament  Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament__id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Course Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_course_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Course Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_course_name}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 0 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_0_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 0 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_0_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 1 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_1_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 1 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_1_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 10 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_10_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 10 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_10_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 11 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_11_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 11 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_11_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 12 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_12_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 12 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_12_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 13 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_13_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 13 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_13_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 14 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_14_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 14 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_14_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 15 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_15_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 15 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_15_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 16 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_16_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 16 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_16_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 17 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_17_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 17 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_17_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 2 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_2_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 2 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_2_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 3 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_3_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 3 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_3_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 4 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_4_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 4 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_4_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 5 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_5_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 5 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_5_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 6 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_6_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 6 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_6_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 7 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_7_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 7 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_7_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 8 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_8_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 8 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_8_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 9 Hole Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_9_hole_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Holes 9 Par | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_holes_9_par}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Host | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_host}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Location City | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_location_city}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Location Country | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_location_country}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Location State | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_location_state}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Par Back Nine | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_par_back_nine}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Par Front Nine | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_par_front_nine}` | — |
| Pga Golf Tour Leaderboards1 Tournament Courses 0 Par Total | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_courses_0_par_total}` | — |
| Pga Golf Tour Leaderboards1 Tournament Current Round | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_current_round}` | — |
| Pga Golf Tour Leaderboards1 Tournament Date End | text | datetime | `{account.store.PgaGolfTourLeaderboards1_tournament_date_end}` | — |
| Pga Golf Tour Leaderboards1 Tournament Date Start | text | datetime | `{account.store.PgaGolfTourLeaderboards1_tournament_date_start}` | — |
| Pga Golf Tour Leaderboards1 Tournament Date Week Number | text | datetime | `{account.store.PgaGolfTourLeaderboards1_tournament_date_week_number}` | — |
| Pga Golf Tour Leaderboards1 Tournament Fedex Cup Points | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_fedex_cup_points}` | — |
| Pga Golf Tour Leaderboards1 Tournament Format | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_format}` | — |
| Pga Golf Tour Leaderboards1 Tournament Is In Future | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_is_in_future}` | — |
| Pga Golf Tour Leaderboards1 Tournament Is In Past | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_is_in_past}` | — |
| Pga Golf Tour Leaderboards1 Tournament Name | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_name}` | — |
| Pga Golf Tour Leaderboards1 Tournament Org Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_org_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Purse | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_purse}` | — |
| Pga Golf Tour Leaderboards1 Tournament Status | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_status}` | — |
| Pga Golf Tour Leaderboards1 Tournament Time Zone | text | datetime | `{account.store.PgaGolfTourLeaderboards1_tournament_time_zone}` | — |
| Pga Golf Tour Leaderboards1 Tournament Timestamp | text | datetime | `{account.store.PgaGolfTourLeaderboards1_tournament_timestamp}` | — |
| Pga Golf Tour Leaderboards1 Tournament Tourn Id | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_tourn_id}` | — |
| Pga Golf Tour Leaderboards1 Tournament Year | text | scalar | `{account.store.PgaGolfTourLeaderboards1_tournament_year}` | — |
| Pga Golf Tour Leaderboards1 Year | text | scalar | `{account.store.PgaGolfTourLeaderboards1_year}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:29 UTC*
