---
title: "Place Exchange - Lucit Application Reference"
description: "Place Exchange is a platform that enables real programmatic out-of-home (OOH) advertising. This application for the Place Exchange Dynamic Creatives player integration links PX..."
keywords: "lucit application, Place Exchange, app reference, integration"
---

# Place Exchange

Place Exchange is a platform that enables real programmatic out-of-home (OOH) advertising. This application for the Place Exchange Dynamic Creatives player integration links PX...

**Application Details:**

- **Name:** Place Exchange
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Player, Analytics Reporter

- **LCUID:** `LCUID-LAP-3f63b208-b093-4706-a547-3082b67f7807`

---

## View in Lucit

**[🔗 View Place Exchange in Lucit](https://lucit.app/PlaceExchange1){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Place Exchange to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Place Exchange"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes


### Add Place Exchange to Your Agency or Operator Profile

1. **Navigate to Apps**
   - Log in to Lucit
   - Switch to your Agency/Operator profile
   - Go to `SETTINGS`
   - Scroll down to view the `Apps & Data Sources` section in `SETTINGS`

2. **Find the Application**
   - Click the `ADD NEW` button and Search for "Place Exchange"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Agency / Operator**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Configure agency-level settings as needed
   - Save your changes




---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:23 UTC*
