---
title: "Premier League Football - Lucit Application Reference"
description: "Get Premier League Football (Soccer) standings and fixtures, live games, and results. Add live standings to your digital billboard OOH creatives, with this dynamic creatives..."
keywords: "lucit application, Premier League Football, app reference, integration"
---

# Premier League Football

Get Premier League Football (Soccer) standings and fixtures, live games, and results. Add live standings to your digital billboard OOH creatives, with this dynamic creatives...

**Application Details:**

- **Name:** Premier League Football
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-a6cbbe26-5562-4358-8e0e-409a014d1f60`

---

## View in Lucit

**[🔗 View Premier League Football in Lucit](https://lucit.app/PremierLeagueFootball){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Premier League Football to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Premier League Football"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Premier League Football application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **2 data source provider(s)**.

### Prerequisites to Using Premier League Football Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Premier League Football Fixtures and Scores

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Premier League Football Fixtures and Scores dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Premier League Football Fixtures and Scores**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Premier League Football Fixtures and Scores to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Premier League Football Fixtures and Scores to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Season** | `text` | Enter a season like 2024,2025, etc. | Required |
| **Game Date** | `text` | Enter a game date in YYYY-MM-DD format, or leave blank to get todays games | — |
| **Include games in pre-game status** | `bool` | Enable this option to include games before they have started.  Useful to show game-time creatives | — |
| **Choose Teams** | `int` [(multiple select)](#choose-teams-options) | Please select one or more teams | — |

**Enum Options:**

<a id="choose-teams-options"></a>

*Choose Teams:*

| Label | Value |
|-------|------|
| Arsenal | 42 |
| Aston Villa | 66 |
| Bournemouth | 35 |
| Brighton | 51 |
| Brentford | 55 |
| Chelsea | 49 |
| Crystal Palace | 52 |
| Everton | 45 |
| Fulham | 36 |
| Ipswich | 57 |
| Leicester | 46 |
| Liverpool | 40 |
| Manchester City | 50 |
| Manchester United | 33 |
| Newcastle | 34 |
| Nottingham Forest | 65 |
| Southampton | 41 |
| Tottenham | 47 |
| West Ham | 48 |
| Wolves | 39 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Premier League Football Fixtures And Scores Feed Last Run Had Errors | text | boolean | `{account.store.PremierLeagueFootballFixturesAndScores_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Premier League Football Fixtures And Scores Feed Last Run Was Success | text | boolean | `{account.store.PremierLeagueFootballFixturesAndScores_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Premier League Football Fixtures And Scores Feed Last Succesful Run At | text | datetime | `{account.store.PremierLeagueFootballFixturesAndScores_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Fixture Date | text | scalar | `{item.inventory_attributes.fixture_date}` | — |
| Fixture Ingame | text | scalar | `{item.inventory_attributes.fixture_ingame}` | — |
| Fixture Periods First | text | scalar | `{item.inventory_attributes.fixture_periods_first}` | — |
| Fixture Periods Second | text | scalar | `{item.inventory_attributes.fixture_periods_second}` | — |
| Fixture Postgame | text | scalar | `{item.inventory_attributes.fixture_postgame}` | — |
| Fixture Pregame | text | scalar | `{item.inventory_attributes.fixture_pregame}` | — |
| Fixture Status Elapsed | text | scalar | `{item.inventory_attributes.fixture_status_elapsed}` | — |
| Fixture Status Extra | text | scalar | `{item.inventory_attributes.fixture_status_extra}` | — |
| Fixture Status Long | text | scalar | `{item.inventory_attributes.fixture_status_long}` | — |
| Fixture Status Short | text | scalar | `{item.inventory_attributes.fixture_status_short}` | — |
| Fixture Timestamp | text | scalar | `{item.inventory_attributes.fixture_timestamp}` | — |
| Fixture Vene Name | text | scalar | `{item.inventory_attributes.fixture_vene_name}` | — |
| Fixture Venue City | text | scalar | `{item.inventory_attributes.fixture_venue_city}` | — |
| Fixture Venue Id | text | scalar | `{item.inventory_attributes.fixture_venue_id}` | — |
| Goals Aways | text | scalar | `{item.inventory_attributes.goals_aways}` | — |
| Goals Home | text | scalar | `{item.inventory_attributes.goals_home}` | — |
| Score Extratime Away | text | scalar | `{item.inventory_attributes.score_extratime_away}` | — |
| Score Extratime Home | text | scalar | `{item.inventory_attributes.score_extratime_home}` | — |
| Score Fulltime Away | text | scalar | `{item.inventory_attributes.score_fulltime_away}` | — |
| Score Fulltime Home | text | scalar | `{item.inventory_attributes.score_fulltime_home}` | — |
| Score Halftime Away | text | scalar | `{item.inventory_attributes.score_halftime_away}` | — |
| Score Halftime Home | text | scalar | `{item.inventory_attributes.score_halftime_home}` | — |
| Score Penalty Away | text | scalar | `{item.inventory_attributes.score_penalty_away}` | — |
| Score Penalty Home | text | scalar | `{item.inventory_attributes.score_penalty_home}` | — |
| Teams Away Id | text | scalar | `{item.inventory_attributes.teams_away_id}` | — |
| Teams Away Logo | img | scalar | `{item.inventory_attributes.teams_away_logo}` | — |
| Teams Away Name | text | scalar | `{item.inventory_attributes.teams_away_name}` | — |
| Teams Away Winner | text | scalar | `{item.inventory_attributes.teams_away_winner}` | — |
| Teams Home Id | text | scalar | `{item.inventory_attributes.teams_home_id}` | — |
| Teams Home Logo | img | scalar | `{item.inventory_attributes.teams_home_logo}` | — |
| Teams Home Name | text | scalar | `{item.inventory_attributes.teams_home_name}` | — |
| Teams Home Winner | text | scalar | `{item.inventory_attributes.teams_home_winner}` | — |



---

### Premier League Football Standings

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Premier League Football Standings dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Premier League Football Standings**

To add values from Premier League Football Standings to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Premier League Football Standings `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Premier League Football Standings or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Premier League Football Standings data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Premier League Football Standings:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Season** | `int` | Enter in the 4 digit year (Like 2020,20201, ...) for the season to pull standings for | Required, Min: 2020 |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Premier League Football Standings 0 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_0_team_logo}` | — |
| Premier League Football Standings 1 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_1_team_logo}` | — |
| Premier League Football Standings 10 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_10_team_logo}` | — |
| Premier League Football Standings 11 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_11_team_logo}` | — |
| Premier League Football Standings 12 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_12_team_logo}` | — |
| Premier League Football Standings 13 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_13_team_logo}` | — |
| Premier League Football Standings 14 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_14_team_logo}` | — |
| Premier League Football Standings 15 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_15_team_logo}` | — |
| Premier League Football Standings 16 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_16_team_logo}` | — |
| Premier League Football Standings 17 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_17_team_logo}` | — |
| Premier League Football Standings 18 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_18_team_logo}` | — |
| Premier League Football Standings 19 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_19_team_logo}` | — |
| Premier League Football Standings 2 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_2_team_logo}` | — |
| Premier League Football Standings 3 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_3_team_logo}` | — |
| Premier League Football Standings 4 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_4_team_logo}` | — |
| Premier League Football Standings 5 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_5_team_logo}` | — |
| Premier League Football Standings 6 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_6_team_logo}` | — |
| Premier League Football Standings 7 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_7_team_logo}` | — |
| Premier League Football Standings 8 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_8_team_logo}` | — |
| Premier League Football Standings 9 Team Logo | img | scalar | `{account.store.PremierLeagueFootballStandings_9_team_logo}` | — |
| Premier League Football Standings Feed Last Run Had Errors | text | boolean | `{account.store.PremierLeagueFootballStandings_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Premier League Football Standings Feed Last Run Was Success | text | boolean | `{account.store.PremierLeagueFootballStandings_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Premier League Football Standings Feed Last Succesful Run At | text | datetime | `{account.store.PremierLeagueFootballStandings_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:35 UTC*
