---
title: "Santiam Pass Ski Patrol - Snow Depth - Lucit Application Reference"
description: "Fetch the current Snow Depth at Hoodoo Butte from Santiam Pass Ski Patrol sensor data"
keywords: "lucit application, Santiam Pass Ski Patrol - Snow Depth, app reference, integration"
---

# Santiam Pass Ski Patrol - Snow Depth

Fetch the current Snow Depth at Hoodoo Butte from Santiam Pass Ski Patrol sensor data

**Application Details:**

- **Name:** Santiam Pass Ski Patrol - Snow Depth
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-fe436845-7059-4803-b1d8-d483641fca51`

---

## View in Lucit

**[🔗 View Santiam Pass Ski Patrol - Snow Depth in Lucit](https://lucit.app/SantiamPassSkiPatrolSnowDepth){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Santiam Pass Ski Patrol - Snow Depth to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Santiam Pass Ski Patrol - Snow Depth"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Santiam Pass Ski Patrol - Snow Depth application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Santiam Pass Ski Patrol - Snow Depth Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Santiam Pass Ski Patrol - Snow Depth

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Santiam Pass Ski Patrol - Snow Depth dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Santiam Pass Ski Patrol - Snow Depth**

To add values from Santiam Pass Ski Patrol - Snow Depth to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Santiam Pass Ski Patrol - Snow Depth `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Santiam Pass Ski Patrol - Snow Depth or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Santiam Pass Ski Patrol - Snow Depth data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Santiam Pass Ski Patrol - Snow Depth:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Santiam Pass Ski Patrol Snow Depth1 Feed Last Run Had Errors | text | boolean | `{account.store.SantiamPassSkiPatrolSnowDepth1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Santiam Pass Ski Patrol Snow Depth1 Feed Last Run Was Success | text | boolean | `{account.store.SantiamPassSkiPatrolSnowDepth1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Santiam Pass Ski Patrol Snow Depth1 Feed Last Succesful Run At | text | datetime | `{account.store.SantiamPassSkiPatrolSnowDepth1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Santiam Pass Ski Patrol Snow Depth1 Snow Depth | text | scalar | `{account.store.SantiamPassSkiPatrolSnowDepth1_snow_depth}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:23 UTC*
