---
title: "Ski Resorts & Conditions - Lucit Application Reference"
description: "Get conditions at your favorite US and Canada Ski Resorts including Lift Status and snow conditions - Lift Status (Open Closed, Hold, Percentage) - Snow cover - Total Season snow..."
keywords: "lucit application, Ski Resorts & Conditions, app reference, integration"
---

# Ski Resorts & Conditions

Get conditions at your favorite US and Canada Ski Resorts including Lift Status and snow conditions - Lift Status (Open Closed, Hold, Percentage) - Snow cover - Total Season snow...

**Application Details:**

- **Name:** Ski Resorts & Conditions
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-851416b2-f469-4024-bb06-389462cfedfe`

---

## View in Lucit

**[🔗 View Ski Resorts & Conditions in Lucit](https://lucit.app/SkiResortsConditions){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Ski Resorts & Conditions to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Ski Resorts & Conditions"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Ski Resorts & Conditions application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Ski Resorts & Conditions Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Ski Resorts & Conditions

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Ski Resorts & Conditions dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Ski Resorts & Conditions**

To add values from Ski Resorts & Conditions to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Ski Resorts & Conditions `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Ski Resorts & Conditions or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Ski Resorts & Conditions data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Ski Resorts & Conditions:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Ski Resort** | `text` [(enum)](#ski-resort-options) | Choose your ski resort | Required |

**Enum Options:**

<a id="ski-resort-options"></a>

*Ski Resort:*

| Label | Value |
|-------|------|
| 49 Degrees North | 49-degrees-north |
| Alpine Meadows | alpine-meadows |
| Alta | alta |
| Alyeska | alyeska |
| Angel Fire | angel-fire |
| Arapaho Basin | arapahoe-basin |
| Aspen Highlands | aspen-highlands |
| Aspen Mountain | aspen-mountain |
| Attitash | attitash |
| Beaver Creek | beavercreek |
| Big Sky | big-sky |
| Big White | big-white |
| Blue Mountain | bluemountain |
| Bolton Valley | bolton-valley |
| Boreal | boreal |
| Breckenridge | breck |
| Bretton Woods | brettonwoods |
| Brian Head | brianhead |
| Bridger Bowl | bridger-bowl |
| Brighton | brighton |
| Bromley Mountain | bromley-mountain |
| Burke Mountain | burke-mountain |
| Buttermilk | buttermilk |
| Caberfae Peaks | caberfae-peaks |
| Camelback Mountain | camelback |
| Canada Olympic Park | canada-olympic-park |
| Cannon | cannon |
| Cataloochee | cataloochee |
| China Peak | chinapeak |
| Cesana Claviere | claviere |
| Copper Mountain | copper |
| Coronet Peak | coronetpeak |
| Courchevel - 3 Vallees | courchevel |
| Cranmore | cranmore-mountain |
| Crans-Montana | cransmontana |
| Crested Butte | crested-butte |
| Crystal Mountain | crystal-mountain |
| Cypress Mountain | cypress-mountain |
| Deer Valley | deer-valley |
| Devil's Head | devils-head |
| Diamond Peak | diamondpeak |
| Falls Creek | falls-creek |
| Folgarida Marilleva | folgarida-marilleva |
| Gore Mountain | gore-mountain |
| Grand Targhee | grand-targhee |
| Grouse Mountain | grouse |
| Gunstock | gunstock |
| Heavenly | heavenly |
| Hochfügen | hochfuegen |
| Homewood | homewood |
| Hoodoo | hoodoo |
| Hunter Mountain | hunter |
| Ischgl - Silvretta | ischgl-silvretta-arena |
| Jackson Hole | jackson-hole |
| Jay Peak | jay-peak |
| Jiminy Peak | jiminypeak |
| June Mountain | june-mountain |
| Keystone | keystone |
| Killington | killington |
| King Pine | king-pine |
| Kirkwood | kirkwood |
| Kitzbühel | kitzbuehel |
| La Plagne | laplagne |
| La Rosière | larosiere |
| Les Arcs | lesarcs |
| Les Menuires | lesmenuires |
| Loon Mountain | loon |
| Loveland | loveland |
| Mad River Glen | mad-river-glen |
| Madonna di Campiglio | madonna-di-campiglio |
| Mammoth Mountain | mammoth-lakes |
| Manning Park | manning-park |
| Megève | megeve |
| Meribel | meribel |
| Monarch Mountain | monarch |
| Montgenevre | montegenevre |
| Morzine | morzine |
| Mount Sunapee | mount-sunapee |
| Mount Snow | mountsnow |
| Mount Buller | mt-buller |
| Mount Hotham | mt-hotham |
| Mount Seymour | mt-seymour |
| Mt Spokane | mt-spokane |
| Mount Bachelor | mtbachelor |
| Mt Brighton | mtbrighton |
| Mountain High | mthigh |
| Mount Hood | mthood |
| Mount Rose | mtrose |
| Niseko | niseko |
| Northstar | northstar |
| Okemo | okemo |
| Owl's Head | owlshead |
| Palisades Tahoe | palisades |
| Park City | parkcity |
| Pats Peak | pats-peak |
| Perisher | perisher |
| Pico Mountain | pico |
| Pinzolo | pinzolo |
| Ponte di Legno - Tonale | pontedilegno-tonale |
| Ragged Mountain | ragged-mountain |
| Red Lodge Mountain | red-lodge-mountain |
| Red Mountain | red-mountain |
| Saddleback | saddleback |
| Cesana San Sicario | sansicario |
| Sasquatch Mountain | sasquatch-mountain |
| Sauze d'Oulx | sauze |
| Schweitzer | schweitzer |
| Sestriere | sestriere |
| Shawnee Mountain | shawnee-mountain |
| Shawnee Peak | shawnee-peak |
| Sierra at Tahoe | sierra |
| Silver Star | silver-star |
| Smugglers' Notch | smuggs |
| Snow Valley | snow-valley |
| Snowbasin | snowbasin |
| Snowbird | snowbird |
| Snowmass | snowmass |
| Snowshoe Mountain | snowshoe |
| Sölden | soelden |
| Solitude | solitude |
| St. Anton Am Arlberg | st-anton-am-arlberg |
| Steamboat | steamboat |
| Stevens Pass | stevens |
| Stowe | stowe |
| Stratton | stratton |
| Sugar Bowl | sugarbowl |
| Sugarbush | sugarbush |
| Sugarloaf | sugarloaf |
| Sun Peaks | sun-peaks |
| Sunday River | sunday-river |
| Sunshine Village | sunshine-village |
| Sun Valley | sunvalley |
| Tahoe Donner | tahoe-donner |
| Taos Ski Valley | taos |
| Tarvisio | tarvisio |
| Telluride | telluride |
| Thredbo | thredbo |
| Tignes | tignes |
| Timberline Lodge | timberline-lodge |
| Mont Tremblant | tremblant |
| Vail | vail |
| Val di Fassa / Carezza | val-di-fassa |
| Val di Fiemme / Obereggen | val-di-fiemme |
| Val Gardena | val-gardena |
| Val d'Isere | valdisere |
| Verbier | verbier |
| Waterville Valley | waterville |
| Whistler Blackcomb | whistler-blackcomb |
| Whiteface | whiteface |
| Whitefish Mountain | whitefish |
| Wildcat | wildcat |
| Windham Mountain | windham |
| Winter Park | winter-park |
| Winterplace | winterplace |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Ski Resorts Conditions1 Country | text | scalar | `{account.store.SkiResortsConditions1_country}` | — |
| Ski Resorts Conditions1 Feed Last Run Had Errors | text | boolean | `{account.store.SkiResortsConditions1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Ski Resorts Conditions1 Feed Last Run Was Success | text | boolean | `{account.store.SkiResortsConditions1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Ski Resorts Conditions1 Feed Last Succesful Run At | text | datetime | `{account.store.SkiResortsConditions1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Ski Resorts Conditions1 Href | text | scalar | `{account.store.SkiResortsConditions1_href}` | — |
| Ski Resorts Conditions1 Lifts Stats Closed | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_closed}` | — |
| Ski Resorts Conditions1 Lifts Stats Hold | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_hold}` | — |
| Ski Resorts Conditions1 Lifts Stats Open | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_open}` | — |
| Ski Resorts Conditions1 Lifts Stats Percentage Closed | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_percentage_closed}` | — |
| Ski Resorts Conditions1 Lifts Stats Percentage Hold | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_percentage_hold}` | — |
| Ski Resorts Conditions1 Lifts Stats Percentage Open | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_percentage_open}` | — |
| Ski Resorts Conditions1 Lifts Stats Percentage Scheduled | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_percentage_scheduled}` | — |
| Ski Resorts Conditions1 Lifts Stats Scheduled | text | scalar | `{account.store.SkiResortsConditions1_lifts_stats_scheduled}` | — |
| Ski Resorts Conditions1 Lifts Status | text | scalar | `{account.store.SkiResortsConditions1_lifts_status}` | — |
| Ski Resorts Conditions1 Location Latitude | text | scalar | `{account.store.SkiResortsConditions1_location_latitude}` | — |
| Ski Resorts Conditions1 Location Longitude | text | scalar | `{account.store.SkiResortsConditions1_location_longitude}` | — |
| Ski Resorts Conditions1 Name | text | scalar | `{account.store.SkiResortsConditions1_name}` | — |
| Ski Resorts Conditions1 Region | text | scalar | `{account.store.SkiResortsConditions1_region}` | — |
| Ski Resorts Conditions1 Slug | text | scalar | `{account.store.SkiResortsConditions1_slug}` | — |
| Ski Resorts Conditions1 Units | text | scalar | `{account.store.SkiResortsConditions1_units}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:20 UTC*
