---
title: "Stock Prices (By DIGICHIEF) - Lucit Application Reference"
description: "Add real time stock prices to your digital out-of-home creatives with the Stock Prices app by Digi Chief. Add individual stocks, generate a top stocks list based on top movers /..."
keywords: "lucit application, Stock Prices (By DIGICHIEF), app reference, integration"
---

# Stock Prices (By DIGICHIEF)

Add real time stock prices to your digital out-of-home creatives with the Stock Prices app by Digi Chief. Add individual stocks, generate a top stocks list based on top movers /...

**Application Details:**

- **Name:** Stock Prices (By DIGICHIEF)
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-d2bf98d4-70b2-4d0a-96c8-d8b6aceacd7d`

---

## View in Lucit

**[🔗 View Stock Prices (By DIGICHIEF) in Lucit](https://lucit.app/StockPricesByDigichief){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Stock Prices (By DIGICHIEF) to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Stock Prices (By DIGICHIEF)"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Stock Prices (By DIGICHIEF) application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **3 data source provider(s)**.

### Prerequisites to Using Stock Prices (By DIGICHIEF) Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Indexes

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Indexes dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Indexes**

To add values from Indexes to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Indexes `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Indexes or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Indexes data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Indexes:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **DIGICHIEF Customer Name** | `secret` | Enter the customer name provided to you along with your API key | Required |
| **DIGICHIEF API Key** | `secret` | Enter the API key provided to you by DIGICHIEF | Required |
| **Index** | `text` [(enum)](#index-options) | Select an Index | Required, Max length: 9 |

**Enum Options:**

<a id="index-options"></a>

*Index:*

| Label | Value |
|-------|------|
| Dow End of Day | DJI-EOD |
| S&P 500 EOD | SPX-EOD |
| NASDAQ EOD | COMP-EOD |
| Russell 2000 EOD | RUT-EOD |
| NYSE | NYA |
| TSX Canadian | TX20 |
| TSX 60 Index | TX60C |
| 13-week T-bill | IRX |
| 5-year T-note | FVX |
| 10-year T-note | TNX |
| 30-year T-note | TYX |
| NASDAQ 100 | NDX |
| FTSE 100 | FTSE |
| Nikkei 225 | N225 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Indexes Ask | text | scalar | `{account.store.Indexes_ask}` | — |
| Indexes Ask Size | text | scalar | `{account.store.Indexes_ask_size}` | — |
| Indexes Avg Volume Y T D | text | scalar | `{account.store.Indexes_avg_volume_y_t_d}` | — |
| Indexes Avg Volume1 M | text | scalar | `{account.store.Indexes_avg_volume1_m}` | — |
| Indexes Avg Volume1 W | text | scalar | `{account.store.Indexes_avg_volume1_w}` | — |
| Indexes Avg Volume3 M | text | scalar | `{account.store.Indexes_avg_volume3_m}` | — |
| Indexes Avg Volume52 | text | scalar | `{account.store.Indexes_avg_volume52}` | — |
| Indexes Avg Volume6 M | text | scalar | `{account.store.Indexes_avg_volume6_m}` | — |
| Indexes Change | text | scalar | `{account.store.Indexes_change}` | — |
| Indexes Change Percent | text | scalar | `{account.store.Indexes_change_percent}` | — |
| Indexes Company Logo | img | scalar | `{account.store.Indexes_company_logo}` | — |
| Indexes Delay | text | scalar | `{account.store.Indexes_delay}` | — |
| Indexes Exchange Default Currency | text | scalar | `{account.store.Indexes_exchange_default_currency}` | — |
| Indexes Exchange Name | text | scalar | `{account.store.Indexes_exchange_name}` | — |
| Indexes Feed Last Run Had Errors | text | boolean | `{account.store.Indexes_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Indexes Feed Last Run Was Success | text | boolean | `{account.store.Indexes_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Indexes Feed Last Succesful Run At | text | datetime | `{account.store.Indexes_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Indexes High | text | scalar | `{account.store.Indexes_high}` | — |
| Indexes High Y T D | text | scalar | `{account.store.Indexes_high_y_t_d}` | — |
| Indexes High1 M | text | scalar | `{account.store.Indexes_high1_m}` | — |
| Indexes High1 W | text | scalar | `{account.store.Indexes_high1_w}` | — |
| Indexes High3 M | text | scalar | `{account.store.Indexes_high3_m}` | — |
| Indexes High52 | text | scalar | `{account.store.Indexes_high52}` | — |
| Indexes High6 M | text | scalar | `{account.store.Indexes_high6_m}` | — |
| Indexes Low | text | scalar | `{account.store.Indexes_low}` | — |
| Indexes Low Y T D | text | scalar | `{account.store.Indexes_low_y_t_d}` | — |
| Indexes Low1 M | text | scalar | `{account.store.Indexes_low1_m}` | — |
| Indexes Low1 W | text | scalar | `{account.store.Indexes_low1_w}` | — |
| Indexes Low3 M | text | scalar | `{account.store.Indexes_low3_m}` | — |
| Indexes Low52 | text | scalar | `{account.store.Indexes_low52}` | — |
| Indexes Low6 M | text | scalar | `{account.store.Indexes_low6_m}` | — |
| Indexes Most Recent Close | text | scalar | `{account.store.Indexes_most_recent_close}` | — |
| Indexes Moving Average200 | text | scalar | `{account.store.Indexes_moving_average200}` | — |
| Indexes Moving Average50 | text | scalar | `{account.store.Indexes_moving_average50}` | — |
| Indexes Name | text | scalar | `{account.store.Indexes_name}` | — |
| Indexes Netgr | text | scalar | `{account.store.Indexes_netgr}` | — |
| Indexes Prev Close | text | scalar | `{account.store.Indexes_prev_close}` | — |
| Indexes Price | text | float | `{account.store.Indexes_price}` | — |
| Indexes Security Type Name | text | scalar | `{account.store.Indexes_security_type_name}` | — |
| Indexes Short Name | text | scalar | `{account.store.Indexes_short_name}` | — |
| Indexes Symbol | text | scalar | `{account.store.Indexes_symbol}` | — |
| Indexes Type | text | scalar | `{account.store.Indexes_type}` | — |
| Indexes Volume | text | scalar | `{account.store.Indexes_volume}` | — |



---

### Individual Stock Price

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Individual Stock Price dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Individual Stock Price**

To add values from Individual Stock Price to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Individual Stock Price `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Individual Stock Price or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Individual Stock Price data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Individual Stock Price:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **DIGICHIEF Customer Name** | `secret` | Enter the customer name provided to you along with your API key | Required |
| **DIGICHIEF API Key** | `secret` | Enter the API key provided to you by DIGICHIEF | Required |
| **Stock Ticker Symbol** | `text` | Add the stock ticker symbol | Required, Max length: 9 |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Individual Stock Price By Digichief Ask | text | scalar | `{account.store.IndividualStockPriceByDigichief_ask}` | — |
| Individual Stock Price By Digichief Ask Size | text | scalar | `{account.store.IndividualStockPriceByDigichief_ask_size}` | — |
| Individual Stock Price By Digichief Avg Volume Y T D | text | scalar | `{account.store.IndividualStockPriceByDigichief_avg_volume_y_t_d}` | — |
| Individual Stock Price By Digichief Avg Volume1 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_avg_volume1_m}` | — |
| Individual Stock Price By Digichief Avg Volume1 W | text | scalar | `{account.store.IndividualStockPriceByDigichief_avg_volume1_w}` | — |
| Individual Stock Price By Digichief Avg Volume3 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_avg_volume3_m}` | — |
| Individual Stock Price By Digichief Avg Volume52 | text | scalar | `{account.store.IndividualStockPriceByDigichief_avg_volume52}` | — |
| Individual Stock Price By Digichief Avg Volume6 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_avg_volume6_m}` | — |
| Individual Stock Price By Digichief Change | text | scalar | `{account.store.IndividualStockPriceByDigichief_change}` | — |
| Individual Stock Price By Digichief Change Percent | text | scalar | `{account.store.IndividualStockPriceByDigichief_change_percent}` | — |
| Individual Stock Price By Digichief Company Logo | img | scalar | `{account.store.IndividualStockPriceByDigichief_company_logo}` | — |
| Individual Stock Price By Digichief Delay | text | scalar | `{account.store.IndividualStockPriceByDigichief_delay}` | — |
| Individual Stock Price By Digichief Exchange Default Currency | text | scalar | `{account.store.IndividualStockPriceByDigichief_exchange_default_currency}` | — |
| Individual Stock Price By Digichief Exchange Name | text | scalar | `{account.store.IndividualStockPriceByDigichief_exchange_name}` | — |
| Individual Stock Price By Digichief Feed Last Run Had Errors | text | boolean | `{account.store.IndividualStockPriceByDigichief_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Individual Stock Price By Digichief Feed Last Run Was Success | text | boolean | `{account.store.IndividualStockPriceByDigichief_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Individual Stock Price By Digichief Feed Last Succesful Run At | text | datetime | `{account.store.IndividualStockPriceByDigichief_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Individual Stock Price By Digichief High | text | scalar | `{account.store.IndividualStockPriceByDigichief_high}` | — |
| Individual Stock Price By Digichief High Y T D | text | scalar | `{account.store.IndividualStockPriceByDigichief_high_y_t_d}` | — |
| Individual Stock Price By Digichief High1 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_high1_m}` | — |
| Individual Stock Price By Digichief High1 W | text | scalar | `{account.store.IndividualStockPriceByDigichief_high1_w}` | — |
| Individual Stock Price By Digichief High3 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_high3_m}` | — |
| Individual Stock Price By Digichief High52 | text | scalar | `{account.store.IndividualStockPriceByDigichief_high52}` | — |
| Individual Stock Price By Digichief High6 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_high6_m}` | — |
| Individual Stock Price By Digichief Low | text | scalar | `{account.store.IndividualStockPriceByDigichief_low}` | — |
| Individual Stock Price By Digichief Low Y T D | text | scalar | `{account.store.IndividualStockPriceByDigichief_low_y_t_d}` | — |
| Individual Stock Price By Digichief Low1 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_low1_m}` | — |
| Individual Stock Price By Digichief Low1 W | text | scalar | `{account.store.IndividualStockPriceByDigichief_low1_w}` | — |
| Individual Stock Price By Digichief Low3 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_low3_m}` | — |
| Individual Stock Price By Digichief Low52 | text | scalar | `{account.store.IndividualStockPriceByDigichief_low52}` | — |
| Individual Stock Price By Digichief Low6 M | text | scalar | `{account.store.IndividualStockPriceByDigichief_low6_m}` | — |
| Individual Stock Price By Digichief Most Recent Close | text | scalar | `{account.store.IndividualStockPriceByDigichief_most_recent_close}` | — |
| Individual Stock Price By Digichief Moving Average200 | text | scalar | `{account.store.IndividualStockPriceByDigichief_moving_average200}` | — |
| Individual Stock Price By Digichief Moving Average50 | text | scalar | `{account.store.IndividualStockPriceByDigichief_moving_average50}` | — |
| Individual Stock Price By Digichief Name | text | scalar | `{account.store.IndividualStockPriceByDigichief_name}` | — |
| Individual Stock Price By Digichief Netgr | text | scalar | `{account.store.IndividualStockPriceByDigichief_netgr}` | — |
| Individual Stock Price By Digichief Prev Close | text | scalar | `{account.store.IndividualStockPriceByDigichief_prev_close}` | — |
| Individual Stock Price By Digichief Price | text | float | `{account.store.IndividualStockPriceByDigichief_price}` | — |
| Individual Stock Price By Digichief Security Type Name | text | scalar | `{account.store.IndividualStockPriceByDigichief_security_type_name}` | — |
| Individual Stock Price By Digichief Short Name | text | scalar | `{account.store.IndividualStockPriceByDigichief_short_name}` | — |
| Individual Stock Price By Digichief Symbol | text | scalar | `{account.store.IndividualStockPriceByDigichief_symbol}` | — |
| Individual Stock Price By Digichief Type | text | scalar | `{account.store.IndividualStockPriceByDigichief_type}` | — |
| Individual Stock Price By Digichief Volume | text | scalar | `{account.store.IndividualStockPriceByDigichief_volume}` | — |



---

### Top Stocks

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Top Stocks dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Top Stocks**

To add values from Top Stocks to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Top Stocks `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Top Stocks or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Top Stocks data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Top Stocks:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **DIGICHIEF Customer Name** | `secret` | Enter the customer name provided to you along with your API key | Required |
| **DIGICHIEF API Key** | `secret` | Enter the API key provided to you by DIGICHIEF | Required |
| **Select a type** | `text` [(enum)](#select-a-type-options) | Select a type | Required |

**Enum Options:**

<a id="select-a-type-options"></a>

*Select a type:*

| Label | Value |
|-------|------|
| Top 10 Most Active | t10mostactive |
| Top 10 % Gainers | t10percentgainers |
| Top 10 % Losers | t10percentlosers |
| Top 10 Most Popular | t10mostpopular |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Top Active Stocks 0  Ask | text | scalar | `{account.store.TopActiveStocks_0__ask}` | — |
| Top Active Stocks 0  Ask Size | text | scalar | `{account.store.TopActiveStocks_0__ask_size}` | — |
| Top Active Stocks 0  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_0__avg_volume_y_t_d}` | — |
| Top Active Stocks 0  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_0__avg_volume1_m}` | — |
| Top Active Stocks 0  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_0__avg_volume1_w}` | — |
| Top Active Stocks 0  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_0__avg_volume3_m}` | — |
| Top Active Stocks 0  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_0__avg_volume52}` | — |
| Top Active Stocks 0  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_0__avg_volume6_m}` | — |
| Top Active Stocks 0  Change | text | scalar | `{account.store.TopActiveStocks_0__change}` | — |
| Top Active Stocks 0  Change Percent | text | scalar | `{account.store.TopActiveStocks_0__change_percent}` | — |
| Top Active Stocks 0  Company Logo | img | scalar | `{account.store.TopActiveStocks_0__company_logo}` | — |
| Top Active Stocks 0  Delay | text | scalar | `{account.store.TopActiveStocks_0__delay}` | — |
| Top Active Stocks 0  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_0__exchange_default_currency}` | — |
| Top Active Stocks 0  Exchange Name | text | scalar | `{account.store.TopActiveStocks_0__exchange_name}` | — |
| Top Active Stocks 0  High | text | scalar | `{account.store.TopActiveStocks_0__high}` | — |
| Top Active Stocks 0  High Y T D | text | scalar | `{account.store.TopActiveStocks_0__high_y_t_d}` | — |
| Top Active Stocks 0  High1 M | text | scalar | `{account.store.TopActiveStocks_0__high1_m}` | — |
| Top Active Stocks 0  High1 W | text | scalar | `{account.store.TopActiveStocks_0__high1_w}` | — |
| Top Active Stocks 0  High3 M | text | scalar | `{account.store.TopActiveStocks_0__high3_m}` | — |
| Top Active Stocks 0  High52 | text | scalar | `{account.store.TopActiveStocks_0__high52}` | — |
| Top Active Stocks 0  High6 M | text | scalar | `{account.store.TopActiveStocks_0__high6_m}` | — |
| Top Active Stocks 0  Low | text | scalar | `{account.store.TopActiveStocks_0__low}` | — |
| Top Active Stocks 0  Low Y T D | text | scalar | `{account.store.TopActiveStocks_0__low_y_t_d}` | — |
| Top Active Stocks 0  Low1 M | text | scalar | `{account.store.TopActiveStocks_0__low1_m}` | — |
| Top Active Stocks 0  Low1 W | text | scalar | `{account.store.TopActiveStocks_0__low1_w}` | — |
| Top Active Stocks 0  Low3 M | text | scalar | `{account.store.TopActiveStocks_0__low3_m}` | — |
| Top Active Stocks 0  Low52 | text | scalar | `{account.store.TopActiveStocks_0__low52}` | — |
| Top Active Stocks 0  Low6 M | text | scalar | `{account.store.TopActiveStocks_0__low6_m}` | — |
| Top Active Stocks 0  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_0__most_recent_close}` | — |
| Top Active Stocks 0  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_0__moving_average200}` | — |
| Top Active Stocks 0  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_0__moving_average50}` | — |
| Top Active Stocks 0  Name | text | scalar | `{account.store.TopActiveStocks_0__name}` | — |
| Top Active Stocks 0  Netgr | text | scalar | `{account.store.TopActiveStocks_0__netgr}` | — |
| Top Active Stocks 0  Prev Close | text | scalar | `{account.store.TopActiveStocks_0__prev_close}` | — |
| Top Active Stocks 0  Price | text | float | `{account.store.TopActiveStocks_0__price}` | — |
| Top Active Stocks 0  Security Type Name | text | scalar | `{account.store.TopActiveStocks_0__security_type_name}` | — |
| Top Active Stocks 0  Short Name | text | scalar | `{account.store.TopActiveStocks_0__short_name}` | — |
| Top Active Stocks 0  Symbol | text | scalar | `{account.store.TopActiveStocks_0__symbol}` | — |
| Top Active Stocks 0  Type | text | scalar | `{account.store.TopActiveStocks_0__type}` | — |
| Top Active Stocks 0  Volume | text | scalar | `{account.store.TopActiveStocks_0__volume}` | — |
| Top Active Stocks 1  Ask | text | scalar | `{account.store.TopActiveStocks_1__ask}` | — |
| Top Active Stocks 1  Ask Size | text | scalar | `{account.store.TopActiveStocks_1__ask_size}` | — |
| Top Active Stocks 1  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_1__avg_volume_y_t_d}` | — |
| Top Active Stocks 1  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_1__avg_volume1_m}` | — |
| Top Active Stocks 1  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_1__avg_volume1_w}` | — |
| Top Active Stocks 1  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_1__avg_volume3_m}` | — |
| Top Active Stocks 1  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_1__avg_volume52}` | — |
| Top Active Stocks 1  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_1__avg_volume6_m}` | — |
| Top Active Stocks 1  Change | text | scalar | `{account.store.TopActiveStocks_1__change}` | — |
| Top Active Stocks 1  Change Percent | text | scalar | `{account.store.TopActiveStocks_1__change_percent}` | — |
| Top Active Stocks 1  Company Logo | img | scalar | `{account.store.TopActiveStocks_1__company_logo}` | — |
| Top Active Stocks 1  Delay | text | scalar | `{account.store.TopActiveStocks_1__delay}` | — |
| Top Active Stocks 1  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_1__exchange_default_currency}` | — |
| Top Active Stocks 1  Exchange Name | text | scalar | `{account.store.TopActiveStocks_1__exchange_name}` | — |
| Top Active Stocks 1  High | text | scalar | `{account.store.TopActiveStocks_1__high}` | — |
| Top Active Stocks 1  High Y T D | text | scalar | `{account.store.TopActiveStocks_1__high_y_t_d}` | — |
| Top Active Stocks 1  High1 M | text | scalar | `{account.store.TopActiveStocks_1__high1_m}` | — |
| Top Active Stocks 1  High1 W | text | scalar | `{account.store.TopActiveStocks_1__high1_w}` | — |
| Top Active Stocks 1  High3 M | text | scalar | `{account.store.TopActiveStocks_1__high3_m}` | — |
| Top Active Stocks 1  High52 | text | scalar | `{account.store.TopActiveStocks_1__high52}` | — |
| Top Active Stocks 1  High6 M | text | scalar | `{account.store.TopActiveStocks_1__high6_m}` | — |
| Top Active Stocks 1  Low | text | scalar | `{account.store.TopActiveStocks_1__low}` | — |
| Top Active Stocks 1  Low Y T D | text | scalar | `{account.store.TopActiveStocks_1__low_y_t_d}` | — |
| Top Active Stocks 1  Low1 M | text | scalar | `{account.store.TopActiveStocks_1__low1_m}` | — |
| Top Active Stocks 1  Low1 W | text | scalar | `{account.store.TopActiveStocks_1__low1_w}` | — |
| Top Active Stocks 1  Low3 M | text | scalar | `{account.store.TopActiveStocks_1__low3_m}` | — |
| Top Active Stocks 1  Low52 | text | scalar | `{account.store.TopActiveStocks_1__low52}` | — |
| Top Active Stocks 1  Low6 M | text | scalar | `{account.store.TopActiveStocks_1__low6_m}` | — |
| Top Active Stocks 1  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_1__most_recent_close}` | — |
| Top Active Stocks 1  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_1__moving_average200}` | — |
| Top Active Stocks 1  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_1__moving_average50}` | — |
| Top Active Stocks 1  Name | text | scalar | `{account.store.TopActiveStocks_1__name}` | — |
| Top Active Stocks 1  Netgr | text | scalar | `{account.store.TopActiveStocks_1__netgr}` | — |
| Top Active Stocks 1  Prev Close | text | scalar | `{account.store.TopActiveStocks_1__prev_close}` | — |
| Top Active Stocks 1  Price | text | float | `{account.store.TopActiveStocks_1__price}` | — |
| Top Active Stocks 1  Security Type Name | text | scalar | `{account.store.TopActiveStocks_1__security_type_name}` | — |
| Top Active Stocks 1  Short Name | text | scalar | `{account.store.TopActiveStocks_1__short_name}` | — |
| Top Active Stocks 1  Symbol | text | scalar | `{account.store.TopActiveStocks_1__symbol}` | — |
| Top Active Stocks 1  Type | text | scalar | `{account.store.TopActiveStocks_1__type}` | — |
| Top Active Stocks 1  Volume | text | scalar | `{account.store.TopActiveStocks_1__volume}` | — |
| Top Active Stocks 2  Ask | text | scalar | `{account.store.TopActiveStocks_2__ask}` | — |
| Top Active Stocks 2  Ask Size | text | scalar | `{account.store.TopActiveStocks_2__ask_size}` | — |
| Top Active Stocks 2  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_2__avg_volume_y_t_d}` | — |
| Top Active Stocks 2  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_2__avg_volume1_m}` | — |
| Top Active Stocks 2  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_2__avg_volume1_w}` | — |
| Top Active Stocks 2  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_2__avg_volume3_m}` | — |
| Top Active Stocks 2  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_2__avg_volume52}` | — |
| Top Active Stocks 2  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_2__avg_volume6_m}` | — |
| Top Active Stocks 2  Change | text | scalar | `{account.store.TopActiveStocks_2__change}` | — |
| Top Active Stocks 2  Change Percent | text | scalar | `{account.store.TopActiveStocks_2__change_percent}` | — |
| Top Active Stocks 2  Company Logo | img | scalar | `{account.store.TopActiveStocks_2__company_logo}` | — |
| Top Active Stocks 2  Delay | text | scalar | `{account.store.TopActiveStocks_2__delay}` | — |
| Top Active Stocks 2  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_2__exchange_default_currency}` | — |
| Top Active Stocks 2  Exchange Name | text | scalar | `{account.store.TopActiveStocks_2__exchange_name}` | — |
| Top Active Stocks 2  High | text | scalar | `{account.store.TopActiveStocks_2__high}` | — |
| Top Active Stocks 2  High Y T D | text | scalar | `{account.store.TopActiveStocks_2__high_y_t_d}` | — |
| Top Active Stocks 2  High1 M | text | scalar | `{account.store.TopActiveStocks_2__high1_m}` | — |
| Top Active Stocks 2  High1 W | text | scalar | `{account.store.TopActiveStocks_2__high1_w}` | — |
| Top Active Stocks 2  High3 M | text | scalar | `{account.store.TopActiveStocks_2__high3_m}` | — |
| Top Active Stocks 2  High52 | text | scalar | `{account.store.TopActiveStocks_2__high52}` | — |
| Top Active Stocks 2  High6 M | text | scalar | `{account.store.TopActiveStocks_2__high6_m}` | — |
| Top Active Stocks 2  Low | text | scalar | `{account.store.TopActiveStocks_2__low}` | — |
| Top Active Stocks 2  Low Y T D | text | scalar | `{account.store.TopActiveStocks_2__low_y_t_d}` | — |
| Top Active Stocks 2  Low1 M | text | scalar | `{account.store.TopActiveStocks_2__low1_m}` | — |
| Top Active Stocks 2  Low1 W | text | scalar | `{account.store.TopActiveStocks_2__low1_w}` | — |
| Top Active Stocks 2  Low3 M | text | scalar | `{account.store.TopActiveStocks_2__low3_m}` | — |
| Top Active Stocks 2  Low52 | text | scalar | `{account.store.TopActiveStocks_2__low52}` | — |
| Top Active Stocks 2  Low6 M | text | scalar | `{account.store.TopActiveStocks_2__low6_m}` | — |
| Top Active Stocks 2  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_2__most_recent_close}` | — |
| Top Active Stocks 2  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_2__moving_average200}` | — |
| Top Active Stocks 2  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_2__moving_average50}` | — |
| Top Active Stocks 2  Name | text | scalar | `{account.store.TopActiveStocks_2__name}` | — |
| Top Active Stocks 2  Netgr | text | scalar | `{account.store.TopActiveStocks_2__netgr}` | — |
| Top Active Stocks 2  Prev Close | text | scalar | `{account.store.TopActiveStocks_2__prev_close}` | — |
| Top Active Stocks 2  Price | text | float | `{account.store.TopActiveStocks_2__price}` | — |
| Top Active Stocks 2  Security Type Name | text | scalar | `{account.store.TopActiveStocks_2__security_type_name}` | — |
| Top Active Stocks 2  Short Name | text | scalar | `{account.store.TopActiveStocks_2__short_name}` | — |
| Top Active Stocks 2  Symbol | text | scalar | `{account.store.TopActiveStocks_2__symbol}` | — |
| Top Active Stocks 2  Type | text | scalar | `{account.store.TopActiveStocks_2__type}` | — |
| Top Active Stocks 2  Volume | text | scalar | `{account.store.TopActiveStocks_2__volume}` | — |
| Top Active Stocks 3  Ask | text | scalar | `{account.store.TopActiveStocks_3__ask}` | — |
| Top Active Stocks 3  Ask Size | text | scalar | `{account.store.TopActiveStocks_3__ask_size}` | — |
| Top Active Stocks 3  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_3__avg_volume_y_t_d}` | — |
| Top Active Stocks 3  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_3__avg_volume1_m}` | — |
| Top Active Stocks 3  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_3__avg_volume1_w}` | — |
| Top Active Stocks 3  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_3__avg_volume3_m}` | — |
| Top Active Stocks 3  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_3__avg_volume52}` | — |
| Top Active Stocks 3  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_3__avg_volume6_m}` | — |
| Top Active Stocks 3  Change | text | scalar | `{account.store.TopActiveStocks_3__change}` | — |
| Top Active Stocks 3  Change Percent | text | scalar | `{account.store.TopActiveStocks_3__change_percent}` | — |
| Top Active Stocks 3  Company Logo | img | scalar | `{account.store.TopActiveStocks_3__company_logo}` | — |
| Top Active Stocks 3  Delay | text | scalar | `{account.store.TopActiveStocks_3__delay}` | — |
| Top Active Stocks 3  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_3__exchange_default_currency}` | — |
| Top Active Stocks 3  Exchange Name | text | scalar | `{account.store.TopActiveStocks_3__exchange_name}` | — |
| Top Active Stocks 3  High | text | scalar | `{account.store.TopActiveStocks_3__high}` | — |
| Top Active Stocks 3  High Y T D | text | scalar | `{account.store.TopActiveStocks_3__high_y_t_d}` | — |
| Top Active Stocks 3  High1 M | text | scalar | `{account.store.TopActiveStocks_3__high1_m}` | — |
| Top Active Stocks 3  High1 W | text | scalar | `{account.store.TopActiveStocks_3__high1_w}` | — |
| Top Active Stocks 3  High3 M | text | scalar | `{account.store.TopActiveStocks_3__high3_m}` | — |
| Top Active Stocks 3  High52 | text | scalar | `{account.store.TopActiveStocks_3__high52}` | — |
| Top Active Stocks 3  High6 M | text | scalar | `{account.store.TopActiveStocks_3__high6_m}` | — |
| Top Active Stocks 3  Low | text | scalar | `{account.store.TopActiveStocks_3__low}` | — |
| Top Active Stocks 3  Low Y T D | text | scalar | `{account.store.TopActiveStocks_3__low_y_t_d}` | — |
| Top Active Stocks 3  Low1 M | text | scalar | `{account.store.TopActiveStocks_3__low1_m}` | — |
| Top Active Stocks 3  Low1 W | text | scalar | `{account.store.TopActiveStocks_3__low1_w}` | — |
| Top Active Stocks 3  Low3 M | text | scalar | `{account.store.TopActiveStocks_3__low3_m}` | — |
| Top Active Stocks 3  Low52 | text | scalar | `{account.store.TopActiveStocks_3__low52}` | — |
| Top Active Stocks 3  Low6 M | text | scalar | `{account.store.TopActiveStocks_3__low6_m}` | — |
| Top Active Stocks 3  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_3__most_recent_close}` | — |
| Top Active Stocks 3  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_3__moving_average200}` | — |
| Top Active Stocks 3  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_3__moving_average50}` | — |
| Top Active Stocks 3  Name | text | scalar | `{account.store.TopActiveStocks_3__name}` | — |
| Top Active Stocks 3  Netgr | text | scalar | `{account.store.TopActiveStocks_3__netgr}` | — |
| Top Active Stocks 3  Prev Close | text | scalar | `{account.store.TopActiveStocks_3__prev_close}` | — |
| Top Active Stocks 3  Price | text | float | `{account.store.TopActiveStocks_3__price}` | — |
| Top Active Stocks 3  Security Type Name | text | scalar | `{account.store.TopActiveStocks_3__security_type_name}` | — |
| Top Active Stocks 3  Short Name | text | scalar | `{account.store.TopActiveStocks_3__short_name}` | — |
| Top Active Stocks 3  Symbol | text | scalar | `{account.store.TopActiveStocks_3__symbol}` | — |
| Top Active Stocks 3  Type | text | scalar | `{account.store.TopActiveStocks_3__type}` | — |
| Top Active Stocks 3  Volume | text | scalar | `{account.store.TopActiveStocks_3__volume}` | — |
| Top Active Stocks 4  Ask | text | scalar | `{account.store.TopActiveStocks_4__ask}` | — |
| Top Active Stocks 4  Ask Size | text | scalar | `{account.store.TopActiveStocks_4__ask_size}` | — |
| Top Active Stocks 4  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_4__avg_volume_y_t_d}` | — |
| Top Active Stocks 4  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_4__avg_volume1_m}` | — |
| Top Active Stocks 4  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_4__avg_volume1_w}` | — |
| Top Active Stocks 4  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_4__avg_volume3_m}` | — |
| Top Active Stocks 4  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_4__avg_volume52}` | — |
| Top Active Stocks 4  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_4__avg_volume6_m}` | — |
| Top Active Stocks 4  Change | text | scalar | `{account.store.TopActiveStocks_4__change}` | — |
| Top Active Stocks 4  Change Percent | text | scalar | `{account.store.TopActiveStocks_4__change_percent}` | — |
| Top Active Stocks 4  Company Logo | img | scalar | `{account.store.TopActiveStocks_4__company_logo}` | — |
| Top Active Stocks 4  Delay | text | scalar | `{account.store.TopActiveStocks_4__delay}` | — |
| Top Active Stocks 4  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_4__exchange_default_currency}` | — |
| Top Active Stocks 4  Exchange Name | text | scalar | `{account.store.TopActiveStocks_4__exchange_name}` | — |
| Top Active Stocks 4  High | text | scalar | `{account.store.TopActiveStocks_4__high}` | — |
| Top Active Stocks 4  High Y T D | text | scalar | `{account.store.TopActiveStocks_4__high_y_t_d}` | — |
| Top Active Stocks 4  High1 M | text | scalar | `{account.store.TopActiveStocks_4__high1_m}` | — |
| Top Active Stocks 4  High1 W | text | scalar | `{account.store.TopActiveStocks_4__high1_w}` | — |
| Top Active Stocks 4  High3 M | text | scalar | `{account.store.TopActiveStocks_4__high3_m}` | — |
| Top Active Stocks 4  High52 | text | scalar | `{account.store.TopActiveStocks_4__high52}` | — |
| Top Active Stocks 4  High6 M | text | scalar | `{account.store.TopActiveStocks_4__high6_m}` | — |
| Top Active Stocks 4  Low | text | scalar | `{account.store.TopActiveStocks_4__low}` | — |
| Top Active Stocks 4  Low Y T D | text | scalar | `{account.store.TopActiveStocks_4__low_y_t_d}` | — |
| Top Active Stocks 4  Low1 M | text | scalar | `{account.store.TopActiveStocks_4__low1_m}` | — |
| Top Active Stocks 4  Low1 W | text | scalar | `{account.store.TopActiveStocks_4__low1_w}` | — |
| Top Active Stocks 4  Low3 M | text | scalar | `{account.store.TopActiveStocks_4__low3_m}` | — |
| Top Active Stocks 4  Low52 | text | scalar | `{account.store.TopActiveStocks_4__low52}` | — |
| Top Active Stocks 4  Low6 M | text | scalar | `{account.store.TopActiveStocks_4__low6_m}` | — |
| Top Active Stocks 4  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_4__most_recent_close}` | — |
| Top Active Stocks 4  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_4__moving_average200}` | — |
| Top Active Stocks 4  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_4__moving_average50}` | — |
| Top Active Stocks 4  Name | text | scalar | `{account.store.TopActiveStocks_4__name}` | — |
| Top Active Stocks 4  Netgr | text | scalar | `{account.store.TopActiveStocks_4__netgr}` | — |
| Top Active Stocks 4  Prev Close | text | scalar | `{account.store.TopActiveStocks_4__prev_close}` | — |
| Top Active Stocks 4  Price | text | float | `{account.store.TopActiveStocks_4__price}` | — |
| Top Active Stocks 4  Security Type Name | text | scalar | `{account.store.TopActiveStocks_4__security_type_name}` | — |
| Top Active Stocks 4  Short Name | text | scalar | `{account.store.TopActiveStocks_4__short_name}` | — |
| Top Active Stocks 4  Symbol | text | scalar | `{account.store.TopActiveStocks_4__symbol}` | — |
| Top Active Stocks 4  Type | text | scalar | `{account.store.TopActiveStocks_4__type}` | — |
| Top Active Stocks 4  Volume | text | scalar | `{account.store.TopActiveStocks_4__volume}` | — |
| Top Active Stocks 5  Ask | text | scalar | `{account.store.TopActiveStocks_5__ask}` | — |
| Top Active Stocks 5  Ask Size | text | scalar | `{account.store.TopActiveStocks_5__ask_size}` | — |
| Top Active Stocks 5  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_5__avg_volume_y_t_d}` | — |
| Top Active Stocks 5  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_5__avg_volume1_m}` | — |
| Top Active Stocks 5  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_5__avg_volume1_w}` | — |
| Top Active Stocks 5  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_5__avg_volume3_m}` | — |
| Top Active Stocks 5  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_5__avg_volume52}` | — |
| Top Active Stocks 5  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_5__avg_volume6_m}` | — |
| Top Active Stocks 5  Change | text | scalar | `{account.store.TopActiveStocks_5__change}` | — |
| Top Active Stocks 5  Change Percent | text | scalar | `{account.store.TopActiveStocks_5__change_percent}` | — |
| Top Active Stocks 5  Company Logo | img | scalar | `{account.store.TopActiveStocks_5__company_logo}` | — |
| Top Active Stocks 5  Delay | text | scalar | `{account.store.TopActiveStocks_5__delay}` | — |
| Top Active Stocks 5  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_5__exchange_default_currency}` | — |
| Top Active Stocks 5  Exchange Name | text | scalar | `{account.store.TopActiveStocks_5__exchange_name}` | — |
| Top Active Stocks 5  High | text | scalar | `{account.store.TopActiveStocks_5__high}` | — |
| Top Active Stocks 5  High Y T D | text | scalar | `{account.store.TopActiveStocks_5__high_y_t_d}` | — |
| Top Active Stocks 5  High1 M | text | scalar | `{account.store.TopActiveStocks_5__high1_m}` | — |
| Top Active Stocks 5  High1 W | text | scalar | `{account.store.TopActiveStocks_5__high1_w}` | — |
| Top Active Stocks 5  High3 M | text | scalar | `{account.store.TopActiveStocks_5__high3_m}` | — |
| Top Active Stocks 5  High52 | text | scalar | `{account.store.TopActiveStocks_5__high52}` | — |
| Top Active Stocks 5  High6 M | text | scalar | `{account.store.TopActiveStocks_5__high6_m}` | — |
| Top Active Stocks 5  Low | text | scalar | `{account.store.TopActiveStocks_5__low}` | — |
| Top Active Stocks 5  Low Y T D | text | scalar | `{account.store.TopActiveStocks_5__low_y_t_d}` | — |
| Top Active Stocks 5  Low1 M | text | scalar | `{account.store.TopActiveStocks_5__low1_m}` | — |
| Top Active Stocks 5  Low1 W | text | scalar | `{account.store.TopActiveStocks_5__low1_w}` | — |
| Top Active Stocks 5  Low3 M | text | scalar | `{account.store.TopActiveStocks_5__low3_m}` | — |
| Top Active Stocks 5  Low52 | text | scalar | `{account.store.TopActiveStocks_5__low52}` | — |
| Top Active Stocks 5  Low6 M | text | scalar | `{account.store.TopActiveStocks_5__low6_m}` | — |
| Top Active Stocks 5  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_5__most_recent_close}` | — |
| Top Active Stocks 5  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_5__moving_average200}` | — |
| Top Active Stocks 5  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_5__moving_average50}` | — |
| Top Active Stocks 5  Name | text | scalar | `{account.store.TopActiveStocks_5__name}` | — |
| Top Active Stocks 5  Netgr | text | scalar | `{account.store.TopActiveStocks_5__netgr}` | — |
| Top Active Stocks 5  Prev Close | text | scalar | `{account.store.TopActiveStocks_5__prev_close}` | — |
| Top Active Stocks 5  Price | text | float | `{account.store.TopActiveStocks_5__price}` | — |
| Top Active Stocks 5  Security Type Name | text | scalar | `{account.store.TopActiveStocks_5__security_type_name}` | — |
| Top Active Stocks 5  Short Name | text | scalar | `{account.store.TopActiveStocks_5__short_name}` | — |
| Top Active Stocks 5  Symbol | text | scalar | `{account.store.TopActiveStocks_5__symbol}` | — |
| Top Active Stocks 5  Type | text | scalar | `{account.store.TopActiveStocks_5__type}` | — |
| Top Active Stocks 5  Volume | text | scalar | `{account.store.TopActiveStocks_5__volume}` | — |
| Top Active Stocks 6  Ask | text | scalar | `{account.store.TopActiveStocks_6__ask}` | — |
| Top Active Stocks 6  Ask Size | text | scalar | `{account.store.TopActiveStocks_6__ask_size}` | — |
| Top Active Stocks 6  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_6__avg_volume_y_t_d}` | — |
| Top Active Stocks 6  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_6__avg_volume1_m}` | — |
| Top Active Stocks 6  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_6__avg_volume1_w}` | — |
| Top Active Stocks 6  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_6__avg_volume3_m}` | — |
| Top Active Stocks 6  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_6__avg_volume52}` | — |
| Top Active Stocks 6  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_6__avg_volume6_m}` | — |
| Top Active Stocks 6  Change | text | scalar | `{account.store.TopActiveStocks_6__change}` | — |
| Top Active Stocks 6  Change Percent | text | scalar | `{account.store.TopActiveStocks_6__change_percent}` | — |
| Top Active Stocks 6  Company Logo | img | scalar | `{account.store.TopActiveStocks_6__company_logo}` | — |
| Top Active Stocks 6  Delay | text | scalar | `{account.store.TopActiveStocks_6__delay}` | — |
| Top Active Stocks 6  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_6__exchange_default_currency}` | — |
| Top Active Stocks 6  Exchange Name | text | scalar | `{account.store.TopActiveStocks_6__exchange_name}` | — |
| Top Active Stocks 6  High | text | scalar | `{account.store.TopActiveStocks_6__high}` | — |
| Top Active Stocks 6  High Y T D | text | scalar | `{account.store.TopActiveStocks_6__high_y_t_d}` | — |
| Top Active Stocks 6  High1 M | text | scalar | `{account.store.TopActiveStocks_6__high1_m}` | — |
| Top Active Stocks 6  High1 W | text | scalar | `{account.store.TopActiveStocks_6__high1_w}` | — |
| Top Active Stocks 6  High3 M | text | scalar | `{account.store.TopActiveStocks_6__high3_m}` | — |
| Top Active Stocks 6  High52 | text | scalar | `{account.store.TopActiveStocks_6__high52}` | — |
| Top Active Stocks 6  High6 M | text | scalar | `{account.store.TopActiveStocks_6__high6_m}` | — |
| Top Active Stocks 6  Low | text | scalar | `{account.store.TopActiveStocks_6__low}` | — |
| Top Active Stocks 6  Low Y T D | text | scalar | `{account.store.TopActiveStocks_6__low_y_t_d}` | — |
| Top Active Stocks 6  Low1 M | text | scalar | `{account.store.TopActiveStocks_6__low1_m}` | — |
| Top Active Stocks 6  Low1 W | text | scalar | `{account.store.TopActiveStocks_6__low1_w}` | — |
| Top Active Stocks 6  Low3 M | text | scalar | `{account.store.TopActiveStocks_6__low3_m}` | — |
| Top Active Stocks 6  Low52 | text | scalar | `{account.store.TopActiveStocks_6__low52}` | — |
| Top Active Stocks 6  Low6 M | text | scalar | `{account.store.TopActiveStocks_6__low6_m}` | — |
| Top Active Stocks 6  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_6__most_recent_close}` | — |
| Top Active Stocks 6  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_6__moving_average200}` | — |
| Top Active Stocks 6  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_6__moving_average50}` | — |
| Top Active Stocks 6  Name | text | scalar | `{account.store.TopActiveStocks_6__name}` | — |
| Top Active Stocks 6  Netgr | text | scalar | `{account.store.TopActiveStocks_6__netgr}` | — |
| Top Active Stocks 6  Prev Close | text | scalar | `{account.store.TopActiveStocks_6__prev_close}` | — |
| Top Active Stocks 6  Price | text | float | `{account.store.TopActiveStocks_6__price}` | — |
| Top Active Stocks 6  Security Type Name | text | scalar | `{account.store.TopActiveStocks_6__security_type_name}` | — |
| Top Active Stocks 6  Short Name | text | scalar | `{account.store.TopActiveStocks_6__short_name}` | — |
| Top Active Stocks 6  Symbol | text | scalar | `{account.store.TopActiveStocks_6__symbol}` | — |
| Top Active Stocks 6  Type | text | scalar | `{account.store.TopActiveStocks_6__type}` | — |
| Top Active Stocks 6  Volume | text | scalar | `{account.store.TopActiveStocks_6__volume}` | — |
| Top Active Stocks 7  Ask | text | scalar | `{account.store.TopActiveStocks_7__ask}` | — |
| Top Active Stocks 7  Ask Size | text | scalar | `{account.store.TopActiveStocks_7__ask_size}` | — |
| Top Active Stocks 7  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_7__avg_volume_y_t_d}` | — |
| Top Active Stocks 7  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_7__avg_volume1_m}` | — |
| Top Active Stocks 7  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_7__avg_volume1_w}` | — |
| Top Active Stocks 7  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_7__avg_volume3_m}` | — |
| Top Active Stocks 7  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_7__avg_volume52}` | — |
| Top Active Stocks 7  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_7__avg_volume6_m}` | — |
| Top Active Stocks 7  Change | text | scalar | `{account.store.TopActiveStocks_7__change}` | — |
| Top Active Stocks 7  Change Percent | text | scalar | `{account.store.TopActiveStocks_7__change_percent}` | — |
| Top Active Stocks 7  Company Logo | img | scalar | `{account.store.TopActiveStocks_7__company_logo}` | — |
| Top Active Stocks 7  Delay | text | scalar | `{account.store.TopActiveStocks_7__delay}` | — |
| Top Active Stocks 7  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_7__exchange_default_currency}` | — |
| Top Active Stocks 7  Exchange Name | text | scalar | `{account.store.TopActiveStocks_7__exchange_name}` | — |
| Top Active Stocks 7  High | text | scalar | `{account.store.TopActiveStocks_7__high}` | — |
| Top Active Stocks 7  High Y T D | text | scalar | `{account.store.TopActiveStocks_7__high_y_t_d}` | — |
| Top Active Stocks 7  High1 M | text | scalar | `{account.store.TopActiveStocks_7__high1_m}` | — |
| Top Active Stocks 7  High1 W | text | scalar | `{account.store.TopActiveStocks_7__high1_w}` | — |
| Top Active Stocks 7  High3 M | text | scalar | `{account.store.TopActiveStocks_7__high3_m}` | — |
| Top Active Stocks 7  High52 | text | scalar | `{account.store.TopActiveStocks_7__high52}` | — |
| Top Active Stocks 7  High6 M | text | scalar | `{account.store.TopActiveStocks_7__high6_m}` | — |
| Top Active Stocks 7  Low | text | scalar | `{account.store.TopActiveStocks_7__low}` | — |
| Top Active Stocks 7  Low Y T D | text | scalar | `{account.store.TopActiveStocks_7__low_y_t_d}` | — |
| Top Active Stocks 7  Low1 M | text | scalar | `{account.store.TopActiveStocks_7__low1_m}` | — |
| Top Active Stocks 7  Low1 W | text | scalar | `{account.store.TopActiveStocks_7__low1_w}` | — |
| Top Active Stocks 7  Low3 M | text | scalar | `{account.store.TopActiveStocks_7__low3_m}` | — |
| Top Active Stocks 7  Low52 | text | scalar | `{account.store.TopActiveStocks_7__low52}` | — |
| Top Active Stocks 7  Low6 M | text | scalar | `{account.store.TopActiveStocks_7__low6_m}` | — |
| Top Active Stocks 7  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_7__most_recent_close}` | — |
| Top Active Stocks 7  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_7__moving_average200}` | — |
| Top Active Stocks 7  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_7__moving_average50}` | — |
| Top Active Stocks 7  Name | text | scalar | `{account.store.TopActiveStocks_7__name}` | — |
| Top Active Stocks 7  Netgr | text | scalar | `{account.store.TopActiveStocks_7__netgr}` | — |
| Top Active Stocks 7  Prev Close | text | scalar | `{account.store.TopActiveStocks_7__prev_close}` | — |
| Top Active Stocks 7  Price | text | float | `{account.store.TopActiveStocks_7__price}` | — |
| Top Active Stocks 7  Security Type Name | text | scalar | `{account.store.TopActiveStocks_7__security_type_name}` | — |
| Top Active Stocks 7  Short Name | text | scalar | `{account.store.TopActiveStocks_7__short_name}` | — |
| Top Active Stocks 7  Symbol | text | scalar | `{account.store.TopActiveStocks_7__symbol}` | — |
| Top Active Stocks 7  Type | text | scalar | `{account.store.TopActiveStocks_7__type}` | — |
| Top Active Stocks 7  Volume | text | scalar | `{account.store.TopActiveStocks_7__volume}` | — |
| Top Active Stocks 8  Ask | text | scalar | `{account.store.TopActiveStocks_8__ask}` | — |
| Top Active Stocks 8  Ask Size | text | scalar | `{account.store.TopActiveStocks_8__ask_size}` | — |
| Top Active Stocks 8  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_8__avg_volume_y_t_d}` | — |
| Top Active Stocks 8  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_8__avg_volume1_m}` | — |
| Top Active Stocks 8  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_8__avg_volume1_w}` | — |
| Top Active Stocks 8  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_8__avg_volume3_m}` | — |
| Top Active Stocks 8  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_8__avg_volume52}` | — |
| Top Active Stocks 8  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_8__avg_volume6_m}` | — |
| Top Active Stocks 8  Change | text | scalar | `{account.store.TopActiveStocks_8__change}` | — |
| Top Active Stocks 8  Change Percent | text | scalar | `{account.store.TopActiveStocks_8__change_percent}` | — |
| Top Active Stocks 8  Company Logo | img | scalar | `{account.store.TopActiveStocks_8__company_logo}` | — |
| Top Active Stocks 8  Delay | text | scalar | `{account.store.TopActiveStocks_8__delay}` | — |
| Top Active Stocks 8  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_8__exchange_default_currency}` | — |
| Top Active Stocks 8  Exchange Name | text | scalar | `{account.store.TopActiveStocks_8__exchange_name}` | — |
| Top Active Stocks 8  High | text | scalar | `{account.store.TopActiveStocks_8__high}` | — |
| Top Active Stocks 8  High Y T D | text | scalar | `{account.store.TopActiveStocks_8__high_y_t_d}` | — |
| Top Active Stocks 8  High1 M | text | scalar | `{account.store.TopActiveStocks_8__high1_m}` | — |
| Top Active Stocks 8  High1 W | text | scalar | `{account.store.TopActiveStocks_8__high1_w}` | — |
| Top Active Stocks 8  High3 M | text | scalar | `{account.store.TopActiveStocks_8__high3_m}` | — |
| Top Active Stocks 8  High52 | text | scalar | `{account.store.TopActiveStocks_8__high52}` | — |
| Top Active Stocks 8  High6 M | text | scalar | `{account.store.TopActiveStocks_8__high6_m}` | — |
| Top Active Stocks 8  Low | text | scalar | `{account.store.TopActiveStocks_8__low}` | — |
| Top Active Stocks 8  Low Y T D | text | scalar | `{account.store.TopActiveStocks_8__low_y_t_d}` | — |
| Top Active Stocks 8  Low1 M | text | scalar | `{account.store.TopActiveStocks_8__low1_m}` | — |
| Top Active Stocks 8  Low1 W | text | scalar | `{account.store.TopActiveStocks_8__low1_w}` | — |
| Top Active Stocks 8  Low3 M | text | scalar | `{account.store.TopActiveStocks_8__low3_m}` | — |
| Top Active Stocks 8  Low52 | text | scalar | `{account.store.TopActiveStocks_8__low52}` | — |
| Top Active Stocks 8  Low6 M | text | scalar | `{account.store.TopActiveStocks_8__low6_m}` | — |
| Top Active Stocks 8  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_8__most_recent_close}` | — |
| Top Active Stocks 8  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_8__moving_average200}` | — |
| Top Active Stocks 8  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_8__moving_average50}` | — |
| Top Active Stocks 8  Name | text | scalar | `{account.store.TopActiveStocks_8__name}` | — |
| Top Active Stocks 8  Netgr | text | scalar | `{account.store.TopActiveStocks_8__netgr}` | — |
| Top Active Stocks 8  Prev Close | text | scalar | `{account.store.TopActiveStocks_8__prev_close}` | — |
| Top Active Stocks 8  Price | text | float | `{account.store.TopActiveStocks_8__price}` | — |
| Top Active Stocks 8  Security Type Name | text | scalar | `{account.store.TopActiveStocks_8__security_type_name}` | — |
| Top Active Stocks 8  Short Name | text | scalar | `{account.store.TopActiveStocks_8__short_name}` | — |
| Top Active Stocks 8  Symbol | text | scalar | `{account.store.TopActiveStocks_8__symbol}` | — |
| Top Active Stocks 8  Type | text | scalar | `{account.store.TopActiveStocks_8__type}` | — |
| Top Active Stocks 8  Volume | text | scalar | `{account.store.TopActiveStocks_8__volume}` | — |
| Top Active Stocks 9  Ask | text | scalar | `{account.store.TopActiveStocks_9__ask}` | — |
| Top Active Stocks 9  Ask Size | text | scalar | `{account.store.TopActiveStocks_9__ask_size}` | — |
| Top Active Stocks 9  Avg Volume Y T D | text | scalar | `{account.store.TopActiveStocks_9__avg_volume_y_t_d}` | — |
| Top Active Stocks 9  Avg Volume1 M | text | scalar | `{account.store.TopActiveStocks_9__avg_volume1_m}` | — |
| Top Active Stocks 9  Avg Volume1 W | text | scalar | `{account.store.TopActiveStocks_9__avg_volume1_w}` | — |
| Top Active Stocks 9  Avg Volume3 M | text | scalar | `{account.store.TopActiveStocks_9__avg_volume3_m}` | — |
| Top Active Stocks 9  Avg Volume52 | text | scalar | `{account.store.TopActiveStocks_9__avg_volume52}` | — |
| Top Active Stocks 9  Avg Volume6 M | text | scalar | `{account.store.TopActiveStocks_9__avg_volume6_m}` | — |
| Top Active Stocks 9  Change | text | scalar | `{account.store.TopActiveStocks_9__change}` | — |
| Top Active Stocks 9  Change Percent | text | scalar | `{account.store.TopActiveStocks_9__change_percent}` | — |
| Top Active Stocks 9  Company Logo | img | scalar | `{account.store.TopActiveStocks_9__company_logo}` | — |
| Top Active Stocks 9  Delay | text | scalar | `{account.store.TopActiveStocks_9__delay}` | — |
| Top Active Stocks 9  Exchange Default Currency | text | scalar | `{account.store.TopActiveStocks_9__exchange_default_currency}` | — |
| Top Active Stocks 9  Exchange Name | text | scalar | `{account.store.TopActiveStocks_9__exchange_name}` | — |
| Top Active Stocks 9  High | text | scalar | `{account.store.TopActiveStocks_9__high}` | — |
| Top Active Stocks 9  High Y T D | text | scalar | `{account.store.TopActiveStocks_9__high_y_t_d}` | — |
| Top Active Stocks 9  High1 M | text | scalar | `{account.store.TopActiveStocks_9__high1_m}` | — |
| Top Active Stocks 9  High1 W | text | scalar | `{account.store.TopActiveStocks_9__high1_w}` | — |
| Top Active Stocks 9  High3 M | text | scalar | `{account.store.TopActiveStocks_9__high3_m}` | — |
| Top Active Stocks 9  High52 | text | scalar | `{account.store.TopActiveStocks_9__high52}` | — |
| Top Active Stocks 9  High6 M | text | scalar | `{account.store.TopActiveStocks_9__high6_m}` | — |
| Top Active Stocks 9  Low | text | scalar | `{account.store.TopActiveStocks_9__low}` | — |
| Top Active Stocks 9  Low Y T D | text | scalar | `{account.store.TopActiveStocks_9__low_y_t_d}` | — |
| Top Active Stocks 9  Low1 M | text | scalar | `{account.store.TopActiveStocks_9__low1_m}` | — |
| Top Active Stocks 9  Low1 W | text | scalar | `{account.store.TopActiveStocks_9__low1_w}` | — |
| Top Active Stocks 9  Low3 M | text | scalar | `{account.store.TopActiveStocks_9__low3_m}` | — |
| Top Active Stocks 9  Low52 | text | scalar | `{account.store.TopActiveStocks_9__low52}` | — |
| Top Active Stocks 9  Low6 M | text | scalar | `{account.store.TopActiveStocks_9__low6_m}` | — |
| Top Active Stocks 9  Most Recent Close | text | scalar | `{account.store.TopActiveStocks_9__most_recent_close}` | — |
| Top Active Stocks 9  Moving Average200 | text | scalar | `{account.store.TopActiveStocks_9__moving_average200}` | — |
| Top Active Stocks 9  Moving Average50 | text | scalar | `{account.store.TopActiveStocks_9__moving_average50}` | — |
| Top Active Stocks 9  Name | text | scalar | `{account.store.TopActiveStocks_9__name}` | — |
| Top Active Stocks 9  Netgr | text | scalar | `{account.store.TopActiveStocks_9__netgr}` | — |
| Top Active Stocks 9  Prev Close | text | scalar | `{account.store.TopActiveStocks_9__prev_close}` | — |
| Top Active Stocks 9  Price | text | float | `{account.store.TopActiveStocks_9__price}` | — |
| Top Active Stocks 9  Security Type Name | text | scalar | `{account.store.TopActiveStocks_9__security_type_name}` | — |
| Top Active Stocks 9  Short Name | text | scalar | `{account.store.TopActiveStocks_9__short_name}` | — |
| Top Active Stocks 9  Symbol | text | scalar | `{account.store.TopActiveStocks_9__symbol}` | — |
| Top Active Stocks 9  Type | text | scalar | `{account.store.TopActiveStocks_9__type}` | — |
| Top Active Stocks 9  Volume | text | scalar | `{account.store.TopActiveStocks_9__volume}` | — |
| Top Active Stocks Feed Last Run Had Errors | text | boolean | `{account.store.TopActiveStocks_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Top Active Stocks Feed Last Run Was Success | text | boolean | `{account.store.TopActiveStocks_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Top Active Stocks Feed Last Succesful Run At | text | datetime | `{account.store.TopActiveStocks_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:05 UTC*
