---
title: "Trestle by Core Logic - Lucit Application Reference"
description: "Trestle is a real estate data distribution platform. It aggregates and normalizes data from disparate sources, automates the data licensing process, and provides fast and..."
keywords: "lucit application, Trestle by Core Logic, app reference, integration"
---

# Trestle by Core Logic

Trestle is a real estate data distribution platform. It aggregates and normalizes data from disparate sources, automates the data licensing process, and provides fast and...

**Application Details:**

- **Name:** Trestle by Core Logic
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-471e30b7-9744-4219-951f-1f5b9bfecf0e`

---

## View in Lucit

**[🔗 View Trestle by Core Logic in Lucit](https://lucit.app/TrestleCoreLogic1){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Trestle by Core Logic to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Trestle by Core Logic"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Trestle by Core Logic application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Trestle by Core Logic Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Trestle IDX Web API - Agent

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Trestle IDX Web API - Agent dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for Trestle IDX Web API - Agent**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on Trestle IDX Web API - Agent to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on Trestle IDX Web API - Agent to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Originating System Name** | `text` | The originating system name for your board of realtors.  In Trestle, this would be listed as Originating ID undernating the MLO Connections | Required |
| **List Office MLS ID** | `text` | The MLS id for your Office / Brokerage | Required |
| **List Agent MLS ID** | `text` | The MLS id for your agent | Required |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Trestle Idx Web Api Feed Last Run Had Errors | text | boolean | `{account.store.TrestleIdxWebApi_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Trestle Idx Web Api Feed Last Run Was Success | text | boolean | `{account.store.TrestleIdxWebApi_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Trestle Idx Web Api Feed Last Succesful Run At | text | datetime | `{account.store.TrestleIdxWebApi_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Bathrooms Full | text | scalar | `{item.inventory_attributes.BathroomsFull}` | — |
| Bathrooms Partial | text | scalar | `{item.inventory_attributes.BathroomsPartial}` | — |
| Bathrooms Total Integer | text | scalar | `{item.inventory_attributes.BathroomsTotalInteger}` | — |
| Bedrooms Total | text | scalar | `{item.inventory_attributes.BedroomsTotal}` | — |
| Building Area Total | text | scalar | `{item.inventory_attributes.BuildingAreaTotal}` | — |
| City | text | scalar | `{item.inventory_attributes.City}` | — |
| Close Date | text | scalar | `{item.inventory_attributes.CloseDate}` | — |
| Co List Agent Email | text | scalar | `{item.inventory_attributes.CoListAgentEmail}` | — |
| Co List Agent Full Name | text | scalar | `{item.inventory_attributes.CoListAgentFullName}` | — |
| Co List Agent Mls Id | text | scalar | `{item.inventory_attributes.CoListAgentMlsId}` | — |
| Co List Agent Preferred Phone | text | scalar | `{item.inventory_attributes.CoListAgentPreferredPhone}` | — |
| Country | text | scalar | `{item.inventory_attributes.Country}` | — |
| County Or Parish | text | scalar | `{item.inventory_attributes.CountyOrParish}` | — |
| Days On Market | text | scalar | `{item.inventory_attributes.DaysOnMarket}` | — |
| Latitude | text | scalar | `{item.inventory_attributes.Latitude}` | — |
| Lc Address Combined | text | scalar | `{item.inventory_attributes.lc_address_combined}` | — |
| Lc Photos | img | scalar | `{item.inventory_attributes.lc_photos}` | — |
| List Agent Email | text | scalar | `{item.inventory_attributes.ListAgentEmail}` | — |
| List Agent Full Name | text | scalar | `{item.inventory_attributes.ListAgentFullName}` | — |
| List Agent Mls Id | text | scalar | `{item.inventory_attributes.ListAgentMlsId}` | — |
| List Agent Preferred Phone | text | scalar | `{item.inventory_attributes.ListAgentPreferredPhone}` | — |
| List Office Mls Id | text | scalar | `{item.inventory_attributes.ListOfficeMlsId}` | — |
| List Office Name | text | scalar | `{item.inventory_attributes.ListOfficeName}` | — |
| List Price | text | scalar | `{item.inventory_attributes.ListPrice}` | — |
| Listing Contract Date | text | scalar | `{item.inventory_attributes.ListingContractDate}` | — |
| Listing Id | text | scalar | `{item.inventory_attributes.ListingId}` | — |
| Listing Key Numeric | text | scalar | `{item.inventory_attributes.ListingKeyNumeric}` | — |
| Longitude | text | scalar | `{item.inventory_attributes.Longitude}` | — |
| Modification Timestamp | text | scalar | `{item.inventory_attributes.ModificationTimestamp}` | — |
| Postal Code | text | scalar | `{item.inventory_attributes.PostalCode}` | — |
| Property Sub Type | text | scalar | `{item.inventory_attributes.PropertySubType}` | — |
| Property Type | text | scalar | `{item.inventory_attributes.PropertyType}` | — |
| Standard Status | text | scalar | `{item.inventory_attributes.StandardStatus}` | — |
| State Or Province | text | scalar | `{item.inventory_attributes.StateOrProvince}` | — |
| Street Dir Prefix | text | scalar | `{item.inventory_attributes.StreetDirPrefix}` | — |
| Street Dir Suffix | text | scalar | `{item.inventory_attributes.StreetDirSuffix}` | — |
| Street Name | text | scalar | `{item.inventory_attributes.StreetName}` | — |
| Street Number | text | scalar | `{item.inventory_attributes.StreetNumber}` | — |
| Street Number Numeric | text | scalar | `{item.inventory_attributes.StreetNumberNumeric}` | — |
| Street Suffix | text | scalar | `{item.inventory_attributes.StreetSuffix}` | — |
| Unparsed Address | text | scalar | `{item.inventory_attributes.UnparsedAddress}` | — |
| Year Built | text | scalar | `{item.inventory_attributes.YearBuilt}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:14 UTC*
