---
title: "US Government Debt Counter - Lucit Application Reference"
description: "Build daily US Debt Counter creatives to show the current total amount of US Government Debt This app returns the following data points - Debt Held by the Public -..."
keywords: "lucit application, US Government Debt Counter, app reference, integration"
---

# US Government Debt Counter

Build daily US Debt Counter creatives to show the current total amount of US Government Debt This app returns the following data points - Debt Held by the Public -...

**Application Details:**

- **Name:** US Government Debt Counter
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-233a9c46-774f-498f-99be-a646436e9ca9`

---

## View in Lucit

**[🔗 View US Government Debt Counter in Lucit](https://lucit.app/UsGovernmentDebtCounter){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add US Government Debt Counter to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "US Government Debt Counter"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The US Government Debt Counter application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using US Government Debt Counter Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### US Government Debt Counter

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with US Government Debt Counter dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with US Government Debt Counter**

To add values from US Government Debt Counter to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from US Government Debt Counter `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled US Government Debt Counter or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using US Government Debt Counter data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from US Government Debt Counter:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

*No configurable settings for this data source.*


#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Us Government Debt Counter1 Feed Last Run Had Errors | text | boolean | `{account.store.UsGovernmentDebtCounter1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Us Government Debt Counter1 Feed Last Run Was Success | text | boolean | `{account.store.UsGovernmentDebtCounter1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Us Government Debt Counter1 Feed Last Succesful Run At | text | datetime | `{account.store.UsGovernmentDebtCounter1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:19 UTC*
