---
title: "VINSolutions - Lucit Application Reference"
description: "VinSolutions is a vehicle inventory management system, powered by HomeNet, is a GPS-based software that allows dealers to find and promote specific inventory that customers want..."
keywords: "lucit application, VINSolutions, app reference, integration"
---

# VINSolutions

VinSolutions is a vehicle inventory management system, powered by HomeNet, is a GPS-based software that allows dealers to find and promote specific inventory that customers want...

**Application Details:**

- **Name:** VINSolutions
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-409764fd-975c-4078-917b-ec360f0fd38e`

---

## View in Lucit

**[🔗 View VINSolutions in Lucit](https://lucit.app/Vinsolutions1){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add VINSolutions to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "VINSolutions"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The VINSolutions application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using VINSolutions Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### VINSolutions

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with VINSolutions dynamic data that updates in real time.

#### Overview



**Data Source Type:** Inventory

This data source generates **Inventory Items** that can be used to create multiple ads automatically. Each row of data becomes an inventory item with associated templates that can be assigned on the TEMPLATES tab.

**How to Generate Creatives for VINSolutions**

When you add this app to your account and configure it, it will automatically generate creatives that can be posted to your digital billboard campaigns

Each row of data that this data source brings in will be turned into a new creative based on the template that you assign to it.

**How to assign a template**

Take the following steps :

1. From your account profile, click on `Apps & Data`
2. Click on VINSolutions to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under `Default Template` click `CHOOSE DEFAULT TEMPLATE` 
5. Select the template to assign to this data (if you have none, you must first create one by clicking on `Home` and then the `Templates` menu item)

To create different templates for different types of inventory items, depending on data for each item, take the following steps

1. From your account profile, click on `Apps & Data`
2. Click on VINSolutions to bring up this data source
3. Click on the `TEMPLATES` tab
4. Under the `Additional Templates` section, click on `ADD TEMPLATE`
5. Select the template to add
6. Configure the conditions for this template using the `+ CONDITION` button

Conditions can be created based on the values of any of the macro listed below that are prefixed with `item.`



#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Dealer Export File Name** | `text` | The name of the file supplied to you by VINSolutions .  Exclude the extension | Required |



#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Vinsolutions2 Feed Last Run Had Errors | text | boolean | `{account.store.Vinsolutions2_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Vinsolutions2 Feed Last Run Was Success | text | boolean | `{account.store.Vinsolutions2_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Vinsolutions2 Feed Last Succesful Run At | text | datetime | `{account.store.Vinsolutions2_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `item.inventory_attributes.`

These values provide custom inventory attribute data at the inventory item level.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Auto I D | text | scalar | `{item.inventory_attributes.auto_i_d}` | — |
| Body Style | text | scalar | `{item.inventory_attributes.body_style}` | — |
| Cab Type | text | scalar | `{item.inventory_attributes.cab_type}` | — |
| Carfax Available | text | scalar | `{item.inventory_attributes.carfax_available}` | — |
| Carfax One Owner | text | scalar | `{item.inventory_attributes.carfax_one_owner}` | — |
| Certified | text | scalar | `{item.inventory_attributes.certified}` | — |
| Color | text | scalar | `{item.inventory_attributes.color}` | — |
| Comment | text | scalar | `{item.inventory_attributes.comment}` | — |
| Compare Price | text | scalar | `{item.inventory_attributes.compare_price}` | — |
| Cost | text | scalar | `{item.inventory_attributes.cost}` | — |
| Custom1 | text | scalar | `{item.inventory_attributes.custom1}` | — |
| Custom2 | text | scalar | `{item.inventory_attributes.custom2}` | — |
| Custom3 | text | scalar | `{item.inventory_attributes.custom3}` | — |
| Custom4 | text | scalar | `{item.inventory_attributes.custom4}` | — |
| Custom5 | text | scalar | `{item.inventory_attributes.custom5}` | — |
| Doors | text | scalar | `{item.inventory_attributes.doors}` | — |
| Drive Train | text | scalar | `{item.inventory_attributes.drive_train}` | — |
| Engine | text | scalar | `{item.inventory_attributes.engine}` | — |
| Engine Cylinders | text | scalar | `{item.inventory_attributes.engine_cylinders}` | — |
| Fuel Type | text | scalar | `{item.inventory_attributes.fuel_type}` | — |
| Image U R Ls | img | scalar | `{item.inventory_attributes.image_u_r_ls}` | — |
| Interior | text | scalar | `{item.inventory_attributes.interior}` | — |
| Internet Special | text | scalar | `{item.inventory_attributes.internet_special}` | — |
| Inventory Date | text | scalar | `{item.inventory_attributes.inventory_date}` | — |
| Invoice | text | scalar | `{item.inventory_attributes.invoice}` | — |
| Last Photo Update Utc | img | scalar | `{item.inventory_attributes.last_photo_update_utc}` | — |
| Last Updated | text | scalar | `{item.inventory_attributes.last_updated}` | — |
| Lot Price | text | scalar | `{item.inventory_attributes.lot_price}` | — |
| M P G City | text | scalar | `{item.inventory_attributes.m_p_g_city}` | — |
| M P G Highway | text | scalar | `{item.inventory_attributes.m_p_g_highway}` | — |
| Model Code | text | scalar | `{item.inventory_attributes.model_code}` | — |
| Model Series | text | scalar | `{item.inventory_attributes.model_series}` | — |
| Msrp | text | scalar | `{item.inventory_attributes.msrp}` | — |
| Options | text | scalar | `{item.inventory_attributes.options}` | — |
| Stock Number | text | scalar | `{item.inventory_attributes.stock_number}` | — |
| Tramsission | text | scalar | `{item.inventory_attributes.tramsission}` | — |
| Transmission | text | scalar | `{item.inventory_attributes.transmission}` | — |
| Trim | text | scalar | `{item.inventory_attributes.trim}` | — |
| Used New | text | scalar | `{item.inventory_attributes.used_new}` | — |
| Vehicle Details Page | text | scalar | `{item.inventory_attributes.vehicle_details_page}` | — |
| Video Embed Url | text | scalar | `{item.inventory_attributes.video_embed_url}` | — |
| Video Player Url | text | scalar | `{item.inventory_attributes.video_player_url}` | — |



---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:24:58 UTC*
