---
title: "Weather (Screen Location) - Lucit Application Reference"
description: "Calculate live weather data conditions for each digital screen in your campaign, and add to your creatives such as current temp, forecast, conditions, wind, rain, snow and more...."
keywords: "lucit application, Weather (Screen Location), app reference, integration"
---

# Weather (Screen Location)

Calculate live weather data conditions for each digital screen in your campaign, and add to your creatives such as current temp, forecast, conditions, wind, rain, snow and more....

**Application Details:**

- **Name:** Weather (Screen Location)
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull), Designer Templates and Elements

- **LCUID:** `LCUID-LAP-c25386d4-55a5-48a6-b9c8-a189051555bd`

---

## View in Lucit

**[🔗 View Weather (Screen Location) in Lucit](https://lucit.app/Weather){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Weather (Screen Location) to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Weather (Screen Location)"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Weather (Screen Location) application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Weather (Screen Location) Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Weather

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Weather dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Weather**

To add values from Weather to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Weather `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Weather or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Weather data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Weather:

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.
    * The `digital_board.store.` keys will appear on the `SCREEN FILTER` section of the `Custom Filters / Triggers Editor`.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Additional forecast days** | `int` [(enum)](#additional-forecast-days-options) | How many additional days of forecast data to fetch | Required |
| **Limit weather data to fields** | `text` | A comma separated list of fields to limit the weather data to.  Useful for campaigns with 100 or more screens | — |
| **Weather Icons (Experimental)** | `text` [(enum)](#weather-icons-(experimental)-options) | Choose a custom set of weather icons for conditions and forecasts.  This is currently experimental feature and is not currently recommended.  Please contact Lucit support for more information on creating custom weather icons | — |
| **Large Campaign Support** | `text` [(enum)](#large-campaign-support-options) | Enable large screen support for large programmatic campaigns to improve performance | — |
| **Distance From Screen Resolution** | `int` [(enum)](#distance-from-screen-resolution-options) | The radius around a screen to pull a single weather data point for.  Useful for adjusting performance of this feed for 100's or 1000's of screens | — |

**Enum Options:**

<a id="additional-forecast-days-options"></a>

*Additional forecast days:*

| Label | Value |
|-------|------|
| Today | 0 |
| Today & Tomorrow | 1 |
| Today plus 2 days | 2 |
| +3 Days | 3 |
| 4 Days | 4 |
| 5 Days | 5 |
| 6 Days | 6 |

<a id="weather-icons-(experimental)-options"></a>

*Weather Icons (Experimental):*

| Label | Value |
|-------|------|
| Basic | — |
| Sample Pack 1 | https://lucit-feeds-weather-icons.s3.us-east-2.amazonaws.com/verde_test/verde-test.json |

<a id="large-campaign-support-options"></a>

*Large Campaign Support:*

| Label | Value |
|-------|------|
| No | \\App\\LuCore\\Feeds\\Retrievers\\DigitalBoardWeatherApiFeedRetriever |
| Yes - Enable Large Campaign Support | \\App\\LuCore\\Feeds\\Retrievers\\DigitalBoardBulkWeatherApiFeedRetriever |

<a id="distance-from-screen-resolution-options"></a>

*Distance From Screen Resolution:*

| Label | Value |
|-------|------|
| 0.5 Miles | 8 |
| 1.5 Miles | 7 |
| 4 Miles | 6 |
| 10 Miles | 5 |
| 25 Miles | 4 |
| 75 Miles | 3 |
| 200 Miles | 2 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Weather1 Feed Last Run Had Errors | text | boolean | `{account.store.Weather1_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Weather1 Feed Last Run Was Success | text | boolean | `{account.store.Weather1_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Weather1 Feed Last Succesful Run At | text | datetime | `{account.store.Weather1_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |


#### Prefix: `digital_board.store.`

These are specific to every screen. The data stores one key/value for each and every screen in your campaign. These values depend on the screen location and may be different for every location your ads are running on. The list of screens that the data source will generate data for comes from the screens attached to your campaign(s).

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Weather1 Current Cloud | text | float | `{digital_board.store.Weather1_current_cloud}` | — |
| Weather1 Current Condition Code | text | string<br/>[(enum)](#digital_board-store-weather1-current-condition-code-options) | `{digital_board.store.Weather1_current_condition_code}` | The condition code for the current conditions |
| Weather1 Current Condition Group Code | text | string<br/>[(enum)](#digital_board-store-weather1-current-condition-group-code-options) | `{digital_board.store.Weather1_current_condition_group_code}` | Each weather condition code is grouped into one of the following simpler group codes |
| Weather1 Current Condition Group Name | text | scalar | `{digital_board.store.Weather1_current_condition_group_name}` | — |
| Weather1 Current Condition Icon | img | scalar<br/>[(enum)](#digital_board-store-weather1-current-condition-icon-options) | `{digital_board.store.Weather1_current_condition_icon}` | The condition icon for the current conditions |
| Weather1 Current Condition Text | text | scalar | `{digital_board.store.Weather1_current_condition_text}` | — |
| Weather1 Current Feelslike C | text | float | `{digital_board.store.Weather1_current_feelslike_c}` | — |
| Weather1 Current Feelslike F | text | float | `{digital_board.store.Weather1_current_feelslike_f}` | — |
| Weather1 Current Gust Kph | text | float | `{digital_board.store.Weather1_current_gust_kph}` | — |
| Weather1 Current Gust Mph | text | float | `{digital_board.store.Weather1_current_gust_mph}` | — |
| Weather1 Current Humidity | text | float | `{digital_board.store.Weather1_current_humidity}` | — |
| Weather1 Current Last Updated | text | datetime | `{digital_board.store.Weather1_current_last_updated}` | — |
| Weather1 Current Precip In | text | float | `{digital_board.store.Weather1_current_precip_in}` | — |
| Weather1 Current Precip Mm | text | float | `{digital_board.store.Weather1_current_precip_mm}` | — |
| Weather1 Current Pressure In | text | float | `{digital_board.store.Weather1_current_pressure_in}` | — |
| Weather1 Current Pressure Mb | text | float | `{digital_board.store.Weather1_current_pressure_mb}` | — |
| Weather1 Current Temp C | text | float | `{digital_board.store.Weather1_current_temp_c}` | — |
| Weather1 Current Temp F | text | float | `{digital_board.store.Weather1_current_temp_f}` | — |
| Weather1 Current Uv | text | float | `{digital_board.store.Weather1_current_uv}` | — |
| Weather1 Current Vis Km | text | float | `{digital_board.store.Weather1_current_vis_km}` | — |
| Weather1 Current Vis Miles | text | float | `{digital_board.store.Weather1_current_vis_miles}` | — |
| Weather1 Current Wind Degree | text | float | `{digital_board.store.Weather1_current_wind_degree}` | — |
| Weather1 Current Wind Dir | text | string | `{digital_board.store.Weather1_current_wind_dir}` | — |
| Weather1 Current Wind Kph | text | float | `{digital_board.store.Weather1_current_wind_kph}` | — |
| Weather1 Current Wind Mph | text | float | `{digital_board.store.Weather1_current_wind_mph}` | — |
| Weather1 Forecast Avghumidity | text | float | `{digital_board.store.Weather1_forecast_avghumidity}` | — |
| Weather1 Forecast Avgtemp C | text | float | `{digital_board.store.Weather1_forecast_avgtemp_c}` | — |
| Weather1 Forecast Avgtemp F | text | float | `{digital_board.store.Weather1_forecast_avgtemp_f}` | — |
| Weather1 Forecast Avgvis Km | text | float | `{digital_board.store.Weather1_forecast_avgvis_km}` | — |
| Weather1 Forecast Avgvis Miles | text | float | `{digital_board.store.Weather1_forecast_avgvis_miles}` | — |
| Weather1 Forecast Condition Code | text | scalar | `{digital_board.store.Weather1_forecast_condition_code}` | — |
| Weather1 Forecast Condition Group Code | text | scalar | `{digital_board.store.Weather1_forecast_condition_group_code}` | — |
| Weather1 Forecast Condition Group Name | text | scalar | `{digital_board.store.Weather1_forecast_condition_group_name}` | — |
| Weather1 Forecast Condition Icon | img | scalar | `{digital_board.store.Weather1_forecast_condition_icon}` | — |
| Weather1 Forecast Condition Text | text | scalar | `{digital_board.store.Weather1_forecast_condition_text}` | — |
| Weather1 Forecast Daily Chance Of Rain | text | integer | `{digital_board.store.Weather1_forecast_daily_chance_of_rain}` | — |
| Weather1 Forecast Daily Chance Of Snow | text | integer | `{digital_board.store.Weather1_forecast_daily_chance_of_snow}` | — |
| Weather1 Forecast Daily Will It Rain | text | boolean | `{digital_board.store.Weather1_forecast_daily_will_it_rain}` | — |
| Weather1 Forecast Daily Will It Snow | text | boolean | `{digital_board.store.Weather1_forecast_daily_will_it_snow}` | — |
| Weather1 Forecast Date | text | datetime | `{digital_board.store.Weather1_forecast_date}` | — |
| Weather1 Forecast Maxtemp C | text | float | `{digital_board.store.Weather1_forecast_maxtemp_c}` | — |
| Weather1 Forecast Maxtemp F | text | float | `{digital_board.store.Weather1_forecast_maxtemp_f}` | — |
| Weather1 Forecast Maxwind Kph | text | float | `{digital_board.store.Weather1_forecast_maxwind_kph}` | — |
| Weather1 Forecast Maxwind Mph | text | float | `{digital_board.store.Weather1_forecast_maxwind_mph}` | — |
| Weather1 Forecast Mintemp C | text | float | `{digital_board.store.Weather1_forecast_mintemp_c}` | — |
| Weather1 Forecast Mintemp F | text | float | `{digital_board.store.Weather1_forecast_mintemp_f}` | — |
| Weather1 Forecast Totalprecip In | text | float | `{digital_board.store.Weather1_forecast_totalprecip_in}` | — |
| Weather1 Forecast Totalprecip Mm | text | float | `{digital_board.store.Weather1_forecast_totalprecip_mm}` | — |
| Weather1 Forecast Totalsnow Cm | text | float | `{digital_board.store.Weather1_forecast_totalsnow_cm}` | — |
| Weather1 Today Astro Is Moon Up | text | boolean | `{digital_board.store.Weather1_today_astro_is_moon_up}` | — |
| Weather1 Today Astro Is Sun Up | text | boolean | `{digital_board.store.Weather1_today_astro_is_sun_up}` | — |
| Weather1 Today Astro Moon Illumination | text | integer | `{digital_board.store.Weather1_today_astro_moon_illumination}` | — |
| Weather1 Today Astro Moon Phase | text | scalar | `{digital_board.store.Weather1_today_astro_moon_phase}` | — |
| Weather1 Today Astro Moonrise | text | datetime | `{digital_board.store.Weather1_today_astro_moonrise}` | — |
| Weather1 Today Astro Moonset | text | datetime | `{digital_board.store.Weather1_today_astro_moonset}` | — |
| Weather1 Today Astro Sunrise | text | datetime | `{digital_board.store.Weather1_today_astro_sunrise}` | — |
| Weather1 Today Astro Sunset | text | datetime | `{digital_board.store.Weather1_today_astro_sunset}` | — |

**Enum Options:**

<a id="digital_board-store-weather1-current-condition-code-options"></a>

*Weather1 Current Condition Code:*

| Label | Value | Description |
|-------|------|-------------|
| Sunny | 1000 | Group : clear |
| Partly cloudy | 1003 | Group : cloudy |
| Cloudy | 1006 | Group : cloudy |
| Overcast | 1009 | Group : cloudy |
| Mist | 1030 | Group : fog |
| Patchy rain possible | 1063 | Group : rain |
| Patchy snow possible | 1066 | Group : snow |
| Patchy sleet possible | 1069 | Group : sleet |
| Patchy freezing drizzle possible | 1072 | Group : freezing_rain |
| Thundery outbreaks possible | 1087 | Group : thunder |
| Blowing snow | 1114 | Group : snow |
| Blizzard | 1117 | Group : blizzard |
| Fog | 1135 | Group : fog |
| Freezing fog | 1147 | Group : fog |
| Patchy light drizzle | 1150 | Group : rain |
| Light drizzle | 1153 | Group : rain |
| Freezing drizzle | 1168 | Group : freezing_rain |
| Heavy freezing drizzle | 1171 | Group : freezing_rain |
| Patchy light rain | 1180 | Group : rain |
| Light rain | 1183 | Group : rain |
| Moderate rain at times | 1186 | Group : rain |
| Moderate rain | 1189 | Group : rain |
| Heavy rain at times | 1192 | Group : rain |
| Heavy rain | 1195 | Group : rain |
| Light freezing rain | 1198 | Group : freezing_rain |
| Moderate or heavy freezing rain | 1201 | Group : freezing_rain |
| Light sleet | 1204 | Group : sleet |
| Moderate or heavy sleet | 1207 | Group : sleet |
| Patchy light snow | 1210 | Group : snow |
| Light snow | 1213 | Group : snow |
| Patchy moderate snow | 1216 | Group : snow |
| Moderate snow | 1219 | Group : snow |
| Patchy heavy snow | 1222 | Group : snow |
| Heavy snow | 1225 | Group : snow |
| Ice pellets | 1237 | Group : sleet |
| Light rain shower | 1240 | Group : rain |
| Moderate or heavy rain shower | 1243 | Group : rain |
| Torrential rain shower | 1246 | Group : rain |
| Light sleet showers | 1249 | Group : sleet |
| Moderate or heavy sleet showers | 1252 | Group : sleet |
| Light snow showers | 1255 | Group : snow |
| Moderate or heavy snow showers | 1258 | Group : snow |
| Light showers of ice pellets | 1261 | Group : sleet |
| Moderate or heavy showers of ice pellets | 1264 | Group : sleet |
| Patchy light rain with thunder | 1273 | Group : thunder |
| Moderate or heavy rain with thunder | 1276 | Group : thunder |
| Patchy light snow with thunder | 1279 | Group : thunder |
| Moderate or heavy snow with thunder | 1282 | Group : thunder |

<a id="digital_board-store-weather1-current-condition-group-code-options"></a>

*Weather1 Current Condition Group Code:*

| Label | Value | Description |
|-------|------|-------------|
| Clear | clear | Conditions : Sunny, Clear |
| Cloudy | cloudy | Conditions : Partly cloudy, Cloudy, Overcast |
| Fog | fog | Conditions : Mist, Fog, Freezing fog |
| Rain | rain | Conditions : Patchy rain possible, Patchy light drizzle, Light drizzle, Patchy light rain, Light rain, Moderate rain at times, Moderate rain, Heavy rain at times, Heavy rain, Light rain shower, Moderate or heavy rain shower, Torrential rain shower |
| Snow | snow | Conditions : Patchy snow possible, Blowing snow, Patchy light snow, Light snow, Patchy moderate snow, Moderate snow, Patchy heavy snow, Heavy snow, Light snow showers, Moderate or heavy snow showers |
| Sleet | sleet | Conditions : Patchy sleet possible, Light sleet, Moderate or heavy sleet, Ice pellets, Light sleet showers, Moderate or heavy sleet showers, Light showers of ice pellets, Moderate or heavy showers of ice pellets |
| Freezing Rain | freezing_rain | Conditions : Patchy freezing drizzle possible, Freezing drizzle, Heavy freezing drizzle, Light freezing rain, Moderate or heavy freezing rain |
| Thunder | thunder | Conditions : Thundery outbreaks possible, Patchy light rain with thunder, Moderate or heavy rain with thunder, Patchy light snow with thunder, Moderate or heavy snow with thunder |
| Blizzard | blizzard | Conditions : Blizzard |

<a id="digital_board-store-weather1-current-condition-icon-options"></a>

*Weather1 Current Condition Icon:*

| Label | Value | Icon |
|-------|------|------|
| Sunny | 113 | <img src="//cdn.weatherapi.com/weather/64x64/day/113.png" alt="icon" style="max-height: 24px;" /> |
| Partly cloudy | 116 | <img src="//cdn.weatherapi.com/weather/64x64/day/116.png" alt="icon" style="max-height: 24px;" /> |
| Cloudy | 119 | <img src="//cdn.weatherapi.com/weather/64x64/day/119.png" alt="icon" style="max-height: 24px;" /> |
| Overcast | 122 | <img src="//cdn.weatherapi.com/weather/64x64/day/122.png" alt="icon" style="max-height: 24px;" /> |
| Mist | 143 | <img src="//cdn.weatherapi.com/weather/64x64/day/143.png" alt="icon" style="max-height: 24px;" /> |
| Patchy rain possible | 176 | <img src="//cdn.weatherapi.com/weather/64x64/day/176.png" alt="icon" style="max-height: 24px;" /> |
| Patchy snow possible | 179 | <img src="//cdn.weatherapi.com/weather/64x64/day/179.png" alt="icon" style="max-height: 24px;" /> |
| Patchy sleet possible | 182 | <img src="//cdn.weatherapi.com/weather/64x64/day/182.png" alt="icon" style="max-height: 24px;" /> |
| Patchy freezing drizzle possible | 185 | <img src="//cdn.weatherapi.com/weather/64x64/day/185.png" alt="icon" style="max-height: 24px;" /> |
| Thundery outbreaks possible | 200 | <img src="//cdn.weatherapi.com/weather/64x64/day/200.png" alt="icon" style="max-height: 24px;" /> |
| Blowing snow | 227 | <img src="//cdn.weatherapi.com/weather/64x64/day/227.png" alt="icon" style="max-height: 24px;" /> |
| Blizzard | 230 | <img src="//cdn.weatherapi.com/weather/64x64/day/230.png" alt="icon" style="max-height: 24px;" /> |
| Fog | 248 | <img src="//cdn.weatherapi.com/weather/64x64/day/248.png" alt="icon" style="max-height: 24px;" /> |
| Freezing fog | 260 | <img src="//cdn.weatherapi.com/weather/64x64/day/260.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light drizzle | 263 | <img src="//cdn.weatherapi.com/weather/64x64/day/263.png" alt="icon" style="max-height: 24px;" /> |
| Light drizzle | 266 | <img src="//cdn.weatherapi.com/weather/64x64/day/266.png" alt="icon" style="max-height: 24px;" /> |
| Freezing drizzle | 281 | <img src="//cdn.weatherapi.com/weather/64x64/day/281.png" alt="icon" style="max-height: 24px;" /> |
| Heavy freezing drizzle | 284 | <img src="//cdn.weatherapi.com/weather/64x64/day/284.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light rain | 293 | <img src="//cdn.weatherapi.com/weather/64x64/day/293.png" alt="icon" style="max-height: 24px;" /> |
| Light rain | 296 | <img src="//cdn.weatherapi.com/weather/64x64/day/296.png" alt="icon" style="max-height: 24px;" /> |
| Moderate rain at times | 299 | <img src="//cdn.weatherapi.com/weather/64x64/day/299.png" alt="icon" style="max-height: 24px;" /> |
| Moderate rain | 302 | <img src="//cdn.weatherapi.com/weather/64x64/day/302.png" alt="icon" style="max-height: 24px;" /> |
| Heavy rain at times | 305 | <img src="//cdn.weatherapi.com/weather/64x64/day/305.png" alt="icon" style="max-height: 24px;" /> |
| Heavy rain | 308 | <img src="//cdn.weatherapi.com/weather/64x64/day/308.png" alt="icon" style="max-height: 24px;" /> |
| Light freezing rain | 311 | <img src="//cdn.weatherapi.com/weather/64x64/day/311.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy freezing rain | 314 | <img src="//cdn.weatherapi.com/weather/64x64/day/314.png" alt="icon" style="max-height: 24px;" /> |
| Light sleet | 317 | <img src="//cdn.weatherapi.com/weather/64x64/day/317.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy sleet | 320 | <img src="//cdn.weatherapi.com/weather/64x64/day/320.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light snow | 323 | <img src="//cdn.weatherapi.com/weather/64x64/day/323.png" alt="icon" style="max-height: 24px;" /> |
| Light snow | 326 | <img src="//cdn.weatherapi.com/weather/64x64/day/326.png" alt="icon" style="max-height: 24px;" /> |
| Patchy moderate snow | 329 | <img src="//cdn.weatherapi.com/weather/64x64/day/329.png" alt="icon" style="max-height: 24px;" /> |
| Moderate snow | 332 | <img src="//cdn.weatherapi.com/weather/64x64/day/332.png" alt="icon" style="max-height: 24px;" /> |
| Patchy heavy snow | 335 | <img src="//cdn.weatherapi.com/weather/64x64/day/335.png" alt="icon" style="max-height: 24px;" /> |
| Heavy snow | 338 | <img src="//cdn.weatherapi.com/weather/64x64/day/338.png" alt="icon" style="max-height: 24px;" /> |
| Ice pellets | 350 | <img src="//cdn.weatherapi.com/weather/64x64/day/350.png" alt="icon" style="max-height: 24px;" /> |
| Light rain shower | 353 | <img src="//cdn.weatherapi.com/weather/64x64/day/353.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy rain shower | 356 | <img src="//cdn.weatherapi.com/weather/64x64/day/356.png" alt="icon" style="max-height: 24px;" /> |
| Torrential rain shower | 359 | <img src="//cdn.weatherapi.com/weather/64x64/day/359.png" alt="icon" style="max-height: 24px;" /> |
| Light sleet showers | 362 | <img src="//cdn.weatherapi.com/weather/64x64/day/362.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy sleet showers | 365 | <img src="//cdn.weatherapi.com/weather/64x64/day/365.png" alt="icon" style="max-height: 24px;" /> |
| Light snow showers | 368 | <img src="//cdn.weatherapi.com/weather/64x64/day/368.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy snow showers | 371 | <img src="//cdn.weatherapi.com/weather/64x64/day/371.png" alt="icon" style="max-height: 24px;" /> |
| Light showers of ice pellets | 374 | <img src="//cdn.weatherapi.com/weather/64x64/day/374.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy showers of ice pellets | 377 | <img src="//cdn.weatherapi.com/weather/64x64/day/377.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light rain with thunder | 386 | <img src="//cdn.weatherapi.com/weather/64x64/day/386.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy rain with thunder | 389 | <img src="//cdn.weatherapi.com/weather/64x64/day/389.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light snow with thunder | 392 | <img src="//cdn.weatherapi.com/weather/64x64/day/392.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy snow with thunder | 395 | <img src="//cdn.weatherapi.com/weather/64x64/day/395.png" alt="icon" style="max-height: 24px;" /> |




---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:25:22 UTC*
