---
title: "Weather (Destination) - Lucit Application Reference"
description: "Add weather data for a specifically selected location. All creatives will use this location regardless of the location of the physical screen Useful for "Destination Weather" for..."
keywords: "lucit application, Weather (Destination), app reference, integration"
---

# Weather (Destination)

Add weather data for a specifically selected location. All creatives will use this location regardless of the location of the physical screen Useful for "Destination Weather" for...

**Application Details:**

- **Name:** Weather (Destination)
- **Class:** ThirdParty
- **Capabilities:** Core Lucit Application, Data Source Application (Pull)

- **LCUID:** `LCUID-LAP-3b5be901-da78-4ef3-941e-7f69585f25cd`

---

## View in Lucit

**[🔗 View Weather (Destination) in Lucit](https://lucit.app/Weather2){: .md-button .md-button--primary}**

---

## Adding This Application

### Prerequisites

- A Lucit account (advertiser) or agency/operator account
- Appropriate permissions to add applications


### Add Weather (Destination) to Your Account

1. **Navigate to Apps**
   - Log in to Lucit
   - Using the Profile Switcher, switch to an Account profile
   - From the home page, Click on `Apps & Data` in the left sidebar

2. **Find the Application**
   - Click on `ADD NEW` Search for "Weather (Destination)"
   - Click on the app card to bring up the `Authorize Application` dialog

3. **Add to Account**
   - Review the requested permissions in the `Authorize Application`
   - Click the `ALLOW` button to add this app to your account

4. **Configure Settings**
   - Once added, click on the app in your `Apps & Data` section
   - Configure any required settings on the `SETTINGS` tab
   - Save your changes




---

## Data Source Providers

The Weather (Destination) application provides data source capabilities. You can use these data sources to pull data from external sources, generate dynamic content for your campaigns and build content triggers for your ads.

This application provides **1 data source provider(s)**.

### Prerequisites to Using Weather (Destination) Data

* A Lucit Account (Advertiser Account)
* A Campaign with at least 1 Screen
* Review the [required settings](#settings) below


---


### Weather (Destination)

This data source allows you to create dynamic out-of-home ads for digital billboards and signage with Weather (Destination) dynamic data that updates in real time.

#### Overview



**Data Source Type:** KeyValue

This data source generates **Key-Value** data that is available globally across all templates in your account. These values can also be used in Triggers / Filters for your creatives in their campaigns.

**How to create a new ad with Weather (Destination)**

To add values from Weather (Destination) to your creative templates, create a new template and use the Dynamic Data Elements section of the Elements Panel:

*  **Create** `Templates -> CREATE A NEW TEMPLATE` button
*  Add macros from Weather (Destination) `Templates -> {TemplateName} -> Elements Panel -> Dynamic Data Elements section -> Scroll down to section labeled Weather (Destination) or use the search filter`
*  Click on the name of the macro field you want to add to your template *(See the Field Map Macros reference below for a complete list)*
*  After clicking on the macro name, a new element will be added to your canvas, linked to the specified macro field. Depending on the Type of field (`text` or `img`) the appropriate element type will be added.
*  You can then move, resize, style and format this element as appropriate for your template.

**How to add triggers using Weather (Destination) data**

Triggers allow you to create an ad and then control whether or not the ad will run depending on the value(s) of the trigger. (Multiple boolean logic supported with multiple fields as necessary)

To create triggers for your creatives based on data from Weather (Destination):

* Navigate to the campaign page `Campaigns -> {Campaign}`
* Use the `{FolderWithStarIcon}` that appears next to each creative on your campaign page. `{Creative} -> Click {FolderWithStarIcon}` to open the `Custom Filters / Triggers Editor` dialog.
* Create your filter in this dialog using the conditionals:
    * The `account.store.` keys will appear on the `DATA SOURCE FILTER` tab of the `Custom Filters / Triggers Editor` dialog.





#### Settings

Configure these settings when setting up the data source. These parameters control how the data source fetches and processes data.

| Field | Type | Description | Validation |
|-------|------|-------------|------------|
| **Location** | `json` | Choose a location | Required |
| **Additional forecast days** | `int` [(enum)](#additional-forecast-days-options) | How many additional days of forecast data to fetch | Required |

**Enum Options:**

<a id="additional-forecast-days-options"></a>

*Additional forecast days:*

| Label | Value |
|-------|------|
| Today | 0 |
| Today & Tomorrow | 1 |
| Today plus 2 days | 2 |
| +3 Days | 3 |
| +4 Days | 4 |
| +5 Days | 5 |
| +6 Days | 6 |




#### Field Map Macros

These macros are provided by this data source and can be used in your templates. The macros allow you to access the dynamic data provided by this data source and are in addition to the standard macros available in the [Standard Field Map](../../../macros/field-map-macro-reference) .  Learn more about [Field Map Types and Structure](../../../macros/field-map-specification)


#### Prefix: `account.store.`

These are values stored in the account key-value store and are the same for every template/ad that you create. These key/values do not depend on the location of the screen but are global to every ad.

| Name | Field Element Type | Data Type | Macro | Description |
|------|------|-----------|-------|-------------|
| Weather3 Current Cloud | text | float | `{account.store.Weather3_current_cloud}` | — |
| Weather3 Current Condition Code | text | string<br/>[(enum)](#account-store-weather3-current-condition-code-options) | `{account.store.Weather3_current_condition_code}` | The condition code for the current conditions |
| Weather3 Current Condition Group Code | text | string | `{account.store.Weather3_current_condition_group_code}` | — |
| Weather3 Current Condition Group Name | text | scalar | `{account.store.Weather3_current_condition_group_name}` | — |
| Weather3 Current Condition Icon | img | scalar<br/>[(enum)](#account-store-weather3-current-condition-icon-options) | `{account.store.Weather3_current_condition_icon}` | The condition icon for the current conditions |
| Weather3 Current Condition Text | text | scalar | `{account.store.Weather3_current_condition_text}` | — |
| Weather3 Current Dewpoint C | text | scalar | `{account.store.Weather3_current_dewpoint_c}` | — |
| Weather3 Current Dewpoint F | text | scalar | `{account.store.Weather3_current_dewpoint_f}` | — |
| Weather3 Current Feelslike C | text | float | `{account.store.Weather3_current_feelslike_c}` | — |
| Weather3 Current Feelslike F | text | float | `{account.store.Weather3_current_feelslike_f}` | — |
| Weather3 Current Gust Kph | text | float | `{account.store.Weather3_current_gust_kph}` | — |
| Weather3 Current Gust Mph | text | float | `{account.store.Weather3_current_gust_mph}` | — |
| Weather3 Current Heatindex C | text | scalar | `{account.store.Weather3_current_heatindex_c}` | — |
| Weather3 Current Heatindex F | text | scalar | `{account.store.Weather3_current_heatindex_f}` | — |
| Weather3 Current Humidity | text | float | `{account.store.Weather3_current_humidity}` | — |
| Weather3 Current Is Day | text | scalar | `{account.store.Weather3_current_is_day}` | — |
| Weather3 Current Last Updated | text | datetime | `{account.store.Weather3_current_last_updated}` | — |
| Weather3 Current Last Updated Epoch | text | datetime | `{account.store.Weather3_current_last_updated_epoch}` | — |
| Weather3 Current Precip In | text | float | `{account.store.Weather3_current_precip_in}` | — |
| Weather3 Current Precip Mm | text | float | `{account.store.Weather3_current_precip_mm}` | — |
| Weather3 Current Pressure In | text | float | `{account.store.Weather3_current_pressure_in}` | — |
| Weather3 Current Pressure Mb | text | float | `{account.store.Weather3_current_pressure_mb}` | — |
| Weather3 Current Temp C | text | float | `{account.store.Weather3_current_temp_c}` | — |
| Weather3 Current Temp F | text | float | `{account.store.Weather3_current_temp_f}` | — |
| Weather3 Current Uv | text | float | `{account.store.Weather3_current_uv}` | — |
| Weather3 Current Vis Km | text | float | `{account.store.Weather3_current_vis_km}` | — |
| Weather3 Current Vis Miles | text | float | `{account.store.Weather3_current_vis_miles}` | — |
| Weather3 Current Wind Degree | text | float | `{account.store.Weather3_current_wind_degree}` | — |
| Weather3 Current Wind Dir | text | string | `{account.store.Weather3_current_wind_dir}` | — |
| Weather3 Current Wind Kph | text | float | `{account.store.Weather3_current_wind_kph}` | — |
| Weather3 Current Wind Mph | text | float | `{account.store.Weather3_current_wind_mph}` | — |
| Weather3 Current Windchill C | text | scalar | `{account.store.Weather3_current_windchill_c}` | — |
| Weather3 Current Windchill F | text | scalar | `{account.store.Weather3_current_windchill_f}` | — |
| Weather3 Feed Last Run Had Errors | text | boolean | `{account.store.Weather3_feed_last_run_had_errors}` | Indicates whether this data source had errors during its last run |
| Weather3 Feed Last Run Was Success | text | boolean | `{account.store.Weather3_feed_last_run_was_success}` | Indicates whether the last feed run was successful |
| Weather3 Feed Last Succesful Run At | text | datetime | `{account.store.Weather3_feed_last_succesful_run_at}` | Timestamp of the last successful feed run |
| Weather3 Forecast Forecastday 0 Astro Is Moon Up | text | boolean | `{account.store.Weather3_forecast_forecastday_0_astro_is_moon_up}` | — |
| Weather3 Forecast Forecastday 0 Astro Is Sun Up | text | boolean | `{account.store.Weather3_forecast_forecastday_0_astro_is_sun_up}` | — |
| Weather3 Forecast Forecastday 0 Astro Moon Illumination | text | integer | `{account.store.Weather3_forecast_forecastday_0_astro_moon_illumination}` | — |
| Weather3 Forecast Forecastday 0 Astro Moon Phase | text | scalar | `{account.store.Weather3_forecast_forecastday_0_astro_moon_phase}` | — |
| Weather3 Forecast Forecastday 0 Astro Moonrise | text | datetime | `{account.store.Weather3_forecast_forecastday_0_astro_moonrise}` | — |
| Weather3 Forecast Forecastday 0 Astro Moonset | text | datetime | `{account.store.Weather3_forecast_forecastday_0_astro_moonset}` | — |
| Weather3 Forecast Forecastday 0 Astro Sunrise | text | datetime | `{account.store.Weather3_forecast_forecastday_0_astro_sunrise}` | — |
| Weather3 Forecast Forecastday 0 Astro Sunset | text | datetime | `{account.store.Weather3_forecast_forecastday_0_astro_sunset}` | — |
| Weather3 Forecast Forecastday 0 Date | text | datetime | `{account.store.Weather3_forecast_forecastday_0_date}` | — |
| Weather3 Forecast Forecastday 0 Date Epoch | text | datetime | `{account.store.Weather3_forecast_forecastday_0_date_epoch}` | — |
| Weather3 Forecast Forecastday 0 Day Avghumidity | text | float | `{account.store.Weather3_forecast_forecastday_0_day_avghumidity}` | — |
| Weather3 Forecast Forecastday 0 Day Avgtemp C | text | float | `{account.store.Weather3_forecast_forecastday_0_day_avgtemp_c}` | — |
| Weather3 Forecast Forecastday 0 Day Avgtemp F | text | float | `{account.store.Weather3_forecast_forecastday_0_day_avgtemp_f}` | — |
| Weather3 Forecast Forecastday 0 Day Avgvis Km | text | float | `{account.store.Weather3_forecast_forecastday_0_day_avgvis_km}` | — |
| Weather3 Forecast Forecastday 0 Day Avgvis Miles | text | float | `{account.store.Weather3_forecast_forecastday_0_day_avgvis_miles}` | — |
| Weather3 Forecast Forecastday 0 Day Condition Code | text | scalar | `{account.store.Weather3_forecast_forecastday_0_day_condition_code}` | — |
| Weather3 Forecast Forecastday 0 Day Condition Group Code | text | scalar | `{account.store.Weather3_forecast_forecastday_0_day_condition_group_code}` | — |
| Weather3 Forecast Forecastday 0 Day Condition Group Name | text | scalar | `{account.store.Weather3_forecast_forecastday_0_day_condition_group_name}` | — |
| Weather3 Forecast Forecastday 0 Day Condition Icon | img | scalar | `{account.store.Weather3_forecast_forecastday_0_day_condition_icon}` | — |
| Weather3 Forecast Forecastday 0 Day Condition Text | text | scalar | `{account.store.Weather3_forecast_forecastday_0_day_condition_text}` | — |
| Weather3 Forecast Forecastday 0 Day Daily Chance Of Rain | text | integer | `{account.store.Weather3_forecast_forecastday_0_day_daily_chance_of_rain}` | — |
| Weather3 Forecast Forecastday 0 Day Daily Chance Of Snow | text | integer | `{account.store.Weather3_forecast_forecastday_0_day_daily_chance_of_snow}` | — |
| Weather3 Forecast Forecastday 0 Day Daily Will It Rain | text | boolean | `{account.store.Weather3_forecast_forecastday_0_day_daily_will_it_rain}` | — |
| Weather3 Forecast Forecastday 0 Day Daily Will It Snow | text | boolean | `{account.store.Weather3_forecast_forecastday_0_day_daily_will_it_snow}` | — |
| Weather3 Forecast Forecastday 0 Day Maxtemp C | text | float | `{account.store.Weather3_forecast_forecastday_0_day_maxtemp_c}` | — |
| Weather3 Forecast Forecastday 0 Day Maxtemp F | text | float | `{account.store.Weather3_forecast_forecastday_0_day_maxtemp_f}` | — |
| Weather3 Forecast Forecastday 0 Day Maxwind Kph | text | float | `{account.store.Weather3_forecast_forecastday_0_day_maxwind_kph}` | — |
| Weather3 Forecast Forecastday 0 Day Maxwind Mph | text | float | `{account.store.Weather3_forecast_forecastday_0_day_maxwind_mph}` | — |
| Weather3 Forecast Forecastday 0 Day Mintemp C | text | float | `{account.store.Weather3_forecast_forecastday_0_day_mintemp_c}` | — |
| Weather3 Forecast Forecastday 0 Day Mintemp F | text | float | `{account.store.Weather3_forecast_forecastday_0_day_mintemp_f}` | — |
| Weather3 Forecast Forecastday 0 Day Totalprecip In | text | float | `{account.store.Weather3_forecast_forecastday_0_day_totalprecip_in}` | — |
| Weather3 Forecast Forecastday 0 Day Totalprecip Mm | text | float | `{account.store.Weather3_forecast_forecastday_0_day_totalprecip_mm}` | — |
| Weather3 Forecast Forecastday 0 Day Totalsnow Cm | text | float | `{account.store.Weather3_forecast_forecastday_0_day_totalsnow_cm}` | — |
| Weather3 Forecast Forecastday 0 Day Uv | text | scalar | `{account.store.Weather3_forecast_forecastday_0_day_uv}` | — |
| Weather3 Location Country | text | scalar | `{account.store.Weather3_location_country}` | — |
| Weather3 Location Lat | text | float | `{account.store.Weather3_location_lat}` | — |
| Weather3 Location Localtime | text | scalar | `{account.store.Weather3_location_localtime}` | — |
| Weather3 Location Localtime Epoch | text | scalar | `{account.store.Weather3_location_localtime_epoch}` | — |
| Weather3 Location Lon | text | float | `{account.store.Weather3_location_lon}` | — |
| Weather3 Location Name | text | scalar | `{account.store.Weather3_location_name}` | — |
| Weather3 Location Region | text | scalar | `{account.store.Weather3_location_region}` | — |
| Weather3 Location Tz Id | text | scalar | `{account.store.Weather3_location_tz_id}` | — |

**Enum Options:**

<a id="account-store-weather3-current-condition-code-options"></a>

*Weather3 Current Condition Code:*

| Label | Value | Description |
|-------|------|-------------|
| Sunny | 1000 | Group : clear |
| Partly cloudy | 1003 | Group : cloudy |
| Cloudy | 1006 | Group : cloudy |
| Overcast | 1009 | Group : cloudy |
| Mist | 1030 | Group : fog |
| Patchy rain possible | 1063 | Group : rain |
| Patchy snow possible | 1066 | Group : snow |
| Patchy sleet possible | 1069 | Group : sleet |
| Patchy freezing drizzle possible | 1072 | Group : freezing_rain |
| Thundery outbreaks possible | 1087 | Group : thunder |
| Blowing snow | 1114 | Group : snow |
| Blizzard | 1117 | Group : blizzard |
| Fog | 1135 | Group : fog |
| Freezing fog | 1147 | Group : fog |
| Patchy light drizzle | 1150 | Group : rain |
| Light drizzle | 1153 | Group : rain |
| Freezing drizzle | 1168 | Group : freezing_rain |
| Heavy freezing drizzle | 1171 | Group : freezing_rain |
| Patchy light rain | 1180 | Group : rain |
| Light rain | 1183 | Group : rain |
| Moderate rain at times | 1186 | Group : rain |
| Moderate rain | 1189 | Group : rain |
| Heavy rain at times | 1192 | Group : rain |
| Heavy rain | 1195 | Group : rain |
| Light freezing rain | 1198 | Group : freezing_rain |
| Moderate or heavy freezing rain | 1201 | Group : freezing_rain |
| Light sleet | 1204 | Group : sleet |
| Moderate or heavy sleet | 1207 | Group : sleet |
| Patchy light snow | 1210 | Group : snow |
| Light snow | 1213 | Group : snow |
| Patchy moderate snow | 1216 | Group : snow |
| Moderate snow | 1219 | Group : snow |
| Patchy heavy snow | 1222 | Group : snow |
| Heavy snow | 1225 | Group : snow |
| Ice pellets | 1237 | Group : sleet |
| Light rain shower | 1240 | Group : rain |
| Moderate or heavy rain shower | 1243 | Group : rain |
| Torrential rain shower | 1246 | Group : rain |
| Light sleet showers | 1249 | Group : sleet |
| Moderate or heavy sleet showers | 1252 | Group : sleet |
| Light snow showers | 1255 | Group : snow |
| Moderate or heavy snow showers | 1258 | Group : snow |
| Light showers of ice pellets | 1261 | Group : sleet |
| Moderate or heavy showers of ice pellets | 1264 | Group : sleet |
| Patchy light rain with thunder | 1273 | Group : thunder |
| Moderate or heavy rain with thunder | 1276 | Group : thunder |
| Patchy light snow with thunder | 1279 | Group : thunder |
| Moderate or heavy snow with thunder | 1282 | Group : thunder |

<a id="account-store-weather3-current-condition-icon-options"></a>

*Weather3 Current Condition Icon:*

| Label | Value | Icon |
|-------|------|------|
| Sunny | 113 | <img src="//cdn.weatherapi.com/weather/64x64/day/113.png" alt="icon" style="max-height: 24px;" /> |
| Partly cloudy | 116 | <img src="//cdn.weatherapi.com/weather/64x64/day/116.png" alt="icon" style="max-height: 24px;" /> |
| Cloudy | 119 | <img src="//cdn.weatherapi.com/weather/64x64/day/119.png" alt="icon" style="max-height: 24px;" /> |
| Overcast | 122 | <img src="//cdn.weatherapi.com/weather/64x64/day/122.png" alt="icon" style="max-height: 24px;" /> |
| Mist | 143 | <img src="//cdn.weatherapi.com/weather/64x64/day/143.png" alt="icon" style="max-height: 24px;" /> |
| Patchy rain possible | 176 | <img src="//cdn.weatherapi.com/weather/64x64/day/176.png" alt="icon" style="max-height: 24px;" /> |
| Patchy snow possible | 179 | <img src="//cdn.weatherapi.com/weather/64x64/day/179.png" alt="icon" style="max-height: 24px;" /> |
| Patchy sleet possible | 182 | <img src="//cdn.weatherapi.com/weather/64x64/day/182.png" alt="icon" style="max-height: 24px;" /> |
| Patchy freezing drizzle possible | 185 | <img src="//cdn.weatherapi.com/weather/64x64/day/185.png" alt="icon" style="max-height: 24px;" /> |
| Thundery outbreaks possible | 200 | <img src="//cdn.weatherapi.com/weather/64x64/day/200.png" alt="icon" style="max-height: 24px;" /> |
| Blowing snow | 227 | <img src="//cdn.weatherapi.com/weather/64x64/day/227.png" alt="icon" style="max-height: 24px;" /> |
| Blizzard | 230 | <img src="//cdn.weatherapi.com/weather/64x64/day/230.png" alt="icon" style="max-height: 24px;" /> |
| Fog | 248 | <img src="//cdn.weatherapi.com/weather/64x64/day/248.png" alt="icon" style="max-height: 24px;" /> |
| Freezing fog | 260 | <img src="//cdn.weatherapi.com/weather/64x64/day/260.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light drizzle | 263 | <img src="//cdn.weatherapi.com/weather/64x64/day/263.png" alt="icon" style="max-height: 24px;" /> |
| Light drizzle | 266 | <img src="//cdn.weatherapi.com/weather/64x64/day/266.png" alt="icon" style="max-height: 24px;" /> |
| Freezing drizzle | 281 | <img src="//cdn.weatherapi.com/weather/64x64/day/281.png" alt="icon" style="max-height: 24px;" /> |
| Heavy freezing drizzle | 284 | <img src="//cdn.weatherapi.com/weather/64x64/day/284.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light rain | 293 | <img src="//cdn.weatherapi.com/weather/64x64/day/293.png" alt="icon" style="max-height: 24px;" /> |
| Light rain | 296 | <img src="//cdn.weatherapi.com/weather/64x64/day/296.png" alt="icon" style="max-height: 24px;" /> |
| Moderate rain at times | 299 | <img src="//cdn.weatherapi.com/weather/64x64/day/299.png" alt="icon" style="max-height: 24px;" /> |
| Moderate rain | 302 | <img src="//cdn.weatherapi.com/weather/64x64/day/302.png" alt="icon" style="max-height: 24px;" /> |
| Heavy rain at times | 305 | <img src="//cdn.weatherapi.com/weather/64x64/day/305.png" alt="icon" style="max-height: 24px;" /> |
| Heavy rain | 308 | <img src="//cdn.weatherapi.com/weather/64x64/day/308.png" alt="icon" style="max-height: 24px;" /> |
| Light freezing rain | 311 | <img src="//cdn.weatherapi.com/weather/64x64/day/311.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy freezing rain | 314 | <img src="//cdn.weatherapi.com/weather/64x64/day/314.png" alt="icon" style="max-height: 24px;" /> |
| Light sleet | 317 | <img src="//cdn.weatherapi.com/weather/64x64/day/317.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy sleet | 320 | <img src="//cdn.weatherapi.com/weather/64x64/day/320.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light snow | 323 | <img src="//cdn.weatherapi.com/weather/64x64/day/323.png" alt="icon" style="max-height: 24px;" /> |
| Light snow | 326 | <img src="//cdn.weatherapi.com/weather/64x64/day/326.png" alt="icon" style="max-height: 24px;" /> |
| Patchy moderate snow | 329 | <img src="//cdn.weatherapi.com/weather/64x64/day/329.png" alt="icon" style="max-height: 24px;" /> |
| Moderate snow | 332 | <img src="//cdn.weatherapi.com/weather/64x64/day/332.png" alt="icon" style="max-height: 24px;" /> |
| Patchy heavy snow | 335 | <img src="//cdn.weatherapi.com/weather/64x64/day/335.png" alt="icon" style="max-height: 24px;" /> |
| Heavy snow | 338 | <img src="//cdn.weatherapi.com/weather/64x64/day/338.png" alt="icon" style="max-height: 24px;" /> |
| Ice pellets | 350 | <img src="//cdn.weatherapi.com/weather/64x64/day/350.png" alt="icon" style="max-height: 24px;" /> |
| Light rain shower | 353 | <img src="//cdn.weatherapi.com/weather/64x64/day/353.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy rain shower | 356 | <img src="//cdn.weatherapi.com/weather/64x64/day/356.png" alt="icon" style="max-height: 24px;" /> |
| Torrential rain shower | 359 | <img src="//cdn.weatherapi.com/weather/64x64/day/359.png" alt="icon" style="max-height: 24px;" /> |
| Light sleet showers | 362 | <img src="//cdn.weatherapi.com/weather/64x64/day/362.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy sleet showers | 365 | <img src="//cdn.weatherapi.com/weather/64x64/day/365.png" alt="icon" style="max-height: 24px;" /> |
| Light snow showers | 368 | <img src="//cdn.weatherapi.com/weather/64x64/day/368.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy snow showers | 371 | <img src="//cdn.weatherapi.com/weather/64x64/day/371.png" alt="icon" style="max-height: 24px;" /> |
| Light showers of ice pellets | 374 | <img src="//cdn.weatherapi.com/weather/64x64/day/374.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy showers of ice pellets | 377 | <img src="//cdn.weatherapi.com/weather/64x64/day/377.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light rain with thunder | 386 | <img src="//cdn.weatherapi.com/weather/64x64/day/386.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy rain with thunder | 389 | <img src="//cdn.weatherapi.com/weather/64x64/day/389.png" alt="icon" style="max-height: 24px;" /> |
| Patchy light snow with thunder | 392 | <img src="//cdn.weatherapi.com/weather/64x64/day/392.png" alt="icon" style="max-height: 24px;" /> |
| Moderate or heavy snow with thunder | 395 | <img src="//cdn.weatherapi.com/weather/64x64/day/395.png" alt="icon" style="max-height: 24px;" /> |




---



## Related Documentation

- [Application Classes & Capabilities Reference](../application-capabilities-reference.md)
- [Application Permissions Reference](../application-permissions-reference.md)
- [API Reference](../../api/index.html)

---

*Last updated: 2026-01-16 10:26:22 UTC*
