---
title: "Application Classes & Capabilities Reference"
description: "Complete reference for Lucit application classes and capabilities for developers building integrations"
keywords: "lucit capabilities, application classes, developer reference, api capabilities"
---

# Application Classes & Capabilities Reference

## Overview

Application classes and capabilities define how your application operates within the Lucit platform. This reference provides a comprehensive guide to all available options for building Lucit applications.

This reference documents **2 Application Classes** and **7 Application Capabilities** available for Lucit application development.

---

## What Are Application Classes?

Application classes define the visibility and access model for your application. Every application belongs to a single class that determines who can install and use it.

### Available Application Classes

| Class | Description |
|-------|-------------|
| **Private** | Only you and other members of this application can add it to accounts |
| **Third Party** | This application allows third party users to add it to their accounts |



NOTE:  There are 2 additional classes that are Lucit Internal Use Only : `Core` and `Generic`

---

## What Are Application Capabilities?

Application capabilities define what functionality your application provides. An application can have one or more capabilities that determine its behavior and features within the Lucit platform.

### Key Capability Properties

- **Name**: The human-readable name of the capability
- **Description**: What the capability enables your application to do
- **Applies To**: Which profile types can see and install apps with this capability (Account, Operator, Ad Agency)
- **Supported Application Classes**: Which application classes can use this capability
- **Provides Form Fields on Edge**: Whether this capability provides custom form fields
- **Can Create Application Domains**: Whether this capability allows creating application domains

### Profile-Based Visibility

When users click "Add New" on the Apps page, the available applications are filtered based on their current profile:

- **Account**: Standard account-level users
- **Operator**: Operator-level users with additional permissions
- **Ad Agency**: Ad agency users managing campaigns

An application is shown if at least one of its capabilities has the corresponding `show_for_` flag set to true for the user's current profile.

### Available Application Capabilities

| Capability | Description | Applies To | Supported Classes | Edge Fields | Domains |
|------------|-------------|------------|-------------------|-------------|----------|
| **Analytics Reporter** | Fetches analytics and reporting data for operators, accounts, canmpaigns and creatives | Account, Operator, Ad Agency | Core, Generic, Private, ThirdParty | — | — |
| **Automation** | Provides automation capabilities to the application. | Account, Operator, Ad Agency | Core, Private | ✓ | — |
| **Data Source Application (Pull)** | This application can be used to create data sources and data feeds that can be used to pull data from remote sources using Lucit internal data-connectors | Account | Core, Generic, Private, ThirdParty | — | — |
| **Designer Templates and Elements** | Store template and designer element packs | Account | Core, Generic, Private, ThirdParty | — | — |
| **Inventory Builder Application (Push)** | This application can be used to create inventory items via remote API calls to the Lucit API | Account | Core, Generic, Private, ThirdParty | — | — |
| **Player** | This application is a digital billboard player and can request creatives from Lucit campaigns | Operator | Core, Generic, Private, ThirdParty | ✓ | — |
| **Widgets** | Use Lucit content widgets on your website. | Account, Operator | Core, Generic, Private, ThirdParty | — | — |


---

## Understanding Supported Application Classes

Each capability lists which application classes can use it. When building your application:

1. Choose your **Application Class** based on who should be able to install your app
2. Select **Capabilities** that are supported by your chosen application class
3. Ensure your capability's profile visibility settings match your intended user base

For example:
- The **Player** capability is supported by all application classes (Core, Generic, Private, Third Party)
- The **Automation** capability is only supported by Core and Private application classes

---

## How to Configure Your Application

### Step 1: Create Your Application

Create a new application under the `Apps` section of your User Profile:

`Switch to User Profile -> Click on Apps -> NEW APPLICATION`

### Step 2: Select Application Class

Choose the appropriate class for your application:

- **Private**: Only you and members of your application can add it to accounts
- **Third Party**: Allow any Lucit user to add your application to their accounts

### Step 3: Add Capabilities

Select one or more capabilities that define what your application does:

1. Navigate to your application and click on the `CAPABILITIES` tab
2. Select the capabilities your application needs by enabling the switch next to each one
3. Each capability may have additional configuration options that you can configure by clicking on the `{GearIcon}` next to each one.
4. Save your changes

### Step 4: Configure Capability-Specific Settings

Some capabilities provide additional configuration options:

- **Player**: Configure player-specific settings for digital billboard displays
- **Data Source Application**: Set up data connectors and feeds
- **Designer Templates and Elements**: Upload template and element packs
- **Automation**: Configure automation rules

### Step 5: Set Up Permissions

After configuring capabilities, set up the permissions your application needs:

1. Go to the `PERMISSIONS` tab of your application
2. Select the permissions required for your capabilities
3. See the [Application Permissions Reference](application-permissions-reference.md) for details

---

## Common Application Configurations

### Analytics Dashboard
- **Class**: Third Party
- **Capabilities**: Analytics Reporter
- **Use Case**: Fetch and display analytics data for clients

### Digital Billboard Player
- **Class**: Third Party
- **Capabilities**: Player
- **Use Case**: Request and display creatives on digital billboards

### Data Integration App
- **Class**: Private or Third Party
- **Capabilities**: Data Source Application (Pull)
- **Use Case**: Pull data from external sources into Lucit

### Inventory Management App
- **Class**: Private or Third Party
- **Capabilities**: Inventory Builder Application (Push)
- **Use Case**: Create and manage inventory items via API

### Design Template Provider
- **Class**: Third Party or Private
- **Capabilities**: Designer Templates and Elements
- **Use Case**: Provide custom templates and design elements

### Web Widget Provider
- **Class**: Third Party or Private
- **Capabilities**: Widgets
- **Use Case**: Embed Lucit content on external websites

---

## Best Practices

### Choose the Right Class

- Use **Private** for internal tools or apps not intended for public distribution
- Use **Third Party** for apps you want to distribute to other Lucit users

### Select Appropriate Capabilities

- Only add capabilities your application actually uses
- Review the supported application classes before selecting capabilities
- Some capabilities are mutually exclusive or work best together

### Plan for Edge Devices

If your capability provides form fields on edge devices (Player, Automation), plan your data collection strategy carefully.

### Consider Application Domains

If your capability can create application domains, understand the implications for data organization and access control.

---

## API Integration

Once your application is configured with the appropriate class and capabilities, you can use the Lucit API to implement the functionality.

**[📖 View API Reference](../api/index.html){: .md-button .md-button--primary}**

See also:

- [Application Permissions Reference](application-permissions-reference.md) - Configure bot permissions
- [API Documentation](../api/index.html) - Complete API reference
---

*Last updated: 2026-01-16 09:25:12 UTC*
