---
title: "Application Permissions Reference"
description: "Complete reference for Lucit application permissions - account and agency permission scopes for bot users"
keywords: "lucit permissions, api permissions, bot users, application scopes, developer reference"
---

# Application Permissions Reference

## Overview

Application permissions define what actions your application's bots can perform when installed on user accounts or agencies. These permissions are configured on your application and automatically granted to bot tokens when users install your app.

This reference documents **11 Account Permissions** and **14 Agency Permissions** available for Lucit applications.

---

## What Are Application Permissions?

Application permissions control what actions your application's bot users can perform on behalf of users. When you build an application in Lucit:

1. **Configure Permissions**: Select the permissions your app needs on the `PERMISSIONS` tab of your application `User Profile -> Apps -> {App} -> PERMISSIONS`
2. **Create Bot Tokens**: Generate tokens under the `TOKENS` tab.  These tokens can be used in API calls and represent automated bot users that can perform actions
    * Note some types of Capabilities will automatically create one or more of these users for you.  For instance.  `Data Source` and `Player` Capabilities will do this.
3. **Users Install Your App**: When users add your application to their Account or Agency, your bots automatically gain the configured permissions (If they hit `ALLOW` when prompted)
4. **Bots Act with Permissions**: Your bot tokens can now perform actions within the scope of the granted permissions

### Permission Scope

- **Account Permissions**: Applied when your app is installed on an advertiser account
- **Agency Permissions**: Applied when your app is installed on an ad agency or operator organization

The permissions elevate what your bot tokens can do within each account or agency/operator where your application is installed.

---

## Account Permissions

Account permissions control what your application's bots can do within advertiser accounts. These permissions are granted when a user adds your application to their account.

| Permission | Description |
|------------|-------------|
| `account.createCampaigns` | Can create campaigns for this account |
| `account.createChildAccounts` | Can create child accounts under this account |
| `account.createContent` | Can add posts / photos, etc. to this account |
| `account.createFeeds` | Can create data sources for this account |
| `account.editCampaigns` | Can edit campaigns for this account |
| `account.view` | A user can view this account |
| `account.viewAnalytics` | Can view analytics for this account |
| `account.viewCampaigns` | Can view campaigns for this account |
| `account.viewContent` | Can view data for this account |
| `account.viewDefaultCreative` | Can view default creatives for this account |
| `account.viewFeeds` | Can view data sources for this account |


---

## Agency Permissions

Agency permissions control what your application's bots can do within ad agencies and operator organizations. These permissions are granted when a user adds your application to their agency or operator.

| Permission | Description |
|------------|-------------|
| `agency.canApproveAds` | Can approve ads for this operator |
| `agency.canEditBoards` | Can edit boards for this operator |
| `agency.canSetBoardImages` | Can set board images for this operators screens |
| `agency.createAccounts` | Can create accounts attached to this operator |
| `agency.createCampaigns` | Can create campaigns attached to boards for this operator |
| `agency.publishAnalytics` | Can publish stats for this operator and its boards |
| `agency.pullCampaigns` | Can execute a campaign pull against this operators boards |
| `agency.updateDeleteAllAgencyAccounts` | Complete permissions to all accounts that are owned by this agency including update, creating content, delete and other operations |
| `agency.view` | Can view basic details about this operator |
| `agency.viewAccounts` | Can view accounts that belong to this operator |
| `agency.viewAnalytics` | Can view stats for this operator and its boards |
| `agency.viewBoards` | Can view the list of boards for this operator |
| `agency.viewCampaigns` | Can view campaigns attached to boards for this operator |
| `agency.viewLightningDevices` | Can view the list of lightning devices for this operator |


---

## How to Configure Permissions

### Step 1: Create Your Application

If you haven't already, create a new application under the `Apps` of your User Profile `Switch to User Profile -> Click on Apps -> NEW APPLICATION`

### Step 2: Select Permissions

While editing your application :

1. Go to the `PERMISSIONS` tab
2. Select the permissions your application needs from the available list
3. Save your changes

### Step 3: Create Bot Tokens

1. Go to the `TOKENS` tab of your application
2. Click on `+ NEW TOKEN` to create a new token
3. Give your token a name
4. Select `Authentication Token` for the token type
5. CLick `Create`
6. Copy and paste the API Token and API Secret.  You will not be able to see this secret again.
7. These tokens will now inherit the permissions you configured when accessing the Lucit API.

### Step 4: Users Install Your App

When users add your application to their account or agency/operator, your bot tokens automatically gain the configured permissions for that account/agency/operator.

### Step 5: Use Permissions in Your API Calls

See the `Authenticating requests` section of [API Reference](../api/index.html) for more information.

## Best Practices

### Request Minimal Permissions

Only request the permissions your application actually needs. Users are more likely to install applications that request fewer permissions.

### Explain Why You Need Permissions

In your application description, clearly explain what each permission is used for and how it benefits the user.

### Secure Your Bot Tokens

Bot tokens have elevated permissions. Store them securely and never expose them in client-side code or public repositories.

### Test Permission Scenarios

Test your application with different permission combinations to ensure it handles missing permissions gracefully.

---

## Common Permission Combinations

### Analytics Dashboard App
- `account.viewAnalytics` - View campaign performance data
- `account.viewCampaigns` - Access campaign information

### Creative Management App
- `account.viewContent` - View existing creatives
- `account.createContent` - Create and edit creatives

### Campaign Automation App
- `account.viewCampaigns` - View campaign details
- `account.createCampaigns` - Create new campaigns
- `account.editCampaigns` - Modify campaign settings
- `account.createContent` - Post ads to campaigns

### Operator Management App
- `agency.viewBoards` - View screen inventory
- `agency.viewAccounts` - See connected accounts
- `agency.canApproveAds` - Approve ads for display

---

## Related Resources

- [Developer Documentation](../index.md)
