---
title: "Lucit Applications Reference"
description: "Complete reference guide for all Lucit applications, capabilities, and integrations available on the platform"
keywords: "lucit applications, app reference, integrations, capabilities, data sources"
---

# Lucit Applications Reference

Welcome to the comprehensive reference for all Lucit applications. Each application provides specific capabilities and integrations to enhance your digital advertising campaigns.

## Overview

Browse all available Lucit applications. Each application provides unique capabilities to enhance your digital advertising campaigns.

This reference includes **114 applications** available in the Lucit platform.

---

## How to Use This Reference

Each application has its own detailed reference page that includes:

- Application details (name, class, capabilities)
- Step-by-step installation guide
- Data source provider information (if applicable)
- Configuration settings
- Field map macros (for data sources)

---

## Available Applications

### [5 Star Business Reviews using Google Business Reviews](app/GoogleBusinessReviews-reference.md)

Create dynamic ads from recent 5-star reviews that were posted about your business on your Google Business Page. This data source brings in any...

### [Adams Outdoor - Scala Ad Manager Integration](app/AdamsOutdoorScalaAdManagerIntegration-reference.md)

Link campaigns in Ad Manager with Scala Scripts designed to pull creatives from your Lucit Campaign. This app allows you to access the required...

### [Ag Inventory using Google Sheets](app/GoogleSheetsAgInventory-reference.md)

Feed Ag data from a Google Drive Sheets Spreadsheet. Use an online spreadsheet to automate ag products onto your Lucit campaign. #title #description...

### [AirNow Air Quality Index](app/AirnowAirQualityIndex-reference.md)

Add The Air Quality Index (AQI) for the locations your creatives are running. The AQI data is updated hourly from AirNow.gov and data is provided for...

### [Alterra Mountain Co Ski Resorts - Snow Report](app/AlterraMountainCoSkiResortsSnowReport-reference.md)

Get the current snow report data from various Alterra Mountain Co Ski Resorts including : - Stratton - Snowshoe Mountain - Blue Mountain - Tremblant...

### [Apparatix](app/Apparatix1-reference.md)

The Apparatix Player and Reporting Application. The Apparatix digital billboard player connects directly to the Lucit system to pull creatives. This...

### [Article Inventory using Google Sheets](app/GoogleSheetsArticleInventory-reference.md)

Get Articles from a Google Drive Spreadsheet. Use an online spreadsheet to automate articles into your Lucit campaign. #title #description #unique id...

### [Automotive Inventory using Google Sheets](app/GoogleSheets-reference.md)

Feed automotive vehicle data from a Google Drive Sheets Spreadsheet. Use an online spreadsheet to automate automotive products onto your Lucit...

### [AutoRevo](app/Autorevo1-reference.md)

Connect your AutoRevo automotive data feed straight from your website to dynamic creatives in Lucit. Auto Revo is a website building tool for...

### [Ayuda](app/Ayuda-reference.md)

Schedule Lucit Dynamic Campaigns on the Lucit Player using the Ayuda App Integration This app will allow you to download the correct dynamic HTML...

### [Bible Verses](app/BibleVerses-reference.md)

Connect Bible verses directly to your dynamic creatives in Lucit. #bible #christianity #christian #verses #prayer #scripture #faith

### [Blip](app/Blip-reference.md)

Connect Lucit with your Blip campaign to manage your ads. Capabilities include creation of new ads, removal of inventory items not wished to...

### [Born On This Day (By DIGICHIEF)](app/BornOnThisDayByDigichief-reference.md)

Create digital signage / billboard creatives with "Born On This Day" facts. This app will randomly display a person who was born on todays date,...

### [Bridge Interactive MLS](app/BridgeInteractiveMls-reference.md)

Bridge is an integrated data distribution and licensing platform for real estate data for brokerages and agents Data Charges - Data charges may apply...

### [CarsForSale](app/Carsforsale1-reference.md)

CarsForSale gives exposure, business solutions, and buyers to your lot. Connect your automotive inventory directly from CarsForSale to Lucit so you...

### [CDK Global](app/CdkGlobal1-reference.md)

CDK Global connects you to dealership software solutions that work together to help you reach your potential. Lucit connects to your automotive data...

### [Christmas Countdown](app/ChristmasCoundown-reference.md)

Christmas Day Countdown sample template. Create a countdown hours/days to Christmas Day with this sample countdown template Use this template as a...

### [Coin Paprika](app/CoinPaprika-reference.md)

Get the current Bitcoin Crypto price from Coin Paprika

### [CoinDesk Live Bitcoin Price](app/CoindeskLiveBitcoinPrice-reference.md)

Add the live Bitcoin price to your creatives with the CoinDesk Bitcoin Cryptocurrency App

### [Commodity Prices (By DIGICHIEF)](app/CommodityPricesByDigichiefDemo-reference.md)

Ag markets, get latest prices for Cocoa, Coffee, Corn, Cotton, Feeder Cattle, Hogs, Live Cattle, Rice, Soybeans and Wheat #financial, #finance, #farm

### [CTI MLS](app/CtiMls1-reference.md)

The Northeast Georgia Board of Realtors data application for brokerages and realtors Data Charges - Data charges may apply depending on the structure...

### [Daily Horoscope](app/DailyHoroscope-reference.md)

Daily Horoscope transforms your daily horoscope experience with dynamically generated content for digital billboard campaigns. Deliver the latest...

### [Daktronics](app/Daktronics1-reference.md)

Connect Lucit with your Daktronics campaign to manage your ads. Capabilities include creation of new ads, removal of inventory items not wished to...

### [Dealer Car Search](app/DealerCarSearch1-reference.md)

A Dealer Website that can connect to Lucit to bring automated ads. This application can bring your automative data feed into Lucit to create instant...

### [Dealer Specialties](app/DealerSpecialties1-reference.md)

Dealer Specialties modernizes dealership's VDPs with custom vehicle merchandising services like photography, videography, 360 walkarounds, and...

### [DealersLink](app/Dealerslink1-reference.md)

DealersLink is a market-data-driven new and used auto dealership management software solution coupled with on-demand inventory. Connect DealersLink...

### [DealerSpike](app/Dealerspike1-reference.md)

Connect your Lucit campaign with your Automotive, Recreational and Motorsports data feeds from Dealer Spike. Dealer Spike partners with Polaris,...

### [DOOHClick Player](app/DoohclickPlayer-reference.md)

Connect campaigns built in the DOOH Click player to Lucit Dynamic Creatives. DOOHClick provides full support for fetching dynamic creatives from...

### [Drive Time - Digital Screen to Location](app/DriveTimeDigitalBoardToLocation-reference.md)

Use this app to display the estimated drive time in minutes from your digital board(s) to specific locations of interest Create a list of locations,...

### [ECRS eCommerce](app/Ecrs1-reference.md)

Data for Point of Sale Systems and eCommerce tools in Grocery, Convenience Stores, Supermarkets, Liquor Stores, Food Co-Ops and Pharmacies

### [Ecwid Ecommerce](app/EcwidEcommerce1-reference.md)

Ecwid by Lightspeed is an ecommerce platform that helps you create an online store and sell from online or in-person. Connect your Ecwid products...

### [ELead Automotive](app/EleadAutomotive-reference.md)

Elead is a browser-based automotive customer relationship management software for all types of automobile dealerships. Connect a Lucit campaign to...

### [Epic Ski Resorts Snow Report](app/EpicSkiResortsSnowReport-reference.md)

Snow Report and Snow Depth information for various Epic Ski Resorts including the following Colorado area locations - Vail - Beaver Creek -...

### [Experity Urgent Care Wait Times](app/ExperityUrgentCareWaitTimes-reference.md)

Add real-time urgent care wait times to your digital signage and digital billboard campaigns. This integration with Experity Patient Engagement...

### [Facebook Social Feed (By Tagbox)](app/FacebookSocialFeedByTagbox-reference.md)

Generate digital screen and digital billboard creatives from a Facebook Social Feed. This app, powered by Tagbox Social Media Aggregator platform,...

### [Famous Quotes](app/FamousQuotes-reference.md)

Connect quotes directly to your dynamic creatives in Lucit.

### [Famous Quotes (By DIGICHIEF)](app/FamousQuotesByDigichief-reference.md)

Add random famous, inspiring and funny quotes to your digital out-of-home signage and billboard creatives #infotainment

### [FlexMLS](app/Flexmls1-reference.md)

Real Estate MLS Data Feeds for Real Estate Agents and Brokerages Feed all of your property data from your FlexMLS RETS feed including Residential,...

### [Florida Gulf Coast MLS](app/FloridaGulfCoastMls-reference.md)

Add MLS Listings for real estate brokerages that belong to the Florida Gulf Coast MLS. The data for this application is provided by Trestle / Core...

### [Formetco F360](app/FormetcoF360-reference.md)

The Formetco F360 Player and Reporting Application. Built by Apparatix, The F360 digital billboard player connects directly to the Lucit system to...

### [Fox News](app/FoxNews-reference.md)

The Fox News Channel (FNC), commonly known as Fox News, is an American multinational conservative news and political commentary television channel...

### [Fun Random Facts (By DIGICHIEF)](app/FunRandomFactsByDigichief-reference.md)

Get fun random facts to display on your digital out-of-home signage creatives. #infotainment

### [Google Sheets Key Value Data](app/GoogleSheetsKeyValueData-reference.md)

Create a google spreadsheet with multiple rows of fields with a name (key) and a value This data will be imported as simple key value pairs and will...

### [Health & Wellness Tips (By DIGICHIEF)](app/HealthWellnessTipsByDigichief-reference.md)

Add random health, wellness, diet and exercise tips to your digital screens This app will randomly return a health and wellness tip to display on...

### [HomeNet Automotive](app/Homenet2-reference.md)

HomeNet’s digital merchandising platforms are designed to help providers support their clients and help dealers build an online presence that...

### [Instagram Social Feed (By Tagbox)](app/Instagram-reference.md)

Generate digital screen and digital billboard creatives from an Instagram Social Feed. This app, powered by Tagbox Social Media Aggregator platform,...

### [Job Listings using Google Sheets](app/GoogleSheetsAvailableJobs-reference.md)

Get Job Listings from a Google Drive Spreadsheet. Use an online spreadsheet to automate Job Listings into your Lucit campaign. #title #description...

### [Lamar iSpot Player](app/LamarIspotPlayer-reference.md)

Connect your Lamar iSpot campaigns with Lucit using the Lamar iSpot player application This app will allow you to get the required details to fill...

### [LDSK](app/Ldsk1-reference.md)

LDSK (Formerly Signkick and LiveDOOH) is a digital signage player platform for Digital Out of Home. This application for LDSK Dynamic Creatives...

### [Lightning Player](app/LightningPlayer-reference.md)

Created by the Lucit team, this application will allow you to create your own screens with a Lightning tv device. The Lightning Player is an...

### [LinkedIn Social Feed (By Tagbox)](app/LinkedinSocialFeedByTagbox-reference.md)

Generate digital screen and digital billboard creatives from a LinkedIn Social Feed. This app, powered by Tagbox Social Media Aggregator platform,...

### [LIOPS (Lucit Ignite OP Supervisor)](app/LiopsLucitWatchfireIgniteOpSupervisor-reference.md)

LIOPS is an application within Lucit that allows a user to connect remotely to a Watchfire sign from within Lucit. Application for the LIOPS Player...

### [Lotus Corp Radio - Now Playing](app/LotusCorpRadioNowPlaying-reference.md)

Provides connectivity to the now playing API for Lotus Corporation Radio Stations Add live now-playing to digital out of home billboard creatives...

### [Loveland Ski Area Snow Pack Depth](app/LovelandSkiAreaSnowPackDepth-reference.md)

Draft Application

### [Lucit Sample Data Sources](app/LucitSampleDataSources-reference.md)

This is a demo application for testing data connectivity with sample data sources. Adding this demo application to a campaign will give you access to...

### [Machine Finder](app/MachineFinder1-reference.md)

Data feeds for Ag, Agriculture, Heavy Equipment, Forestry, Construction Equipment and more Connect Lucit to your Machine Finder inventory data to...

### [Matrix MLS by CoreLogic](app/MatrixMlsByCorelogic-reference.md)

CoreLogic Matrix MLS Data for Real Estate Agents and Brokerages Data Charges - Data charges may apply depending on the structure of your local MLS...

### [Mega Millions](app/MegaMillions-reference.md)

Generate Powerball Lottery creatives with the latest Jackpot amount, add the latest drawing numbers, and even the next estimated Jackpot amount....

### [MLB Live Game Scores](app/MlbLiveGameScores-reference.md)

Add LIVE MLB baseball scores on game-day to your digital billboard and digital signage creatives with the Major League Baseball Sports Game Scores...

### [Navica MLS](app/NavicaMls1-reference.md)

SEI Navica by SEI Systems is MLS Data for Real Estate Agents and Brokerages. Data Charges - Data charges may apply depending on the structure of your...

### [NBA Live Game Scores](app/NbaLiveGameScores-reference.md)

Add LIVE NBA basketball scores on game-day to your digital billboard and digital signage creatives with the National Basketball League Sports Game...

### [NCAA Basketball - Live Game Scores](app/NcaaBasketballLiveGameScores-reference.md)

Add LIVE NCAA Mens basketball scores on game-day to your digital billboard and digital signage creatives with the NCAA Basetball Sports Game Scores...

### [NCAA College Football Live Game Scores](app/NcaaCollegeFootballLiveGameScores-reference.md)

Add LIVE NCAA Football scores on game-day to your digital billboard and digital signage creatives with the NCAA Football Sports Game Scores app Add...

### [NCAA Womens Volleyball Scores](app/NcaaWomensVolleyballScores-reference.md)

Add NCAA Women's volleyball game scores to your digital out-of-home creatives This app will pull in todays games for all teams or, for teams that you...

### [Nearest Location using Google Sheets](app/NearestLocationDataViaGoogleSheets-reference.md)

Use a list of POI (Point Of Interest) locations stored in a Google Sheets Spreadsheet and automatically show information about the nearest location...

### [NFL Live Game Scores](app/NflLiveGameScores-reference.md)

Add LIVE NFL Football scores on game-day to your digital billboard and digital signage creatives with the National Football League Sports Game Scores...

### [Northwoods League Baseball](app/NorthwoodsLeagueBaseball-reference.md)

Live NWL Scores on your digital billboards! This application will fetch live game scores from the Northwoods League summer college baseball league....

### [NTREIS MLS Data](app/NtreisMlsData-reference.md)

MLS Data from Trestle / CoreLogic for North Texas Real Estate Information Services, Inc. North Texas Real Estate Information Systems, Inc. (NTREIS)...

### [Oil and Gas Market Prices (By DIGICHIEF)](app/OilAndGasMarketPricesByDigichief-reference.md)

Add commodity markets for Oil, Natural Gas, West Texas Crude, and Brent Crude to your digital billboard creatives. #financial, #finance

### [Outfront Media Player](app/OutfrontMediaPlayer-reference.md)

Outfront Media specializes in out-of-home (OOH) advertising, which includes billboards, transit displays, and other physical media that reaches...

### [Paragon MLS](app/ParagonMls-reference.md)

Paragon is a Multiple Listing Service (MLS) platform. Connect your MLS data to a Lucit dynamic campaign. Paragon by Black Knight, MLS Data for Real...

### [Paris 2024 Summer Olympics](app/Paris2024Olympics-reference.md)

Create live Olympic medal count digital billboard creatives for the Summer Olympics in 2024 This app will allow you to either build a table of the...

### [PGA Golf Tour Leaderboards](app/PgaGolfTourLeaderboards-reference.md)

Create digital billboard creatives with the top players on the leaderboard from your selected tournament on the PGA Schedule This application will...

### [Pinterest Social Feed (By Tagbox)](app/PinterestSocialFeedByTagbox-reference.md)

Generate digital screen and digital billboard creatives from a Pinterest Social Feed. This app, powered by Tagbox Social Media Aggregator platform,...

### [Place Exchange](app/PlaceExchange1-reference.md)

Place Exchange is a platform that enables real programmatic out-of-home (OOH) advertising. This application for the Place Exchange Dynamic Creatives...

### [Powerball](app/Powerball-reference.md)

Automatically generate Powerball Lottery creatives with the latest Jackpot amount, add the latest drawing numbers, and even the next estimated...

### [Precious Metal Prices (By DIGICHIEF)](app/PreciousMetalPricesByDigichiefDemo-reference.md)

Add the latest prices for Gold, Silver, Copper, and Platinum to your digital out-of-home billboard creatives. #financial, #finance

### [Premier League Football](app/PremierLeagueFootball-reference.md)

Get Premier League Football (Soccer) standings and fixtures, live games, and results. Add live standings to your digital billboard OOH creatives,...

### [PriceAdvantage Fuel Prices](app/PriceadvantageFuelPrices-reference.md)

Live Gas prices for any station store using the PriceAdvantage fuel pricing software PriceAdvantage, by Skyline Products, is used by thousands of gas...

### [Product Inventory using Google Sheets](app/GoogleSheetsProductInventory-reference.md)

Get Product Inventory from a Google Drive Spreadsheet. Use an online spreadsheet to automate your product inventory onto your Lucit campaign. - title...

### [Product Launch Countdown](app/ProductLaunchCountdown-reference.md)

Add a dynamic product launch countdown creative with this sample product countdown template. Use this template as a jumping off point to design your...

### [Real Estate Agents using Google Sheets](app/GoogleSheetsRealEstateAgents-reference.md)

Get Real Estate Agents from a Google Drive Spreadsheet. Use an online spreadsheet to automate Real Estate Agents into your Lucit campaign. - name -...

### [Real Estate Properties using Google Sheets](app/LucitGoogleSheetsRealEstateProperties-reference.md)

Get Real Estate Properties from a Google Drive Spreadsheet. Use an online spreadsheet to automate Real Estate Properties into your Lucit campaign....

### [Recreational Inventory using Google Sheets](app/GoogleSheetsRecreationalInventory-reference.md)

Get Recreational Inventory from a Google Drive Spreadsheet. Use an online spreadsheet to automate your recreational inventory onto your Lucit...

### [Redline Automotive Merchandising](app/Redline2-reference.md)

Whether you’re looking for photography, video, lead-gen services or anything else to help drive more engagement and ROI, Redline has you covered....

### [Rental Properties using Google Sheets](app/RentalPropertiesUsingGoogleSheets-reference.md)

Get Rental / Commercial Lease Properties from a Google Drive Spreadsheet. Use an online spreadsheet to automate Real Estate Rental Properties into...

### [Reviews using Google Sheets](app/GoogleSheetsReview-reference.md)

Feed Review data from a Google Drive Sheets Spreadsheet. Use an online spreadsheet to automate your reviews into your Lucit campaign. #reviewer #star...

### [RMLS](app/Rmls1-reference.md)

The Northwest's largest MLS Data Service for Real Estate Agents and Brokerages Data Charges - Data charges may apply depending on the structure of...

### [RSS Feed](app/RssFeed-reference.md)

Build creatives from any website that provides RSS or Atom Feeds. Really Simple Syndication. It refers to files easily read by a computer called XML...

### [Santiam Pass Ski Patrol - Snow Depth](app/SantiamPassSkiPatrolSnowDepth-reference.md)

Fetch the current Snow Depth at Hoodoo Butte from Santiam Pass Ski Patrol sensor data

### [Shift4Shop](app/3dcart-reference.md)

The Shift4Shop eCommerce application provides product feeds in an RSS format. Shift4Shop (originally named 3dcart before its acquisition by Shift4...

### [Shopify](app/Shopify-reference.md)

eCommerce product inventory, photos and prices from your Shopify Online Store

### [SignBird](app/Signbird2-reference.md)

SignBird provides high quality location photos and videos for billboards and signs. SignBird has a national drone pilot network that will quickly...

### [Ski Resorts & Conditions](app/SkiResortsConditions-reference.md)

Get conditions at your favorite US and Canada Ski Resorts including Lift Status and snow conditions - Lift Status (Open Closed, Hold, Percentage) -...

### [Southeast Alabama Association of Realtors](app/SoutheastAlabamaAssociationOfRealtors-reference.md)

This application can pull MSL Data Feeds for Real Estate Agents and Brokerages and connect to your Lucit campaign. Feed all of your property data...

### [Stock Prices (By DIGICHIEF)](app/StockPricesByDigichief-reference.md)

Add real time stock prices to your digital out-of-home creatives with the Stock Prices app by Digi Chief. Add individual stocks, generate a top...

### [The Financial Times](app/TheFinancialTimes-reference.md)

The Financial Times is a British daily business newspaper that focuses on business and economic current affairs. Connect to this Data Source to add...

### [The New York Times News](app/NewYorkTimesWorldNews-reference.md)

The NY Times is an American daily newspaper based in New York City. Connect to this Data Source to add up-to-date news from The New York Times to...

### [The Washington Post](app/TheWashingtonPost-reference.md)

The Washington Post, locally known as " the Post " and, informally, WaPo or WP, is an American daily newspaper published in Washington, D.C. Connect...

### [This Day In History (By DIGICHIEF)](app/ThisDayInHistoryByDigichief-reference.md)

This app will return a random fact of events that occurred today in history. Including the name of the event and a short description #infotainment

### [Tickets Remaining : EventBrite](app/TicketsRemainingEventbrite-reference.md)

Display the number of tickets still remaining for your EventBrite events For users of Event Brite for managing your event, this integration will...

### [Trestle by Core Logic](app/TrestleCoreLogic1-reference.md)

Trestle is a real estate data distribution platform. It aggregates and normalizes data from disparate sources, automates the data licensing process,...

### [US Government Debt Counter](app/UsGovernmentDebtCounter-reference.md)

Build daily US Debt Counter creatives to show the current total amount of US Government Debt This app returns the following data points - Debt Held...

### [Useless Facts](app/UselessFacts-reference.md)

Generate creatives with random useless facts. Useless Facts API by Joseph Paul https://jsph.pl/

### [vAuto](app/Vauto1-reference.md)

The automotive inventory management system, vAuto, powered by Cox Automotive. Connect a lucit campaign with the inventory data already in vAuto. This...

### [VINSolutions](app/Vinsolutions1-reference.md)

VinSolutions is a vehicle inventory management system, powered by HomeNet, is a GPS-based software that allows dealers to find and promote specific...

### [Vistar Media Player](app/VistarMediaPlayer-reference.md)

Digital signage player application for the Vistar Media System. This application will connect with Lucit to make sure your ads run on your digital...

### [Watchfire](app/Watchfire1-reference.md)

Connect Lucit with your Watchfire campaign to manage your ads. Capabilities include creation of new ads, removal of inventory items not wished to...

### [Weather (Destination)](app/Weather2-reference.md)

Add weather data for a specifically selected location. All creatives will use this location regardless of the location of the physical screen Useful...

### [Weather (Screen Location)](app/Weather-reference.md)

Calculate live weather data conditions for each digital screen in your campaign, and add to your creatives such as current temp, forecast,...

### [Wix](app/Wix-reference.md)

Your Wix website can connect to Lucit to pull your blog posts into a template for easy posting. Create ads from the articles you are already creating.

### [WooCommerce](app/Woocommerce-reference.md)

Connect inventory product, prices and photos with the WooCommerce ecommerce app for Lucit

### [Wordpress](app/Wordpress-reference.md)

Your Wordpress website can connect to Lucit to pull your blog posts into a template for easy posting. Create ads from the articles you are already...

### [X Social Feed (By Tagbox)](app/XTwitterByTagbox-reference.md)

Generate digital screen and digital billboard creatives from an X Social Feed. This app, powered by Tagbox Social Media Aggregator platform, allows...



---

## Application Categories

### By Capability

Applications are organized by their primary capabilities:

#### Other

- [5 Star Business Reviews using Google Business Reviews](app/GoogleBusinessReviews-reference.md)
- [Adams Outdoor - Scala Ad Manager Integration](app/AdamsOutdoorScalaAdManagerIntegration-reference.md)
- [Ag Inventory using Google Sheets](app/GoogleSheetsAgInventory-reference.md)
- [AirNow Air Quality Index](app/AirnowAirQualityIndex-reference.md)
- [Alterra Mountain Co Ski Resorts - Snow Report](app/AlterraMountainCoSkiResortsSnowReport-reference.md)
- [Apparatix](app/Apparatix1-reference.md)
- [Article Inventory using Google Sheets](app/GoogleSheetsArticleInventory-reference.md)
- [Automotive Inventory using Google Sheets](app/GoogleSheets-reference.md)
- [AutoRevo](app/Autorevo1-reference.md)
- [Ayuda](app/Ayuda-reference.md)
- [Bible Verses](app/BibleVerses-reference.md)
- [Blip](app/Blip-reference.md)
- [Born On This Day (By DIGICHIEF)](app/BornOnThisDayByDigichief-reference.md)
- [Bridge Interactive MLS](app/BridgeInteractiveMls-reference.md)
- [CarsForSale](app/Carsforsale1-reference.md)
- [CDK Global](app/CdkGlobal1-reference.md)
- [Christmas Countdown](app/ChristmasCoundown-reference.md)
- [Coin Paprika](app/CoinPaprika-reference.md)
- [CoinDesk Live Bitcoin Price](app/CoindeskLiveBitcoinPrice-reference.md)
- [Commodity Prices (By DIGICHIEF)](app/CommodityPricesByDigichiefDemo-reference.md)
- [CTI MLS](app/CtiMls1-reference.md)
- [Daily Horoscope](app/DailyHoroscope-reference.md)
- [Daktronics](app/Daktronics1-reference.md)
- [Dealer Car Search](app/DealerCarSearch1-reference.md)
- [Dealer Specialties](app/DealerSpecialties1-reference.md)
- [DealersLink](app/Dealerslink1-reference.md)
- [DealerSpike](app/Dealerspike1-reference.md)
- [DOOHClick Player](app/DoohclickPlayer-reference.md)
- [Drive Time - Digital Screen to Location](app/DriveTimeDigitalBoardToLocation-reference.md)
- [ECRS eCommerce](app/Ecrs1-reference.md)
- [Ecwid Ecommerce](app/EcwidEcommerce1-reference.md)
- [ELead Automotive](app/EleadAutomotive-reference.md)
- [Epic Ski Resorts Snow Report](app/EpicSkiResortsSnowReport-reference.md)
- [Experity Urgent Care Wait Times](app/ExperityUrgentCareWaitTimes-reference.md)
- [Facebook Social Feed (By Tagbox)](app/FacebookSocialFeedByTagbox-reference.md)
- [Famous Quotes](app/FamousQuotes-reference.md)
- [Famous Quotes (By DIGICHIEF)](app/FamousQuotesByDigichief-reference.md)
- [FlexMLS](app/Flexmls1-reference.md)
- [Florida Gulf Coast MLS](app/FloridaGulfCoastMls-reference.md)
- [Formetco F360](app/FormetcoF360-reference.md)
- [Fox News](app/FoxNews-reference.md)
- [Fun Random Facts (By DIGICHIEF)](app/FunRandomFactsByDigichief-reference.md)
- [Google Sheets Key Value Data](app/GoogleSheetsKeyValueData-reference.md)
- [Health & Wellness Tips (By DIGICHIEF)](app/HealthWellnessTipsByDigichief-reference.md)
- [HomeNet Automotive](app/Homenet2-reference.md)
- [Instagram Social Feed (By Tagbox)](app/Instagram-reference.md)
- [Job Listings using Google Sheets](app/GoogleSheetsAvailableJobs-reference.md)
- [Lamar iSpot Player](app/LamarIspotPlayer-reference.md)
- [LDSK](app/Ldsk1-reference.md)
- [Lightning Player](app/LightningPlayer-reference.md)
- [LinkedIn Social Feed (By Tagbox)](app/LinkedinSocialFeedByTagbox-reference.md)
- [LIOPS (Lucit Ignite OP Supervisor)](app/LiopsLucitWatchfireIgniteOpSupervisor-reference.md)
- [Lotus Corp Radio - Now Playing](app/LotusCorpRadioNowPlaying-reference.md)
- [Loveland Ski Area Snow Pack Depth](app/LovelandSkiAreaSnowPackDepth-reference.md)
- [Lucit Sample Data Sources](app/LucitSampleDataSources-reference.md)
- [Machine Finder](app/MachineFinder1-reference.md)
- [Matrix MLS by CoreLogic](app/MatrixMlsByCorelogic-reference.md)
- [Mega Millions](app/MegaMillions-reference.md)
- [MLB Live Game Scores](app/MlbLiveGameScores-reference.md)
- [Navica MLS](app/NavicaMls1-reference.md)
- [NBA Live Game Scores](app/NbaLiveGameScores-reference.md)
- [NCAA Basketball - Live Game Scores](app/NcaaBasketballLiveGameScores-reference.md)
- [NCAA College Football Live Game Scores](app/NcaaCollegeFootballLiveGameScores-reference.md)
- [NCAA Womens Volleyball Scores](app/NcaaWomensVolleyballScores-reference.md)
- [Nearest Location using Google Sheets](app/NearestLocationDataViaGoogleSheets-reference.md)
- [NFL Live Game Scores](app/NflLiveGameScores-reference.md)
- [Northwoods League Baseball](app/NorthwoodsLeagueBaseball-reference.md)
- [NTREIS MLS Data](app/NtreisMlsData-reference.md)
- [Oil and Gas Market Prices (By DIGICHIEF)](app/OilAndGasMarketPricesByDigichief-reference.md)
- [Outfront Media Player](app/OutfrontMediaPlayer-reference.md)
- [Paragon MLS](app/ParagonMls-reference.md)
- [Paris 2024 Summer Olympics](app/Paris2024Olympics-reference.md)
- [PGA Golf Tour Leaderboards](app/PgaGolfTourLeaderboards-reference.md)
- [Pinterest Social Feed (By Tagbox)](app/PinterestSocialFeedByTagbox-reference.md)
- [Place Exchange](app/PlaceExchange1-reference.md)
- [Powerball](app/Powerball-reference.md)
- [Precious Metal Prices (By DIGICHIEF)](app/PreciousMetalPricesByDigichiefDemo-reference.md)
- [Premier League Football](app/PremierLeagueFootball-reference.md)
- [PriceAdvantage Fuel Prices](app/PriceadvantageFuelPrices-reference.md)
- [Product Inventory using Google Sheets](app/GoogleSheetsProductInventory-reference.md)
- [Product Launch Countdown](app/ProductLaunchCountdown-reference.md)
- [Real Estate Agents using Google Sheets](app/GoogleSheetsRealEstateAgents-reference.md)
- [Real Estate Properties using Google Sheets](app/LucitGoogleSheetsRealEstateProperties-reference.md)
- [Recreational Inventory using Google Sheets](app/GoogleSheetsRecreationalInventory-reference.md)
- [Redline Automotive Merchandising](app/Redline2-reference.md)
- [Rental Properties using Google Sheets](app/RentalPropertiesUsingGoogleSheets-reference.md)
- [Reviews using Google Sheets](app/GoogleSheetsReview-reference.md)
- [RMLS](app/Rmls1-reference.md)
- [RSS Feed](app/RssFeed-reference.md)
- [Santiam Pass Ski Patrol - Snow Depth](app/SantiamPassSkiPatrolSnowDepth-reference.md)
- [Shift4Shop](app/3dcart-reference.md)
- [Shopify](app/Shopify-reference.md)
- [SignBird](app/Signbird2-reference.md)
- [Ski Resorts & Conditions](app/SkiResortsConditions-reference.md)
- [Southeast Alabama Association of Realtors](app/SoutheastAlabamaAssociationOfRealtors-reference.md)
- [Stock Prices (By DIGICHIEF)](app/StockPricesByDigichief-reference.md)
- [The Financial Times](app/TheFinancialTimes-reference.md)
- [The New York Times News](app/NewYorkTimesWorldNews-reference.md)
- [The Washington Post](app/TheWashingtonPost-reference.md)
- [This Day In History (By DIGICHIEF)](app/ThisDayInHistoryByDigichief-reference.md)
- [Tickets Remaining : EventBrite](app/TicketsRemainingEventbrite-reference.md)
- [Trestle by Core Logic](app/TrestleCoreLogic1-reference.md)
- [US Government Debt Counter](app/UsGovernmentDebtCounter-reference.md)
- [Useless Facts](app/UselessFacts-reference.md)
- [vAuto](app/Vauto1-reference.md)
- [VINSolutions](app/Vinsolutions1-reference.md)
- [Vistar Media Player](app/VistarMediaPlayer-reference.md)
- [Watchfire](app/Watchfire1-reference.md)
- [Weather (Destination)](app/Weather2-reference.md)
- [Weather (Screen Location)](app/Weather-reference.md)
- [Wix](app/Wix-reference.md)
- [WooCommerce](app/Woocommerce-reference.md)
- [Wordpress](app/Wordpress-reference.md)
- [X Social Feed (By Tagbox)](app/XTwitterByTagbox-reference.md)



---

## Getting Started

To add any of these applications to your account:

1. Click on the application name above to view its detailed reference
2. Follow the installation instructions on the application's page
3. Configure the application settings as needed
4. Start using the application's features

---

## Related Documentation

- [Application Classes & Capabilities Reference](application-capabilities-reference.md) - Learn about application classes and capabilities
- [Application Permissions Reference](application-permissions-reference.md) - Understand bot permissions
- [API Reference](../api/index.html) - Complete API documentation

---

*Last updated: 2026-01-16 10:26:37 UTC*
