# Developer Resources

Welcome to the Lucit developer resources section. Here you'll find technical documentation, API references, and integration guides.

## API Documentation

Our comprehensive API documentation provides detailed information about all endpoints, authentication methods, and code examples.

**[📖 View API Reference](api/){: .md-button .md-button--primary}**

The API documentation includes:

- **Authentication** - Learn how to authenticate your requests
- **Endpoints** - Complete reference for all available API endpoints  
- **Examples** - Code examples in multiple programming languages
- **Response Formats** - Detailed response schemas and error codes
- **Rate Limits** - Information about API usage limits
- **SDKs** - Available software development kits

## Quick Links

- [API Reference](api/) - Interactive API documentation
- [OpenAPI Spec](api/openapi.yaml) - Machine-readable API specification
- [Postman Collection](api/collection.json) - Ready-to-use Postman collection

## Support

If you need help with the API or have questions about integration:

- Check the [FAQ](../faq/) for common questions
- Review the API documentation for detailed examples
- Contact our support team for technical assistance

---

*Last updated: January 2, 2026*

## Templates

Resources for building, structuring, and styling Lucit templates:

- [Template Index](templates/index.md)
- [Lucit Template HTML Guide](templates/lucit-template-html-guide.md)
- [Lucit Template CSS Guide](templates/lucit-template-css-guide.md)
- [Lucit Template Animation Guide](templates/lucit-template-animation-guide.md)
- [Managed Template CSS Styles Reference](templates/template-css-styles.md)
- [Text Formatting Functions Guide](./templates/lucit-text-formatting-functions-guide.md)
- [Lucit Render App Guide](templates/lucit-render-app-guide.md)

Use these to understand the HTML/CSS architecture, editable styles, render app integration, and how to structure template-specific assets across screen formats.
