---
title: "Field Map Macro Reference"
description: "Complete reference of all available Lucit macros organized by object type and prefix"
keywords: "lucit macros, field map reference, dynamic fields, macro documentation, api reference"
---

# Field Map Macro Reference

This document provides a comprehensive reference of all available standard macros in the Lucit platform. Macros are organized by object type and prefix for easy navigation.

---

## About This Reference

This reference is automatically generated from the Lucit API Field Maps and includes all publicly available standard macros. Each macro is documented with:

- **Name** - Human-readable name of the macro
- **Macro** - Full macro syntax (with curly braces) for use in templates
- **Description** - What the macro represents or provides
- **Type** - The macro type (text, img, object, svg)
- **Data Type** - The data type of the macro value
- **Placeholder** - Default placeholder value
- **Enum** - Whether the macro has predefined enum options

For more information about field maps and how to use macros, see the [Field Map Specification](field-map-specification.md).

---

## Standard Macros vs Application Macros

Standard macros (included in this guide) are available to all Lucit accounts.   In addition to the standard macros, Applicatoins can provide additional macros via their data sources.  See [Application Reference](./../apps/index.md)

## Quick Navigation

- [Account Macros](#account-macros)
- [Digital Board Macros](#digital-board-macros)
- [Inventory Item Macros](#inventory-item-macros)

---

## Account Macros


### Prefix: `account.`

| Name | Macro | Description |
|------|-------|-------------|
| Name | `{account.name}` | — |
| Website | `{account.website}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Name | text | — | Your Company Name | — |
| Website | text | — | https://www.yourcompany.com | — |


### Prefix: `account.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Logo | `{account.options.primary_image_public_url}` | — |
| Logo (No Background) | `{account.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Logo | img | — | https://lucit.app/assets/designer/image_placeholder_Account.png | — |
| Logo (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Account.png | — |



## Digital Board Macros


### Prefix: `digital_board.`

| Name | Macro | Description |
|------|-------|-------------|
| Screen Identifier | `{digital_board.board_identifier}` | — |
| Screen Name | `{digital_board.name}` | — |
| Screen Tags | `{digital_board.cached_tags}` | — |
| Screen Venue Taxonomy ID | `{digital_board.venue_taxonomy_id}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Screen Identifier | text | — | SCREEN123 | — |
| Screen Name | text | — | The Screen | — |
| Screen Tags | text | — | tag1:tag2:tag3 | — |
| Screen Venue Taxonomy ID | text | — | 12345 | — |


### Prefix: `digital_board.location.`

| Name | Macro | Description |
|------|-------|-------------|
| City | `{digital_board.location.city}` | — |
| City Name Possessive | `{digital_board.location.options.geo_city_name_possessive}` | — |
| Country | `{digital_board.location.options.geo_country_name}` | — |
| Country Code | `{digital_board.location.country}` | — |
| Country Code Possessive | `{digital_board.location.options.geo_country_code_possessive}` | — |
| Country Possessive | `{digital_board.location.options.geo_country_name_possessive}` | — |
| Days Since Unix Epoch | `{digital_board.location.days_since_unix_epoch}` | — |
| Fifteen Minute Intervals Since Unix Epoch | `{digital_board.location.fifteen_minute_intervals_since_unix_epoch}` | — |
| Five Minute Intervals Since Unix Epoch | `{digital_board.location.five_minute_intervals_since_unix_epoch}` | — |
| Hours Since Unix Epoch | `{digital_board.location.hours_since_unix_epoch}` | — |
| Postal Code | `{digital_board.location.postal_code}` | — |
| State / Province | `{digital_board.location.options.geo_state_name}` | — |
| State / Province Code | `{digital_board.location.region}` | — |
| State Code Possessive | `{digital_board.location.options.geo_state_code_possessive}` | — |
| State Possessive | `{digital_board.location.options.geo_state_name_possessive}` | — |
| Thirty Minute Intervals Since Unix Epoch | `{digital_board.location.thirty_minute_intervals_since_unix_epoch}` | — |
| Timezone | `{digital_board.location.timezone}` | — |
| Timezone Offset Seconds | `{digital_board.location.timezone_offset_seconds}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| City | text | — | Anytown | — |
| City Name Possessive | text | — | Anytown's | — |
| Country | text | — | United States | — |
| Country Code | text | — | USA | — |
| Country Code Possessive | text | — | USA's | — |
| Country Possessive | text | — | United States' | — |
| Days Since Unix Epoch | text | — | 5000 | — |
| Fifteen Minute Intervals Since Unix Epoch | text | — | 5000 | — |
| Five Minute Intervals Since Unix Epoch | text | — | 5000 | — |
| Hours Since Unix Epoch | text | — | 5000 | — |
| Postal Code | text | — | 12345 | — |
| State / Province | text | — | New York | — |
| State / Province Code | text | — | NY | — |
| State Code Possessive | text | — | NY's | — |
| State Possessive | text | — | New York's | — |
| Thirty Minute Intervals Since Unix Epoch | text | — | 5000 | — |
| Timezone | text | — | America/Chicago | — |
| Timezone Offset Seconds | text | — | -21600 | — |



## Inventory Item Macros

*Inventory items have different field maps depending on their class type.*


### Ag Inventory Items

*Class: `App\LuCore\InventoryItems\AgInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Make | `{item.make}` | — |
| Model | `{item.model}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Stock # | `{item.dealer_stock_number}` | — |
| Sub Model (Trim) | `{item.sub_model}` | — |
| Title | `{item.title}` | — |
| Year | `{item.year}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Make | text | — | Ford | — |
| Model | text | — | Mustang | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Stock # | text | — | T12345 | — |
| Sub Model (Trim) | text | — | GT | — |
| Title | text | — | Your Caption | — |
| Year | text | — | 2026 | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### Article Inventory Items

*Class: `App\LuCore\InventoryItems\ArticleInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### Automotive Inventory Items

*Class: `App\LuCore\InventoryItems\AutomotiveInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Make | `{item.make}` | — |
| Model | `{item.model}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Stock # | `{item.dealer_stock_number}` | — |
| Sub Model (Trim) | `{item.sub_model}` | — |
| Title | `{item.title}` | — |
| Vin | `{item.vin}` | — |
| Year | `{item.year}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Make | text | — | Ford | — |
| Model | text | — | Mustang | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Stock # | text | — | T12345 | — |
| Sub Model (Trim) | text | — | GT | — |
| Title | text | — | Your Caption | — |
| Vin | text | — | XYZ1234567879 | — |
| Year | text | — | 2026 | — |


### Prefix: `item.inventory_attributes.`

| Name | Macro | Description |
|------|-------|-------------|
| Mileage | `{item.inventory_attributes.mileage}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Mileage | text | — | 100,000 | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### Creative Inventory Items

*Class: `App\LuCore\InventoryItems\CreativeInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### DefaultCreative Inventory Items

*Class: `App\LuCore\InventoryItems\DefaultCreativeInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### JobPost Inventory Items

*Class: `App\LuCore\InventoryItems\JobPostInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### PhotoStream Inventory Items

*Class: `App\LuCore\InventoryItems\PhotoStreamInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Fourth Sub Title | `{item.sub_model}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Secondary Sub Title | `{item.make}` | — |
| Sub Title | `{item.description}` | — |
| Third Sub Title | `{item.model}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Fourth Sub Title | text | — | Fourth Sub Title | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Secondary Sub Title | text | — | Another Sub Caption | — |
| Sub Title | text | — | A second caption | — |
| Third Sub Title | text | — | Third Sub Caption | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### Product Inventory Items

*Class: `App\LuCore\InventoryItems\ProductInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### RealEstateAgent Inventory Items

*Class: `App\LuCore\InventoryItems\RealEstateAgentInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### RealEstate Inventory Items

*Class: `App\LuCore\InventoryItems\RealEstateInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Title | text | — | Your Caption | — |


### Prefix: `item.location.`

| Name | Macro | Description |
|------|-------|-------------|
| Address | `{item.location.address}` | — |
| City | `{item.location.city}` | — |
| City Name Possessive | `{item.location.options.geo_city_name_possessive}` | — |
| Country Code | `{item.location.country}` | — |
| Country Code Possessive | `{item.location.options.geo_country_code_possessive}` | — |
| Country Name | `{item.location.options.geo_country_name}` | — |
| Country Name Possessive | `{item.location.options.geo_country_name_possessive}` | — |
| Postal Code | `{item.location.postal_code}` | — |
| State / Province Code | `{item.location.region}` | — |
| State / Province Name | `{item.location.options.geo_state_name}` | — |
| State Code Possessive | `{item.location.options.geo_state_code_possessive}` | — |
| State Name Possessive | `{item.location.options.geo_state_name_possessive}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Address | text | — | 12345 Main St | — |
| City | text | — | Anytown | — |
| City Name Possessive | text | — | Anytown's | — |
| Country Code | text | — | USA | — |
| Country Code Possessive | text | — | USA's | — |
| Country Name | text | — | Unite States | — |
| Country Name Possessive | text | — | United States' | — |
| Postal Code | text | — | 12345 | — |
| State / Province Code | text | — | NY | — |
| State / Province Name | text | — | New York | — |
| State Code Possessive | text | — | NY's | — |
| State Name Possessive | text | — | New York's | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### Recreational Inventory Items

*Class: `App\LuCore\InventoryItems\RecreationalInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Description | `{item.description}` | — |
| Make | `{item.make}` | — |
| Model | `{item.model}` | — |
| Original Price | `{item.price_original}` | — |
| Price | `{item.price}` | — |
| Stock # | `{item.dealer_stock_number}` | — |
| Sub Model (Trim) | `{item.sub_model}` | — |
| Title | `{item.title}` | — |
| Year | `{item.year}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Description | text | — | This is likely a longer description of the item and probably is longer text than the title will be | — |
| Make | text | — | Ford | — |
| Model | text | — | Mustang | — |
| Original Price | text | — | 35765 | — |
| Price | text | — | 25968 | — |
| Stock # | text | — | T12345 | — |
| Sub Model (Trim) | text | — | GT | — |
| Title | text | — | Your Caption | — |
| Year | text | — | 2026 | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### Review Inventory Items

*Class: `App\LuCore\InventoryItems\ReviewInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Author Name | `{item.title}` | — |
| Number of Stars | `{item.model}` | — |
| Relative Time Description | `{item.make}` | — |
| Review Text | `{item.description}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Author Name | text | — | Sam Smith | — |
| Number of Stars | text | — | 5 | — |
| Relative Time Description | text | — | 3 days ago | — |
| Review Text | text | — | The service here is amazing! | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Author Avatar | `{item.options.primary_image_public_url}` | — |
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Author Avatar | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |


### SocialPost Inventory Items

*Class: `App\LuCore\InventoryItems\SocialPostInventoryItemClass`*


### Prefix: `item.`

| Name | Macro | Description |
|------|-------|-------------|
| Like Count | `{item.model}` | — |
| Platform Name | `{item.make}` | — |
| Post Message | `{item.description}` | — |
| Post Title | `{item.title}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Like Count | text | — | 4 | — |
| Platform Name | text | — | Facebook | — |
| Post Message | text | — | Here is an amazing social media post that I made | — |
| Post Title | text | — | Short title of post | — |


### Prefix: `item.inventory_attributes.`

| Name | Macro | Description |
|------|-------|-------------|
| Author Avatar Image | `{item.inventory_attributes.post_author_avatar_url}` | — |
| Author Name | `{item.inventory_attributes.post_author_name}` | — |
| Platform Image | `{item.inventory_attributes.platform_image_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Author Avatar Image | img | — | https://lucit.app/assets/designer/image_placeholder_User.png | — |
| Author Name | text | — | Sam Smith | — |
| Platform Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |


### Prefix: `item.options.`

| Name | Macro | Description |
|------|-------|-------------|
| Item Image (No Background) | `{item.options.primary_image_background_removed_public_url}` | — |
| Post Image | `{item.options.primary_image_public_url}` | — |

**Additional Details:**

| Name | Type | Data Type | Placeholder | Enum |
|------|------|-----------|-------------|------|
| Item Image (No Background) | img | — | https://lucit.app/assets/designer/image_placeholder_transparent_Item.png | — |
| Post Image | img | — | https://lucit.app/assets/designer/image_placeholder_Item.png | — |



---

## Additional Resources

- [Field Map Specification](field-map-specification.md) - Detailed specification of field map structure
- [API Reference](../api/index.html) - Complete Lucit API documentation
- [Developer Resources](../index.md) - All developer documentation

---

*This documentation is automatically generated. Do not edit manually.*
*Generated on: January 16, 2026 at 09:25 AM*
