---
title: "Field Map Specification for Lucit Dynamic Macros"
description: "Lucit Macros are presented via APIs to templates and triggers via the lucit field map. This field map describes each macro, and provides options and settings for each one"
keywords: "dynamic ooh macros, macros, dynamic content fields, template macros, trigger fields"
---

# Field Map Specification for Lucit Dynamic Macros

## Overview

Lucit [macros](../../definitions.md#macro) are used by [dynamic templates](../../definitions.md#dynamic-creative) and [triggers](../../definitions.md#trigger) to provide dynamic data for rendering creatives or making creative activation decisions via triggers.

These macros are presented to the UI and to API Users via **Field Maps**. A field map describes each macro and provides options and settings for each one.  View the complete [Macro Reference](field-map-macro-reference.md) for a list of every individual macro that is available.

## Where are field maps used?

Field maps are used in the following places in the Lucit UI:

* **Templates** - On the template designer, under Dynamic Data Elements: `Templates → {Template} → Elements Panel → Expand Dynamic Data Elements`. See the [Template Designer General Navigation Guide](../../guides/template-designer-general-navigation-guide.md) for detailed information on using templates.
* **Creative Trigger** - On the item triggers in a campaign: `Campaigns → {Campaign} → CREATIVE ITEMS tab → {Creative Item} → {FolderWithStarIcon}`
* **Campaign Item Filter** - When a campaign is set to `Auto Add New Items To Campaign`, the `Item Filter` allows filtering on macros
* **Data Source Template Assignments** - For data sources that generate inventory items and can attach templates, custom Additional Templates can be set on the item depending on the values of the filter: `Apps & Data → {Click on App} → TEMPLATES tab → Additional Templates section → Filter next to each template`
* **Data Source Auto Add to Campaign Triggers** - When a data source is set to Automatically post items it creates to a specific campaign, you can pre-set the triggers that will be attached to the item when it is first added: `Apps & Data → {Click on App} → SETTINGS tab → Campaigns → Automatic → {FolderWithStarIcon}`

## Source Objects

The following objects provide field maps:

* **Account** - General account level values
    * Used on Templates: `account.`
* **Digital Board** - Values specifically tied to a screen and its location
    * Used on Templates and Triggers: `digital_board.`
* **User** - Values for the user who created the creative ad
    * Used on Templates: `user.`
* **Inventory Item** - The container item for a specific ad
    * Used on templates, data source template assignments, and campaign Item Filters: `item.`
* **App (Data Source Provider)** - A third party data source that provides either global key/value pairs or inventory item specific values
    * **Key Value Pairs** 
        * Used on Templates and Triggers:
            * `account.store.`
            * `digital_board.store.`
    * **Inventory Items**
        * Used on templates, data source template assignments, and campaign item filters:
            * `item.`


## Fetching Field Maps

Using the [Lucit API](../api/index.html), you can fetch field maps via the following endpoints:

- **Account** - `GET /accounts/constants/field-map`
- **Digital Board** - `GET /digital-boards/constants/field-map`
- **Inventory Item** - `GET /inventory-items/constants/field-map`
- **Data Source** - `GET /data-source-providers/{id}/field-map`

## Available Prefixes

The following is a guide to the prefixes you will see in the field map:

| Object | Prefix | Notes |
| --- | --- | --- |
| Account | `account.` | Account fields |
| Account | `account.options.` | Account option fields |
| Account | `account.store.` | Global key/value fields for the account |
| User | `user.` | User fields |
| User | `user.options.` | User option fields |
| Inventory Item | `item.` | Inventory item fields |
| Inventory Item | `item.options.` | Inventory item option fields |
| Inventory Item | `item.location.` | Inventory item location fields |
| Inventory Item | `item.location.options.` | Inventory item location option fields |
| Inventory Item | `item.inventory_attributes.` | Inventory item custom attribute fields (Typically unique fields that have been added by a data source app. Different across data sources) |
| Digital Board | `digital_board.` | Digital Board fields |
| Digital Board | `digital_board.location.` | Digital Board Location fields |
| Digital Board | `digital_board.location.options.` | Digital Board Location Option fields |
| Digital Board | `digital_board.store.` | Key/Value fields attached to this specific digital board |

**NOTE:** In Templates, you will also see image and video (asset) macros that take the following form: 

* **Image**: `{LCUID-LM-xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx.options.public_url}`
* **Video**: `{LCUID-LMV-xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx.options.public_url}`

These macros represent assets that were uploaded directly to the Template.

## Macro Types

The following macro types are supported:

| Type | Notes |
| --- | --- |
| `text` | Produces a text field |
| `img` | Produces an image field |
| `object` | Produces an object field (e.g. a `div`) |
| `svg` | Provides an SVG type object |

## Enum Types

The following enum types are supported for fields with enums:

| Type | Notes |
| --- | --- |
| `none` | No enum |
| `strict` | Strict set of values, cannot be anything else |
| `loose` | Loose set of values, you can add/enter custom text |
| `sample` | Values are only samples. Not restrictive and you can enter custom text |

## Data Types

| Data Type | Notes |
| --- | --- |
| scalar | Scalar (Could be any of text or number) |
| string | Text |
| float | Decimal Number |
| integer | Whole Number |
| boolean | True/False |
| datetime | Date/Time |
| tags | Tags |
| geo_location | Geo Location |
| geo_tags | Geo Tags |


## Field Map Structure

A field map will have the following structure:

```json
{ 
    "field_map": {
        "some_field_key_id": {
            //...field map keys
        },
        "another_field_key_id": {
            //...field map keys
        }
    }
}
```

Sometimes, field maps belong to a specific class (e.g. The Inventory Item field map). These are keyed on those classes like this:

```json
{
    "field_maps": {
        "App\\LuCore\\InventoryItems\\AutomotiveInventoryItemClass": {
            "some_field_key_id": {
                //...field map keys
            },
            "another_field_key_id": {
                //...field map keys
            }
        },
        "App\\LuCore\\InventoryItems\\SomeOtherInventoryItemClass": {
            //...etc.
        }
    }
}
```

## Field Map Keys

The following keys will appear in a field map for a field:

| Key | Notes |
| --- | --- |
| id | An id for this key in non-dotted notation form (using underscores) |
| object | The source object of this key |
| object_name | The name of the source object of this key |
| description | Key description - Can be blank |
| group_id | An id for grouping keys in the UI |
| group_name | Name of the group |
| group_parent_id | An lcuid of the group (typically an app or data source) |
| class | A class associated with this key |
| property | A dotted property for this key. May or may not include the object prefix |
| macro | The full macro for this key without curly braces. Always includes the object prefix |
| macroCode | The macro, but surrounded by curly braces. Useful for copy/paste or pattern matching |
| name | A nice name for the key |
| placeholder | A placeholder to use for this key when adding to a template |
| type | One of the valid *Macro Types* |
| dataType | Data type of the value, defaults to `scalar` |
| defaultClasses | When this macro is added to the template, automatically set these css classes on the container div |
| defaultCss | When this macro is added to a template, automatically add this css to the style attribute on the container div |
| show | If this is `false`, do not show this macro in the UI |
| enum | Set to `true` to provide a drop-down of available values |
| enum_type | One of the valid *Enum Types* |
| enum_options | An array of options for this enum with keys `value` (required), `label` (required), `description` (optional), `icon` (optional - uri to an image) |

