# Lucit Template Animation Guide

## Overview

Lucit Templates support adding animations to elements in the Template Designer. These animations are executed at the appropriate time during editing and during render/play.

## Important Concepts and Prerequisites

* Animations are stored in the `x-animations` attribute on the element being animated, not in inline CSS or style attributes. This lets the Render App execute animations at the right time, both in the editor and at render/play.
* Animations are only supported for templates with Motion enabled (Template → {SettingsGearIcon} → Advanced tab → enable "Motion Capable").
* Animations are only supported in Lucit campaigns where HTML Source Type is set to `Drive Template` (Campaigns → {Campaign} → {3VerticalDotsIcon} → Settings → HTML Source Type dropdown → change from Snapshot to Drive Template).
* Animations are only supported by third-party CMS/Player systems that can render HTML on the screen.

## Adding Animations to an Element

Assuming Motion is enabled for your template:

To add and edit animations and their settings:

1. Add an element to your canvas (for example, a rectangle).
2. Click the element.
3. In the `Edit` panel, scroll down to `Animations` and click `+ANIMATION`.
4. Select the Animation Name (e.g., `Bounce In` or `Fade In Right`).
5. Configure the Duration, Delay, Loop, Direction, and Fill Mode.

This animation appears under a numbered tab (e.g., `1`), which indicates its order.

To add another animation, click the `{PlusSignIcon}` next to the last numbered tab under `Animations`, then repeat.

## Playing Animations

Animations play in these scenarios:

* **Auto play** when the `designer_ready` message is emitted and auto play is enabled.
* **Triggered play** when `designer_ready` is emitted, auto play is disabled, and the Render App receives a `designer_play_content` message from the host (parent container/player).
    * This mode is used in the Template Designer editor and by some player systems that support Lucit animations directly, like the **Lighting Player by Lucit**.

In the Template Designer, you can play animations by:

* Clicking the `PLAY` button on the `Edit` tab in the `Animations` section.
* Clicking the `{PlayIcon}` in the `Action Bar` at the bottom of the canvas.


## Animations Architecture

Animations are keyframes that are executed according to their settings.

**Keyframes**

Keyframes come from two sources:

* **Built-in** The standard Lucit-provided keyframes are stored in the CSS file `dt_animations.css` provided by the Render App. See [Template Animations Keyframes](./template-animation-keyframes.md) for a complete list of available keyframes.
* **Custom** Add custom keyframes by adding `@keyframes` rules to the template's Global CSS.
    * Important: Because keyframes must be global, add them to the template before changing the template's Editor Mode to `Each Size Independently`. To add custom keyframes, the Editor Mode must be set to `All Sizes`.

The combined list of keyframes (built-in and custom) is listed in the Animations dropdown in the Edit panel. `Click element on canvas → Edit tab → Animations → {PlusSign} ANIMATION → Choose Animation`.


**Settings**

The following settings are supported for each animation added to an element (multiple animations are supported):

* `number` **Order** An order number identifying each animation 
* `name` **Keyframe** the keyframe to use.
* `duration` **Duration** how long the animation runs (seconds; decimals supported).
* `delay` **Delay** seconds to wait before starting (decimals supported).
* `iteration` **Loop** None, Once, Forever, or a custom count.
* `direction` **Direction** one of Normal, Reverse, Alternate, Alternate Reverse (stored as CSS-style values in JSON).
* `fillMode` **Fill Mode** one of None, Forwards, Backwards, Both (stored as CSS-style values in JSON).

Note: UI labels may be title-cased (e.g., "Alternate Reverse"), while stored JSON uses CSS-style lowercase values with hyphens (e.g., `alternate-reverse`, `forwards`).

The values of these settings are represented in the `x-animations` attribute JSON array as follows (comments for illustration):

```json
[
    {
        "number": 1,
        "name": "bounceIn",
        "duration": 1,
        "delay": 0,
        "iteration": 1,
        "direction": "normal",
        "fillMode": "backwards"
    }
]
```

An element with multiple animations will look like this:

```json
[
    {
        "number": 1,
        "name": "bounceIn",
        "duration": 1,
        "delay": 0,
        "iteration": 1,
        "direction": "normal",
        "fillMode": "backwards",
        "isCustomIteration": false
    },
    {
        "number": 2,
        "name": "bounceOutDown",
        "duration": 1,
        "delay": 1.5,
        "iteration": 1,
        "direction": "normal",
        "fillMode": "forwards"
    }
]
```

A complete element HTML with animations would look like this:


```html
<div
    id="obj_rectangle_8ytgoz0n"
    title="Rectangle"
    x-objectcode="rectangle"
    class="lc_ut_designer lc_dt_element lc_dt_object"
    style=""
    x-fieldname="rectangle"
    x-optional-field="false"
    x-element-settings="{}"
    x-element-setting-values="{}"
    x-animations='[{"number":1,"name":"bounceIn","duration":1,"delay":0,"iteration":1,"direction":"normal","fillMode":"backwards","isCustomIteration":false},{"number":2,"name":"bounceOutDown","duration":1,"delay":1.5,"iteration":1,"direction":"normal","fillMode":"forwards"}]'>
    <div></div>
</div>
```

### Troubleshooting

If animations aren’t playing:

* Ensure Motion is enabled for the template.
* For Lucit campaigns, verify HTML Source Type is set to `Drive Template`.
* Confirm the player/CMS supports rendering HTML and, if needed, Lucit animation messages.
