# Lucit Template HTML Guide

This is a guide to the HTML structure for Lucit Templates


## Overview

Lucit Template HTML is combined with Render App HTML to produce a final HTML document

This guide describes the structure of this HTML

## Rules

The following "rules" are in effect for our HTML templates.   These rules help to ensure that we can render these templates in the Lucit Template Designer (a WYSIWYG design tool) and that the templates will render as expected in Render App on every screen format size.

**All first layer elements**
1.  MUST be either a `div` or a `video` element
    * *Why?* - The Lucit Template Designer can only detect layers that are div or video elements
2.  MUST be siblings that are direct children of the Render App Container div
    * *Why?* - The Lucit template designer creates a layer list based on the direct children of the parent div `lc_dt_container`
3.  MUST be absolutely positioned inside their parent `div` `container` (class `lc_dt_container`) which is provided by render app
    * *Why* - Absolute positioning is used to ensure that the template is responsive to different screen formats
    * Positioning is provided by their css classes, and, the custom CSS applied.
    * Positioning MUST be in relative units (percentages) NOT IN pixels
4. MUST have the `lc_ut_designer` class
5. MUST have one of the following element primary classes
    * `lc_dt_text`
    * `lc_dt_image`
    * `lc_dt_video`
    * `lc_dt_object`
    * `lc_dt_object_svg`
6.  MUST have the following attributes
    * `id` - Must be unique
    * `title`
    * `class`
    * `x-objectcode` - A code that maps to the Field Map that provided this element
    * `x-fieldname` - Name of field in the Layers Panel
7.  MAY have the following attributes
    * `style`
    * `data-value` - For dynamic elements, contains macros from the Field Map.  This attribute is used to store the dynamic value of the element before any formatting or changes are made to it.
    * `x-placeholder` - A placeholder that appears when no macro value has been set on a dynamic field
    * `x-optional-field` - if `true` this dynamic field does not have to be filled out during Post Ad, if empty or false, then when posting an ad, the user will be required to fill out a value for this field.
    * `x-element-settings` - Contains configurable settings for this dynamic element
    * `x-element-setting-values` - Contains the values of those settings that were selected
    * `x-group-parent-id` - If this dynamic element belongs to an application data source - This is the `LCUID` of the data source
    * `x-animations` - A serialized array of JSON objects containing the animations to apply to this element.
    * `data-max-font-size` - When a `lc_dt_text` element has the `lc_format_fit_text` class, this is the maximum size that the font will grow to.  This is represented in `vmax` units.   If empty, there is no max size.
    * `data-max-chars` - For dynamic `lc_dt_text` elements, the maximum number of characters that will be displayed in this element.  If empty, there is no limit
    * `data-max-chars-show-ellipsis` - For `lc_dt_text` elements when `data-max-chars` is set, whether or not to show an ellipses at the end of any cut-off text
    * `data-video-delay` - For `lc_dt_video` elements, how long to delay, in seconds before playing this video
    * `muted` - MUST exist For `lc_dt_video` elements, MUST be set to `muted`
    * `preload` - MUST exist For `lc_dt_video` elements, MUST be set to `metadata`
    * `playsinline` - MUST exist For `lc_dt_video` elements, MUST be set to `playsinline`
    * `poster` - For `lc_dt_video` elements, the url to the poster / display image for this video
8.  Inner HTML MAY contain
    * Text when element is `lc_dt_text`
    * SVG or HTML code when element is `lc_dt_object_svg` or `lc_dt_object`
9.  Style attribute MAY contain
    * `background-image: url('')` when element is `lc_dt_image`


## Functional Classes

The following is a list of CSS classes that provide function in some way to elements

* `lc_dt_text`  Is a text element that will have Inner HTML containing text
    * These element may contain one of the following additional classes
        * `lc_format_fit_text` auto grow-shrink dynamic text to fit the bounds of the div
        * `lc_format_{function}` special functional classes used by Designer Text Formatting Functions.  For example, `lc_format_price_us` formats the text as a price with a dollar sign.  `lc_format_round_integer` will round the number to the nearest integer, etc. 
* `lc_dt_asset` Any image or video element uploaded to the template by the user has this class to signify that is an upload asset
* `lc_dt_image` An image element that contains a background image in the `style` attribute
    * These elements may contain one of the following additional classes
        * `lc_dt_preserve_aspect` preserves its aspect ratio
        * `lc_dt_image_full_size_stretch` stretch to completely fill the size of the screen
        * `lc_dt_default_background` A default background layer for the canvas.  Does not appear in the layers panel as editable in any way
* `lc_dt_object` A `div` element that can contain additional html in its Inner Html
* `lc_dt_object_svg` a `div` element that contains `svg` in its Inner Html
* `lc_dt_data` A div that contains dynamic data - Typically also will have a `data-value` attribute
* `lc_dt_data_function` Custom fields that render their values using [Designer Functions](./lucit-template-custom-fields.md) have this class
* `lc_dt_element` This element was added from our built in element library or from an app that provides elements
* `lc_dt_text_editable` Non-dynamic text elements have this to indicate that the user can edit the text of this element on the canvas by double-clicking on it

## Examples

Here are some examples


**Text**

```html
<div
  id="obj_your_new_text_era87f9b"
  title="Your New Text"
  x-objectcode="your_new_text"
  class="lc_ut_designer lc_dt_element lc_dt_text lc_dt_text_editable lc_format_fit_text"
  style=""
  x-fieldname="your_new_text"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
  Your New Text
</div>
```

**Dynamic Text Element**

Note the `{item.title}` macro

```html

<div
  id="data_source_text_fldrsep6"
  title=""
  x-objectcode="item_title"
  class="lc_ut_designer lc_dt_data lc_dt_text lc_format_fit_text"
  x-placeholder="Your Caption"
  x-optional-field="false"
  x-fieldname="Title"
  data-value="{item.title}"
  x-element-settings="{}"
  x-element-setting-values="{}">
  {item.title}
</div>

```



**Optional Dynamic Text Element**

Note the `{item.description}` macro and `x-optional-field="true"`   

During the Post Ad process, a user will see a text box to fill out a value for this field, but, this field will not be required, and the user can post an ad and leave this field blank.

If `x-optional-field` was `false` (default) then the user would be required to fill out this field before continuing with the post ad process.

This only applies to templates that are being used to manually create ads via the [Post Ad Process](../../guides/post-ad-navigation-guide.md)

```html

<div
  id="data_source_text_fldrsep6"
  title=""
  x-objectcode="item_description"
  class="lc_ut_designer lc_dt_data lc_dt_text lc_format_fit_text"
  x-placeholder="Your Caption"
  x-optional-field="true"
  x-fieldname="Title"
  data-value="{item.title}"
  x-element-settings="{}"
  x-element-setting-values="{}">
  {item.description}
</div>

```

**Dynamic Text Element with a Screen Data Macro**

Note the `{digital_board.location.city}` macro that will pull the correct city name depending on where this ad is playing

```html

<div
  id="data_source_text_5cy777xh"
  title=""
  x-objectcode="digital_board_location_city"
  class="lc_ut_designer lc_dt_data lc_dt_text lc_format_fit_text"
  x-placeholder="Anytown"
  x-optional-field="false"
  x-fieldname="City"
  data-value="{digital_board.location.city}"
  x-element-settings="{}"
  x-element-setting-values="{}">
  {digital_board.location.city}
</div>
```


**User Uploaded Image**

An image that was uploaded,  or, dragged and dropped onto the Template Designer canvas.

Note that this contains a macro `{LCUID-LM-27b02a5d-a7c6-480e-a1aa-68ff62b9953b.options.public_url}` that represents an `Image` object in Lucit.   At render time, the macro is replaced by the full url to the image.

```html

<div
  id="img_1189942"
  title=""
  x-objectcode="asset_img"
  x-assetid="1189942"
  x-fieldname="icon"
  class="lc_ut_designer lc_dt_asset lc_dt_image lc_dt_preserve_aspect"
  style="background-image: url('{LCUID-LM-27b02a5d-a7c6-480e-a1aa-68ff62b9953b.options.public_url}');"
  data-value="{LCUID-LM-27b02a5d-a7c6-480e-a1aa-68ff62b9953b.options.public_url}"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
</div>

```

**User Uploaded Background Image**

An image uploaded by the user, and `Stretch to fill the screen` was selected.  Note the `lc_dt_image_full_size_stretch` class

```html

<div
  id="img_1189944"
  title=""
  x-objectcode="asset_img"
  x-assetid="1189944"
  x-fieldname="5starauto-demo-creative"
  class="lc_ut_designer lc_dt_asset lc_dt_image lc_dt_image_full_size_stretch"
  style="background-image: url('{LCUID-LM-c9e99b29-16ef-499f-a71a-e0373f0a13ea.options.public_url}');"
  data-value="{LCUID-LM-c9e99b29-16ef-499f-a71a-e0373f0a13ea.options.public_url}"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
</div>

```

**Dynamic Image**

A dynamic image provided during template render.  Either manually during the Post Ad process, or, by a Inventory type data source when generating ads

Note the `{item.options.primary_image_public_url}` that will provide the full url to the image during render

```html

<div
  id="data_source_img_yjzr38ga"
  title=""
  x-objectcode="item_options_primary_image_public_url"
  class="lc_ut_designer lc_dt_data lc_dt_image"
  x-placeholder="https://lucit.app/assets/designer/image_placeholder_Item.png"
  x-fieldname="Item Image"
  style="background-image: url('{item.options.primary_image_public_url}');"
  data-value="{item.options.primary_image_public_url}"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
</div>
```

**User Uploaded Video**

A video uploaded by the user, and `Stretch to fill the screen` was selected.  Note the `lc_dt_image_full_size_stretch` class.

Also note the 2 macros. `{LCUID-LMV-a79c7fba-174b-42e5-9d5d-c80df702a1c5.options.public_url}` is the url to the video file, and `{LCUID-LMV-a79c7fba-174b-42e5-9d5d-c80df702a1c5.options.thumbnail_public_url}` is the url to a static poster image of the video


```html

<video
  id="video_25"
  title=""
  x-objectcode="asset_video"
  x-fieldname="Log Out"
  class="lc_ut_designer lc_dt_asset lc_dt_video lc_dt_image_full_size_stretch"
  muted="muted"
  preload="metadata"
  playsinline="playsinline"
  poster="{LCUID-LMV-a79c7fba-174b-42e5-9d5d-c80df702a1c5.options.thumbnail_public_url}"
  data-value="{LCUID-LMV-a79c7fba-174b-42e5-9d5d-c80df702a1c5.options.public_url}"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
  <source
    src="{LCUID-LMV-a79c7fba-174b-42e5-9d5d-c80df702a1c5.options.public_url}" />
</video>
```

**Lucit Element - Rectangle**

A rectangle shape from the Shapes list

```html
<div
  id="obj_rectangle_qysc0epm"
  title="Rectangle"
  x-objectcode="rectangle"
  class="lc_ut_designer lc_dt_element lc_dt_object"
  style=""
  x-fieldname="rectangle"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
  <div></div>
</div>

```


**Lucit Element - (svg) Circle**

An svg circle from the Shapes list


```xml
<div
  id="obj_circle_63o1a0h4"
  title="Circle"
  x-objectcode="circle"
  class="lc_ut_designer lc_dt_element lc_dt_object lc_dt_object_svg"
  style=""
  x-fieldname="circle"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
  <svg
    height="100%"
    width="100%"
    viewBox="0 0 100 100"
    preserveAspectRatio="xMidYMid meet"
    pointer-events="none">
    <circle
      cx="50"
      cy="50"
      r="40"></circle>
  </svg>
</div>


```

**Lucit Element - Background Image**

A background image element from the Backgrounds list

```html

<div
  id="obj_pink_sky_wl0mwuth"
  title="Pink Sky"
  x-objectcode="pink_sky"
  class="lc_ut_designer lc_dt_asset lc_dt_image lc_dt_image_full_size_stretch"
  style="background-image: url('https://lucore-bucket-images-prod2.s3.us-east-2.amazonaws.com/5155/img_67ec2019046e6_295d3b237c0331e6171e.jpg');"
  x-fieldname="pink_sky"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
</div>
```

**Lucit Dynamic Countdown Element**

The countdown element that has customizable settings to render a countdown to a specific date

Note that this element has `x-element-settings` and `x-element-setting-values` configured.

`x-element-settings` uses the [Form Fields](../fields/lucit-form-fields-specification.md) to render a form when a user edits the settings of this element after adding it to their template.   The values of those settings are stored in `x-element-setting-values`

```html
<div
  id="obj_countdown_hours_and_days_tvguddxi"
  title="Countdown : Hours and Days"
  class="lc_ut_designer lc_dt_element lc_dt_text lc_dt_text_editable lc_format_fit_text"
  x-element-settings='{"fields":[{"key":"targetDate","name":"Target Date","type":"datetime","placeholder":"12\/25\/2024"},{"key":"prefix","name":"Prefix","type":"text","default_value":"Only"},{"key":"suffix","name":"Suffix","type":"text","default_value":"Until the big day!"},{"key":"resultStyle","enum":"true","name":"Style","type":"text","placeholder":"days_hours","enum_options":[{"label":"Days No Label","value":"days_no_label"},{"label":"Days","value":"days"},{"label":"Days, Hours","value":"days_hours"},{"label":"Hours","value":"hours"}]}]}'
  x-fieldname="countdown_hours_and_days"
  x-optional-field="false"
  x-element-setting-values='{"prefix":"Only","suffix":"Until the big day!","targetDate":"2026-12-25T13:07","resultStyle":"days_hours"}'
  x-placeholder="countdown_hours_and_days">
  0 days
</div>


```

**Custom Field (Text) using the `fnConcat` designer function**

This custom text field renders a single text element for multiple macros using the built in `fnConcat` [Designer Function](./lucit-template-custom-fields.md) and concatenating both text and macros together into a single text field

Also note how in this example, we use the double curly brace style for wrapping the macros that appear in Javascript.  This helps prevent escapaing issues.

```html

<div
  id="data_source_text_h8syielw"
  title=""
  x-objectcode="custom_field_zcjrporn"
  class="lc_ut_designer lc_dt_data lc_dt_text lc_format_fit_text lc_dt_data_function"
  x-placeholder="Pre-Owned 2009 Ford Focus"
  x-optional-field="false"
  x-fieldname="Make Modela and Year"
  data-value="{fnConcat([
'Pre-Owned ',
'{{item.year}}',
' ',
'{{item.make}}',
' ',
'{{item.model}}',
]);}"
  x-element-settings="{}"
  x-element-setting-values="{}">
  {fnConcat([ 'Pre-Owned ', '{{item.year}}', ' ', '{{item.make}}', ' ',
  '{{item.model}}', ]);}
</div>

```

**Custom Field (Image) using `fnConcat` to get the url to a team logo icon**

This custom image field renders a single image element for multiple macros using the built in `fnConcat` [Designer Function](./lucit-template-custom-fields.md) and concatanating both text and macros together into a single url that is used to get the image.

```html

<div
  id="data_source_img_be9pcje2"
  title=""
  x-objectcode="custom_field_1ve302cj"
  class="lc_ut_designer lc_dt_data lc_dt_asset lc_dt_image lc_dt_data_function"
  x-placeholder=""
  x-fieldname="Custom Image Field"
  style="background-image: url('{fnConcat([
'https://example.com/images/',
'{{item.inventory_attributes.teams_home_id}}',
'.png'
]);}');"
  data-value="{fnConcat([
'https://example.com/images/',
'{{item.inventory_attributes.teams_home_id}}',
'.png'
]);}"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}"></div>

```

**Element with animations**

This element has 2 animations that are applied to it.  Note the x-animations property.

Each animation provides its settings and these are turned into CSS styles during the rendering of the template.

```xml

<div
  id="obj_hexagon_obf5c7nj"
  title="Hexagon"
  x-objectcode="hexagon"
  class="lc_ut_designer lc_dt_element lc_dt_object lc_dt_object_svg"
  style=""
  x-fieldname="hexagon"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}"
  x-animations='[{"number":1,"name":"bounce","duration":1,"delay":0.25,"iteration":1,"direction":"normal","fillMode":"backwards"},{"number":2,"name":"bounceOutDown","duration":1,"delay":1.25,"iteration":1,"direction":"normal","fillMode":"forwards"}]'>
  <svg
    width="100%"
    height="100%"
    viewBox="0 0 1080 1080"
    pointer-events="none">
    <polygon
      points="784.64 108.67 1040 540 791.07 971.33 286.78 971.33 40 540 288.93 108.67 784.64 108.67"></polygon>
  </svg>
</div>
```



## Full example with multiple elements

This is an example of a template with multiple elements

This is what you would see if using the HTML Tab on the Code Editor in the Template Designer



```html
<div
  id="rectangle_default_bg"
  title=""
  x-objectcode="rectangle"
  class="lc_ut_designer lc_dt_object lc_dt_default_background"
  x-fieldname="rectangle"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}"></div>

<div
  id="obj_deep_relief_zgrfgxql"
  title="Deep Relief"
  x-objectcode="deep_relief"
  class="lc_ut_designer lc_dt_element lc_dt_object lc_dt_image_full_size_stretch"
  x-fieldname="deep_relief"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}"></div>

<div
  id="obj_rectangle_bezseekc"
  title="Rectangle"
  x-objectcode="rectangle"
  class="lc_ut_designer lc_dt_element lc_dt_object"
  style=""
  x-fieldname="rectangle"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
  <div></div>
</div>
<div
  id="obj_your_new_text_ty89hitu"
  title="Your New Text"
  x-objectcode="your_new_text"
  class="lc_ut_designer lc_dt_element lc_dt_text lc_dt_text_editable lc_format_fit_text"
  style=""
  x-fieldname="your_new_text"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}">
  Welcome To My Store
</div>

<div
  id="data_source_img_95dj7s8c"
  title=""
  x-objectcode="item_options_primary_image_public_url"
  class="lc_ut_designer lc_dt_data lc_dt_image"
  x-placeholder="https://lucit.app/assets/designer/image_placeholder_Item.png"
  x-fieldname="Custom Picture"
  style="background-image: url('{item.options.primary_image_public_url}');"
  data-value="{item.options.primary_image_public_url}"
  x-optional-field="false"
  x-element-settings="{}"
  x-element-setting-values="{}"></div>

<div
  id="data_source_text_2qt0j27j"
  title=""
  x-objectcode="item_title"
  class="lc_ut_designer lc_dt_data lc_dt_text lc_format_fit_text"
  x-placeholder="Sally Smith"
  x-optional-field="false"
  x-fieldname="Customer Name"
  data-value="{item.title}"
  x-element-settings="{}"
  x-element-setting-values="{}">
  {item.title}
</div>

```