# Lucit Text Formatting Function Reference

This document contains a reference to all built-in text formatting functions.  These are available to all templates and appear in the Format drop-down under the Effects & Others section of the Edit tab in the Template Designer.    These functions work based on adding CSS classes to the HTML element based on the name of the function.  For instance, a function named `lc_format_price_us is` applied by adding the class `lc_format_price_us` to the element

| Function Name | Friendly Name | Category |
| ------------- | ------------- | -------- |
| `lc_format_date_dayNumeric` | Day : 28 | Date / Time|
| `lc_format_date_dayNumericShort` | Day : 28 | Date / Time|
| `lc_format_date_dayOfWeek` | Day : Saturday | Date / Time|
| `lc_format_date_dayOfWeekShort` | Day : Sat | Date / Time|
| `lc_format_date_dayOrdinal` | Day : 28th | Date / Time|
| `lc_format_date_fullDateLong` | "Date : July 28th | Date / Time|
| `lc_format_date_fullDateLongWithTime` | "Date : July 28th | Date / Time|
| `lc_format_date_fullDateNoYear` | Date : 07/28 | Date / Time|
| `lc_format_date_fullDateNoYearShort` | Date : 7/28 | Date / Time|
| `lc_format_date_fullDateNoYearUK` | Date UK : 28/07 | Date / Time|
| `lc_format_date_fullDateShort` | Date : 07/28/23 | Date / Time|
| `lc_format_date_fullDateShortUK` | Date UK : 28/07/23 | Date / Time|
| `lc_format_date_fullDateShortWithTime` | Date : 07/28/23 8:15 PM | Date / Time|
| `lc_format_date_hour24` | Time : 20h | Date / Time|
| `lc_format_date_monthLong` | Month : July | Date / Time|
| `lc_format_date_monthNumeric` | Month : 07 | Date / Time|
| `lc_format_date_monthNumericShort` | Month : 7 | Date / Time|
| `lc_format_date_time24h` | Time : 20:15 | Date / Time|
| `lc_format_date_timeShort` | Time : 8:15 | Date / Time|
| `lc_format_date_timeShortPM` | Time : 8:15 PM | Date / Time|
| `lc_format_date_timeShortPMAbbr` | Time : 08:15p | Date / Time|
| `lc_format_degrees` | Temperature 55\u00B0 | Number|
| `lc_format_feets_and_inches` | Feets and inches 1\'11\'\' | Number|
| `lc_format_number_short_us_no_decimal_round_downK` | "Number 12K | Number|
| `lc_format_number_us` | 'Number 123 | Number|
| `lc_format_percent` | Percent 10% | Number|
| `lc_format_phone_nanp` | Phone (123) 456-7890 | Phone|
| `lc_format_phone_nanp_dots` | Phone 123.456.7890 | Phone|
| `lc_format_phone_nanp_hyphen` | Phone 123-456-7890 | Phone|
| `lc_format_price_short_uk` | Price £'12K | Currency|
| `lc_format_price_short_uk_no_decimal_round_downK` | Price £'12K | Currency|
| `lc_format_price_short_us` | 'Price $12K | Currency|
| `lc_format_price_short_us_no_decimal_round_downK` | 'Price $12K | Currency|
| `lc_format_price_super_script_uk` | Price " + String.fromCharCode(163) + "12\u2079\u2079 | Currency|
| `lc_format_price_super_script_us` | Price $12\u2079\u2079 | Currency|
| `lc_format_price_thousands_superscript_us` | Price $3.05\u2079 | Currency|
| `lc_format_price_uk` | Price £'12 | Currency|
| `lc_format_price_us` | 'Price $12 | Currency|
| `lc_format_round_hundredths` | Round Number to 100ths Place - 10.11 | Number|
| `lc_format_round_integer` | Round to Nearest Integer | Number|
| `lc_format_round_tenths` | Round Number to 10ths Place - 10.1 | Number|
| `lc_format_round_thousandths` | Round Number to 1000ths Place - 10.111 | Number|
