---
title: "Campaign Page Navigation Guide"
description: "Lists various navigation steps that you can take and actions you can perform on the Lucit Campaign Page"
keywords: "ui, user interface, navigation, lucit, campaign"
---

# Campaign Page Navigation Guide

## What is the campaign page for?

A **campaign** is a container for creatives and is the primary place that you use to control which creatives run, where and when.   The **campaign** represents the object that will be scheduled by your CMS system [Integration Guides](./integrations/index.md)

## Important Concepts

**Campaign Statuses**

* **Draft** has not been scheduled yet
* **Pending Traffic** Activated and waiting for the scheduler to schedule this campaign to run
* **Pending** Scheduled and now waiting for it's first play
* **Pulling** Digital screens are communicating with this campaign but none have started playing on screens
* **Active** Campaign is activated and playing on one or more screens

**Creative States**

* **Active** Creative in the top section of the list of creatives, whose titles are bolded blue/green (Lucit Color) and have a checkmark next to them, are active and will play
* **Pending** Creative is in the `Pending` section below any active ads.  These creatives have a limitation that is preventing them from playing.  This could be a date/time limitation, or, a trigger.  These creatives will run when their triggers / datetimes become valid / active.
* **Available** Creative is in the `Available` section below the pending section.  These creatives are not selected (unchecked) and will not run until activated.

## Campaign Page Elements

*  **Title** name of the campaign.  Change the name of this campaign by clicking the `{PencilIcon}`, typing a new name and then clicking the `{CheckmarkIcon}` to save changes
*  **{3VerticalDotsIcon}** This icon opens a drop down with the following options
    *  **Settings** Edit campaign settings
        *  **Auto Add New Items to Campaign** - Switch - When new creative items are added to this account, automatically add them to this campaign
        *  **Item Filter** When `Auto Add New Items to Campaign` is enabled, filter them according to these rules (filter on the item, its tags, its location / geo tags, and more)
        *  **Accounts** Get creatives from these accounts
        *  **Include Child Accounts** Include child accounts of  your selected accounts
        *  **Analytics Notifications** Send notifications every week with analytics
        *  **Removed Item Notification** Send notifications when a data feed removes items from this campaign
        *  **Analytics Notifications User Roles** Types of users to send this notification to
        *  **Removed Item Notification User Roles** Types of users to send this notification to
        *  **Estimate Play Stats from Daily Average Plays** For integrations that do not support playback reporting (Watchfire and Blip) estimate plays using a daily average
        *  **Estimated Total Plays per Day** Average number of plays to use for the estimates
        *  **Attempt to Auto Attach Missing Screens** If a request from a digital screen comes in for this campaign, and the screen is not attached to this campaign in the `SCREENS` tab, automatically attach it
        *  **Default Creative Item** Choose the default creative that will be used in this campaign if no other creatives are eligible
        *  **Disable Moderation and Approve All Creatives** ADMIN FEATURE - Bypass moderation for all creatives and creative changes in this campaign
        *  **HTML Source Type** Choose from 2 options
            *  **Snapshot** Send an JPG image snapshot of the creative to the player (default)
            *  **Drive Template** Send the HTML content itself to the player (for players that support this)
                *  This is useful for creatives with real-time countdowns that update minute by minute
                *  This is also required for creatives that support video / animation
        *  **Creative Build Schedule** Choose how often this campaign checks for creative re-builds from a dropdown (e.g., Every Hour, Every 30 Minutes, Every 6 Hours). Defaults to Every Hour. Decrease the interval if you want to force some creatives to re-generate more frequently.
    *  **Refresh Data** Refresh the status / creative states of this campaign
    *  **Link Player** Open integration specific scheduling dialog
    *  **Delete Campaign** Delete this campaign
*  **Overview** This section shows the Status of your campaign, as well as some overview analytics when it is running
*  **CREATIVE ITEMS** This tab contains all of your creative items
    *  **FREQUENCY** Edit the frequency / share that each creative in your campaign gets `Campaign -> CREATIVE ITEMS -> FREQUENCY BUTTON` this will open the **Adjust Frequency** dialog.  Move the sliders to change the percentage frequency for each item
    *  **POST AD** Post an ad to this campaign `Campaign -> POST AD`
    *  **Filter section** Filter and search through your creatives using the `Filter...` text box
    *  **Select All** Use the empty checkbox next to the `Filter..` section to select all creatives for bulk-editing. Bulk action buttons appear after clicking this checkbox or by individually selecting checkboxes next to each creative item.
        *  Available Actions Are:
            *  `SCHEDULE` - Set dates/times
            *  `FILTERS` - Set triggers
            *  `ACTIVATE` - Add to campaign
            *  `DEACTIVATE` - Remove from campaign
    *  You then see a list of each of your creatives that you can post to this campaign.   Next to each creative (in each row) you have the following action icons
        *  **{CalendarIcon}** Adjust start date, end time, time of day restrictions
        *  **{FolderWithStarIcon}** Set triggers / filters
        *  **{ScreenIcon}** Select screens to limit this specific creative to
        *  **{CheckmarkIcon}** Indicates that this item has been selected.  Click this to de-select it and make the creative inactive
        *  **{PlusSignIcon}** Indicates that this item has not been selected.  Click this item to select it and add it to your campaign
*  **SCREENS** This tab shows the screens that are part of your campaign.  This is important to ensure that your creatives know what sizes to generate in, and your data sources know what locations to generate data for
    *  **Screen List** Select the screens to attach to this campaign using the checkbox
    *  **Map** View the map of the screens selected / eligible.
*  **SCHEDULE** This is the schedule / timeline view for your campaign (Currently in BETA)
    *  View the timeline based schedule for this campaign
