---
title: "General Lucit Navigation Guide"
description: "List of various navigation steps within the Lucit Platform that can be used to find various actions / paths within the user interface"
keywords: "ui, user interface, navigation, lucit"
---

# General Lucit Navigation Guide

The following is a reference to various parts of the system, how they work and how to navigate them

## What is the Difference between lucit.app and lucit.cc domains?

- **lucit.app** is the Lucit Platform itself.  This documentation is about `lucit.app`
- **lucit.cc** is the Lucit Corporate website with news, information, overviews, etc.


## Navigation Notation Guide

Throughout this document, navigation paths are shown using the following format:

- `Menu -> Submenu -> Action` - Click path to reach a destination
- `{IconName}` - UI icons (e.g., {PencilIcon} for edit, {TrashCanIcon} for delete)
- `BUTTON NAME` - Clickable buttons in ALL CAPS

## Sign Up / Registration / Login

* **Sign In** Existing Users : From [lucit.app](https://lucit.app/) click the `Sign In` button
* **Registration / Sign Up** New Users : From [lucit.app](https://lucit.app/) click on the `Sign Up` button
* **Forgot Password** From [lucit.app](https://lucit.app) click on `Sign In`, and then click on the `Forgot Password` link.  Or, directly Visit [lucit.app/forgot-password](https://lucit.app/forgot-password)

## Contact
- **Contact Lucit Support** Visit [lucit.app/contact](https://lucit.app/contact) and complete the form.

## Profiles

### What are Profiles in Lucit?

Each primary object in Lucit has a profile and when selecting that profile, your user interface, menu and options will update to reflect the capabilities of that profile.

The following objects have profiles in Lucit that you can switch to

* **User** This is YOUR personal user profile.  Every user has one (and only one) User Profile.
* **Operator** Contains settings to manage screens (billboards), accounts and campaigns
* **Ad Agency** Contains settings to manage multiple advertiser profiles and campaigns
* **Account** The container for campaigns, apps & data sources, and creatives

### Basic Profile Actions

* **Switching** On the top-right corner of the screen, click on the Profile Drop-Down to select a profile.   Typically you will see an Icon/Image and a name.
* **Which profile am I on?** On the top-right corner of the screen, your current profile will be displayed.  Click on this to change it
* **Create a new Account** To create a new account, from the very bottom of the `Profile Drop-Down` click `Add New Account`
* **Create a new Ad Agency or Operator** From your `User Profile -> Home Page` click on the `Create New Account / Profile` button and select the appropriate type: `Account` | `Ad Agency` | `Operator / Screen Owner`

### Understanding Profile Context

When you switch profiles, the entire interface changes to match that profile's capabilities:

- **Menu items change based on profile type** - Each profile type (User, Ad Agency, Operator, Account) has its own set of menu items on the left-hand side and a customized home screen page
- **Available actions reflect the profile's permissions** - What you can do depends on which profile you're viewing and your role within that profile
- **Data displayed is scoped to that profile** - When viewing an Account profile, you only see campaigns, creatives, and analytics for that specific account
- **Your role matters** - You may have different permission levels across different profiles (e.g., Admin on one account, Viewer on another)

## Menu Items

Each type of profile will have a different set of menu items on the left-hand side of the screen.  These are as follows

### User Profile Menu Items

* **Home** - Home Page
    * *Common Tasks*
        * Create a new account, ad agency or operator profile `Home -> CREATE NEW ACCOUNT / PROFILE Button`
* **Settings** - User Profile Settings
    * Profile Photo
    * Name
    * Email
    * Mobile Phone
    * About
    * Title
    * Time Zone
    * Notification Settings
    * Log Out / Security Settings
    * Developer Tools Enable / Disable
    * *Common Tasks*
        * Edit the above settings
        * Log out of Lucit `Settings -> Security & Authorization -> Log Out`
        * Change our password `Settings -> Security & Authorization -> Change Password`
        * Enable Developer Tools `Settings -> Developers -> Developer Mode`
        * Adjust your notification preferences `Settings -> Notifications` to enable / disable different types of notifications
* **Help** View help documentation or submit a help support request
    * *Common Tasks*
        * Submit a support request to Lucit support `Help -> Help Request -> Send`
        * View help documentation

If user has Developer Tools enabled, they will see additional menu items

* **Apps** - Create and manage Lucit Apps & Data Sources
    * *Common Tasks*
        * Create a new App `Apps -> New Application`
        * Edit an existing app `Apps -> Click on App`
* **Elements** - Build custom elements for the Lucit Template Designer
    * *Common Tasks*
        * Create new elements for the template designer that can be shared among multiple accounts
        * `Elements -> Add New` to create a new shape, text or background
    * These elements can then be used in the Template Designer. See the [Template Designer General Navigation Guide](template-designer-general-navigation-guide.md) for more information.
* **Test Users** - Create temporary test users
    * *Common Tasks*
        * Create a new test user to get a temporary email / mobile phone that you can use to register in Lucit and test functionality
        * `Test Users -> ADD TEST USER`

### Ad Agency Profile Menu Items

* **Home** Agency Home Page
    * *Common Tasks*
        * View active accounts
* **Accounts** List of agency owned accounts, create new agency owned accounts
    * *Common Tasks*
        * View accounts owned by this agency
        * Switch to the account profiles of any of those accounts `Accounts -> {Account} -> MANAGE`
        * Join any of those accounts if you are not yet a member `Accounts -> {Account} -> JOIN`
        * Create a new account underneath this agency `Accounts -> ADD ACCOUNT`
        * View the users that belong to an account `Accounts -> {Account} -> USERS`
        * Delete an account `Accounts -> {Account} -> {TrashCanIcon}
* **Analytics** View rollup analytics for all campaigns across all accounts the ad agency owns
    * *Common Tasks*
        * Charting hourly, daily, weekly and monthly Plays and Impressions `Analytics -> PERIOD`
            * Drop Downs available for Periods, Timeframes, Data Point, Screen and Campaign
        * Filter by Account, Campaign and Screen
        * View plays & impressions for individual creatives `Analytics -> CREATIVES`
        * View plays & impressions for individual campaigns `Analytics -> CAMPAIGNS`
        * View plays & impressions for individual screens `Analytics -> SCREENS`
* **Team** Invite employees / users at your ad agency to this profile, manage users, permissions,and remove users
    * *Common Tasks*
        * Invite a new employee of your ad agency to access Lucit `Team -> INVITE A TEAM MEMBER`
        * Edit roles / permissions for users `Team -> {User} -> {PencilIcon}`
        * Remove users `Team -> {User} -> {TrashCanIcon}`
* **Activity** View the real-time activity feed for all users and accounts belonging to your ad agency
    * *Common Tasks*
        * View new creatives, campaigns and sign-ins from users that belong to any account in your ad agency
* **Billing** Add / remove payment methods, view an pay invoices
    * *Common Tasks*
        * Add your credit card `Billing -> ADD CARD`
        * Print / View an Invoice
        * View past invoices `Billing -> INVOICES`
        * View past payments `Billing -> PAYMENTS`
* **Settings** Ad Agency Settings
    * Profile Photo
    * Company Name
    * Public Description
    * Public Profile Page Link / QR COde
    * Website
    * Tags
    * Legal Disclaimer Text for Proofs
    * Help and Support Text
    * Apps & Data Sources to manage apps specific to your ad agency
    * Delete
    * *Common Tasks*
        * Edit the above settings
        * Delete your ad agency `Settings -> PERMANENTLY DELETE`
        * Edit the information that appears on your public profile page `Settings -> Edit each field`
* **Help** View help documentation or submit a help support request
    * *Common Tasks*
        * Submit a support request to Lucit support `Help -> Help Request -> Send`
        * View help documentation

### Operator Profile Menu Items

* **Home** Operator Home Page
    * *Common Tasks*
        * View currently activate accounts
* **Approvals** Manage ad approvals / content moderation
    * *Common Tasks*
        * Set approval settings and restrictions `Approvals -> {GearIcon} -> APPROVAL SETTINGS`
        * Set user trust / revoke user trust `Approvals -> {GearIcon} -> TRUSTED USERS`
        * View pending ads that need approval `Approvals -> Status Pending`
        * Approve ads `Approvals -> {Ad} -> Approve`
        * Reject ads `Approvals -> {Ad} -> Reject`
* **Accounts** Operator owned accounts
    * *Common Tasks*
        * View accounts owned by this operator
        * Switch to the account profiles of any of those accounts `Accounts -> {Account} -> MANAGE`
        * Join any of those accounts if you are not yet a member `Accounts -> {Account} -> JOIN`
        * Create a new account underneath this operator `Accounts -> ADD ACCOUNT`
        * View the users that belong to an account `Accounts -> {Account} -> USERS`
        * Delete an account `Accounts -> {Account} -> {TrashCanIcon}`
* **Campaigns** View a list of all campaigns attached to your screens.  
    * *Common Tasks*
        * View campaigns status (Draft, Pending, Running, Paused, Complete) `Campaigns`
        * Make draft campaigns active `Campaigns -> {Campaign} -> ACTIVATE`
        * Use Link Player to access scheduling instructions / tools for your platform
            * `Campaigns -> {Campaign} -> LINK PLAYER`
            * Supported platforms appear when you add their app under Apps & Data in your Operator Settings `Settings -> Apps & Data -> ADD NEW`
* **Analytics** View rollup analytics for all campaigns across all accounts and screens the operator owns
    * *Common Tasks*
        * Charting hourly, daily, weekly and monthly Plays and Impressions `Analytics -> PERIOD`
            * Drop Downs available for Periods, Timeframes, Data Point, Screen and Campaign
        * Filter by Account, Campaign and Screen
        * View plays & impressions for individual creatives `Analytics -> CREATIVES`
        * View plays & impressions for individual campaigns `Analytics -> CAMPAIGNS`
        * View plays & impressions for individual screens `Analytics -> SCREENS`
* **Lighting** If you have the Lucit Lightning player application enabled, manage your Lightning Player Devices here
    * *Common Tasks*
        * Add new Lightning Digital Signage player devices
        * View status of devices
        * Create and Manage groups of devices
* **Screens** View and edit the screens for your operator account
    * *Common Tasks*
        * Add a new screen `Screens -> ADD SCREEN`
        * Set default XR images for your screens `Screens -> DEFAULT SCREEN XR IMAGES`
        * Name, Location (Lat / Long) tags, and Venue Taxonomy `Screens -> {Screen} -> {PencilIcon} -> GENERAL`
        * Screen settings including pixel width / height `Screens -> {Screen} -> {PencilIcon} -> GENERAL`
        * Set the vendor screen identifier for each screen `Screens -> {Screen} -> {PencilIcon} -> GENERAL`
        * Set settings such as facing direction, etc. `Screens -> {Screen} -> {PencilIcon} -> GENERAL`
        * Set Impressions and Slot Lengths `Screens -> {Screen} -> {PencilIcon} -> DISPLAY`
        * Set Google Street View images for a screen `Screens -> {Screen} -> {PencilIcon} -> STREET VIEW`
        * Upload new XR Images for a screens `Screens -> {Screen} -> {PencilIcon} -> XR IMAGES`
        * Attach a screen to screen groups or create new screen groups `Screens -> {Screen} -> {PencilIcon} -> GROUPS`
        * Delete screens `Screens -> {Screen} -> {PencilIcon} -> ADVANCED -> DELETE SCREEN`
* **Team** Invite employees / users at your operator to this profile, manage users, permissions, and remove users
    * *Common Tasks*
        * Invite a new employee of your operator to access Lucit `Team -> INVITE A TEAM MEMBER`
        * Edit roles / permissions for users `Team -> {User} -> {PencilIcon}`
        * Remove users `Team -> {User} -> {TrashCanIcon}`
* **Activity** View the real-time activity feed for all users and accounts belonging to your operator
    * *Common Tasks*
            * View new creatives, campaigns and sign-ins from users that belong to any account in your ad operator
* **Billing** Add / remove payment methods, view an pay invoices
    * *Common Tasks*
        * Add your credit card `Billing -> ADD CARD`
        * Print / View an Invoice
        * View past invoices `Billing -> INVOICES`
        * View past payments `Billing -> PAYMENTS`
* **Settings** Operator Settings
    * Profile Photo
    * Company Name
    * Public Description
    * Public Profile Page Link / QR COde
    * Website
    * Tags
    * Legal Disclaimer Text for Proofs
    * Help and Support Text
    * Apps & Data Sources to manage apps specific to your operator
    * Delete
    * *Common Tasks*
        * Edit the above settings
        * Delete your operator `Settings -> PERMANENTLY DELETE`
        * Edit the information that appears on your public profile page `Settings -> Edit each field`
        * Add tags that can be used to assign to screens for grouping `Settings -> Tags -> CREATE TAG`
        * Add new apps `Settings -> Apps & Data -> ADD NEW`
            * Most common apps to add are player integrations like Apparatix, Watchfire, Daktronics, Blip, Place Exchange, Vistar Media, etc.
* **Help** View help documentation or submit a help support request
    * *Common Tasks*
        * Submit a support request to Lucit support `Help -> Help Request -> Send`
        * View help documentation

### Account Profile Menu Items

* **Home** Account home page.
    * *Common Tasks*
        * View Active Campaign(s) `Home - Campaigns`
        * View Active Running Ads (with real-time last play status) `Home -> Ads`
        * Post a new Ad with the `Post Ad` button `Home -> POST AD`
* **Schedule** *In Beta** Schedule / Timeline view of your campaigns and creatives
* **Campaigns** Your digital ooh campaigns
    * *Common Tasks*
        * Create new campaigns `Campaigns -> {3-Dots Icon} -> ADD CAMPAIGN`
        * Create new group campaigns `Campaigns -> {3-Dots Icon} -> ADD GROUP CAMPAIGN`
        * View campaigns `Campaigns -> {Campaign} -> Click on Campaign`
* **Creatives** View and manage all of your creatives
    * *Common Tasks*
        * Post new ads (creatives) `Creatives -> POST AD`
        * View existing ads `Creatives`
        * Sort and filter ads `Creatives`
* **Templates** Create and Edit templates for dynamic and responsive creatives
    * *Common Tasks*
        * Edit existing templates `Templates -> {Template} -> EDIT TEMPLATE`
        * Duplicate existing templates `Templates -> {Template} -> DUPLICATE TEMPLATE`
        * Create a new template `Templates -> CREATE A NEW TEMPLATE`
    * For detailed information on using the Template Designer, see the [Template Designer General Navigation Guide](template-designer-general-navigation-guide.md)
* **Apps & Data** Add / Edit applications, integrations and data sources
    * *Common Tasks*
        * Add new data feed apps `Apps & Data -> ADD NEW`
        * Edit settings for data feed apps `Apps & Data -> {App} -> Click on App`
        * Refresh / Re-Run data feed apps `Apps & Data -> {App} -> Click on App -> DATA -> REFRESH`
        * View the data that came in from a data feed `Apps & Data -> {App} -> Click on App -> DATA`
        * Attach templates to data feeds `Apps & Data -> {App} -> Click on App -> TEMPLATES -> ADD`
        * Set the schedule for data feeds `Apps & Data -> {App} -> Click on App -> SETTINGS -> SCHEDULE`
        * Filter incoming data according to rules `Apps & Data -> {App} -> Click on App -> SETTINGS -> FILTER`
        * View app Runs and API Calls - `Apps & Data -> {App} -> Click on App -> ANALYTICS`
        * Get help with an app or data source `Apps & Data -> {App} -> Click on App -> HELP`
* **Analytics** View analytics (plays, impressions, time on screen) for your digital billboard campaigns
    * *Common Tasks*
        * Charting hourly, daily, weekly and monthly Plays and Impressions `Analytics -> PERIOD`
            * Drop Downs available for Periods, Timeframes, Data Point, Screen and Campaign
        * Filter by Account, Campaign and Screen
        * View plays & impressions for individual creatives `Analytics -> CREATIVES`
        * View plays & impressions for individual campaigns `Analytics -> CAMPAIGNS`
        * View plays & impressions for individual screens `Analytics -> SCREENS`
* **Users & Invites** Manage users and invite new ones.  Manage permissions and roles
    * *Common Tasks*
        * Invite a user to your account to access Lucit `Users & Invites -> INVITE SOMEONE TO THIS ACCOUNT`
        * Edit roles / permissions for users `Users & Invites -> {User} -> {PencilIcon}`
        * Remove users `Users & Invites -> {User} -> {TrashCanIcon}`
* **Billing** Add / remove payment methods, view an pay invoices
    * *Common Tasks*
        * Add your credit card `Billing -> ADD CARD`
        * Print / View an Invoice
        * View past invoices `Billing -> INVOICES`
        * View past payments `Billing -> PAYMENTS`
* **Settings** Edit account settings
    * Profile Image / Logo
    * Account Name
    * Community Engagement Account Settings
    * Public Description for your profile page
    * Profile page link and QR code
    * Website
    * Account wide creative options
        * Set / Edit Default Creative 
        * Control Draft state of new creatives 
    * Template Studio Settings
        * Enable Background Removal for Data Feed Images
        * Enable / Disable child accounts from seeing the templates from the parent account
    * Tags
        * Tags are used to attach to creatives to help grouping and filtering them
    * *Common Tasks*
        * Edit the above settings
        * Edit or add your account wide fallback default creative `Settings -> Creatives -> Default Creatives -> EDIT DEFAULT`
        * Make it so that when you post a new ad, it starts out in draft state (and does not run automatically) `Settings -> Creatives -> New Ads Will Start in Draft State (Enable)`
        * Make is so that when data feeds bring in images, that it will create a version of each image with no background `Settings -> Template Studio -> Background Remover (Enable)`
        * Create tags that you can use to group / manage your creatives and inventory  `Settings -> Tags -> CREATE TAG`





