---
title: "How to Create a Campaign with POI Dynamic Creatives"
description: "Step-by-step guide for creating location-based dynamic creatives using POI data from Google Sheets"
keywords: "poi, dynamic creatives, location data, google sheets, nearest location, point of interest"
---

# How to Create a Campaign with POI Dynamic Creatives

## Overview

This guide walks you through creating a dynamic advertising campaign that automatically personalizes creative content based on Points of Interest (POI) data. By connecting location data from Google Sheets to Lucit's dynamic template system, you can display location-specific information (like city names, addresses, and phone numbers) that automatically updates for each screen in your campaign.

## What is POI Data?

In the context of an OOH Campaign, POI data can be used to map closest physical locations to the screen that the ad is currently playing on.   The Lucit system will map POI locations to their closest screens to provide the correct dynamic data automatically to any ads that are playing on that screen.

## Objective

By the end of this guide, you will have:

*  Created an account and campaign in Lucit
*  Connected POI data from Google Sheets using the "Nearest Location" app
*  Built a data-connected template that displays location-specific information
*  Posted dynamic creatives that automatically adapt to each screen's location

## Prerequisites

Before starting this guide, ensure you have:

*  A Lucit account with appropriate permissions
*  Access to an Ad Agency profile or the ability to create accounts
*  A campaign with screens attached (or the ability to create one)
*  Basic POI data including:
    *  Location names and addresses
    *  Latitude and longitude coordinates
    *  City, state, and country information
    *  Optional: Phone numbers, additional custom fields
*  A Google account to create and share a Google Sheets document
*  Design assets for your creative (background images in appropriate sizes)

## Example Company

Throughout this guide, we'll use a fictional company called **"Big Shoes"** as our example.

## Setup

### Create Account and Campaign

1.  Switch to your ad agency account profile
2.  Create a new account called "Big Shoes" `Profile Drop-Down -> Add New Account`
3.  Add a new campaign for the account `Campaigns -> {3-Dots Icon} -> ADD CAMPAIGN`

## Adding Data

### Configure the Nearest Location App

1.  Navigate to `Apps & Data -> ADD NEW`
2.  Add the app: `Nearest Location - Google Sheets`
3.  Make a copy of the example spreadsheet that was listed:
    *  Open the example URL: https://docs.google.com/spreadsheets/d/1hkbGRRfqhYq2Rr_cFmgxYUaMVAuudQq1V-F_HcFEA8A/edit?gid=0#gid=0
    *  Use `File -> Make a Copy` in Google Sheets

### Fill Out POI Data Fields

In your copy of the Google Sheet, fill out the following fields for each location:

*  **Name** - Full branded location name (e.g., "Big Shoes South-East Chicago")
*  **Non Branded Location Name** - Generic location name (e.g., "South-East Chicago")
*  **City** - City name
*  **State** - 2-digit state code
*  **Country** - 2-digit country code
*  **Address** - Street address only (no zip or city/state)
*  **Phone** - Phone number (if available)
*  **Latitude** - Location latitude coordinate
*  **Longitude** - Location longitude coordinate
*  **board_id** - Leave this blank (Lucit will auto-populate)
*  **Custom Fields** - Add any additional columns you need (e.g., `mall_name`)

### Share and Connect the Google Sheet

1.  Share the Google Sheet with public access:
    *  In Google Sheets : Click `Share -> General Access -> Anyone with the link`
    *  Set permission level to `Viewer`
    *  Click `Done`
2.  Copy the spreadsheet URL from your browser
3.  Navigate to `Apps & Data -> Nearest Location - Google Sheets`
4.  Click on the `SETTINGS` tab
5.  Paste the URL into the `Google Sheet Url` field
6.  Click the `SAVE CHANGES` button
7.  Verify the data source is working:
    *  Click on the `DATA` tab
    *  Confirm that POI data is appearing
8.  Return to the `SETTINGS` tab
9.  Change the schedule to Manual:
    *  Click `Schedule -> EDIT`
    *  Select `Manual`
    *  Click `SAVE CHANGES`

**Important:** Wait for the feed to finish bringing in data and attaching to all screens in your campaign before proceeding to the next step.

## Creating a Data-Connected Template

This section assumes you are creating a template with Tall, Widescreen, and Bulletin screen formats. *Learn more about screen formats at [Screen Format Reference](../screen-format-reference.md)*

For detailed information on using the Template Designer interface and tools, see the [Template Designer General Navigation Guide](../template-designer-general-navigation-guide.md).

### Create the Template

1.  Navigate to `Templates -> CREATE A NEW TEMPLATE`
2.  Choose `Data Connected Template`
3.  Select the appropriate Screen Formats (Tall, Widescreen, Bulletin)
4.  Click `NEXT`
5.  Select `New | Create a new template from scratch on a blank canvas`
6.  Click `CREATE`
7.  Name your template:
    *  Click the `{PencilIcon}` next to "Untitled" at the top of the page
    *  Enter a descriptive name (e.g., "City Name Template")
    *  Click the `{CheckmarkIcon}` or hit the `Enter Key` on your keyboard

### Setup the Initial Format (Widescreen)

1.  On the Formats bar above the canvas, click on `Widescreen` to select that size
2.  Upload the background image:
    *  Navigate to `Elements Panel -> Expand Uploaded Assets`
    *  Click or drag/drop your Widescreen background image
    *  When prompted, select `Background to stretch to fill the screen`
    *  Click `OK`
3.  Add the dynamic city name element:
    *  In the `Elements Panel`, expand `Dynamic Data Elements`
    *  Scroll down (or search) for `City` under the `Location` section
    *  Click on the `City` element to add it to your canvas
4.  Position the City element on your canvas by dragging it to the desired location
5.  Configure the City text element properties in the `Edit` panel:
    *  **Font Color**: Click `Appearance -> {UnderlinedAIcon}` and choose a color
    *  **Font Family**: Select from `Font -> Family` dropdown, or upload a new font
    *  **Font Case**: Click `Font -> {ABIcon}` to set Uppercase
    *  **Font Size**: Set to `Auto` under `Font -> Size` (allows text to shrink/grow to fill the box)
    *  **Max Font Size**: Set under `Font -> Max Size` to prevent text from growing too large
    *  **Text Alignment**: Click the `{RightAlignIcon}` to align text as needed
6.  Preview different screens to verify the city name updates correctly:
    *  Under the `Screens` tab, click on different screens
    *  Use the up/down arrow keys to navigate between screens
    *  Use the `Search screens...` box to find specific screens
    *  Verify the City field updates with each screen's city name

### Prepare for Editing Other Sizes

By default, templates with multiple screen formats are in `All Sizes` editor mode. Any changes made to one size will responsively apply to all sizes. To edit sizes independently:

1.  Click on the `Canvas` tab
2.  Under `Editor Mode`, choose `Each Size Independently`

### Edit Additional Sizes (Bulletin)

1.  On the Formats bar above the canvas, click on `Bulletin`
2.  Rename the existing background layer:
    *  In the `Layers` panel, find your background image
    *  Double-click on its name
    *  Rename it to `Background - Widescreen`
    *  Press `Enter`
3.  Hide the Widescreen background:
    *  In the `Layers` panel, click the {EyeIcon} next to `Background - Widescreen`
4.  Upload a new Bulletin-sized background:
    *  Navigate to `Elements Panel -> Expand Uploaded Assets`
    *  Click or drag/drop your Bulletin background image
    *  Select `Background to stretch to fill the screen`
    *  Select `Add to size Bulletin only`
    *  Click `OK`
5.  Reposition the City element to fit the Bulletin layout appropriately

### Edit Remaining Sizes (Tall)

Repeat the steps above for the `Tall` size format:

1.  Click on `Tall` in the Formats bar
2.  Rename and hide the existing background layer
3.  Upload a new Tall-sized background (adding to Tall size only)
4.  Reposition the City element as needed

### Set the Preview Image

The preview image helps identify this template in your templates list:

1.  Select your middle size format (e.g., `Widescreen`)
2.  Click on the preview image thumbnail to the left of your template name at the top
3.  The preview will refresh to show the current canvas view

## Posting Your Dynamic Ad

### Post the Ad

1.  Click the `POST AD` button at the top right of the screen
2.  Select the campaign you created earlier
3.  Click `CREATE` or `NEXT` to generate the ad
4.  You will land on the **Proof Page** where you can view how this ad looks for every screen in your campaign

### Review the Proof Page

The Proof Page displays:

*  Visual proofs of your ad in every size on every screen
*  Lucit XR mockups showing your ad on actual billboards (where available)
*  Google Street View images with your ad mocked up (where available)
*  AI-generated placeholder images for screens without photos

You can:

*  Click through different screens to see location-specific content
*  Verify that city names and other dynamic data are displaying correctly
*  Share the proof URL with clients or stakeholders

## What Happens After Posting

Once your ad is created and you're viewing the **Proof Page**:

### Automatic Activation (Default Behavior)

*  **If draft mode is disabled** (default): Your ad will automatically be added to your campaign and will immediately start running on your connected screens
*  **If draft mode is enabled**: Your ad will be created in draft state and you'll need to activate it manually:
    *  Navigate to `Creatives -> {Your Ad} -> ACTIVATE`
    *  To enable draft mode for future ads: `Settings -> Creatives -> New Ads Will Start in Draft State (Enable)`

### Viewing Your Live Ads

*  **View active ads**: Navigate to `Home -> Ads` to see your ad in the active ads list with real-time last play status
*  **Return to campaign**: Click `Campaigns -> {Campaign}` to view all ads in your campaign
*  **Check campaign status**: At `Campaigns -> {Campaign}`, view the list of ads at the top that are checked - these are your running ads

### Making Changes

*  **Edit your ad**: Navigate to `Creatives -> {Your Ad}` then click the `EDIT` button from the **Item Page**
*  **Change images**: Click `CHANGE THIS IMAGE` for each size you want to update
*  **Update template values**: Click `EDIT VALUES` to modify text fields or images (for dynamic template ads)
*  **View updated proof**: Click `VIEW PROOF` to return to the **Proof Page** after making changes

### Monitoring Performance

*  **View analytics**: Navigate to `Analytics` to see plays, impressions, and time on screen
*  **Filter by creative**: Use `Analytics -> CREATIVES` to see performance data for this specific ad
*  **Real-time status**: Check `Home -> Ads` for last play status on each screen

## Tips and Best Practices

### Template Design

*  **Test multiple screens**: Always preview your template on screens in different cities to ensure dynamic content displays correctly
*  **Font sizing**: Use the `Auto` font size feature with a reasonable `Max Size` to prevent text overflow or awkward sizing
*  **Background images**: Prepare separate background images optimized for each screen format for best visual quality

### POI Data Management

*  **Keep data current**: Update your Google Sheet whenever location information changes
*  **Manual refresh**: With manual schedule mode enabled, refresh your data feed when needed via `Apps & Data -> {App} -> DATA -> REFRESH`
*  **Data validation**: Verify all required fields are filled out correctly before posting ads

### Campaign Management

*  **Screen targeting**: Use the Nearest Location app to automatically match POI data to the closest screens
*  **Proof sharing**: Share proof pages with clients for approval before activating campaigns
*  **Draft mode**: Enable draft mode if you want to review all ads before they go live

## Common Questions

**Can I add more dynamic fields beyond City?**

Yes! The Nearest Location app provides many fields including Address, Phone, Latitude, Longitude, and any custom fields you add to your Google Sheet. Add these as dynamic elements in your template.

**What happens if a screen doesn't have nearby POI data?**

Lucit will use the closest available POI data based on latitude/longitude coordinates. Ensure your POI list has good geographic coverage for your campaign.

**Can I update the POI data after posting ads?**

Yes! Update your Google Sheet and then manually refresh the data feed via `Apps & Data -> Nearest Location - Google Sheets -> DATA -> REFRESH`. Your existing ads will update with the new data.

**How do I create different templates for different campaigns?**

Create multiple templates in `Templates`, each with different designs or data fields. When posting ads, select the appropriate template for each campaign.

**Can I use this approach with other data sources?**

Yes! While this guide uses Google Sheets, Lucit supports many data sources. The template creation process remains similar regardless of the data source.

## Related Resources

*  [General Navigation Guide](../general-navigation-guide.md) - Complete Lucit platform navigation reference
*  [Post Ad Navigation Guide](../post-ad-navigation-guide.md) - Detailed post ad workflow documentation
*  [Screen Format Reference](../screen-format-reference.md) - Guide to screen sizes and formats
