---
title: "How to Create Weather-Triggered Creatives - Lucit Platform"
description: "Step-by-step guide for setting up creatives that only display during specific weather conditions like rain, snow, or sunshine"
keywords: "weather triggers, conditional creatives, weather data, dynamic content, screen filters, weather conditions"
---

# How to Create Weather-Triggered Creatives

## Overview

This guide walks you through setting up weather-triggered creatives that automatically activate only when specific weather conditions occur. By connecting real-time weather data to your campaign and applying custom triggers, you can display relevant ads based on current conditions like rain, snow, sunshine, or temperature—automatically adjusting for each screen's local weather.

## What are Weather Triggers?

Weather triggers in Lucit allow you to control when specific creatives display based on real-time weather conditions at each screen's location. This enables contextual advertising that responds to local weather, making your campaigns more relevant and engaging. For example, you can promote umbrellas when it's raining, ice cream during hot weather, or snow tires when it's snowing.

## Objective

By the end of this guide, you will have:

*  Added the Weather data source to your account
*  Connected real-time weather data to your campaign screens
*  Posted a creative to your campaign
*  Configured a weather-based trigger (e.g., "rain") for your creative
*  Understood how weather triggers work across multiple geographic locations

## Prerequisites

Before starting this guide, ensure you have:

*  A Lucit account with appropriate permissions
*  An existing account profile with access to Apps & Data
*  A campaign with screens attached
*  At least one creative posted to your campaign (or ready to post)
*  Permission to edit campaign settings and triggers

## Example Scenario

Throughout this guide, we'll use the example of activating an umbrella advertisement that should only display when it's raining at the screen location.

## Adding the Weather Data Source

### Configure the Weather App

1.  Navigate to `Apps & Data -> ADD NEW`
2.  In the search box, type `Weather`
3.  Find and click on the app titled `Weather (Screen Location)`
4.  When prompted to authorize this application, click `ALLOW`
5.  You will be taken to the app's configuration page

### Configure Weather Settings

1.  Click on the `SETTINGS` tab if not already there
2.  Configure the forecast settings:
    *  **Number of days of forecast data**: Set how many days of forecast data to bring in (default is typically 7 days)
    *  **Update frequency**: The weather data updates automatically based on the app's schedule
3.  Click the `SAVE CHANGES` button
4.  Navigate to the `DATA` tab to monitor the data refresh
5.  Wait for the weather data to finish loading for all your screens

**Important:** The Weather app will automatically attach weather data to all screens in your campaigns. Wait for the initial data refresh to complete before setting up triggers (this usually takes 1-2 minutes).

## Creating Your Weather-Triggered Creative

### Post Your Ad (If Not Already Posted)

If you haven't already posted the creative you want to trigger:

1.  Navigate to `Account Profile -> Home Page` or `Campaigns -> {Campaign}`
2.  Click the `POST AD` button
3.  Follow the post ad workflow to create your creative
4.  For detailed posting instructions, see the [Post Ad Navigation Guide](../post-ad-navigation-guide.md)

### Navigate to Your Campaign

1.  Navigate to `Campaigns -> {Campaign Name}` (click on your campaign)
2.  You will see a list of active creatives in your campaign

## Setting Up the Weather Trigger

### Open the Trigger Editor

1.  Find the creative you wish to enable the rain trigger for in the list of active creatives
2.  Next to that creative, click on the `{FolderWithStarIcon}` (Folder/Star icon)
3.  The **Custom Filters / Triggers Editor** dialog will appear

### Add a Weather Condition

1.  Click on the `SCREEN FILTER` tab
2.  Click the `+ CONDITION` button to add a new condition
3.  Configure the condition:
    *  **When** dropdown: Find and select `Current Condition Group Code`
    *  **Operator** dropdown: Select `Equals` from the list of operators
    *  **Value** field: Choose `Rain` from the dropdown or type it in
4.  Click `SAVE` to apply the trigger

**Result:** This creative will now only activate when the current weather condition for the screen it's running on is "Rain".

### How Geographic Triggers Work

If your campaign has screens across multiple geographic locations:

*  Each screen uses its own local weather conditions
*  The creative will automatically activate at screens where it's raining
*  The creative will remain inactive at screens with different weather
*  Triggers update in real-time as weather conditions change at each location

## What Happens After Setting Up Triggers

Once your weather trigger is configured:

### Automatic Activation Based on Weather

*  **Real-time monitoring**: Lucit continuously monitors weather conditions at each screen location
*  **Automatic activation**: When weather conditions match your trigger (e.g., "Rain"), the creative becomes eligible to play
*  **Automatic deactivation**: When weather conditions change and no longer match, the creative stops playing
*  **Multi-location support**: Each screen independently evaluates conditions based on its local weather

### Viewing Trigger Status

*  **Campaign view**: Navigate to `Campaigns -> {Campaign}` to see all your creatives
*  **Trigger indicator**: The `{FolderWithStarIcon}` icon indicates a creative has custom triggers applied
*  **Edit triggers**: Click the `{FolderWithStarIcon}` icon again to view or modify existing triggers

### Monitoring Performance

*  **Analytics**: Navigate to `Analytics -> CREATIVES` to see plays and impressions for your weather-triggered creative
*  **Filter by screen**: Use `Analytics -> SCREENS` to see performance at specific locations
*  **Weather correlation**: Compare analytics data with weather patterns to understand trigger effectiveness

### Making Changes

*  **Edit triggers**: Click the `{FolderWithStarIcon}` icon next to your creative from `Campaigns -> {Campaign}`
*  **Add multiple conditions**: Click `+ CONDITION` to add additional weather or other criteria
*  **Remove triggers**: Delete conditions or click `CLEAR ALL` to remove all triggers
*  **Edit the creative**: Navigate to `Creatives -> {Your Creative} -> EDIT` to modify the ad itself

## Tips and Best Practices

### Weather Trigger Strategy

*  **Test your triggers**: Monitor the first few days to ensure triggers activate as expected
*  **Use appropriate conditions**: Match weather conditions to your product (Rain → Umbrellas, Hot → Ice Cream, Snow → Winter Tires)
*  **Combine conditions**: Add multiple conditions like temperature + rain for more specific targeting
*  **Plan for seasonal changes**: Consider how weather patterns vary throughout the year in your target markets

### Data Management

*  **Regular monitoring**: Check `Apps & Data -> Weather (Screen Location) -> DATA` to ensure data is updating correctly
*  **Update frequency**: Weather data typically refreshes every 15-30 minutes automatically
*  **Forecast vs. current**: Use "Current Condition" for real-time triggers, not forecast data
*  **Data validation**: Preview the DATA tab to understand what weather values are available

### Campaign Management

*  **Have backup creatives**: Ensure you have non-triggered creatives running so screens aren't blank when conditions don't match
*  **Geographic diversity**: If screens span large areas, weather-triggered campaigns work especially well
*  **Test different conditions**: Try various weather triggers to see which drives the best engagement
*  **Combine with other triggers**: Mix weather triggers with time-of-day or date-based triggers for even more precise targeting

## Available Weather Conditions

Common weather condition values you can trigger on:

*  **Rain** - Any form of rain (light, moderate, heavy)
*  **Snow** - Snow conditions
*  **Clear** - Clear/sunny conditions
*  **Clouds** - Cloudy conditions
*  **Thunderstorm** - Thunderstorm conditions
*  **Drizzle** - Light rain/drizzle
*  **Mist** - Foggy/misty conditions

You can also trigger based on:

*  **Temperature** - Current temperature (use comparison operators like "Greater Than")
*  **Feels Like Temperature** - Apparent temperature
*  **Humidity** - Humidity percentage
*  **Wind Speed** - Current wind speed

## Common Questions

**How quickly do weather triggers respond to changing conditions?**

Weather data updates automatically every 15-30 minutes. Once conditions change and data refreshes, triggers typically activate or deactivate within 1-2 minutes. The exact timing depends on your player platform's update cycle.

**Can I combine multiple weather conditions for one creative?**

Yes! Click `+ CONDITION` multiple times to add multiple conditions. You can combine different weather parameters (e.g., "Rain" AND "Temperature less than 50°F") for highly specific targeting. Conditions are combined with AND logic by default.

**What happens if no creatives match the current weather conditions?**

If you have a default creative (set at `Settings -> Creatives -> Default Creative`), it will display. Otherwise, other active creatives without triggers will continue to play. It's best practice to always have at least one non-triggered creative in your campaign.

**How do I trigger on temperature ranges?**

Use the `Current Temperature` field with comparison operators:
- "Greater Than" for hot weather (e.g., > 85°F)
- "Less Than" for cold weather (e.g., < 40°F)
- Combine two conditions for ranges (e.g., > 70°F AND < 85°F)

**Do weather triggers work differently for different player platforms?**

Weather triggers work consistently across all player platforms integrated with Lucit. However, the creative refresh rate depends on your specific player's update frequency. Most players check for updates every 1-5 minutes.

**Can I see which screens currently meet my weather conditions?**

Yes! Navigate to `Apps & Data -> Weather (Screen Location) -> DATA` to see current weather data for all your screens. You can filter and search to find screens with specific conditions.

**What if a screen doesn't have weather data?**

Weather data is based on screen location (latitude/longitude). If a screen is missing location data, it won't receive weather updates. Ensure screens have proper location coordinates set at `Operator Profile -> Screens -> {Screen} -> {PencilIcon} -> GENERAL`.

**Can I schedule weather-triggered creatives for specific times?**

Yes! You can combine weather triggers with date/time scheduling. Click the `{CalendarIcon}` next to your creative to add start/stop dates and times, and these will work together with your weather triggers.

## Related Resources

*  [Post Ad Navigation Guide](../post-ad-navigation-guide.md) - Detailed guide for posting and managing ads
*  [General Navigation Guide](../general-navigation-guide.md) - Complete Lucit platform navigation reference
*  [How-To Guides](index.md) - Additional step-by-step tutorials
