---
title: "How-To Guides - Lucit Platform Tutorials"
description: "Step-by-step tutorials and how-to guides for common tasks in the Lucit platform, including dynamic creatives, POI data, weather triggers, and campaign management"
keywords: "lucit tutorials, how-to guides, step-by-step, dynamic creatives, poi data, weather triggers, campaign setup"
---

# How-To Guides

This section contains step-by-step tutorials for accomplishing specific tasks in the Lucit platform. Each guide walks you through a complete workflow from start to finish.

## Available Guides

### Campaign & Creative Guides

*  **[Create a Campaign with POI Dynamic Creatives](create-a-campaign-with-poi-dynamic-creatives.md)** - Learn how to create location-based dynamic advertising campaigns that automatically personalize creative content using Points of Interest (POI) data from Google Sheets. This comprehensive guide covers account setup, data integration, template creation, and ad posting.

### Data-Driven & Triggered Campaigns

*  **[Create Weather-Triggered Creatives](create-weather-triggered-creatives.md)** - Set up creatives that automatically activate based on real-time weather conditions like rain, snow, or temperature. Perfect for contextual advertising that responds to local weather at each screen location.

## What You'll Find Here

These how-to guides are designed to:

*  Provide clear, actionable steps for specific tasks
*  Include real-world examples and scenarios
*  Cover complete workflows from beginning to end
*  Explain prerequisites and requirements upfront
*  Show what to expect after completing each guide

## Guide Format

Each how-to guide follows a consistent structure:

*  **Overview** - What the guide covers and why it's useful
*  **Objective** - What you'll accomplish by the end
*  **Prerequisites** - What you need before starting
*  **Step-by-Step Instructions** - Detailed walkthrough with navigation paths
*  **What Happens After** - Understanding the results and next steps
*  **Tips & Best Practices** - Expert recommendations
*  **Common Questions** - FAQ section for troubleshooting
*  **Related Resources** - Links to additional documentation

## Related Documentation

*  **[General Navigation Guide](../general-navigation-guide.md)** - Complete reference for navigating the Lucit platform
*  **[Post Ad Navigation Guide](../post-ad-navigation-guide.md)** - Detailed guide for posting and managing ads
*  **[Integrations](../integrations/index.md)** - Integration guides for player platforms
*  **[Screen Format Reference](../screen-format-reference.md)** - Digital billboard screen format specifications

## Need Help?

If you can't find a guide for what you're trying to accomplish:

*  Check the [General Navigation Guide](../general-navigation-guide.md) for navigation paths to all features
*  Review the [FAQ](../../faq.md) for answers to common questions
*  Contact Lucit support through the platform: `Help -> Help Request -> Send`
