---
title: "Lucit Platform Guides - Technical Documentation & References"
description: "Comprehensive guides and technical references for the Lucit platform. API documentation, screen formats, and implementation guides for DOOH campaigns."
keywords: "Lucit guides, technical documentation, API guides, DOOH technical reference"
---

# Guides

This section contains comprehensive guides and references for working with Lucit.

## How-To Guides

Step-by-step tutorials for accomplishing specific tasks in the Lucit platform

*  **[How-To Guides](how-tos/index.md)** - Step-by-step tutorials including POI dynamic creatives, campaign setup, and more

## Navigation Guides

*  **[General Navigation Guide](general-navigation-guide.md)** - General navigation reference to the Lucit User Interface
*  **[Template Designer General Navigation Guide](template-designer-general-navigation-guide.md)** - Comprehensive guide to the Template Designer WYSIWYG editor for creating dynamic ad creatives
*  **[Post Ad Navigation Guide](post-ad-navigation-guide.md)** - Navigation reference for posting an ad, editing an ad, and viewing ad creative proofs
*  **[Campaign Page Navigation Guide](./campaign-page-navigation-guide.md)** - Navigation reference for managing creatives within your campaign (adding, removing, start/stop, etc.)

## Reference Guides

*  **[Screen Format Reference](screen-format-reference.md)** - Complete reference of all digital billboard screen formats
*  **[User Roles Reference](./user-roles-reference.md)** - A reference to the roles a user can have when being attached to an Account, Operator or Ad Agency


## Integration Guides

Guides for integrating Lucit with various player platforms for scheduling Lucit Dynamic Creatives

*  **[Integrations Guide](integrations/index.md)** - Integrations Guide for All Player Systems

