---
title: "How to Schedule Lucit Campaigns with Adams Outdoor using Ad Manager"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Adams Outdoor using Scala Ad Manager and campaign ID sharing"
keywords: [lucit, adams outdoor, scala, integration, digital signage, dynamic campaigns, scalascript, campaign id]
---

# How to Schedule Lucit Campaigns in Adams Outdoor Ad Manager

## Integration Overview

Adams Outdoor integrates with Lucit through Scala Ad Manager using campaign ID sharing for ScalaScript implementation. The Adams technical team uses the provided campaign hash ID to generate custom ScalaScript code that dynamically pulls content from Lucit's servers.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Adams Outdoor App Installed** - The Adams Outdoor app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Adams Outdoor Partnership** with technical team contact  
✅ **Scala Ad Manager Access** (for Adams team)  
✅ **Target Screen Locations** identified in Adams system

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Adams Outdoor App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Adams Outdoor** app appears in your list
   - If not visible, click **ADD NEW** and add the Adams Outdoor app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Obtain Campaign ID**
   - Copy the **Campaign Hash ID** (format: lch-xxxx) displayed in the Adams section
   - Note this ID for sharing with Adams technical team

### Step 2: Coordinate with Adams Team

#### Direct Campaign ID Sharing

1. **Contact Adams Technical Team**
   - Provide Campaign Hash ID from Step 1
   - Include campaign timing and creative specifications
   - Confirm target screen locations and scheduling requirements
   - Specify any location-specific content requirements

2. **Adams Technical Implementation**
   - Adams team generates custom ScalaScript using provided Campaign ID
   - ScalaScript programmed to pull content from Lucit servers


### Step 3: ScalaScript Implementation

1. **Script Generation by Adams**
   - Adams technical team creates ScalaScript incorporating Lucit Campaign ID
   - Script configured for dynamic content pulling from Lucit API
   - Integration code customized for Adams screen specifications

2. **Scala Ad Manager Deployment**
   - Adams team uploads ScalaScript to Scala Ad Manager
   - Script scheduled according to campaign timing requirements
   - Deployment activated across target Adams screen locations

## Troubleshooting

### Common Issues

**Problem**: Campaign ID not working  
**Solution**: 
- Verify campaign is published and active in Lucit
- Check that Campaign Hash ID is correctly copied (format: lch-xxxx)
- Ensure campaign has screens configured and assigned
- Contact Lucit support to verify campaign API accessibility

**Problem**: ScalaScript not pulling content  
**Solution**:
- Coordinate with Adams technical team to check script implementation
- Verify network connectivity from Adams screens to Lucit servers
- Test Campaign ID manually using Lucit API
- Check for firewall or network restrictions on Adams systems

**Problem**: Content not updating dynamically  
**Solution**:
- Verify campaign updates are published in Lucit
- Check ScalaScript refresh intervals with Adams team
- Confirm script is actively running on target screens

**Problem**: Display formatting issues  
**Solution**:
- Verify screen format settings in Lucit campaign match Adams displays
- Coordinate with Adams team on screen resolution and aspect ratio requirements
- Test content rendering on various Adams screen types
- Adjust Lucit template settings for Adams hardware optimization

### Campaign ID Validation

Your Campaign Hash ID should follow this format:
```
lch-[alphanumeric-string]
```

Example: `lch-4Ccv2XyZ`

## Technical Reference

### Campaign ID Integration
- **Format**: Campaign Hash ID (lch-xxxx format)
- **Usage**: Incorporated into ScalaScript for dynamic content pulling
- **Endpoint**: Lucit API endpoints accessed via ScalaScript
- **Refresh**: Configurable through ScalaScript implementation

### Scala Ad Manager Integration
- **Custom Development**: Adams team creates campaign-specific ScalaScripts
- **Dynamic Content**: Real-time pulling from Lucit servers
- **Screen Compatibility**: Optimized for Adams display hardware
- **Scheduling Integration**: Works with Scala Ad Manager scheduling system

### Performance Considerations
- **Network Requirements**: Reliable internet connectivity from screens to Lucit
- **Refresh Rates**: Configured in ScalaScript based on content type and network performance
- **Screen Compatibility**: Optimized for Adams Outdoor's specific hardware configurations
- **Monitoring**: Performance tracking through Adams system monitoring

## Related Resources

- [API Documentation](../../developer/api/index.html) - Technical specifications for API endpoints
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Notes / Configurations

### Multi-Location Campaigns
- Single Campaign ID can serve multiple Adams screen locations
- Location-specific content using Lucit geo / screen -targeting features

### Performance Optimization
- Work with Adams team to optimize ScalaScript refresh rates
- Monitor content delivery performance across Adams screen network
- Implement fallback content in Ad Manager AND Lucit

### Custom XML Integration
For advanced implementations, Adams can also build custom XML files for scheduling campaigns on Adams screens using enhanced build flags in the Lucit system.  These can be used to
build programmatic impression based campaigns that Adams Outdoor can run using Vistar Cortex

## Next Steps

1. **Coordinate Implementation**: Work with Adams Outdoor technical team for ScalaScript development and deployment
2. **Monitor Performance**: Track campaign performance and content delivery across Adams screen network
3. **Scale Implementation**: Apply successful integration patterns to additional campaigns and locations
4. **Support**: Contact your Lucit Account Representative for campaign optimization and advanced feature assistance

For additional support with Adams Outdoor Scala integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.