---
title: "How to Schedule Lucit Campaigns in Apparatix"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Apparatix digital signage player system using Live Link technology"
keywords: [lucit, apparatix, integration, digital signage, dynamic campaigns, live link]
---

# How to Schedule Lucit Campaigns in Apparatix

## Integration Overview

Apparatix integrates with Lucit through Live Link technology, allowing real-time dynamic content updates without file uploads or manual creative changes. This integration provides seamless dynamic advertising capabilities within the Apparatix player ecosystem.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Apparatix App Installed** - The Apparatix app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Apparatix Player Access** with file management permissions  
✅ **Live Link Enabled in APX** (contact Apparatix support if not visible)
✅ **APX Player Helper installed on every screen** (contact Apparatix support for help)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Apparatix App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Apparatix** app appears in your list
   - If not visible, click **ADD NEW** and add the Apparatix app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Apparatix Tab**
   - In the Link Player dialog, locate the **Apparatix** tab
   - If you don't see the Apparatix tab, return to Step 2 to add the app
   - Click on the **Apparatix** tab to view integration options

7. **Copy Live Link URL**
   - Find the Live Link URL in the Apparatix section
   - Format: `https://pull.lucit.app/api/v1/campaigns/apx/v2/{export.hash_id}/pull/html?api_token={token}&n={account_slug}|{export_slug}`
   - Click **Copy URL** button to clipboard

### Step 2: Apparatix Configuration

1. **Access Apparatix File Manager**
   - Log into your Apparatix control panel
   - Navigate to **File Manager** section

2. **Create Live Link Item**
   - Click **Create New** → **Live Link**
   - Paste the copied Lucit URL into the URL field
   - Name the creative (e.g., "Lucit Dynamic Campaign - [Campaign Name]")

3. **Schedule Campaign**
   - Navigate to **Scheduling** section
   - Create new playlist or add to existing playlist
   - Add your Lucit Live Link creative to desired time slots
   - Apply schedule to target screens/zones

### Step 3: Testing & Validation

1. **Verify Live Link Connection**
   - Check that the Live Link URL loads properly in Apparatix preview
   - Confirm creative displays correctly on test screen
   - Check that you are receiving real-time play reports in Lucit for this campaign

2. **Test Dynamic Updates**
   - Make a change in your Lucit campaign (update text, data, or imagery)
   - Wait for refresh interval (60-300 seconds)
   - Verify changes appear on Apparatix-connected screens

3. **Monitor Performance**
   - Check Apparatix logs for any connection errors
   - Verify consistent refresh rates and data loading

## Troubleshooting

### Common Issues

**Problem**: Live Link URL not working  
**Solution**: 
- Verify Lucit campaign is published and screens are configured
- Make sure your screen identifiers match to the screen identifiers in Apparatix
- Make sure that all screen identifiers end in `.1` for instance `MYSCRA.1`
- Confirm Live Link feature is enabled (contact Apparatix support)

**Problem**: Creative not updating  
**Solution**:
- Check refresh interval settings in Apparatix
- Verify internet connectivity on player devices  
- Confirm campaign changes are saved and published in Lucit

**Problem**: Not working on some screens
- Verify that EACH screen in the campaign has the `APX Player Helper` installed
- Verify that the `APX Player Helper` is up and running on each screen
- Verify that the screen identifiers match for every screen `Operator Profile -> Screens -> {Screen} -> Identifier`

**Problem**: Display formatting issues  
**Solution**:
- Verify screen resolution settings match Lucit screen settings for each screen


## Technical Reference

### Live Link URL Structure
```
https://pull.lucit.app/api/v1/campaigns/apx/v2/{export.hash_id}/pull/html
?api_token={token}
&n={account_slug}|{export_slug}
```

### Supported Features
- **Real-time content updates** via Live Link technology
- **Dynamic data integration** from external APIs and databases  
- **Responsive design** automatically sized for Apparatix screen configurations
- **Rich media support** including images, videos, and interactive elements
- **Multi-screen management** with location-specific content customization

## Related Resources

- [Lucit vs Apparatix Comparison](../../compare/lucit-vs-apparatix.md) - Detailed feature comparison
- [API Documentation](../../developer/api/index.html) - Advanced integration options
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Troubleshooting Guide](index.md#general-troubleshooting) - Additional support resources

## Next Steps

1. **Optimize Campaign Performance**: Monitor analytics and adjust refresh rates for optimal performance
2. **Scale Implementation**: Apply Live Link integration to additional campaigns and screens  
3. **Advanced Features**: Explore location-based dynamic content and personalization options
4. **Support**: Contact your Lucit Account Representative for advanced configuration assistance

For additional support with Apparatix integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.