---
title: "How to Schedule Lucit Campaigns in Ayuda"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Ayuda (by Broadsign) using HTML package generation and lc build tools"
keywords: [lucit, ayuda, broadsign, integration, digital signage, dynamic campaigns, html package, lc build]
---

# How to Schedule Lucit Campaigns in Ayuda

## Integration Overview

Ayuda (by Broadsign) integrates with Lucit through HTML package generation using specialized `lc build` tools. This integration creates downloadable HTML packages that are scheduled directly on Ayuda players, providing dynamic content capabilities within the Broadsign ecosystem.

Note:  Contact Lucit support to enable these tools for your Ayuda install

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Ayuda App Installed** - The Ayuda app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Ayuda Player Access** with content scheduling permissions  
✅ **Lucit Account Representative Contact** for HTML package generation  
✅ **Target Screen Locations** identified in Ayuda system

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Ayuda App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Ayuda** app appears in your list
   - If not visible, click **ADD NEW** and add the Ayuda app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Ayuda Tab**
   - In the Link Player dialog, locate the **Ayuda** tab
   - If you don't see the Ayuda tab, return to Step 2 to add the app
   - Click on the **Ayuda** tab to view integration options

7. **Obtain Campaign Information**
   - Note the **Campaign Hash ID** (format: lch-xxxx) displayed in the Ayuda section
   - Document any location-specific requirements
   - Verify campaign has target screens configured

### Step 2: Request HTML Package

1. **Contact Lucit Account Representative**
   - Request "HTML Package" for Ayuda integration
   - Provide Campaign Hash ID from Step 1
   - Specify target Ayuda player locations
   - Include any special requirements or configurations

2. **Package Generation Process**
   - Lucit team creates custom `settings.js` configuration
   - HTML package built using specialized `lc build` tools
   - Package includes all necessary files for Ayuda player compatibility

### Step 3: HTML Package Components

The generated HTML package includes:

#### Core Files
- **`index.html`**: Main HTML file executed by Ayuda player
- **`settings.js`**: Configuration file with API token and campaign ID
- **`lucit.js`**: Lucit connectivity and content pulling code
- **`style.css`**: Styling for content presentation
- **`fallback.jpg`**: Default creative for network issues

#### Configuration Details
```javascript
// settings.js structure
{
  "api_token": "player-bot-api-token",
  "campaign_id": "lch-campaign-hash-id",
  "default_play_duration": 8,
  "fetch_url": "https://layout.lucit.cc/api/v1/campaigns/ayuda/${CAMPAIGN_ID}/pull?api_token=${API_TOKEN}&location_id=${LOCATION_ID}",
  "debug_mode": false
}
```

### Step 4: Ayuda Implementation

1. **Receive HTML Package**
   - Download ZIP file provided by Lucit team
   - Verify package contents and configuration

2. **Upload to Ayuda System**
   - Access Ayuda content management interface
   - Upload HTML package ZIP file to content library
   - Configure content settings according to Ayuda requirements

3. **Schedule Campaign**
   - Create new playlist or add to existing playlist in Ayuda
   - Add Lucit HTML package to desired time slots
   - Apply schedule to target screens/zones

### Step 5: Testing & Validation

1. **Player Functionality Testing**
   - Verify HTML package loads correctly on Ayuda players
   - Test dynamic content pulling from Lucit servers
   - Confirm face number detection from `formal_location.xml`

2. **Dynamic Content Validation**
   - Make changes in Lucit campaign
   - Verify updates appear on Ayuda-connected screens
   - Test location-specific content delivery

3. **Performance Monitoring**
   - Monitor content loading and refresh performance
   - Check Ayuda player logs for any errors
   - Verify network connectivity and content delivery timing

## Troubleshooting

### Common Issues

**Problem**: HTML package not loading  
**Solution**: 
- Verify ZIP file was uploaded correctly to Ayuda system
- Check that all required files are present in package
- Confirm Ayuda player can access external URLs (network permissions)
- Review Ayuda player logs for specific error messages

**Problem**: Content not updating  
**Solution**:
- Verify campaign updates are published in Lucit
- Check `settings.js` configuration for correct API token and campaign ID
- Confirm network connectivity from Ayuda players to Lucit servers
- Test API endpoints manually to verify accessibility

**Problem**: Location-specific content not working  
**Solution**:
- Verify `formal_location.xml` file exists on Ayuda player
- Check that location IDs match between Ayuda system and Lucit configuration
- Confirm face number detection is working in HTML package
- Test with debug mode enabled for troubleshooting information

**Problem**: Player status showing "skip"  
**Solution**:
- Check network connectivity to Lucit servers
- Verify API token validity in `settings.js`
- Review player logs for specific error messages
- Confirm campaign is published and accessible via API

### Debug Mode

For troubleshooting, HTML packages can be generated with debug mode enabled:

```javascript
// settings.js with debugging
{
  "debug_mode": true,
  "location_id": "test-face-number" // for local testing
}
```

Debug mode provides:
- Console logging of all operations
- On-screen error messages
- Detailed network request information
- Content loading status updates

## Technical Reference

### HTML Package Architecture

The Ayuda player executes the HTML package with this workflow:
1. **Load Settings**: Read configuration from `settings.js`
2. **Face Detection**: Extract face number from `formal_location.xml` 
3. **Content Fetch**: Pull creative from Lucit Drive API
4. **Display**: Render content at 100% screen dimensions
5. **Status Update**: Set player status to "ready"
6. **Analytics**: Fire play pingback on player `play()` method

### API Integration
- **Fetch URL**: `https://lucit.cc/lucit-drive-api/`
- **Endpoint Format**: `/v1/campaigns/ayuda/${CAMPAIGN_ID}/pull`
- **Parameters**: API token, location ID
- **Response**: Dynamic creative content

### Performance Considerations
- **Network Requirements**: Reliable internet connectivity required
- **Refresh Timing**: Configurable based on content update frequency
- **Fallback Content**: Built-in fallback creative for network issues
- **Error Handling**: Comprehensive error logging and status reporting

## Related Resources

- [API Documentation](../../developer/api/index.html) - Lucit Drive API specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Custom Settings
- **Play Duration**: Configurable default display timing
- **Fetch URL**: Customizable API endpoint structure
- **Debug Options**: Enhanced logging and error display
- **Location Targeting**: Face-number-based content customization

### Performance Optimization
- Work with Ayuda team to optimize content refresh rates
- Monitor network performance and content delivery timing
- Implement appropriate fallback content for reliability

## Next Steps

1. **Request Package**: Contact your Lucit Account Representative to request HTML package generation
2. **Coordinate Implementation**: Work with Ayuda team for package deployment and testing
3. **Monitor Performance**: Track content delivery and update performance across Ayuda network
4. **Scale Implementation**: Apply successful integration to additional campaigns and locations

For additional support with Ayuda integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.