---
title: "How to Schedule Lucit Campaigns in Blip Player"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Blip Player using XML feed integration for per-billboard dynamic content"
keywords: [lucit, blip, integration, digital signage, dynamic campaigns, xml feed, billboard]
---

# How to Schedule Lucit Campaigns in Blip Player

## Integration Overview

Blip Player integrates with Lucit through per-billboard XML feeds with dynamic location parameters. This integration requires creating separate ads for each billboard with unique feed URLs, enabling location-specific dynamic content across your Blip network.

Note:  This guide is specific to Billboard Operators who are using the `Blip Player` to manage the content on their digitial signs.

For Blip Programmatic implementation, Dynamic Creatives are not supported at this time.

## Important Note on Analytics

Blip Player Integrations are Legacy integrations and do NOT support play and impression reporting within Lucit.   This integration only allows the Blip Player to display the dynamic creatives.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Blip App Installed** - The Blip app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Blip Player Access** with ad creation and scheduling permissions  
✅ **Billboard Sign IDs** from Blip system  
✅ **Background Images** uploaded for each billboard (if required by campaign)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Blip App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Blip** app appears in your list
   - If not visible, click **ADD NEW** and add the Blip app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Blip Tab**
   - In the Link Player dialog, locate the **Blip** tab
   - If you don't see the Blip tab, return to Step 2 to add the app
   - Click on the **Blip** tab to view integration options

7. **Prepare Billboard Data**
   - Collect all Blip **Sign IDs** for target billboards
   - Note the **Campaign Hash ID** and **API Token** displayed in the Blip section
   - Verify each billboard's screen format matches Lucit campaign settings
   - Confirm background images are uploaded if required

### Step 2: Blip Player Configuration

1. **Create Individual Ads for Each Billboard**
   - In Blip Player, navigate to **Ad Creation**
   - Create a **separate ad for EACH billboard** (1:1 relationship required)
   - Name each ad clearly: "Lucit Dynamic - [Campaign Name] - [Billboard Location]"

2. **Configure XML Feed for Each Ad**
   - Set ad type to **Dynamic/XML Feed**
   - Enter the XML Feed URL for each billboard (These are generated on the `Blip` tab of Link Player in Lucit):
   ```
   https://pull.lucit.app/api/v1/campaigns/blip/{hash_id}/pull/xml?r={random}&api_token={token}&location_id={board_id}
   ```
   - Replace `{hash_id}` with your campaign hash ID
   - Replace `{token}` with your API token  
   - Replace `{board_id}` with the specific Blip Sign ID for this billboard

3. **Configure XPath Settings**
   - Set **XPath Expression**: `lucit-layout-drive/item-set/item/@src`
   - This tells Blip Player where to find the image URL in the XML response
   - Verify XPath is correctly entered (case-sensitive)

4. **Set Refresh Parameters**
   - Configure **Refresh Interval**: 5 minutes recommended

### Step 3: Schedule Campaigns

1. **Create Ad Groups**
   - Group related billboard ads together for easier management
   - Example: "Lucit Dynamic Campaign - Highway Route 101"
   - Add all relevant billboard-specific ads to the group

2. **Configure Scheduling**
   - Set campaign start and end dates
   - Configure daypart scheduling if needed
   - Apply scheduling to entire ad group for consistent timing

3. **Activate Campaigns**
   - Review all billboard-specific ad configurations
   - Activate each ad individually or as part of ad group
   - Monitor initial activation for feed connectivity


## Troubleshooting

### Common Issues

**Problem**: XML feed returning errors  
**Solution**: 
- Verify API token is valid and properly formatted in URL
- Check that campaign hash ID is correct
- Confirm location_id parameter matches exact Blip Sign ID
- Test feed URL manually in browser to verify response

**Problem**: Images not displaying  
**Solution**:
- Verify image URLs in XML response are accessible
- Check that images meet Blip Player format requirements
- Confirm network connectivity from Blip players to Lucit servers
- Review Blip Player logs for image loading errors

**Problem**: XPath not finding content  
**Solution**:
- Verify XPath expression is exactly: `lucit-layout-drive/item-set/item/@src`
- Check XML response structure matches expected format
- Confirm case sensitivity in XPath configuration
- Test XPath expression against actual XML response

**Problem**: Inconsistent updates across billboards  
**Solution**:
- Verify each billboard has unique location_id parameter
- Check that all XML feed URLs are properly configured
- Confirm refresh intervals are consistent across all ads
- Review Blip Player scheduling for timing conflicts

### Feed Validation

Test your XML feed URLs using this format:
```
https://pull.lucit.app/api/v1/campaigns/blip/{hash_id}/pull/xml?r={random}&api_token={token}&location_id={board_id}
```

Expected response structure:
```xml
<?xml version="1.0" encoding="UTF-8"?>
<lucit-layout-drive>
  <item-set>
    <item src="https://pull.lucit.app/generated-image-url.jpg"/>
  </item-set>
</lucit-layout-drive>
```

## Technical Reference

### URL Parameters
- `{hash_id}`: Campaign identifier from Lucit Link Player section
- `{token}`: API token from Lucit Account Settings
- `{board_id}`: Blip Sign ID for specific billboard location
- `{random}`: Optional cache-busting parameter (can use timestamp)


## Related Resources

- [Lucit vs Blip Comparison](../../compare/lucit-vs-blip.md) - Feature comparison and dynamic vs static benefits
- [API Documentation](../../developer/api/index.html) - XML feed technical specifications  
- [Screen Format Reference](../screen-format-reference.md) - Billboard display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Location-Based Content
- Use Lucit's geo-targeting features to customize content per billboard location
- Configure weather, traffic, or local event data integration
- Set up location-specific background images and branding elements

### Bulk Management
- Use spreadsheet templates to track billboard Sign IDs and feed URLs
- Implement naming conventions for easier ad management in Blip Player
- Set up monitoring alerts for feed failures across multiple locations

## Next Steps

1. **Scale Implementation**: Add additional billboards by creating new ads with unique location_id parameters
2. **Performance Monitoring**: Track feed success rates and optimize refresh intervals
3. **Content Optimization**: Use location-specific data and imagery for maximum relevance
4. **Support**: Contact your Lucit Account Representative for advanced location-based content strategies

For additional support with Blip Player integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.